/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.beanManager.el;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.el.ELAwareBeanManager;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.ee.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="4.1")
public class ELAwareBeanManagerTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ELAwareBeanManagerTest.class)).build();
    }

    @Test
    @SpecAssertion(section="el_integration_api", id="a")
    public void testBeanManagerImplementsELAwareBeanManager() {
        assert (this.getCurrentManager() instanceof ELAwareBeanManager);
    }

    @Test
    @SpecAssertion(section="el_integration_api", id="ba")
    public void testContainerProvidesELAwareBeanManagerBean() {
        assert (this.getBeans(ELAwareBeanManager.class, new Annotation[0]).size() > 0);
    }

    @Test
    @SpecAssertion(section="el_integration_api", id="bb")
    public void testELAwareBeanManagerBeanIsDependentScoped() {
        Bean beanManager = (Bean)this.getBeans(ELAwareBeanManager.class, new Annotation[0]).iterator().next();
        assert (beanManager.getScope().equals(Dependent.class));
    }

    @Test
    @SpecAssertion(section="el_integration_api", id="bc")
    public void testELAwareBeanManagerBeanHasCurrentBinding() {
        Bean beanManager = (Bean)this.getBeans(ELAwareBeanManager.class, new Annotation[0]).iterator().next();
        assert (beanManager.getQualifiers().contains(Default.Literal.INSTANCE));
    }

    @Test
    @SpecAssertion(section="el_integration_api", id="c")
    public void testELAwareBeanManagerCastFromCdiCurrent() {
        assert (CDI.current().getBeanManager() instanceof ELAwareBeanManager);
    }
}

