/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.tagext.resource.taghandler;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import ee.jakarta.tck.pages.common.util.JspTestUtil;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@Tags(value={@Tag(value="jsp"), @Tag(value="platform")})
@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    private static final System.Logger logger = System.getLogger(URLClientIT.class.getName());

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=true)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_tagext_resource_taghandler_web.war");
        archive.addClasses(new Class[]{JspTestUtil.class});
        archive.addPackages(true, Filters.exclude((Class[])new Class[]{URLClientIT.class}), new String[]{URLClientIT.class.getPackageName()});
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_tagext_resource_taghandler_web.xml"));
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tagext_resource_taghandler.tld", "tagext_resource_taghandler.tld");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/ResourceTagHandlerTimingTest.jsp")), "ResourceTagHandlerTimingTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/ResourceTagHandlerTest.jsp")), "ResourceTagHandlerTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/ResourceSimpleTagHandlerTimingTest.jsp")), "ResourceSimpleTagHandlerTimingTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/ResourceSimpleTagHandlerTest.jsp")), "ResourceSimpleTagHandlerTest.jsp");
        return archive;
    }

    @Test
    @RunAsClient
    public void ResourceTagHandlerTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagext_resource_taghandler_web/ResourceTagHandlerTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    @RunAsClient
    public void ResourceSimpleTagHandlerTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagext_resource_taghandler_web/ResourceSimpleTagHandlerTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    @RunAsClient
    public void ResourceTagHandlerTimingTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagext_resource_taghandler_web/ResourceTagHandlerTimingTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    @RunAsClient
    public void ResourceSimpleTagHandlerTimingTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagext_resource_taghandler_web/ResourceSimpleTagHandlerTimingTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }
}

