/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.remove.oneXmany;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.remove.oneXmany.A;
import ee.jakarta.tck.persistence.core.entitytest.remove.oneXmany.B;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove1XMTest1() throws Exception {
        boolean pass = false;
        this.logTrace("Begin remove1XMTest1");
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("11", "b1", 1);
            B b2 = new B("12", "b2", 2);
            B b3 = new B("13", "b3", 3);
            B b4 = new B("14", "b4", 4);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("1", "a1", 1, v1);
            boolean status = this.getInstanceStatus(aRef);
            if (!status) {
                this.logTrace("Instance state is not managed as expected.Try invoking remove on it.");
                this.getEntityManager().remove((Object)aRef);
                pass = true;
            } else {
                this.logErr("Instance state is managed.  Unexpected as this is NEW instance.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception fe) {
            this.logErr("Unexpected Exception during remove operation. Should have been ignored.", fe);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("remove1XMTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove1XMTest2() throws Exception {
        boolean pass = false;
        boolean status = false;
        this.logTrace("Begin remove1XMTest2");
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("21", "b1", 2);
            this.createB(b1);
            B b2 = new B("22", "b2", 2);
            this.createB(b2);
            B b3 = new B("23", "b3", 2);
            this.createB(b3);
            B b4 = new B("24", "b4", 2);
            this.createB(b4);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("2", "bean2", 2, v1);
            this.createA(aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            this.logTrace("Get Instance Status ");
            status = this.getInstanceStatus(aRef);
            if (status && newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                this.logTrace("Status is true as expected, try remove");
                this.getEntityManager().remove((Object)this.findA("2"));
                this.logTrace("Call contains after remove");
                if (!this.getEntityManager().contains((Object)aRef)) {
                    pass = true;
                }
            } else {
                this.logTrace("Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("remove1XMTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove1XMTest3() throws Exception {
        this.logTrace("Begin remove1XMTest3");
        boolean pass = false;
        boolean status = false;
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("31", "b1", 3);
            this.createB(b1);
            B b2 = new B("32", "b2", 3);
            this.createB(b2);
            B b3 = new B("33", "b3", 3);
            this.createB(b3);
            B b4 = new B("34", "b4", 3);
            this.createB(b4);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("3", "bean3", 3, v1);
            this.createA(aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            this.logTrace("Get Instance Status ");
            status = this.getInstanceStatus(aRef);
            if (status && newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                this.logTrace("Status is true as expected, try remove()");
                this.getEntityManager().remove((Object)this.findA("3"));
                this.logTrace("Remove is immediately visible to the contains method");
                if (!(this.getEntityManager().contains((Object)aRef) || this.getEntityManager().contains((Object)b1) || this.getEntityManager().contains((Object)b2) || this.getEntityManager().contains((Object)b3) || this.getEntityManager().contains((Object)b4))) {
                    pass = true;
                }
            } else {
                this.logErr("Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("remove1XMTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove1XMTest4() throws Exception {
        this.logTrace("Begin remove1XMTest4");
        boolean pass = false;
        boolean status = false;
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("51", "b1", 5);
            this.createB(b1);
            B b2 = new B("52", "b2", 5);
            this.createB(b2);
            B b3 = new B("53", "b3", 5);
            this.createB(b3);
            B b4 = new B("54", "b4", 5);
            this.createB(b4);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("5", "bean5", 5, v1);
            this.createA(aRef);
            this.logTrace("Get Instance Status ");
            status = this.getEntityManager().contains((Object)aRef);
            if (status) {
                this.logTrace("Status is true, try remove");
                this.getEntityManager().remove((Object)aRef);
                if (!this.getEntityManager().contains((Object)aRef)) {
                    this.getEntityManager().remove((Object)aRef);
                    pass = true;
                }
            } else {
                this.logErr("contains method returned true; unexpected, test fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception caught trying to remove entity instance :", fe);
            }
        }
        if (!pass) {
            throw new Exception("remove1XMTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove1XMTest5() throws Exception {
        boolean pass = false;
        boolean status = false;
        this.logTrace("Begin remove1XMTest5");
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("61", "b1", 6);
            this.createB(b1);
            B b2 = new B("62", "b2", 6);
            this.createB(b2);
            B b3 = new B("63", "b3", 6);
            this.createB(b3);
            B b4 = new B("64", "b4", 6);
            this.createB(b4);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("6", "bean6", 6, v1);
            this.createA(aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            this.logTrace("Get Instance Status ");
            status = this.getInstanceStatus(aRef);
            if (status && newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                this.logTrace("Status is true as expected, try remove()");
                this.getEntityManager().remove((Object)this.findA("6"));
                this.getEntityManager().flush();
                this.logTrace("A removed entity is removed from the  database as a result of the flush operation");
                A newA = this.findA("6");
                if (newA == null) {
                    pass = true;
                }
            } else {
                this.logErr("Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception caught trying to remove entity instance :", fe);
            }
        }
        if (!pass) {
            throw new Exception("remove1XMTest5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove1XMTest6() throws Exception {
        this.logTrace("Begin remove1XMTest6");
        boolean pass = false;
        boolean status = false;
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("71", "b1", 7);
            this.createB(b1);
            B b2 = new B("72", "b2", 7);
            this.createB(b2);
            B b3 = new B("73", "b3", 7);
            this.createB(b3);
            B b4 = new B("74", "b4", 7);
            this.createB(b4);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("7", "bean7", 7, v1);
            this.createA(aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            this.logTrace("Get Instance Status ");
            status = this.getInstanceStatus(aRef);
            if (status && newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                this.logTrace("Status is true as expected, try remove()");
                this.getEntityManager().remove((Object)this.findA("7"));
                if (!(this.getEntityManager().contains((Object)aRef) || this.getEntityManager().contains((Object)b1) || this.getEntityManager().contains((Object)b2) || this.getEntityManager().contains((Object)b3) || this.getEntityManager().contains((Object)b4))) {
                    pass = true;
                }
            } else {
                this.logErr("Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception fe) {
            this.logErr("Unexpected Exception during remove operation. Should have been ignored.", fe);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("remove1XMTest6 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove1XMTest7() throws Exception {
        this.logTrace("Begin remove1XMTest7");
        boolean pass = false;
        boolean status = false;
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("81", "b1", 8);
            this.createB(b1);
            B b2 = new B("82", "b2", 8);
            this.createB(b2);
            B b3 = new B("83", "b3", 8);
            this.createB(b3);
            B b4 = new B("84", "b4", 8);
            this.createB(b4);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("8", "bean8", 8, v1);
            this.createA(aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            this.logTrace("Get Instance Status ");
            status = this.getInstanceStatus(aRef);
            if (status && newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                this.logTrace("Status is true as expected, try remove()");
                this.getEntityManager().remove((Object)this.findA("8"));
                if (!(this.getEntityManager().contains((Object)aRef) || this.getEntityManager().contains((Object)b1) || this.getEntityManager().contains((Object)b2) || this.getEntityManager().contains((Object)b3) || this.getEntityManager().contains((Object)b4))) {
                    pass = true;
                }
            } else {
                this.logErr("Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception fe) {
            this.logErr("Unexpected Exception during remove operation.  Should have been ignored.", fe);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("remove1XMTest7 failed");
        }
    }

    private void createA(A a) {
        this.logTrace("Entered createA method");
        this.getEntityManager().persist((Object)a);
        this.getEntityManager().flush();
    }

    private A findA(String id) {
        this.logTrace("Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private void createB(B b) {
        this.logTrace("Entered createB method");
        this.getEntityManager().persist((Object)b);
        this.getEntityManager().flush();
    }

    private boolean getInstanceStatus(Object o) {
        this.logTrace("Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    private void dumpCollectionDataB(Collection c) {
        this.logTrace("Collection Data");
        this.logTrace("---------------");
        this.logTrace("- size=" + c.size());
        Iterator i = c.iterator();
        int elem = 1;
        while (i.hasNext()) {
            B v = (B)i.next();
            this.logTrace("- Element #" + elem++);
            this.logTrace("  id=" + v.getBId() + ", name=" + v.getBName() + ", value=" + v.getBValue());
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1XM_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_1XM_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

