/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.embedded.adapter1;

import com.sun.ts.tests.common.connector.embedded.adapter1.MsgXAResource;
import com.sun.ts.tests.common.connector.util.AppException;
import com.sun.ts.tests.common.connector.util.TSMessageListenerInterface;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.UnavailableException;
import jakarta.resource.spi.endpoint.MessageEndpoint;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import jakarta.resource.spi.work.Work;
import java.lang.reflect.Method;
import javax.transaction.xa.XAResource;

public class CRDMessageWork
implements Work {
    private String name;
    private boolean stop = false;
    private MessageEndpointFactory factory;
    private MsgXAResource msgxa = new MsgXAResource();
    private MessageEndpoint xaep;
    private MessageEndpoint ep2;

    public CRDMessageWork(String name, MessageEndpointFactory factory) {
        this.factory = factory;
        this.name = name;
        System.out.println("CRDMessageWork.constructor");
    }

    public void run() {
        while (!this.stop) {
            try {
                Debug.trace((String)"Inside the CRDMessageWork run ");
                this.xaep = this.factory.createEndpoint((XAResource)this.msgxa);
                this.ep2 = this.factory.createEndpoint(null);
                Method onMessagexa = this.getOnMessageMethod();
                this.xaep.beforeDelivery(onMessagexa);
                ((TSMessageListenerInterface)this.xaep).onMessage("CRD_MDB Transacted Message To MDB");
                this.xaep.afterDelivery();
                Debug.trace((String)"CRD_MDB Transacted Message To MDB");
                this.callSysExp();
                this.callAppExp();
                boolean isTransacted = this.factory.isDeliveryTransacted(onMessagexa);
                if (!isTransacted) break;
                Debug.trace((String)"CRD_MDB delivery is transacted");
                break;
            }
            catch (AppException ex) {
                ex.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (UnavailableException ex) {
                try {
                    Thread.currentThread();
                    Thread.sleep(3000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (ResourceException re) {
                re.printStackTrace();
            }
        }
    }

    public void callSysExp() {
        try {
            Method onMessage = this.getOnMessageMethod();
            this.ep2.beforeDelivery(onMessage);
            ((TSMessageListenerInterface)this.ep2).onMessage("Throw CRDSysException from Required");
        }
        catch (NoSuchMethodException e) {
            System.out.println("CRDMessageWork: NoSuchMethodException");
            e.getMessage();
            e.printStackTrace();
        }
        catch (UnavailableException e) {
            System.out.println("CRDMessageWork: UnavailableException");
            e.printStackTrace();
        }
        catch (ResourceException re) {
            System.out.println("CRDMessageWork: ResourceException");
            re.printStackTrace();
        }
        catch (AppException ae) {
            System.out.println("CRDMessageWork: AppException");
            ae.printStackTrace();
        }
        catch (Exception e) {
            Debug.trace((String)"CRDEJBException thrown but Required");
        }
        finally {
            try {
                this.ep2.afterDelivery();
            }
            catch (ResourceException re2) {
                re2.printStackTrace();
            }
        }
    }

    public void callAppExp() {
        try {
            Method onMessage = this.getOnMessageMethod();
            this.ep2.beforeDelivery(onMessage);
            ((TSMessageListenerInterface)this.ep2).onMessage("Throw CRDAppException from Required");
        }
        catch (AppException ejbe) {
            System.out.println("AppException thrown by Required MDB");
        }
        catch (NoSuchMethodException ns) {
            ns.printStackTrace();
        }
        catch (ResourceException re) {
            re.printStackTrace();
        }
        finally {
            try {
                this.ep2.afterDelivery();
            }
            catch (ResourceException re2) {
                re2.printStackTrace();
            }
        }
    }

    public Method getOnMessageMethod() {
        Method onMessageMethod = null;
        try {
            Class<TSMessageListenerInterface> msgListenerClass = TSMessageListenerInterface.class;
            Class[] paramTypes = new Class[]{String.class};
            onMessageMethod = msgListenerClass.getMethod("onMessage", paramTypes);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        return onMessageMethod;
    }

    public void release() {
    }

    public void stop() {
        this.stop = true;
    }

    public String toString() {
        return this.name;
    }
}

