/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.resultSet.resultSet10;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class resultSetClient10
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.resultSet.resultSet10";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private transient DatabaseMetaData dbmd = null;
    private Statement stmt = null;
    private PreparedStatement pstmt = null;
    private DataSource ds1 = null;
    private String drManager = null;
    private String sqlStmt = null;
    private dbSchema dbSch = null;
    private rsSchema rsSch = null;
    private Properties props = null;
    private Properties sqlp = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        resultSetClient10 theTests = new resultSetClient10();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.props = p;
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbSch = new dbSchema();
                this.rsSch = new rsSchema();
                this.stmt = this.conn.createStatement();
                this.dbmd = this.conn.getMetaData();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte01() throws Exception {
        String smaxByteVal = null;
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            String Max_Val_Query = this.sqlp.getProperty("Tinyint_Query_Max", "");
            rs = this.stmt.executeQuery(Max_Val_Query);
            rs.next();
            this.msg.setMsg("Calling getByte on Tinyint_Tab");
            byte retValue = rs.getByte(1);
            this.msg.setMsg("Calling extractVal to get the Maximum Value of Byte");
            smaxByteVal = this.rsSch.extractVal("Tinyint_Tab", 1, this.sqlp, this.conn);
            byte maxByteVal = Byte.parseByte(smaxByteVal);
            this.msg.addOutputMsg(" " + maxByteVal, " " + retValue);
            if (maxByteVal == retValue) {
                this.msg.setMsg("getByte method returns : " + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the Maximum value from Tinyint", "test getByte Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                rs.close();
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte02() throws Exception {
        String sminByteVal = null;
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            String Min_Val_Query = this.sqlp.getProperty("Tinyint_Query_Min", "");
            rs = this.stmt.executeQuery(Min_Val_Query);
            rs.next();
            this.msg.setMsg("Calling getByte on Tinyint_Tab");
            byte retValue = rs.getByte(1);
            sminByteVal = this.rsSch.extractVal("Tinyint_Tab", 2, this.sqlp, this.conn);
            byte minByteVal = Byte.parseByte(sminByteVal);
            this.msg.addOutputMsg("" + minByteVal, "" + retValue);
            if (minByteVal == retValue) {
                this.msg.setMsg("getByte method returns : " + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the Minimum value from Tinyint ", "test getByte Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                rs.close();
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte03() throws Exception {
        Object snullByteVal = null;
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            String Null_Val_Query = this.sqlp.getProperty("Tinyint_Query_Null", "");
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            this.msg.setMsg("Calling getByte on Tinyint_Tab");
            byte retValue = rs.getByte(1);
            if (retValue == 0) {
                this.msg.setMsg("Calling getByte method on a SQL Null column returns" + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the value zero ", "test getByte Failed");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                rs.close();
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte76() throws Exception {
        String smaxByteVal = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        String columname = null;
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            String Max_Val_Query = this.sqlp.getProperty("Tinyint_Query_Max", "");
            rs = this.stmt.executeQuery(Max_Val_Query);
            rsmd = rs.getMetaData();
            rs.next();
            this.msg.setMsg("Calling getByte on Tinyint_Tab");
            columname = rsmd.getColumnName(1);
            byte retValue = rs.getByte(columname);
            this.msg.setMsg("Calling extractVal to get the Maximum Value of Byte");
            smaxByteVal = this.rsSch.extractVal("Tinyint_Tab", 1, this.sqlp, this.conn);
            byte maxByteVal = Byte.parseByte(smaxByteVal);
            this.msg.addOutputMsg("" + maxByteVal, "" + retValue);
            if (maxByteVal == retValue) {
                this.msg.setMsg("getByte method returns : " + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the Maximum value from Tinyint", "Call to getByte is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                rs.close();
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte77() throws Exception {
        String sminByteVal = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        String columname = null;
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            String Min_Val_Query = this.sqlp.getProperty("Tinyint_Query_Min", "");
            rs = this.stmt.executeQuery(Min_Val_Query);
            rsmd = rs.getMetaData();
            rs.next();
            this.msg.setMsg("Calling getByte on Tinyint_Tab");
            columname = rsmd.getColumnName(1);
            byte retValue = rs.getByte(columname);
            sminByteVal = this.rsSch.extractVal("Tinyint_Tab", 2, this.sqlp, this.conn);
            byte minByteVal = Byte.parseByte(sminByteVal);
            this.msg.addOutputMsg("" + minByteVal, "" + retValue);
            if (minByteVal == retValue) {
                this.msg.setMsg("getByte method returns : " + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the Minimum value from Tinyint ", "Call to getByte is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                rs.close();
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte78() throws Exception {
        Object snullByteVal = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        String columname = null;
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            String Null_Val_Query = this.sqlp.getProperty("Tinyint_Query_Null", "");
            rs = this.stmt.executeQuery(Null_Val_Query);
            rsmd = rs.getMetaData();
            rs.next();
            this.msg.setMsg("Calling getByte on Tinyint_Tab");
            columname = rsmd.getColumnName(1);
            byte retValue = rs.getByte(columname);
            if (retValue == 0) {
                this.msg.setMsg("Calling getByte method on a SQL Null column returns" + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the value zero ", "Call to getByte is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                rs.close();
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte04() throws Exception {
        ResultSet rs = null;
        String str = null;
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            str = this.rsSch.extractVal("Tinyint_Tab", 1, this.sqlp, this.conn);
            String sPrepStatement = this.sqlp.getProperty("Smallint_Tab_Max_Update", null);
            short shortVal = Short.parseShort(str);
            this.pstmt = this.conn.prepareStatement(sPrepStatement);
            this.pstmt.setShort(1, shortVal);
            this.pstmt.executeUpdate();
            String Max_Val_Query = this.sqlp.getProperty("Smallint_Query_Max", null);
            rs = this.stmt.executeQuery(Max_Val_Query);
            rs.next();
            this.msg.setMsg("Calling getByte on Smallint_Tab");
            byte retValue = rs.getByte(1);
            byte maxByteVal = Byte.parseByte(str);
            this.msg.addOutputMsg("" + maxByteVal, "" + retValue);
            if (maxByteVal == retValue) {
                this.msg.setMsg("getByte method returns : " + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the Maximum value from Smallint", "test getByte Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                rs.close();
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte05() throws Exception {
        ResultSet rs = null;
        String str = null;
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            str = this.rsSch.extractVal("Tinyint_Tab", 2, this.sqlp, this.conn);
            String sPrepStatement = this.sqlp.getProperty("Smallint_Tab_Min_Update", null);
            short shortVal = Short.parseShort(str);
            this.pstmt = this.conn.prepareStatement(sPrepStatement);
            this.pstmt.setShort(1, shortVal);
            this.pstmt.executeUpdate();
            String Min_Val_Query = this.sqlp.getProperty("Smallint_Query_Min", null);
            rs = this.stmt.executeQuery(Min_Val_Query);
            rs.next();
            this.msg.setMsg("Calling getByte on Smallint_Tab");
            byte retValue = rs.getByte(1);
            byte minByteVal = Byte.parseByte(str);
            this.msg.addOutputMsg("" + minByteVal, "" + retValue);
            if (minByteVal == retValue) {
                this.msg.setMsg("getByte method returns : " + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the Minimum value from Smallint", "test getByte Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                rs.close();
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte06() throws Exception {
        Object snullByteVal = null;
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            String Null_Val_Query = this.sqlp.getProperty("Smallint_Query_Null", "");
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            this.msg.setMsg("Calling getByte on Smallint_Tab");
            byte retValue = rs.getByte(1);
            if (retValue == 0) {
                this.msg.setMsg("Calling getByte method on a SQL Null column returns" + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the value zero ", "test getByte Failed");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                rs.close();
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte07() throws Exception {
        ResultSet rs = null;
        String str = null;
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            str = this.rsSch.extractVal("Tinyint_Tab", 1, this.sqlp, this.conn);
            String sPrepStatement = this.sqlp.getProperty("Integer_Tab_Max_Update", null);
            int intVal = Integer.parseInt(str);
            this.pstmt = this.conn.prepareStatement(sPrepStatement);
            this.pstmt.setInt(1, intVal);
            this.pstmt.executeUpdate();
            String Max_Val_Query = this.sqlp.getProperty("Integer_Query_Max", null);
            rs = this.stmt.executeQuery(Max_Val_Query);
            rs.next();
            this.msg.setMsg("Calling getByte on Integer_Tab");
            byte retValue = rs.getByte(1);
            byte maxByteVal = Byte.parseByte(str);
            this.msg.addOutputMsg("" + maxByteVal, "" + retValue);
            if (maxByteVal == retValue) {
                this.msg.setMsg("getByte method returns : " + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the Maximum value from Integer table ", "test getByte Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                rs.close();
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte08() throws Exception {
        ResultSet rs = null;
        String str = null;
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            str = this.rsSch.extractVal("Tinyint_Tab", 2, this.sqlp, this.conn);
            String sPrepStatement = this.sqlp.getProperty("Integer_Tab_Min_Update", null);
            int intVal = Integer.parseInt(str);
            this.pstmt = this.conn.prepareStatement(sPrepStatement);
            this.pstmt.setInt(1, intVal);
            this.pstmt.executeUpdate();
            String Min_Val_Query = this.sqlp.getProperty("Integer_Query_Min", null);
            rs = this.stmt.executeQuery(Min_Val_Query);
            rs.next();
            this.msg.setMsg("Calling getByte on Integer_Tab");
            byte retValue = rs.getByte(1);
            byte minByteVal = Byte.parseByte(str);
            this.msg.addOutputMsg("" + minByteVal, "" + retValue);
            if (minByteVal == retValue) {
                this.msg.setMsg("getByte method returns : " + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the Minimum value from Integer table ", "test getByte Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                rs.close();
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte09() throws Exception {
        Object snullByteVal = null;
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            String Null_Val_Query = this.sqlp.getProperty("Integer_Query_Null", "");
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            this.msg.setMsg("Calling getByte on Integer_Tab");
            byte retValue = rs.getByte(1);
            if (retValue == 0) {
                this.msg.setMsg("Calling getByte method on a SQL Null column returns" + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the value zero ", "test getByte Failed");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                rs.close();
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte13() throws Exception {
        ResultSet rs = null;
        String str = null;
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            str = this.rsSch.extractVal("Tinyint_Tab", 1, this.sqlp, this.conn);
            String sPrepStatement = this.sqlp.getProperty("Real_Tab_Max_Update", null);
            float floatVal = Float.parseFloat(str);
            this.pstmt = this.conn.prepareStatement(sPrepStatement);
            this.pstmt.setFloat(1, floatVal);
            this.pstmt.executeUpdate();
            String Max_Val_Query = this.sqlp.getProperty("Real_Query_Max", null);
            rs = this.stmt.executeQuery(Max_Val_Query);
            rs.next();
            this.msg.setMsg("Calling getByte on Real_Tab");
            byte retValue = rs.getByte(1);
            byte maxByteVal = Byte.parseByte(str);
            this.msg.addOutputMsg("" + maxByteVal, "" + retValue);
            if (maxByteVal == retValue) {
                this.msg.setMsg("getByte method returns : " + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the Maximum value from Real table ", "test getByte Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                rs.close();
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte14() throws Exception {
        ResultSet rs = null;
        String str = null;
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            str = this.rsSch.extractVal("Tinyint_Tab", 2, this.sqlp, this.conn);
            String sPrepStatement = this.sqlp.getProperty("Real_Tab_Min_Update", null);
            float floatVal = Float.parseFloat(str);
            this.pstmt = this.conn.prepareStatement(sPrepStatement);
            this.pstmt.setFloat(1, floatVal);
            this.pstmt.executeUpdate();
            String Min_Val_Query = this.sqlp.getProperty("Real_Query_Min", null);
            rs = this.stmt.executeQuery(Min_Val_Query);
            rs.next();
            this.msg.setMsg("Calling getByte on Real_Tab");
            byte retValue = rs.getByte(1);
            byte minByteVal = Byte.parseByte(str);
            this.msg.addOutputMsg("" + minByteVal, "" + retValue);
            if (minByteVal == retValue) {
                this.msg.setMsg("getByte method returns : " + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the Minimum value from Real table ", "test getByte Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                rs.close();
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte15() throws Exception {
        Object snullByteVal = null;
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            String Null_Val_Query = this.sqlp.getProperty("Real_Query_Null", "");
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            this.msg.setMsg("Calling getByte on Real_Tab");
            byte retValue = rs.getByte(1);
            if (retValue == 0) {
                this.msg.setMsg("Calling getByte method on a SQL Null column returns" + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the value zero ", "test getByte Failed");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                rs.close();
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte16() throws Exception {
        ResultSet rs = null;
        String str = null;
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            str = this.rsSch.extractVal("Tinyint_Tab", 1, this.sqlp, this.conn);
            String sPrepStatement = this.sqlp.getProperty("Float_Tab_Max_Update", null);
            double doubleVal = Double.parseDouble(str);
            this.pstmt = this.conn.prepareStatement(sPrepStatement);
            this.pstmt.setDouble(1, doubleVal);
            this.pstmt.executeUpdate();
            String Max_Val_Query = this.sqlp.getProperty("Float_Query_Max", null);
            rs = this.stmt.executeQuery(Max_Val_Query);
            rs.next();
            this.msg.setMsg("Calling getByte on Float_Tab");
            byte retValue = rs.getByte(1);
            byte maxByteVal = Byte.parseByte(str);
            this.msg.addOutputMsg("" + maxByteVal, "" + retValue);
            if (maxByteVal == retValue) {
                this.msg.setMsg("getByte method returns : " + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the Maximum value from Float table ", "test getByte Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                rs.close();
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte17() throws Exception {
        ResultSet rs = null;
        String str = null;
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            str = this.rsSch.extractVal("Tinyint_Tab", 2, this.sqlp, this.conn);
            String sPrepStatement = this.sqlp.getProperty("Float_Tab_Min_Update", null);
            double doubleVal = Double.parseDouble(str);
            this.pstmt = this.conn.prepareStatement(sPrepStatement);
            this.pstmt.setDouble(1, doubleVal);
            this.pstmt.executeUpdate();
            String Min_Val_Query = this.sqlp.getProperty("Float_Query_Min", null);
            rs = this.stmt.executeQuery(Min_Val_Query);
            rs.next();
            this.msg.setMsg("Calling getByte on Float_Tab");
            byte retValue = rs.getByte(1);
            byte minByteVal = Byte.parseByte(str);
            this.msg.addOutputMsg("" + minByteVal, "" + retValue);
            if (minByteVal == retValue) {
                this.msg.setMsg("getByte method returns : " + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the Minimum value from Float table ", "test getByte Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                rs.close();
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte18() throws Exception {
        Object snullByteVal = null;
        ResultSet rs = null;
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            String Null_Val_Query = this.sqlp.getProperty("Float_Query_Null", "");
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            this.msg.setMsg("Calling getByte on Float_Tab");
            byte retValue = rs.getByte(1);
            if (retValue == 0) {
                this.msg.setMsg("Calling getByte method on a SQL Null column returns" + retValue);
            } else {
                this.msg.printTestError("getByte method does not return the value zero ", "test getByte Failed");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte is Failed!");
        }
        finally {
            try {
                rs.close();
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws Exception {
        try {
            this.stmt.close();
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

