/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.deployment.packaging.war.modules;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.ee.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.deployment.packaging.war.modules.AlternativeBar;
import org.jboss.cdi.tck.tests.deployment.packaging.war.modules.Bar;
import org.jboss.cdi.tck.tests.deployment.packaging.war.modules.BarInspector;
import org.jboss.cdi.tck.tests.deployment.packaging.war.modules.Baz;
import org.jboss.cdi.tck.tests.deployment.packaging.war.modules.Bazinga;
import org.jboss.cdi.tck.tests.deployment.packaging.war.modules.Business;
import org.jboss.cdi.tck.tests.deployment.packaging.war.modules.BusinessOperationEvent;
import org.jboss.cdi.tck.tests.deployment.packaging.war.modules.ContainerEventsObserver;
import org.jboss.cdi.tck.tests.deployment.packaging.war.modules.Foo;
import org.jboss.cdi.tck.tests.deployment.packaging.war.modules.LegacyService;
import org.jboss.cdi.tck.tests.deployment.packaging.war.modules.LegacyServiceProducer;
import org.jboss.cdi.tck.tests.deployment.packaging.war.modules.LoggingDecorator;
import org.jboss.cdi.tck.tests.deployment.packaging.war.modules.Qux;
import org.jboss.cdi.tck.tests.deployment.packaging.war.modules.Secured;
import org.jboss.cdi.tck.tests.deployment.packaging.war.modules.SecurityInterceptor;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="2.0")
public class WebArchiveModulesTest
extends AbstractTest {
    @Inject
    Foo foo;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(WebArchiveModulesTest.class)).withClasses(new Class[]{Foo.class, Secured.class, SecurityInterceptor.class, Business.class, BusinessOperationEvent.class})).withBeansXml(new BeansXml().alternatives(new Class[]{AlternativeBar.class}))).withBeanLibrary(new BeansXml().interceptors(new Class[]{SecurityInterceptor.class}), new Class[]{Bar.class, AlternativeBar.class, BarInspector.class})).withBeanLibrary(new BeansXml().decorators(new Class[]{LoggingDecorator.class}), new Class[]{Baz.class, LoggingDecorator.class, Bazinga.class})).withBeanLibrary(new Class[]{Qux.class, ContainerEventsObserver.class, LegacyServiceProducer.class})).withLibrary(new Class[]{LegacyService.class})).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="init_events", id="bb")})
    public void testExtensionAndContainerEvents() throws Exception {
        Assert.assertTrue((boolean)ContainerEventsObserver.allEventsOk());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bean_archive_ee", id="jg"), @SpecAssertion(section="bean_archive_ee", id="jh"), @SpecAssertion(section="performing_typesafe_resolution", id="n")})
    public void testInjectionChainVisibilityAndInterceptorEnablement() {
        SecurityInterceptor.reset();
        Bar bar = this.foo.getBar();
        Assert.assertTrue((boolean)bar.isAlternative());
        Assert.assertTrue((boolean)bar.getBaz().getId().equals(bar.getQux().getBaz().getId()));
        Assert.assertEquals((int)SecurityInterceptor.getNumberOfInterceptions(), (int)3);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="decorator_resolution", id="aa"), @SpecAssertion(section="enabled_decorators_bean_archive", id="a"), @SpecAssertion(section="observer_resolution", id="c")})
    public void testDecoratorAndCrossModuleEventObserver() throws Exception {
        this.foo.getBar().getBaz().businessOperation1();
        this.foo.businessOperation1();
        Assert.assertEquals((int)LoggingDecorator.getNumberOfDecorationsPerformed(), (int)1);
        Assert.assertEquals((int)Qux.getEventsObserved(), (int)1);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="producer_method", id="aa"), @SpecAssertion(section="producer_method", id="c"), @SpecAssertion(section="observer_resolution", id="c")})
    public void testProducerAndEventDuringDisposal() throws Exception {
        Bean bean = this.getUniqueBean(LegacyService.class, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext((Contextual)bean);
        LegacyService instance = (LegacyService)bean.create(ctx);
        bean.destroy((Object)instance, ctx);
        Assert.assertTrue((boolean)Foo.legacyObserved);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="declaring_selected_alternatives_bean_archive", id="i")})
    public void testAlternatives(BarInspector barInspector) throws Exception {
        Set beans = this.getCurrentManager().getBeans(AlternativeBar.class, new Annotation[0]);
        Assert.assertEquals((int)beans.size(), (int)1);
        Assert.assertEquals((Object)((Bean)beans.iterator().next()).getBeanClass(), AlternativeBar.class);
        Assert.assertFalse((boolean)barInspector.getBar().isAlternative());
    }
}

