/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entityManager2;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entityManager2.DoesNotExist;
import ee.jakarta.tck.persistence.core.entityManager2.Employee;
import ee.jakarta.tck.persistence.core.entityManager2.Order;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Query;
import jakarta.persistence.StoredProcedureQuery;
import jakarta.persistence.TransactionRequiredException;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Client1
extends PMClientBase {
    Employee[] empRef = new Employee[5];
    Order[] orders = new Order[5];
    Properties props = null;
    Map map = new HashMap();
    Employee emp = new Employee(1, "foo", "bar", this.getUtilDate("2000-02-14"), 35000.0f);
    String dataBaseName = null;
    static final String ORACLE = "oracle";

    public static void main(String[] args) {
        Client1 theTests = new Client1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.map.putAll(this.getEntityManager().getProperties());
            this.map.put("foo", "bar");
            this.displayMap(this.map);
            this.dataBaseName = p.getProperty("jdbc.db");
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findExceptionsTest() throws Exception {
        int pass = 0;
        this.logMsg("Testing findClassObjectIllegalArgumentException");
        this.logMsg("Invalid Object test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Client1.class, (Object)1);
            this.getEntityTransaction().commit();
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        this.logMsg("Invalid PK test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Order.class, (Object)"PK");
            this.getEntityTransaction().commit();
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        this.logMsg("Null PK test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Order.class, null);
            this.getEntityTransaction().commit();
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        this.logMsg("Testing findClassObjectMapIllegalArgumentException");
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        this.logTrace("Invalid Object test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Client1.class, (Object)1, myMap);
            this.getEntityTransaction().commit();
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        this.logMsg("Invalid PK test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Order.class, (Object)"PK", myMap);
            this.getEntityTransaction().commit();
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        this.logMsg("Null PK test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Order.class, null, myMap);
            this.getEntityTransaction().commit();
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        this.logMsg("Testing findClassObjectLockModeTypeIllegalArgumentException");
        this.logMsg("Invalid Object test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Client1.class, (Object)1, LockModeType.NONE);
            this.getEntityTransaction().commit();
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        this.logMsg("Invalid PK test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Order.class, (Object)"PK", LockModeType.NONE);
            this.getEntityTransaction().commit();
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        this.logMsg("Null PK test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Order.class, null, LockModeType.NONE);
            this.getEntityTransaction().commit();
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        this.logMsg("Testing findClassObjectLockModeTypeTransactionRequiredException");
        try {
            if (this.getEntityTransaction().isActive()) {
                this.logTrace("A transaction is active, execute rollback");
                this.getEntityTransaction().rollback();
            } else {
                this.logTrace("No transaction is active");
            }
        }
        catch (Exception fe) {
            this.logErr("Unexpected exception rolling back TX:", fe);
        }
        try {
            this.getEntityManager().find(Order.class, (Object)1, LockModeType.PESSIMISTIC_READ);
            this.logErr("TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException tre) {
            this.logTrace("TransactionRequiredException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing findClassObjectLockModeTypeMapIllegalArgumentException");
        this.logMsg("Invalid Object test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Client1.class, (Object)1, LockModeType.NONE, myMap);
            this.getEntityTransaction().commit();
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        this.logMsg("Invalid PK test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Order.class, (Object)"PK", LockModeType.NONE, myMap);
            this.getEntityTransaction().commit();
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        this.logMsg("Null PK test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Order.class, null, LockModeType.NONE, myMap);
            this.getEntityTransaction().commit();
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        this.logMsg("Testing findClassObjectLockModeTypeMapTransactionRequiredException");
        try {
            if (this.getEntityTransaction().isActive()) {
                this.logTrace("A transaction is active, execute rollback");
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception fe) {
            this.logErr("Unexpected exception rolling back TX:", fe);
        }
        try {
            this.getEntityManager().find(Order.class, (Object)0, LockModeType.PESSIMISTIC_READ, myMap);
            this.logErr("TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException tre) {
            this.logTrace("TransactionRequiredException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (pass != 14) {
            throw new Exception("findExceptionsTest failed");
        }
    }

    public void flushExceptionsTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityManager().flush();
            this.logErr("TransactionRequiredException was not thrown");
        }
        catch (TransactionRequiredException e) {
            this.logTrace("TransactionRequiredException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("flushExceptionsTest failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback1Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().contains(PMClientBase.class);
            this.logErr("RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback1Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback2Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNamedQuery("doesnotexist");
            this.logErr("RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback2Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback3Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNamedQuery("doesnotexist", PMClientBase.class);
            this.logErr("RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback3Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback4Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNamedStoredProcedureQuery("doesnotexist");
            this.logErr("RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback4Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityManagerMethodsRuntimeExceptionsCauseRollback5Test() throws Exception {
        boolean pass;
        block17: {
            pass = false;
            try {
                this.getEntityTransaction().begin();
                CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
                CriteriaDelete cd = cbuilder.createCriteriaDelete(DoesNotExist.class);
                cd.from(DoesNotExist.class);
                try {
                    Query q = this.getEntityManager().createQuery(cd);
                    this.logMsg("RuntimeException wasn't thrown, try executing it");
                    q.executeUpdate();
                    this.logErr("RuntimeException not thrown");
                }
                catch (RuntimeException e) {
                    this.logTrace("RuntimeException Caught as Expected.", e);
                    if (!this.getEntityTransaction().getRollbackOnly()) {
                        this.logErr("Transaction was not marked for rollback");
                        break block17;
                    }
                    this.logTrace("Transaction was marked for rollback");
                    pass = true;
                }
                catch (Exception e) {
                    this.logErr("Unexpected exception occurred", e);
                }
            }
            catch (Exception e) {
                this.logErr("Unexpected exception occurred while creating CriteriaDelete", e);
            }
            finally {
                try {
                    if (this.getEntityTransaction().isActive()) {
                        this.getEntityTransaction().rollback();
                    }
                }
                catch (Exception fe) {
                    this.logErr("Unexpected exception rolling back TX:", fe);
                }
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback5Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityManagerMethodsRuntimeExceptionsCauseRollback6Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            CriteriaQuery cquery = cbuilder.createQuery(PMClientBase.class);
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            this.logMsg("RuntimeException wasn't thrown, try executing it");
            q.executeUpdate();
            this.logErr("RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback6Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityManagerMethodsRuntimeExceptionsCauseRollback7Test() throws Exception {
        boolean pass;
        block17: {
            pass = false;
            try {
                this.getEntityTransaction().begin();
                CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
                CriteriaUpdate cu = cbuilder.createCriteriaUpdate(DoesNotExist.class);
                Root root = cu.from(DoesNotExist.class);
                cu.where((Expression)cbuilder.equal((Expression)root.get("id"), (Object)1));
                cu.set(root.get("firstName"), (Object)"foobar");
                try {
                    Query q = this.getEntityManager().createQuery(cu);
                    this.logMsg("RuntimeException wasn't thrown, try executing it");
                    q.executeUpdate();
                    this.logErr("RuntimeException not thrown");
                }
                catch (RuntimeException e) {
                    this.logTrace("RuntimeException Caught as Expected.");
                    if (!this.getEntityTransaction().getRollbackOnly()) {
                        this.logErr("Transaction was not marked for rollback");
                        break block17;
                    }
                    this.logTrace("Transaction was marked for rollback");
                    pass = true;
                }
                catch (Exception e) {
                    this.logErr("Unexpected exception occurred", e);
                }
            }
            catch (Exception e) {
                this.logErr("Unexpected exception occurred while creating CriteriaUpdate", e);
            }
            finally {
                try {
                    if (this.getEntityTransaction().isActive()) {
                        this.getEntityTransaction().rollback();
                    }
                }
                catch (Exception fe) {
                    this.logErr("Unexpected exception rolling back TX:", fe);
                }
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback7Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback8Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createQuery("invalid");
            this.logErr("RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback8Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback9Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createQuery("invalid", PMClientBase.class);
            this.logErr("RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback9Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback10Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("doesnotexist");
            this.logMsg("RuntimeException not thrown, try executing it");
            spq.execute();
            this.logErr("RuntimeException was not thrown, after trying to executing it");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback10Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback11Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("doesnotexist", new Class[]{PMClientBase.class});
            this.logMsg("RuntimeException not thrown, try executing it");
            spq.execute();
            this.logErr("RuntimeException was not thrown, after trying to executing it");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback11Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback12Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("doesnotexist", new String[]{"doesnotexist"});
            this.logMsg("RuntimeException not thrown, try executing it");
            spq.execute();
            this.logErr("RuntimeException was not thrown, after trying to executing it");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback12Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback13Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().detach(PMClientBase.class);
            this.logErr("RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback13Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback14Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(PMClientBase.class, (Object)"doesnotexist");
            this.logErr("RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback14Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback15Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(PMClientBase.class, (Object)"doesnotexist", LockModeType.NONE);
            this.logErr("RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback15Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback16Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(PMClientBase.class, (Object)"doesnotexist", LockModeType.NONE, this.map);
            this.logErr("RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback16Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback17Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(PMClientBase.class, (Object)"doesnotexist", this.map);
            this.logErr("RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback17Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback21Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().getLockMode(PMClientBase.class);
            this.logErr("RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback21Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback23Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().getReference(PMClientBase.class, (Object)"doesnotexist");
            this.logErr("RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback23Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback24Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().lock(PMClientBase.class, LockModeType.NONE);
            this.logErr("RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback24Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback25Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().lock(PMClientBase.class, LockModeType.NONE, this.map);
            this.logErr("RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback25Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback26Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().merge(PMClientBase.class);
            this.logErr("RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback26Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback27Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist(PMClientBase.class);
            this.logErr("RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback27Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback28Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh(PMClientBase.class);
            this.logErr("RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback28Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback29Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh(PMClientBase.class, LockModeType.NONE);
            this.logErr("RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback29Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback30Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh(PMClientBase.class, LockModeType.NONE, this.map);
            this.logErr("RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback30Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback31Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh(PMClientBase.class, this.map);
            this.logErr("RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback31Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback32Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().remove(PMClientBase.class);
            this.logErr("RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            this.logTrace("RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                this.logErr("Transaction was not marked for rollback");
            } else {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback32Test failed");
        }
    }
}

