/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.common.util;

import ee.jakarta.tck.pages.common.util.JspTestUtil;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.PageContext;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class MethodValidatorBean {
    private String _methods = null;
    private PageContext _context = null;
    private String _name = null;

    public String getMethods() {
        return this._methods;
    }

    public void setMethods(String methods) {
        this._methods = methods;
    }

    public PageContext getContext() {
        return this._context;
    }

    public void setContext(PageContext context) {
        this._context = context;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getResult() throws JspException {
        Object message = null;
        List list = (List)this._context.getAttribute(this._name, 4);
        if (list != null) {
            String[] expectedMethods;
            String[] calledMethods = MethodValidatorBean.getMethodsFromList(list);
            if (calledMethods.length == (expectedMethods = this.getMethodsAsArray()).length) {
                for (int i = 0; i < expectedMethods.length; ++i) {
                    message = calledMethods[i].equals(expectedMethods[i]) ? "Test PASSED" : "Test FAILED.  Expected the following method method sequence to be called against the tag handler by the container: [ " + this._methods + " ]\nActual sequence: " + JspTestUtil.getAsString(calledMethods);
                }
            } else {
                message = calledMethods.length > expectedMethods.length ? "Test FAILED.  The container called more methods against the tag handler than expected. Expected: [ " + this._methods + " ]\nActual: " + JspTestUtil.getAsString(calledMethods) : "Test FAILED.  The container called fewer methods against the tag handler than expected. Expected: [ " + this._methods + " ]\nActual: " + JspTestUtil.getAsString(calledMethods);
            }
        } else {
            message = "Test FAILED.  Unable to obtain List of methods from the PageContext.";
        }
        this._context.removeAttribute(this._name, 4);
        return message;
    }

    private String[] getMethodsAsArray() {
        if (this._methods == null) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(this._methods, ",");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return MethodValidatorBean.getMethodsFromList(list);
    }

    private static String[] getMethodsFromList(List list) {
        if (list == null) {
            return new String[0];
        }
        return list.toArray(new String[list.size()]);
    }
}

