/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.vehicle.ejb;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.RemoteStatus;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import jakarta.ejb.EJBException;
import java.util.Properties;

public class EJBVehicle {
    private EETest testObj;
    private Properties properties;
    private String[] arguments;

    public void initialize(String[] args, Properties p) {
        try {
            TestUtil.init(p);
        }
        catch (Exception e) {
            TestUtil.logErr("initLogging failed in ejb vehicle.", e);
            throw new EJBException();
        }
        this.arguments = args;
        this.properties = p;
        try {
            String testClassName = TestUtil.getProperty(this.properties, "test_classname");
            Class<?> c = Class.forName(testClassName);
            this.testObj = (EETest)c.newInstance();
        }
        catch (Exception e) {
            TestUtil.logErr("Failed to create the EETest instance in the vehicle", e);
            throw new EJBException();
        }
        TestUtil.logTrace("initialize");
    }

    public RemoteStatus runTest() {
        RemoteStatus sTestStatus = new RemoteStatus(Status.passed(""));
        TestUtil.logTrace("in runTest()");
        try {
            sTestStatus = new RemoteStatus(this.testObj.run(this.arguments, this.properties));
            if (sTestStatus.getType() == 0) {
                TestUtil.logMsg("Test running in ejb vehicle passed");
            } else {
                TestUtil.logMsg("Test running in ejb vehicle failed");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            TestUtil.logErr("Test running in ejb vehicle failed", e);
            sTestStatus = new RemoteStatus(Status.failed("Test running in ejb vehicle failed"));
        }
        return sTestStatus;
    }
}

