/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.escapeSyntax.scalar1;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.fnSchema;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="tck-javatest")})
public class scalarClient1
extends ServiceEETest {
    private static final String testName = "jdbc.ee.escapeSyntax";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private Statement stmt = null;
    private ResultSet rs = null;
    private String drManager = null;
    private fnSchema fnSch = null;
    private Properties props = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        scalarClient1 theTests = new scalarClient1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.props = p;
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.stmt = this.conn.createStatement();
                this.fnSch = new fnSchema();
                this.fnSch.createTable(p, this.conn);
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!", e);
        }
    }

    public void testConcat() throws Exception {
        try {
            String queryString = null;
            this.msg.setMsg("Query that contains a call to the function concat.");
            queryString = this.props.getProperty("Concat_Fn_Query", "");
            this.msg.setMsg(queryString);
            this.rs = this.stmt.executeQuery(queryString);
            this.rs.next();
            String retString = this.rs.getString(1);
            this.msg.setMsg("Concatenated String: " + retString);
            this.rs.close();
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to testConcat Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testConcat Failed!");
        }
    }

    public void testAscii() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isStringFuncFound("ASCII", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("String function ASCII is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("String function ASCII is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testAscii Failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Ascii_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("The ASCII value of the leftmost character=" + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testAscii Failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testAscii Failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testInsert() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isStringFuncFound("INSERT", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("String function INSERT is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("String function INSERT is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testInsert Failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Insert_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("The string after insertion: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testInsert Failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testInsert Failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testLcase() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isStringFuncFound("LCASE", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("String function LCASE is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("String function LCASE is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testLcase Failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Lcase_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Lowercase String: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testLcase Failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testLcase Failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testLeft() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isStringFuncFound("LEFT", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("String function LEFT is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("String function LEFT is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testLeft Failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Left_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("The first 2 chars: <" + retString + ">");
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testLeft Failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testLeft Failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testLength() throws Exception {
        try {
            String queryString = null;
            this.msg.setMsg("Query that contains a call to the function length");
            queryString = this.props.getProperty("Length_Fn_Query", "");
            this.msg.setMsg(queryString);
            this.rs = this.stmt.executeQuery(queryString);
            this.rs.next();
            String retString = this.rs.getString(1);
            this.msg.setMsg("String length=" + retString);
            this.rs.close();
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to testLength Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testLength Failed!");
        }
    }

    public void testLocate01() throws Exception {
        try {
            String queryString = null;
            queryString = this.props.getProperty("Locate_Fn_Query", "");
            this.msg.setMsg(queryString);
            this.rs = this.stmt.executeQuery(queryString);
            this.rs.next();
            String retString = this.rs.getString(1);
            this.msg.setMsg("str1 starts at " + retString + " of str2");
            this.rs.close();
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to testLocate01 Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testLocate01 Failed!");
        }
    }

    public void testLtrim() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isStringFuncFound("LTRIM", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("String function LTRIM is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("String function LTRIM is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testLtrim Failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Ltrim_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("String after Left Trim: <" + retString + ">");
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testLtrim Failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testLtrim Failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testRepeat() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isStringFuncFound("REPEAT", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("String function REPEAT is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("String function REPEAT is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testRepeat Failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Repeat_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("The repeated string: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testRepeat Failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testRepeat Failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testRight() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isStringFuncFound("RIGHT", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("String function RIGHT is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("String function RIGHT is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testRight Failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Right_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("The last 3 chars: <" + retString + ">");
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testRight Failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testRight Failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testRtrim() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isStringFuncFound("RTRIM", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("String function RTRIM is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("String function RTRIM is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testRtrim Failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Rtrim_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("String after Right Trim: <" + retString + ">");
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testRtrim Failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testRtrim Failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testSoundex() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isStringFuncFound("SOUNDEX", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("String function SOUNDEX is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("String function SOUNDEX is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testSoundex Failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Soundex_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Sound of the word: <" + retString + ">");
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testSoundex Failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testSoundex Failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testSpace() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isStringFuncFound("SPACE", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("String function SPACE is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("String function SPACE is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testSpace Failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Space_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Space string: <" + retString + ">");
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testSpace Failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testSpace Failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testSubstring() throws Exception {
        try {
            String queryString = null;
            queryString = this.props.getProperty("Substring_Fn_Query", "");
            this.rs = this.stmt.executeQuery(queryString);
            this.rs.next();
            String retString = this.rs.getString(1);
            this.msg.setMsg("Sub string: <" + retString + ">");
            this.rs.close();
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to testSubstring Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testSubstring Failed!");
        }
    }

    public void testUcase() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isStringFuncFound("UCASE", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("String function UCASE is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("String function UCASE is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testUcase Failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Ucase_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Uppercase String: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testUcase Failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testUcase Failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testChar() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isStringFuncFound("CHAR", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("String function CHAR is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("String function CHAR is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testChar Failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Char_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Resultant Char is <" + retString + ">");
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testChar Failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testChar Failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testReplace() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isStringFuncFound("REPLACE", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("String function REPLACE is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("String function REPLACE is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testReplace Failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Replace_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("String after replacement: <" + retString + ">");
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testReplace Failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testReplace Failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testUser() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isSystemFuncFound("USER", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("System function USER is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("System function USER is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testUser Failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("User_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("User Name: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testUser Failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testUser Failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testIfNull() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isSystemFuncFound("IFNULL", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("System function IFNULL is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("System function IFNULL is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testIfNull Failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Ifnull_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("<" + retString + ">");
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testIfNull Failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testIfNull Failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testSin() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isNumericFuncFound("SIN", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Numeric function SIN  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Numeric function SIN is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testSin!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Sin_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("<" + retString + ">");
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testSin!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testSin!");
            }
        }
        this.msg.printTestMsg();
    }

    public void cleanup() throws Exception {
        try {
            this.stmt.close();
            this.fnSch.dropTable(this.props, this.conn);
            this.fnSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

