/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.basic.common;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.lite.basic.common.Basic1IF;
import com.sun.ts.tests.ejb30.lite.basic.common.BasicBeanHelper;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBContext;
import jakarta.ejb.PostActivate;
import jakarta.ejb.PrePassivate;
import jakarta.ejb.SessionContext;

public abstract class BasicBeanBase
implements Basic1IF {
    @Resource
    private SessionContext sessionContext;
    @Resource
    private EJBContext ejbContext;

    public Class<?> getBusinessInterface() {
        return this.sessionContext.getInvokedBusinessInterface();
    }

    @PostConstruct
    @PostActivate
    private void postConstruct() {
        Helper.getLogger().info("In postConstruct of " + this);
        Helper.assertNotEquals("check sessionContext not null", null, this.sessionContext);
        Helper.assertNotEquals("check ejbContext not null", null, this.ejbContext);
    }

    @PrePassivate
    private void prePassivate() {
        Helper.getLogger().info("In prePassivate of " + this);
    }

    @PreDestroy
    private void preDestroy() {
        Helper.getLogger().info("In preDestroy of " + this);
    }

    @Override
    public int add(int a, int b) {
        return a + b;
    }

    public String globalJNDI(String appName, String modName) {
        StringBuilder reason = new StringBuilder();
        BasicBeanHelper.globalJNDI(appName, modName, this.getBusinessInterface(), reason, this.ejbContext, null);
        return reason.toString();
    }

    public String appJNDI(String moduleName) {
        StringBuilder reason = new StringBuilder();
        BasicBeanHelper.appJNDI(moduleName, this.getBusinessInterface(), reason, this.ejbContext);
        return reason.toString();
    }

    public String moduleJNDI() {
        StringBuilder reason = new StringBuilder();
        BasicBeanHelper.moduleJNDI(this.getBusinessInterface(), reason, this.ejbContext);
        return reason.toString();
    }
}

