/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.rsMeta;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class rsMetaClient
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.rsMeta";
    private TSNamingContextInterface jc = null;
    private transient Connection coffeeCon = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private String drManager = null;
    private String query = null;
    private ResultSet rs = null;
    private ResultSetMetaData rsmd = null;
    private Statement stmt = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        rsMetaClient theTests = new rsMetaClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                String fTableName = p.getProperty("ftable", "");
                this.query = "SELECT COF_NAME, PRICE FROM " + fTableName;
                if (this.query.length() == 0) {
                    throw new Exception("Invalid SQL Statement ");
                }
                this.logTrace("SQL Statement : " + this.query);
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.coffeeCon = dmCon.getConnection(p);
                    this.dbSch = new dbSchema();
                    this.dbSch.createData(p, this.coffeeCon);
                    this.stmt = this.coffeeCon.createStatement();
                    this.rs = this.stmt.executeQuery(this.query);
                    this.rsmd = this.rs.getMetaData();
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.coffeeCon = dsCon.getConnection(p);
                    this.dbSch = new dbSchema();
                    this.dbSch.createData(p, this.coffeeCon);
                    this.stmt = this.coffeeCon.createStatement();
                    this.rs = this.stmt.executeQuery(this.query);
                    this.rsmd = this.rs.getMetaData();
                }
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void testGetColumnCount() throws Exception {
        try {
            this.msg.setMsg("Calling getColumnCount on ResultSetMetaData");
            int coloumnCount = this.rsmd.getColumnCount();
            if (coloumnCount >= 0) {
                this.msg.setMsg("getColumnCount method returns: " + coloumnCount);
            } else {
                this.msg.printTestError(" getColumnCount method returns a negative value", "Call to getColumnCount is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getColumnCount is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getColumnCount is Failed!");
        }
    }

    public void testIsAutoIncrement() throws Exception {
        try {
            this.msg.setMsg("Calling isAutoIncrement on ResultSetMetaData");
            boolean retValue = this.rsmd.isAutoIncrement(1);
            if (retValue) {
                this.msg.setMsg("isAutoIncrement method returns column is automatically numbered");
            } else {
                this.msg.setMsg("isAutoIncrement method returns column cannot be automatically numbered");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to isAutoIncrement is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to isAutoIncrement is Failed!");
        }
    }

    public void testIsCaseSensitive() throws Exception {
        try {
            this.msg.setMsg("Calling isCaseSensitive on ResultSetMetaData");
            boolean retValue = this.rsmd.isCaseSensitive(1);
            if (retValue) {
                this.msg.setMsg("isCaseSensitive method returns column's are case sensitive");
            } else {
                this.msg.setMsg("isCaseSensitive method returns column's are case insensitive");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to isCaseSensitive is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to isCaseSensitive is Failed!");
        }
    }

    public void testIsSearchable() throws Exception {
        try {
            this.msg.setMsg("Calling isSearchable on ResultSetMetaData");
            boolean retValue = this.rsmd.isSearchable(1);
            if (retValue) {
                this.msg.setMsg("isSearchable method returns column can be used in a where clause");
            } else {
                this.msg.setMsg("isSearchable method returns column cannot be used in a where clause");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to isSearchable is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to isSearchable is Failed!");
        }
    }

    public void testIsCurrency() throws Exception {
        try {
            this.msg.setMsg("Calling IsCurrency on ResultSetMetaData");
            boolean retValue = this.rsmd.isCurrency(2);
            if (retValue) {
                this.msg.setMsg("isCurrency method returns column is a cash value");
            } else {
                this.msg.setMsg("isCurrency method returns column does not contains a cash value");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to isCurrency is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to isCurrency is Failed!");
        }
    }

    public void testIsNullable() throws Exception {
        try {
            this.msg.setMsg("Calling isNullable on ResultSetMetaData");
            int coloumnCount = this.rsmd.isNullable(2);
            if (coloumnCount == 0 || coloumnCount == 1 || coloumnCount == 2) {
                this.msg.setMsg("isNullable method returns: " + coloumnCount);
            } else {
                this.msg.printTestError(" isNullable method returns a negative value", "Call to isNullable is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to isNullable is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to isNullable is Failed!");
        }
    }

    public void testIsSigned() throws Exception {
        try {
            this.msg.setMsg("Calling isSigned on ResultSetMetaData");
            boolean retValue = this.rsmd.isSigned(2);
            if (retValue) {
                this.msg.setMsg("isSigned method returns values in the column are signed numbers");
            } else {
                this.msg.setMsg("isSigned method returns values in the column are unsigned numbers");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to isSigned is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to isSigned is Failed!");
        }
    }

    public void testGetColumnDisplaySize() throws Exception {
        try {
            this.msg.setMsg("Calling getColumnDisplaySize on ResultSetMetaData");
            int colDispSize = this.rsmd.getColumnDisplaySize(2);
            if (colDispSize >= 0) {
                this.msg.setMsg("getColumnDisplaySize method returns: " + colDispSize);
            } else {
                this.msg.printTestError(" getColumnDisplaySize method returns a negative value", "Call to getColumnDisplaySize is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getColumnDisplaySize is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getColumnDisplaySize is Failed!");
        }
    }

    public void testGetColumnLabel() throws Exception {
        try {
            this.msg.setMsg("Calling getColumnLabel on ResultSetMetadata");
            String sRetValue = this.rsmd.getColumnLabel(2);
            if (sRetValue == null) {
                this.msg.setMsg("getColumnLabel method does not returns the suggested column title");
            } else {
                this.msg.setMsg("getColumnLabel method returns:  " + sRetValue);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getColumnLabel is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getColumnLabel is Failed!");
        }
    }

    public void testGetColumnName() throws Exception {
        try {
            this.msg.setMsg("Calling getColumnName on ResultSetMetadata");
            String sRetValue = this.rsmd.getColumnName(2);
            if (sRetValue == null) {
                this.msg.setMsg("getColumnName method does not returns the column name");
            } else {
                this.msg.setMsg("getColumnName method returns:  " + sRetValue);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getColumnName is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getColumnName is Failed!");
        }
    }

    public void testGetSchemaName() throws Exception {
        try {
            this.msg.setMsg("Calling getSchemaName on ResultSetMetadata");
            String sRetValue = this.rsmd.getSchemaName(2);
            if (sRetValue == null) {
                this.msg.setMsg("getSchemaName method does not returns the schema name ");
            } else {
                this.msg.setMsg("getSchemaName returns:  " + sRetValue);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getColumnName is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getColumnName is Failed!");
        }
    }

    public void testGetPrecision() throws Exception {
        try {
            this.msg.setMsg("Calling getPrecision on ResultSetMetaData");
            int precisionSize = this.rsmd.getPrecision(1);
            if (precisionSize >= 0) {
                this.msg.setMsg("getPrecision method returns: " + precisionSize);
            } else {
                this.msg.printTestError(" getPrecision method returns a negative value", "Call to getPrecision is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getPrecision is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getPrecision is Failed!");
        }
    }

    public void testGetScale() throws Exception {
        try {
            this.msg.setMsg("Calling getScale on ResultSetMetaData");
            int scaleSize = this.rsmd.getScale(2);
            if (scaleSize >= 0) {
                this.msg.setMsg("getScale method returns: " + scaleSize);
            } else {
                this.msg.printTestError(" getScale method returns a negative value", "Call to getScale is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getScale is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getScale is Failed!");
        }
    }

    public void testGetTableName() throws Exception {
        try {
            this.msg.setMsg("Calling getTableName on ResultSetMetadata");
            String sRetValue = this.rsmd.getTableName(1);
            if (sRetValue == null) {
                this.msg.setMsg("getTableName method does not returns the column's table name");
            } else {
                this.msg.setMsg("getTableName method returns:  " + sRetValue);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTableName is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTableName is Failed!");
        }
    }

    public void testGetCatalogName() throws Exception {
        try {
            this.msg.setMsg("Calling getCatalogName on ResultSetMetadata");
            String sRetValue = this.rsmd.getCatalogName(1);
            if (sRetValue == null) {
                this.msg.setMsg("getCatalogName method does not returns the column's table's catalog name");
            } else {
                this.msg.setMsg("getCatalogName method returns:  " + sRetValue);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getCatalogName is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getCatalogName is Failed!");
        }
    }

    public void testGetColumnType() throws Exception {
        try {
            this.msg.setMsg("Calling getColumnType on ResultSetMetaData");
            int colType = this.rsmd.getColumnType(1);
            switch (colType) {
                case -7: 
                case -6: 
                case -5: 
                case -4: 
                case -3: 
                case -2: 
                case -1: 
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 91: 
                case 92: 
                case 93: 
                case 1111: 
                case 2000: 
                case 2001: 
                case 2002: 
                case 2003: 
                case 2004: 
                case 2005: 
                case 2006: {
                    this.msg.setMsg("getColumnType method returns: " + colType);
                    break;
                }
                default: {
                    this.msg.printTestError(" getColumnType method returns a illegal value", "Call to getColumnTypeName failed !");
                }
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getColumnTypeName failed !");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getColumnTypeName failed !");
        }
    }

    public void testGetColumnTypeName() throws Exception {
        try {
            this.msg.setMsg("Calling getColumnTypeName on ResultSetMetadata");
            String sRetValue = this.rsmd.getColumnTypeName(1);
            if (sRetValue == null) {
                this.msg.setMsg("getColumnTypeName method does not returns the type name used by the database ");
            } else {
                this.msg.setMsg("getColumnTypeName method returns:  " + sRetValue);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getColumnTypeName is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getColumnTypeName is Failed!");
        }
    }

    public void testIsReadOnly() throws Exception {
        try {
            this.msg.setMsg("Calling isReadOnly on ResultSetMetaData");
            boolean retValue = this.rsmd.isReadOnly(1);
            if (retValue) {
                this.msg.setMsg("isReadOnly method returns column cannot be writable");
            } else {
                this.msg.setMsg("isReadOnly method returns column can be writable");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to isReadOnly is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to isReadOnly is Failed!");
        }
    }

    public void testIsWritable() throws Exception {
        try {
            this.msg.setMsg("Calling isWritable on ResultSetMetaData");
            boolean retValue = this.rsmd.isWritable(1);
            if (retValue) {
                this.msg.setMsg("isWritable method returns column is writable");
            } else {
                this.msg.setMsg("isWritable method returns column cannot be writable");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to isWritable is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to isWritable is Failed!");
        }
    }

    public void testIsDefinitelyWritable() throws Exception {
        try {
            this.msg.setMsg("Calling isDefinitelyWritable on ResultSetMetaData");
            boolean retValue = this.rsmd.isDefinitelyWritable(1);
            if (retValue) {
                this.msg.setMsg("isDefinitelyWritable method returns write on the column is definitely succeed");
            } else {
                this.msg.setMsg("isDefinitelyWritable method returns write on the column is definitely failed");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to isDefinitelyWritable is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to isDefinitelyWritable is Failed!");
        }
    }

    public void testGetColumnClassName() throws Exception {
        try {
            this.msg.setMsg("Calling getColumnClassName on ResultSetMetadata");
            String sRetValue = this.rsmd.getColumnClassName(1);
            if (sRetValue == null) {
                this.msg.setMsg("getColumnClassName method does not returns the fully-qualified name of the class");
            } else {
                this.msg.setMsg("getColumnClassName method returns:  " + sRetValue);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getColumnClassName is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getColumnClassName is Failed!");
        }
    }

    public void cleanup() throws Exception {
        try {
            this.stmt.close();
            this.dbSch.destroyData(this.coffeeCon);
            this.dbSch.dbUnConnect(this.coffeeCon);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

