/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.override.nocallbacklistener;

import ee.jakarta.tck.persistence.core.override.util.CallBackCounts;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.PostPersist;
import jakarta.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name="NOENTITYLISTENER_TABLE")
public class NoCallBackListener
implements Serializable {
    private Long id;

    @Id
    @Column(name="ID")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void prePersistFromXML() {
        this.updateCallBackCount("prePersistFromXML");
    }

    public void preRemoveFromXML() {
        this.updateCallBackCount("preRemoveFromXML");
    }

    public void postRemoveFromXML() {
        this.updateCallBackCount("postRemoveFromXML");
    }

    @PostPersist
    public void postPersistFromXML() {
        this.updateCallBackCount("postPersist");
    }

    public void postLoadFromXML() {
        this.updateCallBackCount("postLoadFromXML");
    }

    protected void updateCallBackCount(String callBackKeyName) {
        CallBackCounts.updateCount(callBackKeyName);
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof NoCallBackListener)) {
            return false;
        }
        NoCallBackListener other = (NoCallBackListener)object;
        return this.id == other.id || this.id != null && this.id.equals(other.id);
    }

    public String toString() {
        return "override.nocallbacklistener.NoCallBackListener id=" + this.id;
    }
}

