/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.misc;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Customer_;
import ee.jakarta.tck.persistence.common.schema30.Order;
import ee.jakarta.tck.persistence.common.schema30.Util;
import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.EntityType;
import java.util.List;
import java.util.Set;

public class Client1
extends Util {
    public static void main(String[] args) {
        Client1 theTests = new Client1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void predicateIsNegatedTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.logMsg("Testing default");
        Predicate pred = cbuilder.equal(cbuilder.literal((Object)"1"), (Object)"1");
        Boolean result = pred.isNegated();
        if (!result.booleanValue()) {
            this.logTrace("Received expected result:" + result);
            pass1 = true;
        } else {
            this.logErr("Expected:false , actual:" + result);
        }
        pred = null;
        this.logMsg("Testing when Predicate.not is present");
        pred = cbuilder.equal(cbuilder.literal((Object)"1"), (Object)"1").not();
        result = pred.isNegated();
        if (result.booleanValue()) {
            this.logTrace("Received expected result:" + result);
            pass2 = true;
        } else {
            this.logErr("Expected:true, actual:" + result);
        }
        pred = null;
        this.logMsg("Testing when CriteriaBuilder.not is present");
        pred = cbuilder.not((Expression)cbuilder.equal(cbuilder.literal((Object)"1"), (Object)"1"));
        result = pred.isNegated();
        if (result.booleanValue()) {
            this.logTrace("Received expected result:" + result);
            pass3 = true;
        } else {
            this.logErr("Expected:true, actual:" + result);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("predicateIsNegatedTest failed");
        }
    }

    public void predicateBooleanOperatorTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            this.logMsg("Testing values()");
            Predicate.BooleanOperator[] results = Predicate.BooleanOperator.values();
            if (results.length == 2) {
                if (results[0].equals((Object)Predicate.BooleanOperator.AND) && results[1].equals((Object)Predicate.BooleanOperator.OR) || results[0].equals((Object)Predicate.BooleanOperator.OR) && results[1].equals((Object)Predicate.BooleanOperator.AND)) {
                    this.logTrace("Received expected values from values()");
                    pass1 = true;
                }
            } else {
                this.logErr("Expected number of values: 2, actual:" + results.length);
            }
            this.logMsg("Testing valueOf(...)");
            for (Predicate.BooleanOperator pb : Predicate.BooleanOperator.values()) {
                this.logTrace("Testing:" + pb.name());
                try {
                    Predicate.BooleanOperator.valueOf((String)pb.name());
                    pass2 = true;
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received unexpected IllegalArgumentException exception");
                }
                catch (Exception e) {
                    this.logErr("Received unexpected exception", e);
                }
            }
            this.logMsg("Testing valueOf(Invalid_value)");
            try {
                Predicate.BooleanOperator.valueOf((String)"Invalid_value");
                this.logErr("Did not received IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected exception");
                pass3 = true;
            }
            catch (Exception e) {
                this.logErr("Received unexpected exception", e);
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("predicateBooleanOperatorTest failed");
        }
    }

    public void predicateGetOperatorTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_2 = customer.getModel();
            this.logMsg("Testing default");
            Predicate predicate = cbuilder.equal((Expression)customer.get(Customer_2.getSingularAttribute("id", String.class)), (Object)"1");
            Predicate.BooleanOperator result = predicate.getOperator();
            if (!result.equals((Object)Predicate.BooleanOperator.AND)) {
                this.logErr("Expected:" + Predicate.BooleanOperator.AND.name() + ", actual:" + result.name());
            } else {
                pass1 = true;
            }
            this.logMsg("Testing AND");
            predicate = cbuilder.and((Expression)cbuilder.equal((Expression)customer.get(Customer_2.getSingularAttribute("id", String.class)), (Object)"1"), (Expression)cbuilder.equal((Expression)customer.get(Customer_2.getSingularAttribute("id", String.class)), (Object)"1"));
            if (!predicate.getOperator().equals((Object)Predicate.BooleanOperator.AND)) {
                this.logErr("Expected:" + Predicate.BooleanOperator.AND.name() + ", actual:" + result.name());
            } else {
                pass2 = true;
            }
            this.logMsg("Testing OR");
            predicate = cbuilder.or((Expression)cbuilder.equal((Expression)customer.get(Customer_2.getSingularAttribute("id", String.class)), (Object)"1"), (Expression)cbuilder.equal((Expression)customer.get(Customer_2.getSingularAttribute("id", String.class)), (Object)"1"));
            if (!predicate.getOperator().equals((Object)Predicate.BooleanOperator.OR)) {
                this.logErr("Expected:" + Predicate.BooleanOperator.OR.name() + ", actual:" + result.name());
            } else {
                pass3 = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("predicateGetOperatorTest failed");
        }
    }

    public void selectionGetCompoundSelectionItemsIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        Expression sel = cbuilder.length((Expression)customer.get(Customer_.id));
        try {
            sel.getCompoundSelectionItems();
            this.logErr("Did not throw IllegalStateException");
        }
        catch (IllegalStateException ise) {
            this.logTrace("Received IllegalStateException");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("selectionGetCompoundSelectionItemsIllegalStateExceptionTest failed");
        }
    }

    public void expressionIsCompoundSelectionTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Expression exp = cbuilder.literal((Object)"1");
        boolean actual = exp.isCompoundSelection();
        if (!actual) {
            this.logTrace("Received expected result:" + actual);
            pass = true;
        } else {
            this.logErr("Expected isCompoundSelection() to return: false, actual:" + actual);
        }
        if (!pass) {
            throw new Exception("expressionGetCompoundSelectionItemsTest failed");
        }
    }

    public void expressionGetCompoundSelectionItemsIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Expression exp = cbuilder.literal((Object)"1");
        try {
            exp.getCompoundSelectionItems();
            this.logErr("Did not throw IllegalStateException");
        }
        catch (IllegalStateException ise) {
            this.logTrace("Received IllegalStateException");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("expressionGetCompoundSelectionItemsIllegalStateExceptionTest failed");
        }
    }

    public void getRoots() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createTupleQuery();
            if (cquery != null) {
                cquery.from(Customer.class);
                cquery.from(Order.class);
                Set rootSet = cquery.getRoots();
                if (rootSet != null) {
                    if (rootSet.size() == 2) {
                        int count = 0;
                        boolean foundCustomer = false;
                        boolean foundOrder = false;
                        for (Root newRoot : rootSet) {
                            EntityType eType1 = newRoot.getModel();
                            String name = eType1.getName();
                            this.logTrace("entityType Name = " + name);
                            if (name.equals("Customer")) {
                                this.logTrace("Received expected name:" + name);
                                foundCustomer = true;
                                ++count;
                            }
                            if (!name.equals("Order")) continue;
                            this.logTrace("Received expected name:" + name);
                            foundOrder = true;
                            ++count;
                        }
                        if (count == 2 && foundCustomer && foundOrder) {
                            pass = true;
                        } else {
                            this.logErr("Did not get Customer and Order roots back from getRoot");
                        }
                    } else {
                        this.logErr("getRoots did not return 2 entries in the set");
                    }
                } else {
                    this.logErr("getRoots returned null");
                }
            } else {
                this.logErr("Failed to get Non-null Criteria Query");
            }
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getRoots test failed");
        }
    }

    public void getSelection() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            this.logMsg("Testing non-compound selection");
            CriteriaQuery cquery = qbuilder.createQuery(Customer.class);
            if (cquery != null) {
                Root customer = cquery.from(Customer.class);
                cquery.select((Selection)customer);
                Selection _select = cquery.getSelection();
                if (_select != null) {
                    if (!_select.isCompoundSelection()) {
                        this.logTrace("isCompoundSelection returned expected false");
                        pass1 = true;
                    } else {
                        this.logErr("isCompoundSelection returned true instead of false");
                    }
                    String javaName = _select.getJavaType().getName();
                    if (javaName.equals("ee.jakarta.tck.persistence.common.schema30.Customer")) {
                        pass2 = true;
                    } else {
                        this.logErr("Expected: ee.jakarta.tck.persistence.common.schema30.Customer, actual:" + javaName);
                    }
                } else {
                    this.logErr("get Selection returned null");
                }
                this.logMsg("Testing compound selection");
                CriteriaQuery cquery1 = qbuilder.createQuery();
                customer = cquery1.from(Customer.class);
                EntityType CUSTOMER_ = customer.getModel();
                cquery1.multiselect(new Selection[]{customer.get(CUSTOMER_.getSingularAttribute("id", String.class)), customer.get(CUSTOMER_.getSingularAttribute("name", String.class))});
                Selection _select1 = cquery1.getSelection();
                if (_select1 != null) {
                    if (_select1.isCompoundSelection()) {
                        this.logTrace("isCompoundSelection returned expected true");
                        pass3 = true;
                    } else {
                        this.logErr("isCompoundSelection returned false");
                    }
                } else {
                    this.logErr("get Selection returned null");
                }
            } else {
                this.logErr("Failed to get Non-null Criteria Query");
            }
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception ", e);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("getSelection failed");
        }
    }

    public void getGroupList() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Customer.class);
            if (cquery != null) {
                Root customer = cquery.from(Customer.class);
                this.logMsg("Testing with NO group expressions");
                List groupList = cquery.getGroupList();
                if (groupList != null) {
                    if (groupList.size() == 0) {
                        this.logTrace("Received empty list from getGroupList");
                        pass1 = true;
                    } else {
                        this.logErr("Expected : 0 Received :" + groupList.size());
                        for (Expression strExpr : groupList) {
                            this.logErr("Expression:" + strExpr.toString());
                        }
                    }
                } else {
                    this.logErr("getGroupList returned null instead of empty list when no groupby expressions have been specified");
                }
                this.logMsg("Testing with group expressions");
                Path e = customer.get("name");
                cquery.groupBy(new Expression[]{e});
                groupList = cquery.getGroupList();
                if (groupList != null) {
                    if (groupList.size() == 1) {
                        for (Expression strExpr : groupList) {
                            String sType = strExpr.getJavaType().getName();
                            if (sType.equals("java.lang.String")) {
                                this.logTrace("Received expected type:" + sType);
                                pass2 = true;
                                continue;
                            }
                            this.logErr("Expected type: java.lang.String, actual:" + sType);
                        }
                    } else {
                        this.logErr("Expected : 1 Received :" + groupList.size());
                        for (Expression strExpr : groupList) {
                            this.logErr("Actual expression:" + strExpr.toString());
                        }
                    }
                } else {
                    this.logErr("getGroupList returned null instead of a populated list when groupby expressions have been specified");
                }
            } else {
                this.logErr("Failed to get Non-null Criteria Query");
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception groupBy: " + e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("getGroupList failed");
        }
    }

    public void isDistinct() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery();
            if (cquery != null) {
                cquery.from(Customer.class);
                cquery.distinct(true);
                Boolean isDistinct = cquery.isDistinct();
                if (isDistinct.booleanValue()) {
                    pass = true;
                }
            } else {
                this.logErr("Failed to get Non-null Criteria Query");
            }
        }
        catch (Exception e) {
            this.logErr("Caught unexpected excetion: " + e);
        }
        if (!pass) {
            throw new Exception("isDistinct test failed");
        }
    }

    public void getResultType() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            Class resultType;
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            this.logMsg("Testing specific class return type");
            String expected = "ee.jakarta.tck.persistence.common.schema30.Customer";
            CriteriaQuery cquery = qbuilder.createQuery(Customer.class);
            if (cquery != null) {
                resultType = cquery.getResultType();
                if (resultType != null) {
                    if (resultType.getName().equals(expected)) {
                        this.logTrace("Got Expected Result Type");
                        pass1 = true;
                    } else {
                        this.logErr("Received  UnExpected Result Type :" + resultType.getName());
                    }
                } else {
                    this.logErr("getResultType returned null instead of:" + expected);
                }
            } else {
                this.logErr("Failed to get Non-null Criteria Query for:" + expected);
            }
            this.logMsg("Testing Tuple return type");
            expected = "jakarta.persistence.Tuple";
            cquery = qbuilder.createQuery(Tuple.class);
            if (cquery != null) {
                resultType = cquery.getResultType();
                if (resultType != null) {
                    if (resultType.getName().equals(expected)) {
                        this.logTrace("Got Expected Result Type");
                        pass2 = true;
                    } else {
                        this.logErr("Received  UnExpected Result Type :" + resultType.getName());
                    }
                } else {
                    this.logErr("getResultType returned null instead of:" + expected);
                }
            } else {
                this.logErr("getResultType returned null instead of:" + expected);
            }
            this.logMsg("Testing Object return type");
            expected = "java.lang.Object";
            cquery = qbuilder.createQuery();
            if (cquery != null) {
                resultType = cquery.getResultType();
                if (resultType != null) {
                    if (resultType.getName().equals(expected)) {
                        this.logTrace("Got Expected Result Type");
                        pass3 = true;
                    } else {
                        this.logErr("Received  UnExpected Result Type :" + resultType.getName());
                    }
                } else {
                    this.logErr("getResultType returned null instead of:" + expected);
                }
            } else {
                this.logErr("getResultType returned null instead of:" + expected);
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception getGroupRestriction: " + e);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("getResultType test failed");
        }
    }
}

