/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.binaryoperator;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.el.api.expression.ExpressionTest;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.el.common.elcontext.BarELContext;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import com.sun.ts.tests.el.common.elcontext.FuncMapperELContext;
import com.sun.ts.tests.el.common.elcontext.SimpleELContext;
import com.sun.ts.tests.el.common.elcontext.VRContext;
import com.sun.ts.tests.el.common.elcontext.VarMapperELContext;
import com.sun.ts.tests.el.common.elresolver.EmployeeELResolver;
import com.sun.ts.tests.el.common.elresolver.FunctionELResolver;
import com.sun.ts.tests.el.common.elresolver.VariableELResolver;
import com.sun.ts.tests.el.common.elresolver.VectELResolver;
import com.sun.ts.tests.el.common.functionmapper.TCKFunctionMapper;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.MethodsBean;
import com.sun.ts.tests.el.common.util.NameValuePair;
import com.sun.ts.tests.el.common.util.ResolverType;
import com.sun.ts.tests.el.common.util.SimpleBean;
import com.sun.ts.tests.el.common.util.SimpleInterface;
import com.sun.ts.tests.el.common.util.TestNum;
import com.sun.ts.tests.el.common.util.TypesBean;
import com.sun.ts.tests.el.common.util.Validator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.protocol.common.TargetVehicle;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="el"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="tck-javatest")})
public class ELClientJspTest
extends ServiceEETest {
    static final String VEHICLE_ARCHIVE = "binaryoperator_jsp_vehicle";
    private static final System.Logger logger = System.getLogger(ELClientJspTest.class.getName());
    Properties testProps;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    public static String inputStreamToString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public static String editWebXmlString(InputStream inStream, String jsp_vehicle) throws IOException {
        return ELClientJspTest.inputStreamToString(inStream).replaceAll("el_jsp_vehicle", jsp_vehicle);
    }

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="binaryoperator_jsp_vehicle", order=2)
    public static WebArchive createDeploymentVehicle() throws IOException {
        WebArchive jsp_vehicle_web = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"binaryoperator_jsp_vehicle_web.war");
        jsp_vehicle_web.addClasses(new Class[]{EETest.Fault.class, EETest.SetupException.class, EETest.class, ServiceEETest.class, VehicleClient.class, VehicleRunnable.class, VehicleRunnerFactory.class, ExpressionTest.class, EmployeeELResolver.class, FunctionELResolver.class, VariableELResolver.class, VectELResolver.class, BareBonesELContext.class, SimpleELContext.class, SimpleELContext.Resolver.class, FuncMapperELContext.class, BarELContext.class, VRContext.class, VarMapperELContext.class, ELTestUtil.class, SimpleBean.class, SimpleInterface.class, ResolverType.class, NameValuePair.class, ExprEval.class, MethodsBean.class, TestNum.class, TypesBean.class, Validator.class, TCKFunctionMapper.class, ELClientJspTest.class});
        InputStream inStream = ELClientJspTest.class.getResourceAsStream("/vehicle/jsp/jsp_vehicle_web.xml");
        String webXml = ELClientJspTest.editWebXmlString(inStream, VEHICLE_ARCHIVE);
        jsp_vehicle_web.setWebXML((Asset)new StringAsset(webXml));
        URL warResURL = ELClientJspTest.class.getResource("/vehicle/jsp/contentRoot/client.html");
        jsp_vehicle_web.addAsWebResource(warResURL, "/client.html");
        warResURL = ELClientJspTest.class.getResource("/vehicle/jsp/contentRoot/jsp_vehicle.jsp");
        jsp_vehicle_web.addAsWebResource(warResURL, "/jsp_vehicle.jsp");
        return jsp_vehicle_web;
    }

    public static void main(String[] args) {
        ELClientJspTest theTests = new ELClientJspTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        TestUtil.logTrace((String)"Setup method called");
        this.testProps = p;
    }

    public void cleanup() throws Exception {
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elNullOperandAddTest() throws Exception {
        boolean pass = false;
        Long expectedResult = Long.valueOf("0");
        try {
            String expr = ExprEval.buildElExpr(true, "+");
            TestUtil.logTrace((String)("expression to be evaluated is " + expr));
            Object result = ExprEval.evaluateValueExpression(expr, null, Object.class);
            TestUtil.logTrace((String)("result is " + result.toString()));
            pass = ExprEval.compareClass(result, Long.class) && ExprEval.compareValue((Long)result, expectedResult, 0);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elNullOperandSubtractTest() throws Exception {
        boolean pass = false;
        Long expectedResult = Long.valueOf("0");
        try {
            String expr = ExprEval.buildElExpr(false, "-");
            TestUtil.logTrace((String)("expression to be evaluated is " + expr));
            Object result = ExprEval.evaluateValueExpression(expr, null, Object.class);
            TestUtil.logTrace((String)("result is " + result.toString()));
            pass = ExprEval.compareClass(result, Long.class) && ExprEval.compareValue((Long)result, expectedResult, 0);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elNullOperandMultiplyTest() throws Exception {
        boolean pass = false;
        Long expectedResult = Long.valueOf("0");
        try {
            String expr = ExprEval.buildElExpr(true, "*");
            TestUtil.logTrace((String)("expression to be evaluated is " + expr));
            Object result = ExprEval.evaluateValueExpression(expr, null, Object.class);
            TestUtil.logTrace((String)("result is " + result.toString()));
            pass = ExprEval.compareClass(result, Long.class) && ExprEval.compareValue((Long)result, expectedResult, 0);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elNullOperandDivisionTest() throws Exception {
        boolean pass = false;
        Long expectedResult = Long.valueOf("0");
        try {
            String expr = ExprEval.buildElExpr(true, "/");
            TestUtil.logTrace((String)("expression to be evaluated is " + expr));
            Object result = ExprEval.evaluateValueExpression(expr, null, Object.class);
            TestUtil.logTrace((String)("result is " + result.toString()));
            pass = ExprEval.compareClass(result, Long.class) && ExprEval.compareValue((Long)result, expectedResult, 0);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elNullOperandModulusTest() throws Exception {
        boolean pass = false;
        Long expectedResult = Long.valueOf("0");
        try {
            String expr = ExprEval.buildElExpr(true, "%");
            TestUtil.logTrace((String)("expression to be evaluated is " + expr));
            Object result = ExprEval.evaluateValueExpression(expr, null, Object.class);
            TestUtil.logTrace((String)("result is " + result.toString()));
            pass = ExprEval.compareClass(result, Long.class) && ExprEval.compareValue((Long)result, expectedResult, 0);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigDecimalAddTest() throws Exception {
        BigDecimal testValue = BigDecimal.valueOf(10.531);
        BigDecimal expectedResult = BigDecimal.valueOf(11.531);
        Validator.testBigDecimal(testValue, expectedResult, "+");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigDecimalSubtractTest() throws Exception {
        BigDecimal testValue = BigDecimal.valueOf(10.531);
        BigDecimal expectedResult = BigDecimal.valueOf(9.531);
        Validator.testBigDecimal(testValue, expectedResult, "-");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigDecimalMultiplyTest() throws Exception {
        BigDecimal testValue = BigDecimal.valueOf(1.5);
        BigDecimal expectedResult = BigDecimal.valueOf(1.5);
        Validator.testBigDecimal(testValue, expectedResult, "*");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigDecimalDivisionTest() throws Exception {
        BigDecimal testValue = BigDecimal.valueOf(3.0);
        BigDecimal expectedResult = BigDecimal.valueOf(3.0);
        Validator.testBigDecimal(testValue, expectedResult, "/");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigDecimalModulusTest() throws Exception {
        BigDecimal testValue = BigDecimal.valueOf(2.5);
        BigDecimal expectedResult = BigDecimal.valueOf(0.5);
        Validator.testBigDecimal(testValue, expectedResult, "%");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigIntegerAddTest() throws Exception {
        BigInteger testValue = BigInteger.valueOf(10531L);
        BigInteger expectedResult = BigInteger.valueOf(10532L);
        Validator.testBigInteger(testValue, expectedResult, "+");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigIntegerSubtractTest() throws Exception {
        BigInteger testValue = BigInteger.valueOf(10531L);
        BigInteger expectedResult = BigInteger.valueOf(10530L);
        Validator.testBigInteger(testValue, expectedResult, "-");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigIntegerMultiplyTest() throws Exception {
        BigInteger testValue = BigInteger.valueOf(10531L);
        BigInteger expectedResult = BigInteger.valueOf(10531L);
        Validator.testBigInteger(testValue, expectedResult, "*");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigIntegerDivisionTest() throws Exception {
        BigInteger testValue = BigInteger.valueOf(10531L);
        BigInteger expectedResult = BigInteger.valueOf(10531L);
        Validator.testBigInteger(testValue, expectedResult, "/");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigIntegerModulusTest() throws Exception {
        BigInteger testValue = BigInteger.valueOf(10531L);
        BigInteger expectedResult = BigInteger.valueOf(0L);
        Validator.testBigInteger(testValue, expectedResult, "%");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elFloatAddTest() throws Exception {
        for (Float testValue : TestNum.getFloatList()) {
            Float expectedResult = Float.valueOf(testValue.floatValue() + Float.valueOf("1.0").floatValue());
            Validator.testFloat(testValue, expectedResult, "+");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elFloatSubtractTest() throws Exception {
        for (Float testValue : TestNum.getFloatList()) {
            Float expectedResult = Float.valueOf(testValue.floatValue() - Float.valueOf("1.0").floatValue());
            Validator.testFloat(testValue, expectedResult, "-");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elFloatMultiplyTest() throws Exception {
        for (Float testValue : TestNum.getFloatList()) {
            Float expectedResult = Float.valueOf(testValue.floatValue() * Float.valueOf("1.0").floatValue());
            Validator.testFloat(testValue, expectedResult, "*");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elFloatDivisionTest() throws Exception {
        for (Float testValue : TestNum.getFloatList()) {
            Float expectedResult = Float.valueOf(testValue.floatValue() / Float.valueOf("1.0").floatValue());
            Validator.testFloat(testValue, expectedResult, "/");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elFloatModulusTest() throws Exception {
        for (Float testValue : TestNum.getFloatList()) {
            Float expectedResult = Float.valueOf(testValue.floatValue() % Float.valueOf("1.0").floatValue());
            Validator.testFloat(testValue, expectedResult, "%");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elDoubleAddTest() throws Exception {
        Double testValue = 2.5;
        Double expectedResult = 3.5;
        Validator.testDouble(testValue, expectedResult, "+");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elDoubleSubtractTest() throws Exception {
        Double testValue = 2.5;
        Double expectedResult = 1.5;
        Validator.testDouble(testValue, expectedResult, "-");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elDoubleMultiplyTest() throws Exception {
        Double testValue = 2.5;
        Double expectedResult = 2.5;
        Validator.testDouble(testValue, expectedResult, "*");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elDoubleDivisionTest() throws Exception {
        Double testValue = 2.5;
        Double expectedResult = 2.5;
        Validator.testDouble(testValue, expectedResult, "/");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elDoubleModulusTest() throws Exception {
        Double testValue = 2.5;
        Double expectedResult = 0.5;
        Validator.testDouble(testValue, expectedResult, "%");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elNumericStringSubtractTest() throws Exception {
        String testValue = "25e-1";
        Double expectedResult = 1.5;
        Validator.testNumericString(testValue, expectedResult, "-");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elNumericStringMultiplyTest() throws Exception {
        String testValue = "25E-1";
        Double expectedResult = 2.5;
        Validator.testNumericString(testValue, expectedResult, "*");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elNumericStringDivisionTest() throws Exception {
        String testValue = "2.5";
        Double expectedResult = 2.5;
        Validator.testNumericString(testValue, expectedResult, "/");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elNumericStringModulusTest() throws Exception {
        String testValue = "2.5e0";
        Double expectedResult = 0.5;
        Validator.testNumericString(testValue, expectedResult, "%");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elLongAddTest() throws Exception {
        Long testValue = 25000L;
        Long expectedResult = 25001L;
        Validator.testLong(testValue, expectedResult, "+");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elLongSubtractTest() throws Exception {
        Long testValue = 25000L;
        Long expectedResult = 24999L;
        Validator.testLong(testValue, expectedResult, "-");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elLongMultiplyTest() throws Exception {
        Long testValue = 25000L;
        Long expectedResult = 25000L;
        Validator.testLong(testValue, expectedResult, "*");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elLongDivisionTest() throws Exception {
        Long testValue = 25000L;
        Long expectedResult = 25000L;
        Validator.testLong(testValue, expectedResult, "/");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elLongModulusTest() throws Exception {
        Long testValue = 25000L;
        Long expectedResult = 0L;
        Validator.testLong(testValue, expectedResult, "%");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elIntegerAddTest() throws Exception {
        Integer testValue = 25;
        Integer expectedResult = 26;
        Validator.testInteger(testValue, expectedResult, "+");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elIntegerSubtractTest() throws Exception {
        Integer testValue = 25;
        Integer expectedResult = 24;
        Validator.testInteger(testValue, expectedResult, "-");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elIntegerMultiplyTest() throws Exception {
        Integer testValue = 25;
        Integer expectedResult = 25;
        Validator.testInteger(testValue, expectedResult, "*");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elIntegerDivisionTest() throws Exception {
        Integer testValue = 25;
        Integer expectedResult = 25;
        Validator.testInteger(testValue, expectedResult, "/");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elIntegerModulusTest() throws Exception {
        Integer testValue = 25;
        Integer expectedResult = 0;
        Validator.testInteger(testValue, expectedResult, "%");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elShortAddTest() throws Exception {
        Short testValue = Short.valueOf("2");
        Short expectedResult = Short.valueOf("3");
        Validator.testShort(testValue, expectedResult, "+");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elShortSubtractTest() throws Exception {
        Short testValue = Short.valueOf("2");
        Short expectedResult = Short.valueOf("1");
        Validator.testShort(testValue, expectedResult, "-");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elShortMultiplyTest() throws Exception {
        Short testValue = Short.valueOf("2");
        Short expectedResult = Short.valueOf("2");
        Validator.testShort(testValue, expectedResult, "*");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elShortDivisionTest() throws Exception {
        Short testValue = Short.valueOf("2");
        Short expectedResult = Short.valueOf("2");
        Validator.testShort(testValue, expectedResult, "/");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elShortModulusTest() throws Exception {
        Short testValue = Short.valueOf("2");
        Short expectedResult = Short.valueOf("0");
        Validator.testShort(testValue, expectedResult, "%");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elByteAddTest() throws Exception {
        Byte testValue = Byte.valueOf("2");
        Byte expectedResult = Byte.valueOf("3");
        Validator.testByte(testValue, expectedResult, "+");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elByteSubtractTest() throws Exception {
        Byte testValue = Byte.valueOf("2");
        Byte expectedResult = Byte.valueOf("1");
        Validator.testByte(testValue, expectedResult, "-");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elByteMultiplyTest() throws Exception {
        Byte testValue = Byte.valueOf("2");
        Byte expectedResult = Byte.valueOf("2");
        Validator.testByte(testValue, expectedResult, "*");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elByteDivisionTest() throws Exception {
        Byte testValue = Byte.valueOf("2");
        Byte expectedResult = Byte.valueOf("2");
        Validator.testByte(testValue, expectedResult, "/");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elByteModulusTest() throws Exception {
        Byte testValue = Byte.valueOf("2");
        Byte expectedResult = Byte.valueOf("0");
        Validator.testByte(testValue, expectedResult, "%");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBooleanAndTest() throws Exception {
        Validator.testBoolean(true, "true", true, "&&");
        Validator.testBoolean(true, true, true, "&&");
        Validator.testBoolean(true, "false", false, "and");
        Validator.testBoolean(true, false, false, "and");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBooleanOrTest() throws Exception {
        Validator.testBoolean(false, "false", false, "||");
        Validator.testBoolean(true, "false", true, "or");
        Validator.testBoolean(true, false, true, "||");
        Validator.testBoolean(true, true, true, "or");
    }
}

