/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.common.util;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.NameValuePair;
import com.sun.ts.tests.el.common.util.TestNum;
import jakarta.el.ELProcessor;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Validator {
    private static Validator instance = null;

    protected Validator() {
    }

    private Validator getInstance() {
        if (instance == null) {
            instance = new Validator();
        }
        return instance;
    }

    public static void testBigDecimal(BigDecimal testVal, Object expectedVal, String operator) throws Exception {
        boolean pass = false;
        for (int i = 0; TestNum.getNumberList().size() > i; ++i) {
            TestUtil.logMsg((String)"*** Start \"BigDecimal\" Test Sequence ***");
            Object testNum = TestNum.getNumberList().get(i);
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            try {
                String expr = ExprEval.buildElExpr(true, operator);
                TestUtil.logMsg((String)("expression to be evaluated is " + expr));
                TestUtil.logMsg((String)("types are BigDecimal and " + testNum.getClass().getName()));
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                TestUtil.logMsg((String)("result is " + result.toString()));
                if ("+=".equals(operator)) {
                    pass = Validator.runConcatenationTest(testVal, result, testNum);
                } else if ("%".equals(operator)) {
                    returnType = Double.class;
                    TestUtil.logMsg((String)("Setting Expected Type: " + returnType.getName()));
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Double)result, ((BigDecimal)expectedVal).doubleValue());
                } else {
                    returnType = BigDecimal.class;
                    TestUtil.logMsg((String)("Setting Expected Type: " + returnType.getName()));
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((BigDecimal)result, (BigDecimal)expectedVal, 5);
                }
            }
            catch (RuntimeException re) {
                TestUtil.printStackTrace((Throwable)re);
                throw new Exception(re);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                TestUtil.logMsg((String)"*** End \"BigDecimal\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    public static void testFloat(Float testVal, Object expectedVal, String operator) throws Exception {
        boolean pass = false;
        for (int i = 0; TestNum.getNumberList().size() > i; ++i) {
            TestUtil.logMsg((String)"*** Start \"Float\" Test Sequence ***");
            Object testNum = TestNum.getNumberList().get(i);
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            if (testNum instanceof BigDecimal) {
                TestUtil.logMsg((String)("Skip " + testNum.getClass().getSimpleName() + " for Float tests we already tested for this in the BigDecimal tests."));
                continue;
            }
            try {
                String expr = ExprEval.buildElExpr(true, operator);
                TestUtil.logMsg((String)("expression to be evaluated is " + expr));
                TestUtil.logMsg((String)("types are Float and " + testNum.getClass().getName()));
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                TestUtil.logMsg((String)("result is " + result.toString()));
                if ("+=".equals(operator)) {
                    pass = Validator.runConcatenationTest(testVal, result, testNum);
                } else if ("%".equals(operator)) {
                    returnType = Double.class;
                    TestUtil.logMsg((String)("Setting Expected Type: " + returnType.getCanonicalName()));
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Double)result, ((Float)expectedVal).doubleValue());
                } else if (testNum instanceof BigInteger) {
                    returnType = BigDecimal.class;
                    TestUtil.logMsg((String)("Setting Expected Type: " + returnType.getCanonicalName()));
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue(Float.valueOf(((BigDecimal)result).floatValue()), (Float)expectedVal, 3);
                } else {
                    returnType = Double.class;
                    TestUtil.logMsg((String)("Setting Expected Type: " + returnType.getCanonicalName()));
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Double)result, (Float)expectedVal, 3);
                }
            }
            catch (RuntimeException re) {
                TestUtil.printStackTrace((Throwable)re);
                throw new Exception(re);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                TestUtil.logMsg((String)"*** End \"Float\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    public static void testDouble(Double testVal, Object expectedVal, String operator) throws Exception {
        boolean pass = false;
        for (int i = 0; TestNum.getNumberList().size() > i; ++i) {
            TestUtil.logMsg((String)"*** Start \"Double\"Test Sequence ***");
            Object testNum = TestNum.getNumberList().get(i);
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            if (testNum instanceof BigDecimal || testNum instanceof Float) {
                String skipType = testNum.getClass().getSimpleName();
                TestUtil.logMsg((String)("Skip " + skipType + " Data type already tested for this in the " + skipType + " tests."));
                continue;
            }
            try {
                String expr = ExprEval.buildElExpr(true, operator);
                TestUtil.logMsg((String)("expression to be evaluated is " + expr));
                TestUtil.logMsg((String)("types are Double and " + testNum.getClass().getName()));
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                TestUtil.logMsg((String)("result is " + result.toString()));
                if ("+=".equals(operator)) {
                    pass = Validator.runConcatenationTest(testVal, result, testNum);
                } else if ("%".equals(operator)) {
                    returnType = Double.class;
                    TestUtil.logMsg((String)("Setting Expected Type: " + returnType.getCanonicalName()));
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Double)result, expectedVal);
                } else if (testNum instanceof BigInteger) {
                    returnType = BigDecimal.class;
                    TestUtil.logMsg((String)("Setting Expected Type: " + returnType.getCanonicalName()));
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue(((BigDecimal)result).doubleValue(), expectedVal);
                } else {
                    returnType = Double.class;
                    TestUtil.logMsg((String)("Setting Expected Type: " + returnType.getCanonicalName()));
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Double)result, expectedVal);
                }
            }
            catch (RuntimeException re) {
                TestUtil.printStackTrace((Throwable)re);
                throw new Exception(re);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                TestUtil.logMsg((String)"*** End \"Double\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    public static void testNumericString(String testVal, Double expectedVal, String operator) throws Exception {
        boolean pass = false;
        for (int i = 0; TestNum.getNumberList().size() > i; ++i) {
            TestUtil.logMsg((String)"*** Start \"NumericString\"Test Sequence ***");
            Object testNum = TestNum.getNumberList().get(i);
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            if (testNum instanceof BigDecimal || testNum instanceof Float || testNum instanceof Double) {
                String skipType = testNum.getClass().getSimpleName();
                TestUtil.logMsg((String)("Skip " + skipType + " Data type already tested for this in the " + skipType + " tests."));
                continue;
            }
            try {
                String expr = ExprEval.buildElExpr(true, operator);
                TestUtil.logMsg((String)("expression to be evaluated is " + expr));
                TestUtil.logMsg((String)("types are String and " + testNum.getClass().getName()));
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                TestUtil.logMsg((String)("result is " + result.toString()));
                if ("%".equals(operator)) {
                    returnType = Double.class;
                    TestUtil.logMsg((String)("Setting Expected Type: " + returnType.getCanonicalName()));
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Double)result, expectedVal);
                } else if (testNum instanceof BigInteger) {
                    returnType = BigDecimal.class;
                    TestUtil.logMsg((String)("Setting Expected Type: " + returnType.getCanonicalName()));
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue(((BigDecimal)result).doubleValue(), expectedVal);
                } else {
                    returnType = Double.class;
                    TestUtil.logMsg((String)("Setting Expected Type: " + returnType.getCanonicalName()));
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Double)result, expectedVal);
                }
            }
            catch (RuntimeException re) {
                TestUtil.printStackTrace((Throwable)re);
                throw new Exception(re);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                TestUtil.logMsg((String)"*** End \"NumericString\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    public static void testBigInteger(BigInteger testVal, Object expectedVal, String operator) throws Exception {
        boolean pass = false;
        for (int i = 0; TestNum.getNumberList().size() > i; ++i) {
            TestUtil.logMsg((String)"*** Start \"BigInteger\" Test Sequence ***");
            Object testNum = TestNum.getNumberList().get(i);
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            if (testNum instanceof BigDecimal || testNum instanceof Float || testNum instanceof Double || testNum instanceof String) {
                String skipType = testNum.getClass().getSimpleName();
                TestUtil.logMsg((String)("Skip " + skipType + " Data type already tested for this in the " + skipType + " tests."));
                continue;
            }
            try {
                String expr = ExprEval.buildElExpr(true, operator);
                TestUtil.logMsg((String)("expression to be evaluated is " + expr));
                TestUtil.logMsg((String)("types are BigInteger and " + testNum.getClass().getName()));
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                TestUtil.logMsg((String)("result is " + result.toString()));
                if ("+=".equals(operator)) {
                    pass = Validator.runConcatenationTest(testVal, result, testNum);
                } else if ("/".equals(operator)) {
                    returnType = BigDecimal.class;
                    TestUtil.logMsg((String)("Setting Expected Type: " + returnType.getCanonicalName()));
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((BigDecimal)result, BigDecimal.valueOf(((BigInteger)expectedVal).doubleValue()), 0);
                } else {
                    returnType = BigInteger.class;
                    TestUtil.logMsg((String)("Setting Expected Type: " + returnType.getCanonicalName()));
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((BigInteger)result, (BigInteger)expectedVal, 0);
                }
            }
            catch (RuntimeException re) {
                TestUtil.printStackTrace((Throwable)re);
                throw new Exception(re);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                TestUtil.logMsg((String)"*** End \"BigInteger\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    public static void testLong(Long testVal, Object expectedVal, String operator) throws Exception {
        boolean pass = false;
        for (int i = 0; TestNum.getNumberList().size() > i; ++i) {
            TestUtil.logMsg((String)"*** Start \"Long\" Test Sequence ***");
            Object testNum = TestNum.getNumberList().get(i);
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            if (testNum instanceof BigDecimal || testNum instanceof Float || testNum instanceof Double || testNum instanceof String || testNum instanceof BigInteger) {
                String skipType = testNum.getClass().getSimpleName();
                TestUtil.logMsg((String)("Skip " + skipType + " Data type already tested for this in the " + skipType + " tests."));
                continue;
            }
            try {
                String expr = ExprEval.buildElExpr(true, operator);
                TestUtil.logMsg((String)("expression to be evaluated is " + expr));
                TestUtil.logMsg((String)("types are  Long and " + testNum.getClass().getName()));
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                TestUtil.logMsg((String)("result is " + result.toString()));
                if ("+=".equals(operator)) {
                    pass = Validator.runConcatenationTest(testVal, result, testNum);
                } else if ("/".equals(operator)) {
                    returnType = Double.class;
                    TestUtil.logMsg((String)("Setting Expected Type: " + returnType.getCanonicalName()));
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Double)result, ((Long)expectedVal).doubleValue());
                } else {
                    returnType = Long.class;
                    TestUtil.logMsg((String)("Setting Expected Type: " + returnType.getCanonicalName()));
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Long)result, (Long)expectedVal, 0);
                }
            }
            catch (RuntimeException re) {
                TestUtil.printStackTrace((Throwable)re);
                throw new Exception(re);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                TestUtil.logMsg((String)"*** End \"Long\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    public static void testInteger(Integer testVal, Object expectedVal, String operator) throws Exception {
        boolean pass = false;
        for (int i = 0; TestNum.getNumberList().size() > i; ++i) {
            TestUtil.logMsg((String)"*** Start \"Integer\" Test Sequence ***");
            Object testNum = TestNum.getNumberList().get(i);
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            if (testNum instanceof BigDecimal || testNum instanceof Float || testNum instanceof Double || testNum instanceof String || testNum instanceof Long || testNum instanceof BigInteger) {
                String skipType = testNum.getClass().getSimpleName();
                TestUtil.logMsg((String)("Skip " + skipType + " Data type already tested for this in the " + skipType + " tests."));
                continue;
            }
            try {
                String expr = ExprEval.buildElExpr(true, operator);
                TestUtil.logMsg((String)("expression to be evaluated is " + expr));
                TestUtil.logMsg((String)("types are  Integer and " + testNum.getClass().getName()));
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                TestUtil.logMsg((String)("result is " + result.toString()));
                if ("+=".equals(operator)) {
                    pass = Validator.runConcatenationTest(testVal, result, testNum);
                } else if ("/".equals(operator)) {
                    returnType = Double.class;
                    TestUtil.logMsg((String)("Setting Expected Type: " + returnType.getCanonicalName()));
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Double)result, ((Integer)expectedVal).doubleValue());
                } else {
                    returnType = Long.class;
                    TestUtil.logMsg((String)("Setting Expected Type: " + returnType.getCanonicalName()));
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Long)result, ((Integer)expectedVal).longValue());
                }
            }
            catch (RuntimeException re) {
                TestUtil.printStackTrace((Throwable)re);
                throw new Exception(re);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                TestUtil.logMsg((String)"*** End \"Integer\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    public static void testShort(Short testVal, Object expectedVal, String operator) throws Exception {
        boolean pass = false;
        for (int i = 0; TestNum.getNumberList().size() > i; ++i) {
            TestUtil.logMsg((String)"*** Start \"Short\" Test Sequence ***");
            Object testNum = TestNum.getNumberList().get(i);
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            if (!(testNum instanceof Short) && !(testNum instanceof Byte)) {
                String skipType = testNum.getClass().getSimpleName();
                TestUtil.logMsg((String)("Skip " + skipType + " Data type already tested for this in the " + skipType + " tests."));
                continue;
            }
            try {
                String expr = ExprEval.buildElExpr(true, operator);
                TestUtil.logMsg((String)("expression to be evaluated is " + expr));
                TestUtil.logMsg((String)("types are  Short and " + testNum.getClass().getName()));
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                TestUtil.logMsg((String)("result is " + result.toString()));
                if ("+=".equals(operator)) {
                    pass = Validator.runConcatenationTest(testVal, result, testNum);
                } else if ("/".equals(operator)) {
                    returnType = Double.class;
                    TestUtil.logMsg((String)("Setting Expected Type: " + returnType.getCanonicalName()));
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Double)result, ((Short)expectedVal).doubleValue());
                } else {
                    returnType = Long.class;
                    TestUtil.logMsg((String)("Setting Expected Type: " + returnType.getCanonicalName()));
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Long)result, ((Short)expectedVal).longValue());
                }
            }
            catch (RuntimeException re) {
                TestUtil.printStackTrace((Throwable)re);
                throw new Exception(re);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                TestUtil.logMsg((String)"*** End \"Short\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    public static void testByte(Byte testVal, Object expectedVal, String operator) throws Exception {
        boolean pass = false;
        for (int i = 0; TestNum.getNumberList().size() > i; ++i) {
            TestUtil.logMsg((String)"*** Start \"Byte\" Test Sequence ***");
            Object testNum = TestNum.getNumberList().get(i);
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            if (!(testNum instanceof Byte)) {
                String skipType = testNum.getClass().getSimpleName();
                TestUtil.logMsg((String)("Skip " + skipType + " Data type already tested for this in the " + skipType + " tests."));
                continue;
            }
            try {
                String expr = ExprEval.buildElExpr(true, operator);
                TestUtil.logMsg((String)("expression to be evaluated is " + expr));
                TestUtil.logMsg((String)("types are  Byte and " + testNum.getClass().getName()));
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                TestUtil.logMsg((String)("result is " + result.toString()));
                if ("+=".equals(operator)) {
                    pass = Validator.runConcatenationTest(testVal, result, testNum);
                } else if ("/".equals(operator)) {
                    returnType = Double.class;
                    TestUtil.logMsg((String)("Setting Expected Type: " + returnType.getCanonicalName()));
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Double)result, ((Byte)expectedVal).doubleValue());
                } else {
                    returnType = Long.class;
                    TestUtil.logMsg((String)("Setting Expected Type: " + returnType.getCanonicalName()));
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Long)result, ((Byte)expectedVal).longValue());
                }
            }
            catch (RuntimeException re) {
                TestUtil.printStackTrace((Throwable)re);
                throw new Exception(re);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                TestUtil.logMsg((String)"*** End \"Byte\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    public static void testBoolean(boolean testValOne, Object testValTwo, Object expectedVal, String operator) throws Exception {
        boolean pass = false;
        NameValuePair[] values = NameValuePair.buildNameValuePair(testValOne, testValTwo);
        try {
            TestUtil.logMsg((String)"*** Start \"Boolean\" Test Sequence ***");
            String expr = ExprEval.buildElExpr(true, operator);
            TestUtil.logMsg((String)("expression to be evaluated is " + expr));
            TestUtil.logMsg((String)("types are  Boolean and " + testValTwo.getClass().getName()));
            Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
            if ("+=".equals(operator)) {
                pass = Validator.runConcatenationTest(testValOne, result, testValTwo);
            } else {
                TestUtil.logMsg((String)("result is " + result.toString()));
                pass = ExprEval.compareClass(result, Boolean.class) && ExprEval.compareValue((Object)((Boolean)result), expectedVal);
            }
        }
        catch (RuntimeException re) {
            TestUtil.printStackTrace((Throwable)re);
            throw new Exception(re);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(e);
        }
        finally {
            ExprEval.cleanup();
            TestUtil.logMsg((String)"*** End \"Boolean\" Test Sequence ***");
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    public static void testExpression(ELProcessor elp, String expr, Object expected, String testName) throws Exception {
        boolean pass = false;
        try {
            TestUtil.logMsg((String)("*** Start " + testName + " Test Sequence ***"));
            TestUtil.logMsg((String)("expression to be evaluated is " + expr));
            Object result = elp.eval(expr);
            boolean bl = pass = ExprEval.compareClass(result, expected.getClass()) && ExprEval.compareValue(result, expected);
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (RuntimeException re) {
            TestUtil.printStackTrace((Throwable)re);
            throw new Exception(re);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(e);
        }
        finally {
            ExprEval.cleanup();
            TestUtil.logMsg((String)("*** End " + testName + " Test Sequence ***"));
        }
    }

    private static Boolean runConcatenationTest(Object testVal, Object result, Object testNum) {
        Class<String> returnType = String.class;
        String expectedResult = testVal.toString() + testNum.toString();
        TestUtil.logMsg((String)("Setting Expected Type: " + returnType.getName()));
        return ExprEval.compareClass(result, returnType) && ExprEval.compareValue(result, expectedResult);
    }
}

