/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.expressionfactory;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.el.api.expression.ExpressionTest;
import com.sun.ts.tests.common.el.api.resolver.BarELResolver;
import com.sun.ts.tests.common.el.api.resolver.ResolverTest;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import com.sun.ts.tests.el.common.elcontext.SimpleELContext;
import com.sun.ts.tests.el.common.elresolver.EmployeeELResolver;
import com.sun.ts.tests.el.common.elresolver.VariableELResolver;
import com.sun.ts.tests.el.common.elresolver.VectELResolver;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.NameValuePair;
import com.sun.ts.tests.el.common.util.ResolverType;
import com.sun.ts.tests.el.common.util.SimpleBean;
import com.sun.ts.tests.el.common.util.SimpleInterface;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ExpressionFactory;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.protocol.common.TargetVehicle;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="el"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="tck-javatest")})
public class ELClientJspTest
extends ServiceEETest {
    static final String VEHICLE_ARCHIVE = "expressionfactory_jsp_vehicle";
    private static final System.Logger logger = System.getLogger(ELClientJspTest.class.getName());
    private Properties testProps;

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="expressionfactory_jsp_vehicle", order=2)
    public static WebArchive createDeploymentVehicle() throws IOException {
        WebArchive jsp_vehicle_web = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"expressionfactory_jsp_vehicle_web.war");
        jsp_vehicle_web.addClasses(new Class[]{EETest.Fault.class, EETest.SetupException.class, EETest.class, ServiceEETest.class, VehicleClient.class, VehicleRunnable.class, VehicleRunnerFactory.class, ExpressionTest.class, BarELResolver.class, ResolverTest.class, BareBonesELContext.class, SimpleELContext.class, SimpleELContext.Resolver.class, ELTestUtil.class, SimpleBean.class, SimpleInterface.class, ResolverType.class, NameValuePair.class, ExprEval.class, EmployeeELResolver.class, VariableELResolver.class, VectELResolver.class, ELClientJspTest.class, ObjectAndType.class});
        InputStream inStream = ELClientJspTest.class.getResourceAsStream("/vehicle/jsp/jsp_vehicle_web.xml");
        String webXml = ELClientJspTest.editWebXmlString(inStream, VEHICLE_ARCHIVE);
        jsp_vehicle_web.setWebXML((Asset)new StringAsset(webXml));
        URL warResURL = ELClientJspTest.class.getResource("/vehicle/jsp/contentRoot/client.html");
        jsp_vehicle_web.addAsWebResource(warResURL, "/client.html");
        warResURL = ELClientJspTest.class.getResource("/vehicle/jsp/contentRoot/jsp_vehicle.jsp");
        jsp_vehicle_web.addAsWebResource(warResURL, "/jsp_vehicle.jsp");
        return jsp_vehicle_web;
    }

    public static String inputStreamToString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public static String editWebXmlString(InputStream inStream, String servlet_vehicle) throws IOException {
        return ELClientJspTest.inputStreamToString(inStream).replaceAll("el_jsp_vehicle", servlet_vehicle);
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    public static void main(String[] args) {
        ELClientJspTest theTests = new ELClientJspTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        TestUtil.logTrace((String)"Setup method called");
        this.testProps = p;
    }

    @AfterEach
    public void cleanup() throws Exception {
        TestUtil.logTrace((String)"Cleanup method called");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void newInstanceTest() throws Exception {
        try {
            ExpressionFactory.newInstance();
            ExpressionFactory.newInstance(null);
            Properties props = new Properties();
            props.setProperty("jakarta.el.cacheSize", "128M");
            ExpressionFactory.newInstance((Properties)props);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void createValueExpressionTest() throws Exception {
        boolean pass = true;
        String[] exprStr = new String[]{"${employee.lastname}", "#{employee.lastname}", "John Doe", "${employee.firstname}${employee.lastname}", "#{employee.firstname}#{employee.lastname}", "Name: ${employee.firstname}${employee.lastname}", "Name: #{employee.firstname}#{employee.lastname}"};
        ValueExpression vexp = null;
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            SimpleELContext context = new SimpleELContext();
            for (int i = 0; i < exprStr.length; ++i) {
                try {
                    vexp = expFactory.createValueExpression((ELContext)context, exprStr[i], Object.class);
                }
                catch (NullPointerException npe) {
                    pass = false;
                    TestUtil.logErr((String)("Test FAILED" + exprStr[i]));
                    TestUtil.printStackTrace((Throwable)npe);
                    continue;
                }
                catch (ELException ee) {
                    pass = false;
                    TestUtil.logErr((String)("Test FAILED" + exprStr[i]));
                    TestUtil.printStackTrace((Throwable)ee);
                    continue;
                }
                if (vexp.getExpressionString().equals(exprStr[i])) continue;
                pass = false;
                TestUtil.logErr((String)"Failed. Expression string mismatch.");
                TestUtil.logErr((String)("Expected: " + exprStr[i]));
                TestUtil.logErr((String)("Received: " + vexp.getExpressionString()));
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void createValueExpression2Test() throws Exception {
        boolean pass = true;
        ObjectAndType[] testCases = new ObjectAndType[]{new ObjectAndType("some string", String.class), new ObjectAndType(null, String.class), new ObjectAndType(1, String.class), new ObjectAndType(1.5, Integer.class), new ObjectAndType("10000", Long.class), new ObjectAndType(1, Boolean.class), new ObjectAndType(Boolean.TRUE, Character.class), new ObjectAndType(1, Class.class)};
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        for (int i = 0; i < testCases.length; ++i) {
            try {
                expFactory.createValueExpression(testCases[i].obj, testCases[i].type);
                continue;
            }
            catch (Exception e) {
                pass = false;
                TestUtil.logErr((String)("Exception: Test Case " + i));
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new Exception("Test FAILED");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void createValueExpressionELExceptionTest() throws Exception {
        boolean pass = true;
        String[] exprStr = new String[]{"${employee.lastname", "#{employee[lastname}", "${ 5 ! 3 }", "${ 5 + }", "${employee.firstname}#{employee.lastname}", "#{employee.firstname}${employee.lastname}", "Name: ${employee.firstname}#{employee.lastname}", "Name: #{employee.firstname}${employee.lastname}"};
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            SimpleELContext context = new SimpleELContext();
            for (int i = 0; i < exprStr.length; ++i) {
                try {
                    expFactory.createValueExpression((ELContext)context, exprStr[i], Object.class);
                }
                catch (ELException ee) {
                    continue;
                }
                catch (NullPointerException npe) {
                    pass = false;
                    TestUtil.logErr((String)("Test FAILED" + exprStr[i]));
                    TestUtil.printStackTrace((Throwable)npe);
                    continue;
                }
                pass = false;
                TestUtil.logErr((String)"Failed. No ELException thrown when calling");
                TestUtil.logErr((String)("createValueExpression() with parameter " + exprStr[i]));
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void createMethodExpressionTest() throws Exception {
        boolean pass = true;
        String[] exprStr = new String[]{"${add}", "${vect.add}", "${vect[add]}", "#{add}", "#{vect.add}", "#{vect[add]}", "add"};
        MethodExpression mexp = null;
        Class[] paramTypes = new Class[]{};
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            SimpleELContext context = new SimpleELContext();
            for (int i = 0; i < exprStr.length; ++i) {
                try {
                    mexp = expFactory.createMethodExpression((ELContext)context, exprStr[i], Object.class, paramTypes);
                }
                catch (NullPointerException npe) {
                    pass = false;
                    TestUtil.logErr((String)("Test FAILED" + exprStr[i]));
                    TestUtil.printStackTrace((Throwable)npe);
                    continue;
                }
                catch (ELException ee) {
                    pass = false;
                    TestUtil.logErr((String)("Test FAILED" + exprStr[i]));
                    TestUtil.printStackTrace((Throwable)ee);
                    continue;
                }
                if (mexp.getExpressionString().equals(exprStr[i])) continue;
                pass = false;
                TestUtil.logErr((String)"Failed. Expression string mismatch.");
                TestUtil.logErr((String)("Expected: " + exprStr[i]));
                TestUtil.logErr((String)("Received: " + mexp.getExpressionString()));
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void createMethodExpressionELExceptionTest() throws Exception {
        boolean pass = true;
        String[] exprStr = new String[]{"${vect.add", "#{vect[add}", "${ 5 }", "${ -A }", "${ A + B }", "${vect.remove}${vect.add}", "#{vect.remove}#{vect.add}", "${vect.remove}#{vect.add}", "#{vect.remove}${vect.add}"};
        Class[] paramTypes = new Class[]{};
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            SimpleELContext context = new SimpleELContext();
            for (int i = 0; i < exprStr.length; ++i) {
                try {
                    expFactory.createMethodExpression((ELContext)context, exprStr[i], Object.class, paramTypes);
                }
                catch (ELException ee) {
                    continue;
                }
                catch (NullPointerException npe) {
                    pass = false;
                    TestUtil.logErr((String)("Test FAILED" + exprStr[i]));
                    TestUtil.printStackTrace((Throwable)npe);
                    continue;
                }
                pass = false;
                TestUtil.logErr((String)"Failed. No ELException thrown when calling");
                TestUtil.logErr((String)("createMethodExpression() with parameter " + exprStr[i]));
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void createExpressionNPETest() throws Exception {
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        SimpleELContext context = new SimpleELContext();
        TestUtil.logMsg((String)"Testing: ELContext.createValueExpression(context, function, null)");
        ELTestUtil.checkForNPE(expFactory, "createValueExpression", new Class[]{ELContext.class, String.class, Class.class}, new Object[]{context, "function", null});
        TestUtil.logMsg((String)"Testing: ELContext.createValueExpression(instance, null)");
        ELTestUtil.checkForNPE(expFactory, "createValueExpression", new Class[]{Object.class, Class.class}, new Object[]{"function", null});
        TestUtil.logMsg((String)"Testing: ELContext.createMethodExpression(context, instance, returnTypes, null)");
        ELTestUtil.checkForNPE(expFactory, "createMethodExpression", new Class[]{ELContext.class, String.class, Class.class, Class[].class}, new Object[]{context, "${foo}", Object.class, null});
    }

    @Test
    @TargetVehicle(value="jsp")
    public void coerceToTypeTest() throws Exception {
        boolean pass = true;
        ObjectAndType[] testCases = new ObjectAndType[]{new ObjectAndType("some string", String.class), new ObjectAndType(null, String.class), new ObjectAndType(1, String.class), new ObjectAndType(1.5, String.class), new ObjectAndType(Boolean.FALSE, String.class), new ObjectAndType(1.5, Integer.class), new ObjectAndType(1, Float.class), new ObjectAndType("10000", Long.class), new ObjectAndType("no value", Boolean.class), new ObjectAndType(null, null)};
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        for (int i = 0; i < testCases.length; ++i) {
            try {
                Object coercedObj = expFactory.coerceToType(testCases[i].obj, testCases[i].type);
                if (coercedObj == null) {
                    if (testCases[i].type == null || testCases[i].obj == null) continue;
                    pass = false;
                    TestUtil.logErr((String)("Failed: Test Case " + i));
                    continue;
                }
                if (ExprEval.compareClass(coercedObj, testCases[i].type)) continue;
                pass = false;
                TestUtil.logErr((String)("Failed: Test Case " + i));
                continue;
            }
            catch (Exception e) {
                pass = false;
                TestUtil.logErr((String)("Exception: Test Case " + i));
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new Exception("Test FAILED");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void coerceToTypeELExceptionTest() throws Exception {
        boolean pass = true;
        ObjectAndType[] testCases = new ObjectAndType[]{new ObjectAndType(1, Boolean.class), new ObjectAndType(Boolean.FALSE, Long.class), new ObjectAndType(Boolean.TRUE, Character.class), new ObjectAndType(true, Float.class), new ObjectAndType("non-numeric string", Long.class), new ObjectAndType(1, Class.class)};
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        for (int i = 0; i < testCases.length; ++i) {
            try {
                expFactory.coerceToType(testCases[i].obj, testCases[i].type);
                pass = false;
                TestUtil.logErr((String)("Test Case " + i + " did not cause an exception"));
                continue;
            }
            catch (ELException elx) {
                pass = true;
                continue;
            }
            catch (Exception e) {
                pass = false;
                TestUtil.logErr((String)("Test Case " + i + " threw an exception"));
                TestUtil.logErr((String)"but it was not an ELException");
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new Exception("Test FAILED");
        }
    }

    private static class ObjectAndType {
        public Object obj;
        public Class<?> type;

        public ObjectAndType(Object obj, Class<?> type) {
            this.obj = obj;
            this.type = type;
        }
    }
}

