/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.arrayelresolver;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.el.api.resolver.BarELResolver;
import com.sun.ts.tests.common.el.api.resolver.ResolverTest;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import jakarta.el.ArrayELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.protocol.common.TargetVehicle;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="el"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="tck-javatest")})
public class ELClientJspTest
extends ServiceEETest {
    static final String VEHICLE_ARCHIVE = "arrayelresolver_jsp_vehicle";
    private static final System.Logger logger = System.getLogger(ELClientJspTest.class.getName());
    private Properties testProps;
    private static final String[] names = new String[]{"doug", "nick", "roger", "ryan", "ed"};

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="arrayelresolver_jsp_vehicle", order=2)
    public static WebArchive createDeploymentVehicle() throws IOException {
        WebArchive jsp_vehicle_web = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"arrayelresolver_jsp_vehicle_web.war");
        jsp_vehicle_web.addClasses(new Class[]{EETest.Fault.class, EETest.SetupException.class, EETest.class, ServiceEETest.class, BarELResolver.class, ResolverTest.class, VehicleClient.class, VehicleRunnable.class, VehicleRunnerFactory.class, BareBonesELContext.class, ELTestUtil.class, ELClientJspTest.class});
        InputStream inStream = ELClientJspTest.class.getResourceAsStream("/vehicle/jsp/jsp_vehicle_web.xml");
        String webXml = ELClientJspTest.editWebXmlString(inStream, VEHICLE_ARCHIVE);
        jsp_vehicle_web.setWebXML((Asset)new StringAsset(webXml));
        URL warResURL = ELClientJspTest.class.getResource("/vehicle/jsp/contentRoot/client.html");
        jsp_vehicle_web.addAsWebResource(warResURL, "/client.html");
        warResURL = ELClientJspTest.class.getResource("/vehicle/jsp/contentRoot/jsp_vehicle.jsp");
        jsp_vehicle_web.addAsWebResource(warResURL, "/jsp_vehicle.jsp");
        return jsp_vehicle_web;
    }

    public static String inputStreamToString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public static String editWebXmlString(InputStream inStream, String servlet_vehicle) throws IOException {
        return ELClientJspTest.inputStreamToString(inStream).replaceAll("el_jsp_vehicle", servlet_vehicle);
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    public static void main(String[] args) {
        ELClientJspTest theTests = new ELClientJspTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        TestUtil.logTrace((String)"Setup method called");
        this.testProps = p;
    }

    @AfterEach
    public void cleanup() throws Exception {
        TestUtil.logTrace((String)"Cleanup method called");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void arrayELResolverTest() throws Exception {
        boolean pass;
        StringBuffer buf = new StringBuffer();
        String[] colors = new String[]{"red", "blue", "green"};
        try {
            ArrayELResolver arrayResolver = new ArrayELResolver();
            BareBonesELContext barebonesContext = new BareBonesELContext();
            ELContext context = barebonesContext.getELContext();
            pass = ResolverTest.testELResolver((ELContext)context, (ELResolver)arrayResolver, (Object)colors, (Object)1, (Object)"yellow", (StringBuffer)buf, (boolean)false);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="jsp")
    public void arrayELResolverNPETest() throws Exception {
        boolean pass;
        StringBuffer buf = new StringBuffer();
        ArrayELResolver resolver = new ArrayELResolver();
        try {
            pass = ResolverTest.testELResolverNPE((ELResolver)resolver, (Object)names, (Object)1, (Object)"billy", (StringBuffer)buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="jsp")
    public void arrayELResolverPNFETest() throws Exception {
        boolean pass;
        StringBuffer buf = new StringBuffer();
        ArrayELResolver resolver = new ArrayELResolver();
        BareBonesELContext barebonesContext = new BareBonesELContext();
        ELContext context = barebonesContext.getELContext();
        try {
            pass = ResolverTest.testELResolverPNFE((ELContext)context, (ELResolver)resolver, (Object)names, (Object)10, (StringBuffer)buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="jsp")
    public void arrayELResolverIAETest() throws Exception {
        boolean pass;
        StringBuffer buf = new StringBuffer();
        ArrayELResolver resolver = new ArrayELResolver();
        BareBonesELContext barebonesContext = new BareBonesELContext();
        ELContext context = barebonesContext.getELContext();
        try {
            pass = ResolverTest.testELResolverIAE((ELContext)context, (ELResolver)resolver, (Object)names, (Object)"GARBAGE", (Object)"billy", (StringBuffer)buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="jsp")
    public void arrayELResolverPNWETest() throws Exception {
        boolean pass;
        StringBuffer buf = new StringBuffer();
        ArrayELResolver resolver = new ArrayELResolver(true);
        BareBonesELContext barebonesContext = new BareBonesELContext();
        ELContext context = barebonesContext.getELContext();
        try {
            pass = ResolverTest.testELResolverPNWE((ELContext)context, (ELResolver)resolver, (Object)names, (Object)1, (Object)"billy", (StringBuffer)buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="jsp")
    public void arrayELResolverOBETest() throws Exception {
        boolean pass = true;
        StringBuffer buf = new StringBuffer();
        ArrayELResolver resolver = new ArrayELResolver();
        BareBonesELContext barebonesContext = new BareBonesELContext();
        ELContext context = barebonesContext.getELContext();
        try {
            Object value = resolver.getValue(context, (Object)names, (Object)5);
            if (value != null) {
                pass = false;
                buf.append("Expected Value: 'null'").append(TestUtil.NEW_LINE).append("Received Value: ").append(value.toString());
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void arrayELResolverCCETest() throws Exception {
        boolean pass = false;
        ArrayELResolver resolver = new ArrayELResolver();
        BareBonesELContext barebonesContext = new BareBonesELContext();
        ELContext context = barebonesContext.getELContext();
        try {
            resolver.setValue(context, (Object)names, (Object)1, (Object)Boolean.TRUE);
        }
        catch (ClassCastException cce) {
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Failed: Exception thrown but was not a ClassCastException");
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("Failed: No exception thrown.");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void arrayELResolverLengthTest() throws Exception {
        boolean pass;
        StringBuffer buf = new StringBuffer();
        String[] colors = new String[]{"red", "blue", "green"};
        try {
            ArrayELResolver arrayResolver = new ArrayELResolver();
            BareBonesELContext barebonesContext = new BareBonesELContext();
            ELContext context = barebonesContext.getELContext();
            pass = ResolverTest.testELResolver((ELContext)context, (ELResolver)arrayResolver, (Object)colors, (Object)"length", (Object)"3", (StringBuffer)buf, (boolean)true);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }
}

