/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.ee.propagation.cm.extended;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import ee.jakarta.tck.persistence.ee.common.Account;
import ee.jakarta.tck.persistence.ee.common.B;
import ee.jakarta.tck.persistence.ee.propagation.cm.extended.Stateful3IF;
import ee.jakarta.tck.persistence.ee.propagation.cm.extended.Teller;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.EJBException;
import jakarta.ejb.Remote;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateful;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContextType;
import java.util.Properties;

@Stateful(name="Stateful3Bean")
@Remote(value={Stateful3IF.class})
public class Stateful3Bean
implements Stateful3IF {
    @PersistenceContext(type=PersistenceContextType.EXTENDED, unitName="CTS-EXT-UNIT")
    private EntityManager entityManager;
    public SessionContext sessionContext;
    private static final B[] bRef = new B[5];
    @EJB(beanName="TellerBean", beanInterface=Teller.class)
    private Teller beanRef;

    @Resource
    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    @Override
    public void init(Properties p) {
        TestUtil.logTrace((String)"init");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    @Override
    public void createTestData() {
        try {
            TestUtil.logTrace((String)"createTestData");
            TestUtil.logTrace((String)"Create 5 Bees");
            Stateful3Bean.bRef[0] = new B("1", "customerB1", 1);
            Stateful3Bean.bRef[1] = new B("2", "customerB2", 2);
            Stateful3Bean.bRef[2] = new B("3", "customerB3", 3);
            Stateful3Bean.bRef[3] = new B("4", "customerB4", 4);
            Stateful3Bean.bRef[4] = new B("5", "customerB5", 5);
            TestUtil.logTrace((String)"Start to persist Bees ");
            for (B b : bRef) {
                if (b == null) continue;
                this.entityManager.persist((Object)b);
                TestUtil.logTrace((String)("persisted B " + b));
            }
            this.entityManager.flush();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Unexpected while creating test data:" + e));
        }
    }

    @Override
    public void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        try {
            this.entityManager.createNativeQuery("DELETE FROM BEJB_1X1_BI_BTOB").executeUpdate();
            this.entityManager.createNativeQuery("DELETE FROM AEJB_1X1_BI_BTOB").executeUpdate();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        TestUtil.logTrace((String)"Clearing cache");
        this.entityManager.getEntityManagerFactory().getCache().evictAll();
    }

    @Override
    public boolean test1() {
        TestUtil.logTrace((String)"Begin test1");
        boolean pass = false;
        try {
            this.removeTestData();
            this.createTestData();
            B anotherB = (B)this.entityManager.find(B.class, (Object)"3");
            if (anotherB != null) {
                TestUtil.logTrace((String)("newB found" + anotherB.getName()));
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception :", (Throwable)e);
            pass = false;
        }
        finally {
            this.removeTestData();
        }
        return pass;
    }

    @Override
    public boolean test2() {
        TestUtil.logTrace((String)"Begin test2");
        boolean pass = false;
        try {
            this.entityManager.getTransaction();
        }
        catch (IllegalStateException ise) {
            pass = true;
            TestUtil.logTrace((String)("IllegalStateException Caught as Expected: " + ise));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception :", (Throwable)e);
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test3() {
        boolean pass = false;
        try {
            this.beanRef.removeTestData();
            TestUtil.logTrace((String)"DEBUG:  createAccountData");
            this.beanRef.createTestData();
            String accounts = this.beanRef.getAllAccounts();
            if (accounts != null) {
                TestUtil.logTrace((String)accounts);
            }
            Account ACCOUNT = (Account)this.entityManager.find(Account.class, (Object)1075);
            pass = this.beanRef.checkAccountStatus(ACCOUNT);
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception:", (Throwable)e);
        }
        finally {
            this.beanRef.removeTestData();
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test4() {
        Double EXPECTED_BALANCE = 10540.75;
        boolean pass = false;
        try {
            this.beanRef.removeTestData();
            System.out.println("DEBUG:  createAccountData");
            this.beanRef.createTestData();
            Account ACCOUNT = (Account)this.entityManager.find(Account.class, (Object)1075);
            Double balance = this.beanRef.balance(ACCOUNT.id());
            balance = this.beanRef.deposit(ACCOUNT.id(), 100.0);
            balance = this.beanRef.withdraw(ACCOUNT.id(), 50.0);
            if (EXPECTED_BALANCE.equals(balance)) {
                TestUtil.logTrace((String)"Expected balance received.");
                pass = true;
            } else {
                TestUtil.logErr((String)(" Did not get Expected balance, got:" + balance + "Expected: " + EXPECTED_BALANCE));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception:", (Throwable)e);
        }
        finally {
            this.beanRef.removeTestData();
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test5() {
        boolean pass = false;
        boolean pass1 = false;
        try {
            this.removeTestData();
            TestUtil.logTrace((String)"createTestData");
            this.createTestData();
            TestUtil.logTrace((String)"find customerB");
            B customerB = (B)this.entityManager.find(B.class, (Object)"4");
            if (null != customerB) {
                TestUtil.logTrace((String)"check customer status");
                pass1 = this.beanRef.checkCustomerStatus(customerB);
            }
            this.entityManager.refresh((Object)customerB);
            if (pass1 && customerB.getA().getName().equals("customerA9")) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception:", (Throwable)e);
        }
        finally {
            this.removeTestData();
        }
        return pass;
    }

    @Override
    public boolean test6() {
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"find customerB");
            B customerB = (B)this.entityManager.find(B.class, (Object)"3");
            if (null != customerB) {
                TestUtil.logTrace((String)"customer is not null, call rollbackStatus()");
                pass = this.beanRef.rollbackStatus(customerB);
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception:", (Throwable)e);
        }
        return pass;
    }

    @Override
    public boolean verifyTest6() {
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"verifyTest6:  find customerB");
            B customerB = (B)this.entityManager.find(B.class, (Object)"3");
            if (customerB.getName().equals("customerB3")) {
                pass = true;
            } else {
                TestUtil.logErr((String)(" did not get the expected result.  Expected customerB3, got: " + customerB.getName()));
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception in verifyTest6:", (Throwable)e);
        }
        finally {
            this.removeTestData();
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test7() {
        boolean pass = false;
        boolean pass1 = false;
        try {
            this.removeTestData();
            TestUtil.logTrace((String)"createTestData");
            this.createTestData();
            B customerB = (B)this.entityManager.find(B.class, (Object)"5");
            if (null != customerB) {
                TestUtil.logTrace((String)"customer is not null, call flushStatus()");
                pass1 = this.beanRef.flushStatus(customerB);
                TestUtil.logTrace((String)"refresh customerB entity to be sure to get actual state");
                this.entityManager.refresh((Object)customerB);
                if (pass1 && customerB.getName().equals("flushB")) {
                    pass = true;
                } else {
                    TestUtil.logErr((String)(" did not get the expected result.  Expected flushB, got: " + customerB.getName()));
                }
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception:", (Throwable)e);
        }
        finally {
            this.removeTestData();
        }
        return pass;
    }
}

