/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_msgTypesQ2;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageListener;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.Properties;

public class MsgBeanMsgTestQ2
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    private MessageDrivenContext mdc = null;
    private QueueConnectionFactory qFactory = null;
    private QueueConnection qConnection = null;
    private Queue queueR = null;
    private Queue queue = null;
    private QueueSender mSender = null;
    private QueueSession qSession = null;

    public MsgBeanMsgTestQ2() {
        TestUtil.logTrace((String)"@MsgBeanMsgTestQ2()!");
    }

    public void ejbCreate() {
        TestUtil.logTrace((String)"jms.ee.mdb.mdb_msgTypesQ2  - @MsgBeanMsgTestQ2-ejbCreate() !!");
        try {
            this.context = new TSNamingContext();
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            if (this.qFactory == null) {
                TestUtil.logTrace((String)"qFactory error");
            }
            TestUtil.logTrace((String)"got a qFactory !!");
            this.queueR = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            if (this.queueR == null) {
                TestUtil.logTrace((String)"queueR error");
            }
            this.queue = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE");
            if (this.queue == null) {
                TestUtil.logTrace((String)"queue error");
            }
            this.p = new Properties();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("MDB ejbCreate Error!", e);
        }
    }

    public void onMessage(Message msg) {
        JmsUtil.initHarnessProps((Message)msg, (Properties)this.p);
        TestUtil.logTrace((String)("from jms.ee.mdb.mdb_msgTypesQ2 @onMessage!" + msg));
        try {
            TestUtil.logTrace((String)("onMessage will run TestCase: " + msg.getStringProperty("TestCase")));
            this.qConnection = this.qFactory.createQueueConnection();
            if (this.qConnection == null) {
                TestUtil.logTrace((String)"connection error");
            } else {
                this.qConnection.start();
                this.qSession = this.qConnection.createQueueSession(true, 0);
            }
            if (msg.getStringProperty("TestCase").equals("messageObjectCopyQTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - running messageObjectCopyQTestCreate - create the message");
                this.messageObjectCopyQTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("messageObjectCopyQTest")) {
                TestUtil.logTrace((String)"@onMessage - running messageObjectCopyQTest - read and verify the message");
                this.messageObjectCopyQTest((ObjectMessage)msg);
            }
            if (msg.getStringProperty("TestCase").equals("streamMessageConversionQTestsBooleanCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionQTestsBooleanCreate - create the message");
                this.streamMessageConversionQTestsBooleanCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionQTestsBoolean")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionQTestsBoolean - read and verify the message");
                this.streamMessageConversionQTestsBoolean((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionQTestsByteCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionQTestsByteCreate - create the message");
                this.streamMessageConversionQTestsByteCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionQTestsByte")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionQTestsByte - read and verify the message");
                this.streamMessageConversionQTestsByte((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionQTestsShortCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionQTestsShortCreate - create the message");
                this.streamMessageConversionQTestsShortCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionQTestsShort")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionQTestsShort - read and verify the message");
                this.streamMessageConversionQTestsShort((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionQTestsIntCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionQTestsIntCreate - create the message");
                this.streamMessageConversionQTestsIntCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionQTestsInt")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionQTestsInt - read and verify the message");
                this.streamMessageConversionQTestsInt((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionQTestsLongCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionQTestsLongCreate - create the message");
                this.streamMessageConversionQTestsLongCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionQTestsLong")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionQTestsLong - read and verify the message");
                this.streamMessageConversionQTestsLong((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionQTestsFloatCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionQTestsFloatCreate - create the message");
                this.streamMessageConversionQTestsFloatCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionQTestsFloat")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionQTestsFloat - read and verify the message");
                this.streamMessageConversionQTestsFloat((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionQTestsDoubleCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionQTestsDoubleCreate - create the message");
                this.streamMessageConversionQTestsDoubleCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionQTestsDouble")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionQTestsDouble - read and verify the message");
                this.streamMessageConversionQTestsDouble((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionQTestsStringCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionQTestsStringCreate - create the message");
                this.streamMessageConversionQTestsStringCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionQTestsString")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionQTestsString - read and verify the message");
                this.streamMessageConversionQTestsString((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionQTestsCharCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionQTestsCharCreate - create the message");
                this.streamMessageConversionQTestsCharCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionQTestsChar")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionQTestsChar - read and verify the message");
                this.streamMessageConversionQTestsChar((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionQTestsBytesCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionQTestsBytesCreate - create the message");
                this.streamMessageConversionQTestsBytesCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionQTestsBytes")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionQTestsBytes - read and verify the message");
                this.streamMessageConversionQTestsBytes((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionQTestsInvFormatStringCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionQTestsInvFormatStringCreate - create the message");
                this.streamMessageConversionQTestsInvFormatStringCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionQTestsInvFormatString")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageConversionQTestsInvFormatString - read and verify the message");
                this.streamMessageConversionQTestsInvFormatString((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageQTestsFullMsgCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageQTestsFullMsgCreate - create the message");
                this.streamMessageQTestsFullMsgCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageQTestsFullMsg")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageQTestsFullMsg - read and verify the message");
                this.streamMessageQTestsFullMsg((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageQTestNullCreate")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageQTestNullCreate - create the message");
                this.streamMessageQTestNullCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageQTestNull")) {
                TestUtil.logTrace((String)"@onMessage - running streamMessageQTestNull - read and verify the message");
                this.streamMessageQTestNull((StreamMessage)msg);
            } else {
                TestUtil.logTrace((String)"@onMessage - invalid message type found in StringProperty");
            }
            TestUtil.logTrace((String)"@onMessage - Finished for this test!");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.qConnection != null) {
                try {
                    this.qConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
    }

    public void messageObjectCopyQTestCreate() {
        boolean pass = true;
        try {
            ObjectMessage messageSentObjectMsg = null;
            StringBuffer sBuff = new StringBuffer("This is");
            String initial = "This is";
            messageSentObjectMsg = this.qSession.createObjectMessage();
            JmsUtil.addPropsToMessage((Message)messageSentObjectMsg, (Properties)this.p);
            messageSentObjectMsg.setObject((Serializable)sBuff);
            sBuff.append("a test ");
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "messageObjectCopyQTest");
            messageSentObjectMsg.setStringProperty("TestCase", "messageObjectCopyQTest");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSentObjectMsg);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionQTestsBooleanCreate() {
        try {
            StreamMessage messageSent = null;
            boolean abool = true;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionQTestsBoolean");
            TestUtil.logTrace((String)"Verify conversion support for boolean primitive type section 3.11.3");
            messageSent.setStringProperty("TestCase", "streamMessageConversionQTestsBoolean");
            messageSent.writeBoolean(abool);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionQTestsByteCreate() {
        try {
            StreamMessage messageSent = null;
            byte bValue = 127;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionQTestsByte");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setStringProperty("TestCase", "streamMessageConversionQTestsByte");
            messageSent.writeByte(bValue);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionQTestsShortCreate() {
        try {
            StreamMessage messageSent = null;
            short sValue = 1;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionQTestsShort");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setStringProperty("TestCase", "streamMessageConversionQTestsShort");
            messageSent.writeShort(sValue);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionQTestsIntCreate() {
        try {
            StreamMessage messageSent = null;
            int iValue = 6;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionQTestsInt");
            messageSent.setStringProperty("TestCase", "streamMessageConversionQTestsInt");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeInt(iValue);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionQTestsLongCreate() {
        try {
            StreamMessage messageSent = null;
            long lValue = 2L;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionQTestsLong");
            messageSent.setStringProperty("TestCase", "streamMessageConversionQTestsLong");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeLong(lValue);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionQTestsFloatCreate() {
        try {
            StreamMessage messageSent = null;
            float fValue = 5.0f;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionQTestsFloat");
            messageSent.setStringProperty("TestCase", "streamMessageConversionQTestsFloat");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeFloat(fValue);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionQTestsDoubleCreate() {
        try {
            StreamMessage messageSent = null;
            double dValue = 3.0;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionQTestsDouble");
            messageSent.setStringProperty("TestCase", "streamMessageConversionQTestsDouble");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeDouble(dValue);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionQTestsStringCreate() {
        try {
            StreamMessage messageSent = null;
            String myString = "10";
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionQTestsString");
            messageSent.setStringProperty("TestCase", "streamMessageConversionQTestsString");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeString(myString);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionQTestsCharCreate() {
        try {
            StreamMessage messageSent = null;
            char charValue = 'a';
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionQTestsChar");
            messageSent.setStringProperty("TestCase", "streamMessageConversionQTestsChar");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeChar(charValue);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionQTestsBytesCreate() {
        try {
            StreamMessage messageSent = null;
            byte[] bValues = new byte[]{1, 2, 3};
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionQTestsBytes");
            TestUtil.logTrace((String)"Verify conversion support for byte[] primitive type section 3.11.3");
            messageSent.setStringProperty("TestCase", "streamMessageConversionQTestsBytes");
            messageSent.writeBytes(bValues);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionQTestsInvFormatStringCreate() {
        try {
            StreamMessage messageSent = null;
            String myString = "mytest string";
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionQTestsInvFormatString");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setStringProperty("TestCase", "streamMessageConversionQTestsInvFormatString");
            messageSent.writeString(myString);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageQTestsFullMsgCreate() {
        try {
            StreamMessage messageSent = null;
            byte bValue = 127;
            boolean abool = false;
            byte[] bValues = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
            byte[] bValues2 = new byte[]{11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
            char charValue = 'Z';
            short sValue = Short.MAX_VALUE;
            long lValue = Long.MAX_VALUE;
            double dValue = 6.02E23;
            float fValue = 6.02E23f;
            int iValue = 6;
            boolean pass = true;
            String myString = "text";
            String sTesting = "Testing StreamMessages";
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageQTestsFullMsg");
            messageSent.writeBytes(bValues2, 0, bValues2.length);
            messageSent.writeBoolean(abool);
            messageSent.writeByte(bValue);
            messageSent.writeBytes(bValues);
            messageSent.writeChar(charValue);
            messageSent.writeDouble(dValue);
            messageSent.writeFloat(fValue);
            messageSent.writeInt(iValue);
            messageSent.writeLong(lValue);
            messageSent.writeObject((Object)sTesting);
            messageSent.writeShort(sValue);
            messageSent.writeString(myString);
            messageSent.writeObject(null);
            messageSent.setStringProperty("TestCase", "streamMessageQTestsFullMsg");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageQTestNullCreate() {
        try {
            StreamMessage messageSent = null;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageQTestNull");
            TestUtil.logTrace((String)"writeString(null) ");
            messageSent.setStringProperty("TestCase", "streamMessageQTestNull");
            messageSent.writeString(null);
            TestUtil.logTrace((String)"Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void messageObjectCopyQTest(ObjectMessage messageReceivedObjectMsg) {
        boolean pass = true;
        String testCase = "messageObjectCopyQTest";
        String initial = "This is";
        try {
            TestUtil.logMsg((String)"Ensure that changing the object did not change the message");
            StringBuffer s = (StringBuffer)messageReceivedObjectMsg.getObject();
            TestUtil.logTrace((String)("s is " + s));
            if (s.toString().equals(initial)) {
                TestUtil.logTrace((String)"Pass: msg was not changed");
            } else {
                TestUtil.logTrace((String)"Fail: msg was changed!");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionQTestsBoolean(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionQTestsBoolean";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            boolean pass = true;
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBoolean to read a boolean");
            try {
                if (messageReceived.readBoolean() == abool) {
                    TestUtil.logTrace((String)"Pass: boolean to boolean - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readString to read a boolean");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Boolean.valueOf(abool).toString())) {
                    TestUtil.logTrace((String)"Pass: boolean to string - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBytes[] to read a boolean - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)("Count returned from readBytes is : " + nCount));
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                bValue = messageReceived.readByte();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readShort to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readShort();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readChar to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readChar();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readInt to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readInt();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readLong to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readLong();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readFloat to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readFloat();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readDouble to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readDouble();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionQTestsByte(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionQTestsByte";
        try {
            byte bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read a boolean - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readString to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Byte.toString(bValue))) {
                    TestUtil.logTrace((String)"Pass: byte to string - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBytes[] to read a byte - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)("Count returned from readBytes is : " + nCount));
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readByte() == bValue) {
                    TestUtil.logTrace((String)"Pass: byte to byte - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readShort to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readShort() == bValue) {
                    TestUtil.logTrace((String)"Pass: byte to short - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readChar to read a boolean - this is not valid");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                pass = false;
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readInt to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readInt() == bValue) {
                    TestUtil.logTrace((String)"Pass: byte to int - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readLong to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == (long)bValue) {
                    TestUtil.logTrace((String)"Pass: byte to long - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readFloat to read a boolean - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readDouble to read a boolean - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionQTestsShort(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionQTestsShort";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            short sValue = 1;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBoolean to read a short - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readString to read a short");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Short.toString(sValue))) {
                    TestUtil.logTrace((String)"Pass: short to string - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBytes[] to read a short - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)("Count returned from readBytes is : " + nCount));
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read a short - this is not valid");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readShort to read a short");
            try {
                messageReceived.reset();
                if (messageReceived.readShort() == sValue) {
                    TestUtil.logTrace((String)"Pass: short to short - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readChar to read a short - this is not valid");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readInt to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readInt() == sValue) {
                    TestUtil.logTrace((String)"Pass: short to int - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readLong to read a short");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == (long)sValue) {
                    TestUtil.logTrace((String)"Pass: short to long - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readFloat to read a short - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readDouble to read a short - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionQTestsInt(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionQTestsInt";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBoolean to read an int - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readString to read an int");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Integer.toString(iValue))) {
                    TestUtil.logTrace((String)"Pass: int to string - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBytes[] to read an int - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)("Count returned from readBytes is : " + nCount));
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read an int - this is not valid");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readShort to read an int");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readChar to read an int - this is not valid");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readInt to read an int");
            try {
                messageReceived.reset();
                if (messageReceived.readInt() == iValue) {
                    TestUtil.logTrace((String)"Pass: int to int - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readLong to read an int");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == (long)iValue) {
                    TestUtil.logTrace((String)"Pass: int to long - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readFloat to read an int - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readDouble to read an int - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionQTestsLong(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionQTestsLong";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBoolean to read a long - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readString to read a long");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Long.toString(lValue))) {
                    TestUtil.logTrace((String)"Pass: long to string - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBytes[] to read  a long - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)("Count returned from readBytes is : " + nCount));
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read an long - this is not valid");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readShort to read a long");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readChar to read a long - this is not valid");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readInt to read a long");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readLong to read a long");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == lValue) {
                    TestUtil.logTrace((String)"Pass: int to long - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readFloat to read a long - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readDouble to read an long - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionQTestsFloat(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionQTestsFloat";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBoolean to read a float  ");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readString to read a float");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Float.toString(fValue))) {
                    TestUtil.logTrace((String)"Pass: float to string - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBytes[] to read  a float ");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)("Count returned from readBytes is : " + nCount));
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read a float  ");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readShort to read a float");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readChar to read a long  ");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readInt to read a float");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readLong to read a long");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readFloat to read a float  ");
            try {
                messageReceived.reset();
                if (messageReceived.readFloat() == fValue) {
                    TestUtil.logTrace((String)"Pass: float to float - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readDouble to read an float  ");
            try {
                messageReceived.reset();
                if (messageReceived.readDouble() == (double)fValue) {
                    TestUtil.logTrace((String)"Pass: float to double - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionQTestsDouble(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionQTestsDouble";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBoolean to read a double  ");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readString to read a double");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Double.toString(dValue))) {
                    TestUtil.logTrace((String)"Pass: double to string");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBytes[] to read  a double ");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)("Count returned from readBytes is : " + nCount));
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read a double  ");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readShort to read a double");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readChar to read a double  ");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readInt to read a double");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readLong to read a double");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readFloat to read a double  ");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readDouble to read a double  ");
            try {
                messageReceived.reset();
                if (messageReceived.readDouble() == dValue) {
                    TestUtil.logTrace((String)"Pass: double to double ");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionQTestsString(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionQTestsString";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            String myString = "10";
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readString to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(myString)) {
                    TestUtil.logTrace((String)"Pass: string to string - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBytes[] to read a String");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)("Count returned from readBytes is : " + nCount));
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readByte() == Byte.parseByte(myString)) {
                    TestUtil.logTrace((String)"Pass: String to byte ");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readShort to read a string");
            try {
                messageReceived.reset();
                if (messageReceived.readShort() == Short.parseShort(myString)) {
                    TestUtil.logTrace((String)"Pass: String to short ");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readChar to read a String ");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readInt to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readInt() == Integer.parseInt(myString)) {
                    TestUtil.logTrace((String)"Pass: String to int ");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readLong to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == Long.parseLong(myString)) {
                    TestUtil.logTrace((String)"Pass: String to long ");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readFloat to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readFloat() == Float.parseFloat(myString)) {
                    TestUtil.logTrace((String)"Pass: String to float ");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readDouble to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readDouble() == Double.parseDouble(myString)) {
                    TestUtil.logTrace((String)"Pass: String to double ");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBoolean to read a string ");
            try {
                messageReceived.clearBody();
                messageReceived.writeString("true");
                messageReceived.reset();
                if (messageReceived.readBoolean() == abool) {
                    TestUtil.logTrace((String)"Pass: String to boolean ");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBoolean to read a string  that is !true ");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                if (!b) {
                    TestUtil.logTrace((String)"Fail: !true should return false");
                    pass = false;
                } else {
                    TestUtil.logTrace((String)"Pass: !true returned false");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionQTestsChar(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionQTestsChar";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBoolean to read a char - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readString to read a char");
            try {
                messageReceived.reset();
                String s = messageReceived.readString();
                TestUtil.logTrace((String)("char returned for \"a\" is : " + s));
                if (s.equals("a")) {
                    TestUtil.logTrace((String)"Pass: char to string - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBytes[] to read a char - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)("Count returned from readBytes is : " + nCount));
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read a char - this is not valid");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readShort to read a char");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readChar to read a char ");
            try {
                messageReceived.reset();
                if (messageReceived.readChar() == 'a') {
                    TestUtil.logTrace((String)"Pass: char to char - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readInt to read a char ");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readLong to read a char");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readFloat to read a char - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readDouble to read a char - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionQTestsBytes(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionQTestsBytes";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues2 = new byte[]{0, 0, 0};
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBytes[] to read a byte[] ");
            boolean nCount = false;
            try {
                messageReceived.reset();
                if (messageReceived.readBytes(bValues2) == 3) {
                    TestUtil.logTrace((String)"Pass: byte[] to byte[] - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: count incorrect");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBoolean to read a byte[]");
            messageReceived.reset();
            try {
                boolean b = messageReceived.readBoolean();
                TestUtil.logTrace((String)"Fail: byte[] to boolean conversion should have thrown MessageFormatException");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readString to read a byte[]");
            try {
                messageReceived.reset();
                String s = messageReceived.readString();
                TestUtil.logTrace((String)"Fail: byte[] to boolean conversion should have thrown MessageFormatException");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readShort to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readChar to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readInt to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readLong to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readFloat to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readDouble to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionQTestsInvFormatString(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionQTestsInvFormatString";
        try {
            boolean pass = true;
            String myString = "mytest string";
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read a String that is not valid ");
            try {
                byte b = messageReceived.readByte();
                TestUtil.logTrace((String)"Fail: java.lang.NumberFormatException expected");
                pass = false;
            }
            catch (NumberFormatException e) {
                TestUtil.logTrace((String)"Pass: java.lang.NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Verify that the data can be read as a string and pointer did not move");
            try {
                String s = messageReceived.readString();
                TestUtil.logTrace((String)("message read: " + s));
                if (s.equals(myString)) {
                    TestUtil.logTrace((String)"Pass: able to read the string");
                } else {
                    TestUtil.logTrace((String)"Fail: string not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readShort to read a string that is not valid ");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                TestUtil.logTrace((String)"Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException e) {
                TestUtil.logTrace((String)"Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readInt to read a String that is not valid ");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                TestUtil.logTrace((String)"Fail: NumberFormatException was expected");
            }
            catch (NumberFormatException e) {
                TestUtil.logTrace((String)"Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readLong to read a String that is not valid ");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                TestUtil.logTrace((String)"Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException e) {
                TestUtil.logTrace((String)"Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readFloat to read a String that is not valid ");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                TestUtil.logTrace((String)"Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException e) {
                TestUtil.logTrace((String)"Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readDouble to read a String that is not valid ");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                TestUtil.logTrace((String)"Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException e) {
                TestUtil.logTrace((String)"Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageQTestsFullMsg(StreamMessage messageReceived) {
        String testCase = "streamMessageQTestsFullMsg";
        try {
            int i;
            byte bValue = 127;
            boolean abool = false;
            byte[] bValues2 = new byte[]{11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
            byte[] bValuesReturned = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            byte[] bValuesReturned2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            char charValue = 'Z';
            short sValue = Short.MAX_VALUE;
            long lValue = Long.MAX_VALUE;
            double dValue = 6.02E23;
            float fValue = 6.02E23f;
            int iValue = 6;
            boolean pass = true;
            String myString = "text";
            String sTesting = "Testing StreamMessages";
            try {
                int nCount = bValuesReturned2.length;
                do {
                    nCount = messageReceived.readBytes(bValuesReturned2);
                    TestUtil.logTrace((String)("nCount is " + nCount));
                    if (nCount == -1) continue;
                    for (i = 0; i < bValuesReturned2.length; ++i) {
                        if (bValuesReturned2[i] != bValues2[i]) {
                            TestUtil.logTrace((String)("Fail: byte[] " + i + " is not valid"));
                            pass = false;
                            continue;
                        }
                        TestUtil.logTrace((String)("PASS: byte[]" + i + " is valid"));
                    }
                } while (nCount >= bValuesReturned2.length);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readBoolean() == abool) {
                    TestUtil.logTrace((String)"Pass: boolean returned ok");
                } else {
                    TestUtil.logTrace((String)"Fail: boolean not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readByte() == bValue) {
                    TestUtil.logTrace((String)"Pass: Byte returned ok");
                } else {
                    TestUtil.logTrace((String)"Fail: Byte not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                int nCount = bValuesReturned.length;
                do {
                    nCount = messageReceived.readBytes(bValuesReturned);
                    TestUtil.logTrace((String)("nCount is " + nCount));
                    if (nCount == -1) continue;
                    for (i = 0; i < bValuesReturned2.length; ++i) {
                        if (bValuesReturned2[i] != bValues2[i]) {
                            TestUtil.logTrace((String)("Fail: byte[] " + i + " is not valid"));
                            pass = false;
                            continue;
                        }
                        TestUtil.logTrace((String)("PASS: byte[]" + i + " is valid"));
                    }
                } while (nCount >= bValuesReturned.length);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readChar() == charValue) {
                    TestUtil.logTrace((String)"Pass: correct char");
                } else {
                    TestUtil.logTrace((String)"Fail: char not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readDouble() == dValue) {
                    TestUtil.logTrace((String)"Pass: correct double");
                } else {
                    TestUtil.logTrace((String)"Fail: double not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readFloat() == fValue) {
                    TestUtil.logTrace((String)"Pass: correct float");
                } else {
                    TestUtil.logTrace((String)"Fail: float not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readInt() == iValue) {
                    TestUtil.logTrace((String)"Pass: correct int");
                } else {
                    TestUtil.logTrace((String)"Fail: int not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readLong() == lValue) {
                    TestUtil.logTrace((String)"Pass: correct long");
                } else {
                    TestUtil.logTrace((String)"Fail: long not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readObject().equals(sTesting)) {
                    TestUtil.logTrace((String)"Pass: correct object");
                } else {
                    TestUtil.logTrace((String)"Fail: object not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readShort() == sValue) {
                    TestUtil.logTrace((String)"Pass: correct short");
                } else {
                    TestUtil.logTrace((String)"Fail: short not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readString().equals(myString)) {
                    TestUtil.logTrace((String)"Pass: correct string");
                } else {
                    TestUtil.logTrace((String)"Fail: string not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readObject() == null) {
                    TestUtil.logTrace((String)"Pass: correct object");
                } else {
                    TestUtil.logTrace((String)"Fail: object not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageQTestNull(StreamMessage messageReceived) {
        String testCase = "streamMessageQTestNull";
        try {
            boolean pass = true;
            try {
                if (messageReceived.readObject() == null) {
                    TestUtil.logTrace((String)"Pass: Read a null");
                } else {
                    TestUtil.logTrace((String)"Fail: null value not returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)"Error trying to read a null object");
                TestUtil.logTrace((String)("Error: unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void sendTestResults(String testCase, boolean results) {
        TextMessage msg = null;
        try {
            this.mSender = this.qSession.createSender(this.queueR);
            msg = this.qSession.createTextMessage();
            msg.setStringProperty("TestCase", testCase);
            msg.setText(testCase);
            if (results) {
                msg.setStringProperty("Status", "Pass");
            } else {
                msg.setStringProperty("Status", "Fail");
            }
            TestUtil.logTrace((String)"Sending response message");
            this.mSender.send((Message)msg);
        }
        catch (JMSException je) {
            TestUtil.printStackTrace((Throwable)je);
            TestUtil.logTrace((String)("Error: " + ((Object)((Object)je)).getClass().getName() + " was thrown"));
        }
        catch (Exception ee) {
            TestUtil.printStackTrace((Throwable)ee);
            TestUtil.logTrace((String)("Error: " + ee.getClass().getName() + " was thrown"));
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        TestUtil.logTrace((String)"jms.ee.mdb.mdb_msgTypesQ2  In MsgBeanMsgTestQ2::setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"jms.ee.mdb.mdb_msgTypesQ2  In MsgBeanMsgTestQ2::remove()!!");
    }
}

