/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.lob;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.lob.DataTypes;
import java.util.Arrays;
import java.util.Properties;

public class Client
extends PMClientBase {
    private DataTypes dataTypes;
    private Byte[] smallByteArray = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
            this.logTrace("Done creating test data");
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lobTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        Object[] largeByteArray = null;
        try {
            this.getEntityTransaction().begin();
            this.logMsg("FIND DataTypes and verify initial value");
            this.dataTypes = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.dataTypes && Arrays.equals((Object[])this.smallByteArray, (Object[])this.dataTypes.getByteArrayData())) {
                this.logTrace("Expected results received");
                pass1 = true;
                this.logTrace("DataType Entity is not null, setting byteData ");
                largeByteArray = this.createLargeByteArray();
                this.dataTypes.setByteArrayData((Byte[])largeByteArray);
                this.getEntityManager().merge((Object)this.dataTypes);
                this.getEntityManager().flush();
                this.logMsg("FIND DataTypes again and verify updated value");
                this.dataTypes = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
                this.logTrace("Check results");
                if (null != this.dataTypes && Arrays.equals(largeByteArray, (Object[])this.dataTypes.getByteArrayData())) {
                    this.logTrace("Expected results received");
                    pass2 = true;
                } else {
                    this.logErr("Unexpected result in array comparison.");
                }
            } else {
                this.logErr("Unexpected result in array comparison.");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("lobTest failed");
        }
    }

    public void createTestData() {
        this.logTrace("createTestData");
        try {
            this.getEntityTransaction().begin();
            this.smallByteArray = this.createSmallByteArray();
            this.dataTypes = new DataTypes(1, this.smallByteArray);
            this.getEntityManager().persist((Object)this.dataTypes);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception in createTestData:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
    }

    private Byte[] createSmallByteArray() {
        StringBuffer strbuf = new StringBuffer();
        for (int i = 0; i < 1024; ++i) {
            strbuf.append(i);
        }
        String value = strbuf.toString();
        System.out.println("String Buffer :" + value);
        byte[] myByte = value.getBytes();
        Byte[] convertedByte = new Byte[myByte.length];
        for (int i = 0; i < myByte.length; ++i) {
            convertedByte[i] = myByte[i];
        }
        return convertedByte;
    }

    private Byte[] createLargeByteArray() {
        StringBuffer strbuf = new StringBuffer();
        for (int i = 0; i < 4096; ++i) {
            strbuf.append(i);
        }
        String value = strbuf.toString();
        System.out.println("String Buffer :" + value);
        byte[] myByte = value.getBytes();
        Byte[] convertedByte = new Byte[myByte.length];
        for (int i = 0; i < myByte.length; ++i) {
            convertedByte[i] = myByte[i];
        }
        return convertedByte;
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

