/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.dbMeta.dbMeta9;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class dbMetaClient9
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.dbMeta.dbMeta9";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private transient DatabaseMetaData dbmd = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private String dbName = null;
    private String dbUser = null;
    private String drManager = null;
    private String sCatalogName = null;
    private String sSchemaName = null;
    private String sPtable = null;
    private String sFtable = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        dbMetaClient9 theTests = new dbMetaClient9();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                this.dbName = p.getProperty("db1", "");
                this.dbUser = p.getProperty("user1", "");
                this.sPtable = p.getProperty("ptable", "TSTABLE1");
                this.sFtable = p.getProperty("ftable", "TSTABLE2");
                if (this.dbName.length() == 0) {
                    throw new Exception("Invalid db1  Database Name");
                }
                if (this.dbUser.length() == 0) {
                    throw new Exception("Invalid Login Id");
                }
                if (this.sPtable.length() == 0) {
                    throw new Exception("Invalid Primary table");
                }
                if (this.sFtable.length() == 0) {
                    throw new Exception("Invalid Foreign table");
                }
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                int nLocdbname = this.dbName.indexOf(61);
                this.sCatalogName = this.dbName.substring(nLocdbname + 1);
                this.sCatalogName = this.sCatalogName.trim();
                this.sSchemaName = this.dbUser;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbSch = new dbSchema();
                this.dbSch.createData(p, this.conn);
                this.dbmd = this.conn.getMetaData();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void testGetTypeInfo() throws Exception {
        try {
            ResultSetMetaData rsmd = null;
            String[] sColumnNames = new String[]{"TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX"};
            boolean statusColumnMatch = true;
            boolean statusColumnCount = true;
            Object sRetStr = new String();
            sRetStr = "";
            int iColumnNamesLength = sColumnNames.length;
            this.msg.setMsg("Calling DatabaseMetaData.getTypeInfo");
            this.msg.setMsg("invoke getTypeInfo method");
            ResultSet oRet_ResultSet = this.dbmd.getTypeInfo();
            rsmd = oRet_ResultSet.getMetaData();
            int iCount = rsmd.getColumnCount();
            this.msg.setMsg("Minimum Column Count is:" + iColumnNamesLength);
            this.msg.setMsg("Comparing Column Lengths");
            if (iColumnNamesLength > iCount) {
                statusColumnCount = false;
            } else if (iColumnNamesLength < iCount) {
                iCount = iColumnNamesLength;
                statusColumnCount = true;
            } else {
                statusColumnCount = true;
            }
            this.msg.setMsg("Comparing Column Names...");
            while (iColumnNamesLength > 0) {
                if (!sColumnNames[iColumnNamesLength - 1].equalsIgnoreCase(rsmd.getColumnName(iCount))) {
                    statusColumnMatch = false;
                    break;
                }
                statusColumnMatch = true;
                --iCount;
                --iColumnNamesLength;
            }
            if (!statusColumnMatch && statusColumnCount) {
                this.msg.printTestError("Columns return are not same either in order or name", "Call to getTypeInfo Failed!");
            }
            this.msg.setMsg("Store all the Type names returned");
            while (oRet_ResultSet.next()) {
                sRetStr = (String)sRetStr + oRet_ResultSet.getString(1) + ",";
            }
            if (sRetStr == "") {
                this.msg.setMsg("getTypeInfo did not return any type names");
            } else {
                this.msg.setMsg("The Type names returned are : " + (String)sRetStr);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTypeInfo is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTypeInfo is Failed!");
        }
    }

    public void testSupportsResultSetType1() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsResultSetType(TYPE_FORWARD_ONLY)");
            boolean retValue = this.dbmd.supportsResultSetType(1003);
            if (retValue) {
                this.msg.setMsg("TYPE_FORWARD_ONLY ResultSetType is supported");
            } else {
                this.msg.setMsg("TYPE_FORWARD_ONLY ResultSetType is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsResultSetType1 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsResultSetType1 is Failed!");
        }
    }

    public void testSupportsResultSetType2() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsResultSetType(TYPE_SCROLL_INSENSITIVE)");
            boolean retValue = this.dbmd.supportsResultSetType(1004);
            if (retValue) {
                this.msg.setMsg("TYPE_SCROLL_INSENSITIVE ResultSetType is supported");
            } else {
                this.msg.setMsg("TYPE_SCROLL_INSENSITIVE ResultSetType is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsResultSetType2 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsResultSetType2 is Failed!");
        }
    }

    public void testSupportsResultSetType3() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsResultSetType(TYPE_SCROLL_SENSITIVE)");
            boolean retValue = this.dbmd.supportsResultSetType(1005);
            if (retValue) {
                this.msg.setMsg("TYPE_SCROLL_SENSITIVE ResultSetType is supported");
            } else {
                this.msg.setMsg("TYPE_SCROLL_SENSITIVE ResultSetType is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsResultSetType3 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsResultSetType3 is Failed!");
        }
    }

    public void testSupportsResultSetConcurrency1() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsResultSetConcurrency(TYPE_FORWARD_ONLY, CONCUR_READ_ONLY)");
            boolean retValue = this.dbmd.supportsResultSetConcurrency(1003, 1007);
            if (retValue) {
                this.msg.setMsg("supportsResultSetConcurrency(TYPE_FORWARD_ONLY, CONCUR_READ_ONLY) is supported");
            } else {
                this.msg.setMsg("supportsResultSetConcurrency(TYPE_FORWARD_ONLY, CONCUR_READ_ONLY) is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsResultSetConcurrency1 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsResultSetConcurrency1 is Failed!");
        }
    }

    public void testSupportsResultSetConcurrency2() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsResultSetConcurrency(TYPE_FORWARD_ONLY, CONCUR_UPDATABLE)");
            boolean retValue = this.dbmd.supportsResultSetConcurrency(1003, 1008);
            if (retValue) {
                this.msg.setMsg("supportsResultSetConcurrency(TYPE_FORWARD_ONLY, CONCUR_UPDATABLE) is supported");
            } else {
                this.msg.setMsg("supportsResultSetConcurrency(TYPE_FORWARD_ONLY, CONCUR_UPDATABLE) is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsResultSetConcurrency2 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsResultSetConcurrency2 is Failed!");
        }
    }

    public void testSupportsResultSetConcurrency3() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsResultSetConcurrency(TYPE_SCROLL_INSENSITIVE, CONCUR_READ_ONLY)");
            boolean retValue = this.dbmd.supportsResultSetConcurrency(1004, 1007);
            if (retValue) {
                this.msg.setMsg("supportsResultSetConcurrency(TYPE_SCROLL_INSENSITIVE, CONCUR_READ_ONLY) is supported");
            } else {
                this.msg.setMsg("supportsResultSetConcurrency(TYPE_SCROLL_INSENSITIVE, CONCUR_READ_ONLY) is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsResultSetConcurrency3 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsResultSetConcurrency3 is Failed!");
        }
    }

    public void testSupportsResultSetConcurrency4() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsResultSetConcurrency(TYPE_SCROLL_INSENSITIVE, CONCUR_UPDATABLE)");
            boolean retValue = this.dbmd.supportsResultSetConcurrency(1004, 1008);
            if (retValue) {
                this.msg.setMsg("supportsResultSetConcurrency(TYPE_SCROLL_INSENSITIVE, CONCUR_UPDATABLE) is supported");
            } else {
                this.msg.setMsg("supportsResultSetConcurrency(TYPE_SCROLL_INSENSITIVE, CONCUR_UPDATABLE) is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsResultSetConcurrency4 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsResultSetConcurrency4 is Failed!");
        }
    }

    public void testSupportsResultSetConcurrency5() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsResultSetConcurrency(TYPE_SCROLL_SENSITIVE, CONCUR_READ_ONLY)");
            boolean retValue = this.dbmd.supportsResultSetConcurrency(1005, 1007);
            if (retValue) {
                this.msg.setMsg("supportsResultSetConcurrency(TYPE_SCROLL_SENSITIVE, CONCUR_READ_ONLY) is supported");
            } else {
                this.msg.setMsg("supportsResultSetConcurrency(TYPE_SCROLL_SENSITIVE, CONCUR_READ_ONLY) is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsResultSetConcurrency5 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsResultSetConcurrency5 is Failed!");
        }
    }

    public void testSupportsResultSetConcurrency6() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsResultSetConcurrency(TYPE_SCROLL_SENSITIVE, CONCUR_UPDATABLE)");
            boolean retValue = this.dbmd.supportsResultSetConcurrency(1005, 1008);
            if (retValue) {
                this.msg.setMsg("supportsResultSetConcurrency(TYPE_SCROLL_SENSITIVE, CONCUR_UPDATABLE) is supported");
            } else {
                this.msg.setMsg("supportsResultSetConcurrency(TYPE_SCROLL_SENSITIVE, CONCUR_UPDATABLE) is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsResultSetConcurrency6 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsResultSetConcurrency6 is Failed!");
        }
    }

    public void testOwnUpdatesAreVisible1() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.ownUpdatesAreVisible(TYPE_FORWARD_ONLY)");
            boolean retValue = this.dbmd.ownUpdatesAreVisible(1003);
            if (retValue) {
                this.msg.setMsg("Result Set's own updates are visible for TYPE_FORWARD_ONLY");
            } else {
                this.msg.setMsg("Result Set's own updates are not visible for TYPE_FORWARD_ONLY");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to ownUpdatesAreVisible1 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to ownUpdatesAreVisible1 is Failed!");
        }
    }

    public void testOwnUpdatesAreVisible2() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.ownUpdatesAreVisible(TYPE_SCROLL_INSENSITIVE)");
            boolean retValue = this.dbmd.ownUpdatesAreVisible(1004);
            if (retValue) {
                this.msg.setMsg("Result Set's own updates are visible for TYPE_SCROLL_INSENSITIVE");
            } else {
                this.msg.setMsg("Result Set's own updates are not visible for TYPE_SCROLL_INSENSITIVE");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to ownUpdatesAreVisible2 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to ownUpdatesAreVisible2 is Failed!");
        }
    }

    public void testOwnUpdatesAreVisible3() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.ownUpdatesAreVisible(TYPE_SCROLL_SENSITIVE)");
            boolean retValue = this.dbmd.ownUpdatesAreVisible(1005);
            if (retValue) {
                this.msg.setMsg("Result Set's own updates are visible for TYPE_SCROLL_SENSITIVE");
            } else {
                this.msg.setMsg("Result Set's own updates are not visible for TYPE_SCROLL_SENSITIVE");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to ownUpdatesAreVisible3 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to ownUpdatesAreVisible3 is Failed!");
        }
    }

    public void testOwnDeletesAreVisible1() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.ownDeletesAreVisible(TYPE_FORWARD_ONLY)");
            boolean retValue = this.dbmd.ownDeletesAreVisible(1003);
            if (retValue) {
                this.msg.setMsg("Result Set's own deletes are visible for TYPE_FORWARD_ONLY");
            } else {
                this.msg.setMsg("Result Set's own deletes are not visible for TYPE_FORWARD_ONLY");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to ownDeletesAreVisible1 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to ownDeletesAreVisible1 is Failed!");
        }
    }

    public void testOwnDeletesAreVisible2() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.ownDeletesAreVisible(TYPE_SCROLL_INSENSITIVE)");
            boolean retValue = this.dbmd.ownDeletesAreVisible(1004);
            if (retValue) {
                this.msg.setMsg("Result Set's own deletes are visible for TYPE_SCROLL_INSENSITIVE");
            } else {
                this.msg.setMsg("Result Set's own deletes are not visible for TYPE_SCROLL_INSENSITIVE");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to ownDeletesAreVisible2 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to ownDeletesAreVisible2 is Failed!");
        }
    }

    public void testOwnDeletesAreVisible3() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.ownDeletesAreVisible(TYPE_SCROLL_SENSITIVE)");
            boolean retValue = this.dbmd.ownDeletesAreVisible(1005);
            if (retValue) {
                this.msg.setMsg("Result Set's own deletes are visible for TYPE_SCROLL_SENSITIVE");
            } else {
                this.msg.setMsg("Result Set's own deletes are not visible for TYPE_SCROLL_SENSITIVE");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to ownDeletesAreVisible3 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to ownDeletesAreVisible3 is Failed!");
        }
    }

    public void testOwnInsertsAreVisible1() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.ownInsertsAreVisible(TYPE_FORWARD_ONLY)");
            boolean retValue = this.dbmd.ownInsertsAreVisible(1003);
            if (retValue) {
                this.msg.setMsg("Result Set's own inserts are visible for TYPE_FORWARD_ONLY");
            } else {
                this.msg.setMsg("Result Set's own inserts are not visible for TYPE_FORWARD_ONLY");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to ownInsertsAreVisible1 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to ownInsertsAreVisible1 is Failed!");
        }
    }

    public void testOwnInsertsAreVisible2() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.ownInsertsAreVisible(TYPE_SCROLL_INSENSITIVE)");
            boolean retValue = this.dbmd.ownInsertsAreVisible(1004);
            if (retValue) {
                this.msg.setMsg("Result Set's own inserts are visible for TYPE_SCROLL_INSENSITIVE");
            } else {
                this.msg.setMsg("Result Set's own inserts are not visible for TYPE_SCROLL_INSENSITIVE");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to ownInsertsAreVisible2 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to ownInsertsAreVisible2 is Failed!");
        }
    }

    public void testOwnInsertsAreVisible3() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.ownInsertsAreVisible(TYPE_SCROLL_SENSITIVE)");
            boolean retValue = this.dbmd.ownInsertsAreVisible(1005);
            if (retValue) {
                this.msg.setMsg("Result Set's own inserts are visible for TYPE_SCROLL_SENSITIVE");
            } else {
                this.msg.setMsg("Result Set's own inserts are not visible for TYPE_SCROLL_SENSITIVE");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to ownInsertsAreVisible3 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to ownInsertsAreVisible3 is Failed!");
        }
    }

    public void testOthersUpdatesAreVisible1() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.othersUpdatesAreVisible(TYPE_FORWARD_ONLY)");
            boolean retValue = this.dbmd.othersUpdatesAreVisible(1003);
            if (retValue) {
                this.msg.setMsg("Updates made by others are visible for TYPE_FORWARD_ONLY");
            } else {
                this.msg.setMsg("Updates made by others are not visible for TYPE_FORWARD_ONLY");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to othersUpdatesAreVisible1 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to othersUpdatesAreVisible1 is Failed!");
        }
    }

    public void cleanup() throws Exception {
        try {
            this.dbSch.destroyData(this.conn);
            this.dbSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

