/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_sndToQueue;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.commonee.MDB_Q_Test;
import jakarta.ejb.EJB;
import java.util.Properties;

public class MDBClient
extends EETest {
    @EJB(name="ejb/MDB_SNDToQueue_Test")
    private static MDB_Q_Test hr;
    private Properties props = null;

    public static void main(String[] args) {
        MDBClient theTests = new MDBClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.props = p;
        try {
            if (hr == null) {
                throw new Exception("@EJB injection failed");
            }
            hr.setup(p);
            if (hr.isThereSomethingInTheQueue()) {
                TestUtil.logTrace((String)"Error: message(s) left in Q");
                hr.cleanTheQueue();
            } else {
                TestUtil.logTrace((String)"Nothing left in queue");
            }
            this.logMsg("Setup ok;");
        }
        catch (Exception e) {
            throw new Exception("Setup Failed!", e);
        }
    }

    public void mdbSendTextMsgToQueueTest() throws Exception {
        String messageType = "TextMessage";
        String matchMe = "TextMessageFromMsgBean";
        try {
            TestUtil.logTrace((String)"Call bean - have it tell mdb to send a text message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                TestUtil.logTrace((String)"Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mdbSendTextMsgToQueueTest failed");
            }
            TestUtil.logTrace((String)"Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    public void mdbSendBytesMsgToQueueTest() throws Exception {
        String messageType = "BytesMessage";
        String matchMe = "BytesMessageFromMsgBean";
        try {
            TestUtil.logTrace((String)"Call bean - have it tell mdb to send a Bytes message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                TestUtil.logTrace((String)"Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mdbSendBytesMsgToQueueTest failed");
            }
            TestUtil.logTrace((String)"Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    public void mdbSendMapMsgToQueueTest() throws Exception {
        String matchMe = "MapMessageFromMsgBean";
        String messageType = "MapMessage";
        try {
            TestUtil.logTrace((String)"Call bean - have it tell mdb to send a map message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                TestUtil.logTrace((String)"Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mdbSendMapMsgToQueueTest failed");
            }
            TestUtil.logTrace((String)"Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    public void mdbSendStreamMsgToQueueTest() throws Exception {
        String matchMe = "StreamMessageFromMsgBean";
        String messageType = "StreamMessage";
        try {
            TestUtil.logTrace((String)"Call bean - have it tell mdb to send a stream message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                TestUtil.logTrace((String)"Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mdbSendStreamMsgToQueueTest failed");
            }
            TestUtil.logTrace((String)"Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    public void mdbSendObjectMsgToQueueTest() throws Exception {
        String matchMe = "ObjectMessageFromMsgBean";
        String messageType = "ObjectMessage";
        try {
            TestUtil.logTrace((String)"Call bean - have it tell mdb to send an object message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                TestUtil.logTrace((String)"Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mdbSendObjectMsgToQueueTest failed");
            }
            TestUtil.logTrace((String)"Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            if (hr.isThereSomethingInTheQueue()) {
                TestUtil.logTrace((String)"Error: message(s) left in Q");
                hr.cleanTheQueue();
            } else {
                TestUtil.logTrace((String)"Nothing left in queue");
            }
            this.logMsg("End  of client cleanup;");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }
}

