/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.embeddableMapValue;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.embeddableMapValue.Address;
import ee.jakarta.tck.persistence.core.annotations.embeddableMapValue.Employee;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Client
extends PMClientBase {
    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void embeddableMapValue() throws Exception {
        this.logTrace("Begin embeddableMapValue");
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        EntityManager em = this.getEntityManager();
        EntityTransaction et = this.getEntityTransaction();
        try {
            this.logTrace("New instances");
            Address addr1 = new Address("1", "1 Network Drive", "Burlington", "MA", "01801");
            Address addr2 = new Address("2", "Some Address", "Boston", "MA", "01803");
            Employee emp1 = new Employee(1, "Barack", "Obama");
            HashMap<String, Address> locationAddressMap = new HashMap<String, Address>();
            locationAddressMap.put("home", addr2);
            locationAddressMap.put("office", addr1);
            emp1.setLocationAddress(locationAddressMap);
            this.logTrace("Created new Employee");
            et.begin();
            em.persist((Object)emp1);
            this.logTrace("persisted new Employee");
            em.flush();
            this.clearCache();
            this.logTrace("query for Employee");
            Employee newEmployee = (Employee)em.find(Employee.class, (Object)1);
            int newEmployeeId = newEmployee.getId();
            String newEmployeeFirstName = newEmployee.getFirstName();
            String newEmployeeLastName = newEmployee.getLastName();
            this.logTrace("Employee Id = " + newEmployeeId);
            this.logTrace("Employee First Name = " + newEmployeeFirstName);
            this.logTrace("Employee Last Name = " + newEmployeeLastName);
            if (newEmployeeId == 1) {
                pass1 = true;
                this.logTrace("Employee Id match");
            }
            if (newEmployeeFirstName.equals("Barack")) {
                this.logTrace("Employee First Name match");
                pass2 = true;
            }
            if (newEmployeeLastName.equals("Obama")) {
                this.logTrace("Employee Last Name match");
                pass3 = true;
            }
            Map<String, Address> newLocationAddressMap = newEmployee.getLocationAddress();
            Address homeAddress = newLocationAddressMap.get("home");
            Address officeAddress = newLocationAddressMap.get("office");
            if (officeAddress.getStreet().equals("1 Network Drive") && officeAddress.getCity().equals("Burlington") && officeAddress.getState().equals("MA") && officeAddress.getZip().equals("01801")) {
                pass4 = true;
                this.logTrace("Employee officeAddress match");
            }
            if (homeAddress.getStreet().equals("Some Address") && homeAddress.getCity().equals("Boston") && homeAddress.getState().equals("MA") && homeAddress.getZip().equals("01803")) {
                pass5 = true;
                this.logTrace("Employee HomeAddress match");
            }
            et.commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception :", e);
        }
        finally {
            try {
                if (et.isActive()) {
                    et.rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5)) {
            this.logErr("embeddableMapValue failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from COLTAB_EMP_EMBEDED_ADDRESS").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from EMPLOYEE_EMBEDED_ADDRESS").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

