/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.dateTime.dateTime1;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.TimeZone;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class dateTimeClient1
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.dateTime.dateTime1";
    private TSNamingContextInterface jc = null;
    private String sqlStmt = null;
    private Properties sqlp = null;
    private int valToGeneralize = 0;
    private Calendar cal = null;
    private Timestamp inTimeVal = null;
    private Timestamp inTimeVal1 = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        dateTimeClient1 theTests = new dateTimeClient1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            TimeZone tz = null;
            tz = TimeZone.getDefault();
            boolean b1 = tz.useDaylightTime();
            if (!b1) {
                this.cal = Calendar.getInstance(tz);
                this.valToGeneralize = tz.getOffset(this.cal.get(0), this.cal.get(1), this.cal.get(2), this.cal.get(5), this.cal.get(7), this.cal.get(14));
            } else {
                this.valToGeneralize = tz.getRawOffset();
            }
            this.sqlp = p;
            this.msg = new JDBCTestMsg();
        }
        catch (Exception e) {
            this.logErr("Setup Failed!", e);
        }
    }

    public void testTimestamp01() throws Exception {
        String sTimestampVal = null;
        String sLongTstampVal = null;
        String sInTimeVal = null;
        try {
            sTimestampVal = this.sqlp.getProperty("DateTime_Str_Val1", "");
            this.msg.setMsg("Timestamp String Value :  " + sTimestampVal);
            sLongTstampVal = this.sqlp.getProperty("DateTime_Long_Val1", "");
            long tstampVal = Long.parseLong(sLongTstampVal);
            this.inTimeVal = new Timestamp(tstampVal -= (long)this.valToGeneralize);
            this.msg.setMsg("Timestamp Value  " + this.inTimeVal);
            sInTimeVal = this.inTimeVal.toString().trim();
            this.msg.setMsg("the string after timestamp creation is " + sInTimeVal);
            boolean booRetVal = sTimestampVal.equals(sInTimeVal);
            if (booRetVal) {
                this.msg.setMsg("Timestamp Constructor constructs Timestamp object");
            } else {
                this.msg.printTestError("Timestamp Constructor does not construct the expected Timestamp object", "Call to Timestamp Constructor is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to Timestamp Constructor is Failed!");
        }
    }

    public void testTimestamp02() throws Exception {
        String sTimestampVal = null;
        String sInTimeVal = null;
        String sLongTstampVal = null;
        try {
            sTimestampVal = this.sqlp.getProperty("DateTime_Str_Val2", "");
            this.msg.setMsg("Timestamp String Value :  " + sTimestampVal);
            sLongTstampVal = this.sqlp.getProperty("DateTime_Long_Val2", "");
            long tstampVal = Long.parseLong(sLongTstampVal);
            this.inTimeVal = new Timestamp(tstampVal -= (long)this.valToGeneralize);
            sInTimeVal = this.inTimeVal.toString().trim();
            this.msg.setMsg("the string after timestamp creation is" + sInTimeVal);
            boolean booRetVal = sTimestampVal.equals(sInTimeVal);
            if (booRetVal) {
                this.msg.setMsg("Timestamp Constructor constructs the Timestamp object");
            } else {
                this.msg.printTestError("Timestamp Constructor does not construct the expected Timestamp object", "Call to Timestamp Constructor is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to Timestamp Constructor is Failed!");
        }
    }

    public void testSetNanos01() throws Exception {
        String sLongTstampVal = null;
        int nanoVal = 0;
        try {
            sLongTstampVal = this.sqlp.getProperty("DateTime_Long_Val1", "");
            long tstampVal = Long.parseLong(sLongTstampVal);
            this.inTimeVal = new Timestamp(tstampVal - (long)this.valToGeneralize);
            this.inTimeVal.setNanos(0);
            nanoVal = this.inTimeVal.getNanos();
            if (nanoVal == 0) {
                this.msg.setMsg("setNanos method sets the Nano seconds to Timestamp object");
            } else {
                this.msg.printTestError("setNanos method does not set the Nano seconds to Timestamp object", "Call to setNanos is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setNanos is Failed!");
        }
    }

    public void testSetNanos02() throws Exception {
        String sLongTstampVal = null;
        int nanoVal = 0;
        try {
            sLongTstampVal = this.sqlp.getProperty("DateTime_Long_Val1", "");
            long tstampVal = Long.parseLong(sLongTstampVal);
            this.inTimeVal = new Timestamp(tstampVal -= (long)this.valToGeneralize);
            this.inTimeVal.setNanos(999999999);
            nanoVal = this.inTimeVal.getNanos();
            if (nanoVal == 999999999) {
                this.msg.setMsg("setNanos method sets the Nano seconds for Timestamp object");
            } else {
                this.msg.printTestError("setNanos method does not set the Nano seconds for Timestamp object", "Call to setNanos is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setNanos is Failed!");
        }
    }

    public void testSetNanos03() throws Exception {
        boolean illArgExceptFlag = false;
        String sLongTstampVal = null;
        try {
            sLongTstampVal = this.sqlp.getProperty("DateTime_Long_Val1", "");
            long tstampVal = Long.parseLong(sLongTstampVal);
            this.inTimeVal = new Timestamp(tstampVal - (long)this.valToGeneralize);
            try {
                this.inTimeVal.setNanos(-1);
            }
            catch (IllegalArgumentException e) {
                TestUtil.printStackTrace((Throwable)e);
                illArgExceptFlag = true;
            }
            if (illArgExceptFlag) {
                this.msg.setMsg("setNanos Method does not set the out of range value");
            } else {
                this.msg.printTestError("setNanos Method sets the value which is exceeding limit", "Call to setNanos is Failed");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setNanos is Failed");
        }
    }

    public void testSetNanos04() throws Exception {
        boolean illArgExceptFlag = false;
        String sLongTstampVal = null;
        try {
            sLongTstampVal = this.sqlp.getProperty("DateTime_Long_Val1", "");
            long tstampVal = Long.parseLong(sLongTstampVal);
            this.inTimeVal = new Timestamp(tstampVal - (long)this.valToGeneralize);
            try {
                this.inTimeVal.setNanos(1000000000);
            }
            catch (IllegalArgumentException e) {
                TestUtil.printStackTrace((Throwable)e);
                illArgExceptFlag = true;
            }
            if (illArgExceptFlag) {
                this.msg.setMsg("setNanos Method does not set the exceeding limit");
            } else {
                this.msg.printTestError("setNanos Method sets the value which is exceeding limit", "Call to setNanos is Failed");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setNanos is Failed");
        }
    }

    public void testGetNanos() throws Exception {
        String sLongTstampVal = null;
        int nanoVal = 0;
        try {
            sLongTstampVal = this.sqlp.getProperty("DateTime_Long_Val1", "");
            long tstampVal = Long.parseLong(sLongTstampVal);
            this.inTimeVal = new Timestamp(tstampVal - (long)this.valToGeneralize);
            nanoVal = this.inTimeVal.getNanos();
            if (nanoVal >= 0 || nanoVal <= 999999999) {
                this.msg.setMsg("getNanos method returns the Nano seconds of Timestamp object" + nanoVal);
            } else {
                this.msg.printTestError("getNanos() does not return the Nano seconds of Timestamp object", "Call to getNanos is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getNanos is Failed!");
        }
    }

    public void testToString01() throws Exception {
        String sTimestampVal = null;
        String sLongTstampVal = null;
        String sInTimeVal = null;
        try {
            sTimestampVal = this.sqlp.getProperty("DateTime_Str_Val1", "");
            this.msg.setMsg("Timestamp String Value :  " + sTimestampVal);
            sLongTstampVal = this.sqlp.getProperty("DateTime_Long_Val1", "");
            long tstampVal = Long.parseLong(sLongTstampVal);
            this.inTimeVal = new Timestamp(tstampVal -= (long)this.valToGeneralize);
            sInTimeVal = this.inTimeVal.toString();
            this.msg.setMsg("sInTimeVal = " + sInTimeVal);
            if (sInTimeVal.equals(sTimestampVal)) {
                this.msg.setMsg("toString method returns a String object");
            } else {
                this.msg.printTestError("toString method does not return the String object", "Call to toString is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to toString is Failed!");
        }
    }

    public void testToString02() throws Exception {
        String sLongTstampVal = null;
        String sTimestampVal = null;
        String retTstampVal = null;
        try {
            sTimestampVal = this.sqlp.getProperty("DateTime_Str_Val2", "");
            this.msg.setMsg("Timestamp String Value :  " + sTimestampVal);
            sLongTstampVal = this.sqlp.getProperty("DateTime_Long_Val2", "");
            long tstampVal = Long.parseLong(sLongTstampVal);
            this.inTimeVal = new Timestamp(tstampVal -= (long)this.valToGeneralize);
            retTstampVal = this.inTimeVal.toString().trim();
            if (retTstampVal.equals(sTimestampVal)) {
                this.msg.setMsg("toString method returns a String object");
            } else {
                this.msg.printTestError("toString method does not return a String object", "Call to toString is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to toString is Failed!");
        }
    }

    public void testAfter01() throws Exception {
        String sLongTstampVal = null;
        String sRefVal = null;
        Timestamp inTimeVal2 = null;
        try {
            sLongTstampVal = this.sqlp.getProperty("DateTime_Long_Val1", "");
            long tstampVal1 = Long.parseLong(sLongTstampVal);
            sRefVal = this.sqlp.getProperty("Ref_Milli_Val", "");
            long tstampVal2 = Long.parseLong(sRefVal);
            tstampVal2 = (tstampVal1 -= (long)this.valToGeneralize) - (long)this.valToGeneralize - tstampVal2;
            this.inTimeVal1 = new Timestamp(tstampVal1);
            this.msg.setMsg("Timestamp Value # 1 : " + this.inTimeVal1);
            inTimeVal2 = new Timestamp(tstampVal2);
            this.msg.setMsg("Timestamp Value # 2 : " + inTimeVal2);
            boolean booRetVal = this.inTimeVal1.after(inTimeVal2);
            if (booRetVal) {
                this.msg.setMsg("after method returns  " + booRetVal);
            } else {
                this.msg.printTestError("after method does not return expected Value ", "Call to after is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to after is Failed!");
        }
    }

    public void testAfter02() throws Exception {
        String sLongTstampVal = null;
        String sRefVal = null;
        Timestamp inTimeVal2 = null;
        try {
            sLongTstampVal = this.sqlp.getProperty("DateTime_Long_Val1", "");
            long tstampVal1 = Long.parseLong(sLongTstampVal);
            sRefVal = this.sqlp.getProperty("Ref_Milli_Val", "");
            long tstampVal2 = Long.parseLong(sRefVal);
            tstampVal2 = (tstampVal1 -= (long)this.valToGeneralize) - (long)this.valToGeneralize + tstampVal2;
            this.inTimeVal1 = new Timestamp(tstampVal1);
            this.msg.setMsg("Timestamp Value # 1 : " + this.inTimeVal1);
            inTimeVal2 = new Timestamp(tstampVal2);
            this.msg.setMsg("Timestamp Value # 2 : " + inTimeVal2);
            boolean booRetVal = this.inTimeVal1.after(inTimeVal2);
            if (!booRetVal) {
                this.msg.setMsg("after method returns : " + booRetVal);
            } else {
                this.msg.printTestError("after method does not return the expected Value ", "Call to after is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to after is Failed!");
        }
    }

    public void testAfter03() throws Exception {
        Timestamp inTimeVal2 = null;
        String sLongTstampVal = null;
        String sNanosVal = null;
        try {
            sLongTstampVal = this.sqlp.getProperty("DateTime_Long_Val1", "");
            long tstampVal1 = Long.parseLong(sLongTstampVal);
            sNanosVal = this.sqlp.getProperty("Ref_Nano_Val", "");
            int nanosSet = Integer.parseInt(sNanosVal);
            this.inTimeVal1 = new Timestamp(tstampVal1 -= (long)this.valToGeneralize);
            this.inTimeVal1.setNanos(nanosSet);
            this.msg.setMsg("Timestamp Value # 1  :  " + this.inTimeVal1);
            inTimeVal2 = new Timestamp(tstampVal1);
            this.msg.setMsg("Timestamp Value # 2  :  " + inTimeVal2);
            boolean booRetVal = this.inTimeVal1.after(inTimeVal2);
            if (booRetVal) {
                this.msg.setMsg("after method returns" + booRetVal);
            } else {
                this.msg.printTestError("after method does not return the expected Value ", "Call to after is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to after is Failed!");
        }
    }

    public void testAfter04() throws Exception {
        String sLongTstampVal = null;
        try {
            sLongTstampVal = this.sqlp.getProperty("DateTime_Long_Val1", "");
            long tstampVal = Long.parseLong(sLongTstampVal);
            this.inTimeVal = new Timestamp(tstampVal -= (long)this.valToGeneralize);
            this.msg.setMsg("TimeStamp Value # 1 :  " + this.inTimeVal);
            this.inTimeVal1 = new Timestamp(tstampVal);
            String sNanosVal = this.sqlp.getProperty("Ref_Nano_Val", "");
            int nanoVal = Integer.parseInt(sNanosVal);
            this.inTimeVal1.setNanos(nanoVal);
            this.msg.setMsg("TimeStamp Value # 2 :  " + this.inTimeVal1);
            boolean booRetVal = this.inTimeVal.after(this.inTimeVal1);
            if (!booRetVal) {
                this.msg.setMsg("after method returns " + booRetVal);
            } else {
                this.msg.printTestError("after method does not return the expected value", "Call to after is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to after is Failed!");
        }
    }

    public void testBefore01() throws Exception {
        String sTimestampVal = null;
        String sLongTstampVal = null;
        String sRefVal = null;
        try {
            sTimestampVal = this.sqlp.getProperty("DateTime_Long_Val1", "");
            this.msg.setMsg("Timestamp String Value :  " + sTimestampVal);
            sLongTstampVal = this.sqlp.getProperty("DateTime_Long_Val1", "");
            long tstampVal1 = Long.parseLong(sLongTstampVal);
            sRefVal = this.sqlp.getProperty("Ref_Milli_Val", "");
            long tstampVal2 = Long.parseLong(sRefVal);
            tstampVal2 = (tstampVal1 -= (long)this.valToGeneralize) - (long)this.valToGeneralize + tstampVal2;
            this.inTimeVal = new Timestamp(tstampVal1);
            this.msg.setMsg("Timestamp Value1 : " + this.inTimeVal);
            this.inTimeVal1 = new Timestamp(tstampVal2);
            this.msg.setMsg("Timestamp Value2 : " + this.inTimeVal1);
            boolean booRetVal = this.inTimeVal.before(this.inTimeVal1);
            if (booRetVal) {
                this.msg.setMsg("before method returns : " + booRetVal);
            } else {
                this.msg.printTestError("before method does not return the expected value ", "Call to before is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to before is Failed!");
        }
    }

    public void testBefore02() throws Exception {
        String sTimestampVal = null;
        String sLongTstampVal = null;
        String sRefVal = null;
        try {
            sTimestampVal = this.sqlp.getProperty("DateTime_Long_Val1", "");
            this.msg.setMsg("Timestamp String Value :  " + sTimestampVal);
            sLongTstampVal = this.sqlp.getProperty("DateTime_Long_Val1", "");
            long tstampVal1 = Long.parseLong(sLongTstampVal);
            sRefVal = this.sqlp.getProperty("Ref_Milli_Val", "");
            long tstampVal2 = Long.parseLong(sRefVal);
            tstampVal2 = (tstampVal1 -= (long)this.valToGeneralize) - (long)this.valToGeneralize - tstampVal2;
            this.inTimeVal = new Timestamp(tstampVal1);
            this.msg.setMsg("Timestamp Value1 :  " + this.inTimeVal);
            this.inTimeVal1 = new Timestamp(tstampVal2);
            this.msg.setMsg("Timestamp Value2 :  " + this.inTimeVal1);
            boolean booRetVal = this.inTimeVal.before(this.inTimeVal1);
            if (!booRetVal) {
                this.msg.setMsg("before method returns : " + booRetVal);
            } else {
                this.msg.printTestError("before method does not return the expected Value ", "Call to before is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to before is Failed!");
        }
    }

    public void testBefore03() throws Exception {
        String sLongTstampVal = null;
        Timestamp inTimeVal1 = null;
        try {
            sLongTstampVal = this.sqlp.getProperty("DateTime_Long_Val1", "");
            long tstampVal = Long.parseLong(sLongTstampVal);
            this.inTimeVal = new Timestamp(tstampVal -= (long)this.valToGeneralize);
            this.msg.setMsg("Timestamp Value # 1 : " + this.inTimeVal);
            inTimeVal1 = new Timestamp(tstampVal);
            String sNanosVal = this.sqlp.getProperty("Ref_Nano_Val", "");
            int nanosSet = Integer.parseInt(sNanosVal);
            inTimeVal1.setNanos(nanosSet);
            this.msg.setMsg("Timestamp Value # 2 : " + inTimeVal1);
            boolean booRetVal = this.inTimeVal.before(inTimeVal1);
            if (booRetVal) {
                this.msg.setMsg("before method returns " + booRetVal);
            } else {
                this.msg.printTestError("before method does not return the expected value ", "Call to before is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to before is Failed!");
        }
    }

    public void testBefore04() throws Exception {
        String sLongTstampVal = null;
        String sNanosVal = null;
        try {
            sLongTstampVal = this.sqlp.getProperty("DateTime_Long_Val1", "");
            long tstampVal = Long.parseLong(sLongTstampVal);
            this.inTimeVal = new Timestamp(tstampVal -= (long)this.valToGeneralize);
            this.msg.setMsg("Timestamp Value 1" + this.inTimeVal);
            this.inTimeVal1 = new Timestamp(tstampVal);
            sNanosVal = this.sqlp.getProperty("Ref_Nano_Val", "");
            int nanosSet = Integer.parseInt(sNanosVal);
            this.inTimeVal1.setNanos(nanosSet);
            this.msg.setMsg("Timestamp Value 2" + this.inTimeVal1);
            boolean booRetVal = this.inTimeVal.before(this.inTimeVal1);
            if (booRetVal) {
                this.msg.setMsg("before method returns " + booRetVal);
            } else {
                this.msg.printTestError("before method does not return the expected Value", "Call to before is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to before is Failed!");
        }
    }

    public void testEqualsTimestamp01() throws Exception {
        String sLongTstampVal = null;
        try {
            sLongTstampVal = this.sqlp.getProperty("DateTime_Long_Val1", "");
            long tstampVal1 = Long.parseLong(sLongTstampVal);
            String sRefMilliVal = this.sqlp.getProperty("Ref_Milli_Val", "");
            long tstampVal2 = Long.parseLong(sRefMilliVal);
            String sRefNanoVal = this.sqlp.getProperty("Ref_Nano_Val2", "");
            int setNanosVal = Integer.parseInt(sRefNanoVal);
            this.inTimeVal = new Timestamp(tstampVal1 -= (long)this.valToGeneralize);
            this.msg.setMsg("Timestamp Value1 : " + this.inTimeVal);
            this.inTimeVal1 = new Timestamp(tstampVal2 -= (long)this.valToGeneralize);
            this.inTimeVal1.setNanos(setNanosVal);
            this.msg.setMsg("Timestamp Value2 : " + this.inTimeVal1);
            boolean booRetVal = this.inTimeVal.equals(this.inTimeVal1);
            if (booRetVal) {
                this.msg.setMsg("The method equals() returns the expected value");
            } else {
                this.msg.printTestError("The method equals() doesnt work as expected", "call to equals() failed");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "call to equals() failed");
        }
    }

    public void testEqualsObject01() throws Exception {
        String sLongTstampVal = null;
        try {
            sLongTstampVal = this.sqlp.getProperty("DateTime_Long_Val1", "");
            long tstampVal1 = Long.parseLong(sLongTstampVal);
            this.inTimeVal = new Timestamp(tstampVal1 -= (long)this.valToGeneralize);
            this.msg.setMsg("Timestamp Value1:  " + this.inTimeVal);
            Timestamp tsObj = new Timestamp(tstampVal1);
            this.msg.setMsg("Timestamp Object Value1:  " + tsObj);
            boolean booRetVal = this.inTimeVal.equals((Object)tsObj);
            if (booRetVal) {
                this.msg.setMsg("The method equals() returns the expected value");
            } else {
                this.msg.printTestError("The method equals() doesnt work as expected", "call to equals() failed");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to equals is Failed!");
        }
    }

    public void testEqualsObject02() throws Exception {
        String sTimestampVal = null;
        String sLongTstampVal = null;
        try {
            sTimestampVal = this.sqlp.getProperty("DateTime_Long_Val1", "");
            this.msg.setMsg("Timestamp String Value :  " + sTimestampVal);
            sLongTstampVal = this.sqlp.getProperty("DateTime_Long_Val1", "");
            long tstampVal1 = Long.parseLong(sLongTstampVal);
            tstampVal1 -= (long)this.valToGeneralize;
            String sRefMilliVal = this.sqlp.getProperty("Ref_Milli_Val", "");
            long tstampVal2 = Long.parseLong(sRefMilliVal);
            String sRefNanoVal = this.sqlp.getProperty("Ref_Nano_Val2", "");
            int setNanosVal = Integer.parseInt(sRefNanoVal);
            this.inTimeVal = new Timestamp(tstampVal2 -= (long)this.valToGeneralize);
            this.inTimeVal.setNanos(setNanosVal);
            this.msg.setMsg("TimeStamp Value    " + this.inTimeVal);
            Timestamp tsObj = new Timestamp(tstampVal1);
            this.msg.setMsg("Object Value " + tsObj);
            boolean booRetVal = this.inTimeVal.equals((Object)tsObj);
            if (booRetVal) {
                this.msg.setMsg("The method equals() returns the expected value");
            } else {
                this.msg.printTestError("The method equals() doesnt work as expected", "Call to equals is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to equals is Failed!");
        }
    }

    public void testValueOf01() throws Exception {
        String sTimestampVal = null;
        String sLongTstampVal = null;
        String sTestTimestampVal = null;
        String sInTimeVal = null;
        try {
            sTimestampVal = this.sqlp.getProperty("DateTime_Str_Val1", "");
            this.msg.setMsg("Timestamp String Value :  " + sTimestampVal);
            sLongTstampVal = this.sqlp.getProperty("DateTime_Long_Val1", "");
            long tstampVal1 = Long.parseLong(sLongTstampVal);
            this.inTimeVal = new Timestamp(tstampVal1 -= (long)this.valToGeneralize);
            sInTimeVal = this.inTimeVal.toString();
            this.msg.setMsg("TimeStamp Value    " + this.inTimeVal);
            this.inTimeVal1 = Timestamp.valueOf(sTimestampVal);
            sTestTimestampVal = this.inTimeVal1.toString().trim();
            this.msg.setMsg("Test Timestamp object's Value " + sTestTimestampVal);
            boolean booRetVal = sInTimeVal.equals(sTestTimestampVal);
            if (booRetVal) {
                this.msg.setMsg("The method valueOf() returns the correct object");
            } else {
                this.msg.printTestError("The method valueOf() doesnt work as expected", "call to valueOf() failed");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "call to valueOf() failed");
        }
    }

    public void testValueOf02() throws Exception {
        String sTimestampVal = null;
        String sLongTstampVal = null;
        String sTestTimestampVal = null;
        String sInTimeVal = null;
        try {
            sTimestampVal = this.sqlp.getProperty("DateTime_Str_Val2", "");
            this.msg.setMsg("Timestamp String Value :  " + sTimestampVal);
            sLongTstampVal = this.sqlp.getProperty("DateTime_Long_Val2", "");
            long tstampVal1 = Long.parseLong(sLongTstampVal);
            this.inTimeVal = new Timestamp(tstampVal1 -= (long)this.valToGeneralize);
            sInTimeVal = this.inTimeVal.toString();
            this.msg.setMsg("TimeStamp Value    " + this.inTimeVal);
            this.inTimeVal1 = Timestamp.valueOf(sTimestampVal);
            sTestTimestampVal = this.inTimeVal1.toString().trim();
            this.msg.setMsg("Test Timestamp object's Value " + sTestTimestampVal);
            boolean booRetVal = sInTimeVal.equals(sTestTimestampVal);
            if (booRetVal) {
                this.msg.setMsg("The method valueOf() returns the correct object");
            } else {
                this.msg.printTestError("The method valueOf() doesnt work as expected", "call to valueOf() failed");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "call to valueOf() failed");
        }
    }

    public void cleanup() throws Exception {
        try {
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred in Cleanup method", e);
        }
    }
}

