/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.spec.session.sessionid;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.spec.session.sessionid.WSTestServer;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.CloseReason;
import jakarta.websocket.ContainerProvider;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = 10L;
    private static final System.Logger logger = System.getLogger(WSClientIT.class.getName());
    private static final String CONTEXT_ROOT = "/ws_spec_sessionid_web";
    private static StringBuffer receivedMessageString = new StringBuffer();
    static CountDownLatch messageLatch;
    static CountDownLatch onCloseLatch;
    static volatile String session_id;
    static volatile String session_id_endpoint_onOpen;
    static volatile String session_id_endpoint_onClose;
    static volatile Session session;
    static volatile Session session_endpoint_onOpen;
    static volatile Session session_endpoint_onClose;

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ws_spec_sessionid_web.war");
        archive.addClasses(new Class[]{WSTestServer.class});
        archive.addClasses(new Class[]{IOUtil.class});
        archive.addAsWebInfResource(WSClientIT.class.getPackage(), "web.xml", "web.xml");
        return archive;
    }

    public WSClientIT() throws Exception {
        this.setContextRoot("ws_spec_sessionid_web");
    }

    @Test
    public void getIdTest() throws Exception {
        boolean passed = true;
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(1);
            session = clientContainer.connectToServer(TCKGetIdEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_spec_sessionid_web/TCKTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            session_id = session.getId();
            onCloseLatch = new CountDownLatch(1);
            session.close();
            onCloseLatch.await(this._ws_wait, TimeUnit.SECONDS);
            if (session_id != session_id_endpoint_onOpen || session_id != session_id_endpoint_onClose) {
                passed = false;
                System.out.print("Session IDs are not the same.");
            }
            logger.log(System.Logger.Level.INFO, "session_id                 =" + session_id);
            logger.log(System.Logger.Level.INFO, "session_id_endpoint_onClose=" + session_id_endpoint_onClose);
            logger.log(System.Logger.Level.INFO, "session_id_endpoint_onOpen =" + session_id_endpoint_onOpen);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        if (!passed) {
            throw new Exception("Test failed with incorrect response");
        }
    }

    @Test
    public void instanceTest() throws Exception {
        boolean passed = true;
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(1);
            session = clientContainer.connectToServer(TCKGetIdEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_spec_sessionid_web/TCKTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            onCloseLatch = new CountDownLatch(1);
            session.close();
            onCloseLatch.await(this._ws_wait, TimeUnit.SECONDS);
            if (session != session_endpoint_onOpen || session != session_endpoint_onClose) {
                passed = false;
                System.out.print("Sessions are not the same.");
            }
            logger.log(System.Logger.Level.INFO, "session                 =" + session);
            logger.log(System.Logger.Level.INFO, "session_endpoint_onClose=" + session_endpoint_onClose);
            logger.log(System.Logger.Level.INFO, "session_endpoint_onOpen =" + session_endpoint_onOpen);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        if (!passed) {
            throw new Exception("Test failed with incorrect response");
        }
    }

    @Test
    public void unique() throws Exception {
        int size = 5;
        boolean passed = true;
        Session[] sessions = new Session[size];
        try {
            int i;
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            for (i = 0; i < size; ++i) {
                messageLatch = new CountDownLatch(1);
                sessions[i] = session = clientContainer.connectToServer(TCKGetIdEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_spec_sessionid_web/TCKTestServer"));
                messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
                onCloseLatch = new CountDownLatch(1);
                session.close();
                onCloseLatch.await(this._ws_wait, TimeUnit.SECONDS);
                logger.log(System.Logger.Level.INFO, "Session " + i);
                if (session != session_endpoint_onOpen || session != session_endpoint_onClose) {
                    passed = false;
                    System.out.print("Sessions are not the same.");
                }
                logger.log(System.Logger.Level.INFO, "session                 =" + session);
                logger.log(System.Logger.Level.INFO, "session_endpoint_onClose=" + session_endpoint_onClose);
                logger.log(System.Logger.Level.INFO, "session_endpoint_onOpen =" + session_endpoint_onOpen);
            }
            for (i = 0; i < size; ++i) {
                for (int j = i + 1; j < size; ++j) {
                    if (sessions[i] != sessions[j]) continue;
                    passed = false;
                    logger.log(System.Logger.Level.INFO, "two sessions are the same: ");
                    logger.log(System.Logger.Level.INFO, "session " + i + " " + sessions[i]);
                    logger.log(System.Logger.Level.INFO, "session " + j + " " + sessions[j]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        if (!passed) {
            throw new Exception("Test failed with incorrect response");
        }
    }

    @Override
    public void cleanup() throws Exception {
        super.cleanup();
    }

    public static final class TCKGetIdEndpoint
    extends Endpoint {
        public void onOpen(Session session, EndpointConfig config) {
            session_id_endpoint_onOpen = session.getId();
            session_endpoint_onOpen = session;
            session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

                public void onMessage(String message) {
                    receivedMessageString.append(message);
                    messageLatch.countDown();
                }
            });
            session.addMessageHandler((MessageHandler)new MessageHandler.Whole<ByteBuffer>(){

                public void onMessage(ByteBuffer data) {
                    String message_string = IOUtil.byteBufferToString(data);
                    receivedMessageString.append("========Basic ByteBuffer MessageHander received=" + message_string);
                    messageLatch.countDown();
                }
            });
        }

        public void onClose(Session session, CloseReason closeReason) {
            session_id_endpoint_onClose = session.getId();
            session_endpoint_onClose = session;
            receivedMessageString.append("CloseCode=" + closeReason.getCloseCode());
            receivedMessageString.append("ReasonPhrase=" + closeReason.getReasonPhrase());
            onCloseLatch.countDown();
        }
    }
}

