/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.spec.configuration.urimatching;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.spec.configuration.urimatching.WSL1ExactServer;
import com.sun.ts.tests.websocket.spec.configuration.urimatching.WSL1ParamServer;
import com.sun.ts.tests.websocket.spec.configuration.urimatching.WSL2CParamDServer;
import com.sun.ts.tests.websocket.spec.configuration.urimatching.WSL2DParamCServer;
import com.sun.ts.tests.websocket.spec.configuration.urimatching.WSL2ExactCDServer;
import com.sun.ts.tests.websocket.spec.configuration.urimatching.WSL2ParamCDServer;
import com.sun.ts.tests.websocket.spec.configuration.urimatching.WSL3ACDExactServer;
import com.sun.ts.tests.websocket.spec.configuration.urimatching.WSL3ACParamDServer;
import com.sun.ts.tests.websocket.spec.configuration.urimatching.WSL3ADParamCServer;
import com.sun.ts.tests.websocket.spec.configuration.urimatching.WSL3AParamCDServer;
import com.sun.ts.tests.websocket.spec.configuration.urimatching.WSL3CDParamAServer;
import com.sun.ts.tests.websocket.spec.configuration.urimatching.WSL3CParamADServer;
import com.sun.ts.tests.websocket.spec.configuration.urimatching.WSL3DParamACServer;
import com.sun.ts.tests.websocket.spec.configuration.urimatching.WSL3ParamACDServer;
import jakarta.websocket.DeploymentException;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = -6954038749538806576L;
    static final String ECHO = "Echo message to be sent to server endpoint";

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_spec_configuration_urimatching_web.war");
        archive.addPackages(false, Filters.exclude((Class[])new Class[]{WSClientIT.class}), new String[]{"com.sun.ts.tests.websocket.spec.configuration.urimatching"});
        archive.addClasses(new Class[]{IOUtil.class});
        return archive;
    }

    public WSClientIT() throws Exception {
        this.setContextRoot("wsc_spec_configuration_urimatching_web");
    }

    @Test
    public void match1ExactTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("a"));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, WSL1ExactServer.class.getName());
        this.invoke();
    }

    @Test
    public void match1ParamTest() throws Exception {
        String param = "c";
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(param));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, param);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, WSL1ParamServer.class.getName());
        this.invoke();
    }

    @Test
    public void match2CParamDTest() throws Exception {
        String param = "one";
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("c/", param));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, param);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, WSL2CParamDServer.class.getName());
        this.invoke();
    }

    @Test
    public void match2CDExactTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("c/d"));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, WSL2ExactCDServer.class.getName());
        this.invoke();
    }

    @Test
    public void match2ParamCExactDTest() throws Exception {
        String c = "one";
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(c, "/d"));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, c);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, WSL2DParamCServer.class.getName());
        this.invoke();
    }

    @Test
    public void match2ParamCDTest() throws Exception {
        String c = "one";
        String d = "two";
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(c, "/", d));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, c);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, d);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, WSL2ParamCDServer.class.getName());
        this.invoke();
    }

    @Test
    public void match3ACDExactTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("a/c/d"));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, WSL3ACDExactServer.class.getName());
        this.invoke();
    }

    @Test
    public void match3AParamCDTest() throws Exception {
        String c = "one";
        String d = "two";
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("a/", c, "/", d));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, c);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, d);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, WSL3AParamCDServer.class.getName());
        this.invoke();
    }

    @Test
    public void match3CParamADTest() throws Exception {
        String a = "one";
        String d = "two";
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(a, "/c/", d));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, a);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, d);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, WSL3CParamADServer.class.getName());
        this.invoke();
    }

    @Test
    public void match3DParamACTest() throws Exception {
        String a = "one";
        String c = "two";
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(a, "/", c, "/d"));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, a);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, c);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, WSL3DParamACServer.class.getName());
        this.invoke();
    }

    @Test
    public void match3ParamACDTest() throws Exception {
        String a = "one";
        String c = "two";
        String d = "three";
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(a, "/", c, "/", d));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, a);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, c);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, d);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, WSL3ParamACDServer.class.getName());
        this.invoke();
    }

    @Test
    public void match3ACParamDTest() throws Exception {
        String d = "three";
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("a/c/", d));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, d);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, WSL3ACParamDServer.class.getName());
        this.invoke();
    }

    @Test
    public void match3ADParamCTest() throws Exception {
        String c = "two";
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("a/", c, "/d"));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, c);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, WSL3ADParamCServer.class.getName());
        this.invoke();
    }

    @Test
    public void match3CDParamATest() throws Exception {
        String a = "two";
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(a, "/c/d"));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, a);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, WSL3CDParamAServer.class.getName());
        this.invoke();
    }

    @Test
    public void noMatch4ACDETest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("a/c/d/e"));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ECHO);
        try {
            this.invoke();
        }
        catch (Exception e) {
            WSClientIT.assertCause(e, DeploymentException.class, "DeploymentException is not the cause", e);
            return;
        }
        new Exception("No Deployment exception thrown");
    }
}

