/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.basic;

import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextEncoder;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.basic.HolderForThrowingEncoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.basic.OPS;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.basic.ThrowingEncoder;
import jakarta.websocket.EncodeException;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.PongMessage;
import jakarta.websocket.RemoteEndpoint;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;

@ServerEndpoint(value="/server", encoders={StringBeanTextEncoder.class, ThrowingEncoder.class})
public class WSCServerSideServer {
    private static final System.Logger logger = System.getLogger(WSCServerSideServer.class.getName());
    static final String[] RESPONSE = new String[]{"OK", "FAIL"};

    @OnMessage
    public String onMessage(PongMessage pong) {
        return IOUtil.byteBufferToString(pong.getApplicationData());
    }

    @OnMessage
    public String onMessage(String msg, Session session) {
        RemoteEndpoint.Basic basicRemote = session.getBasicRemote();
        OPS op = OPS.valueOf(msg.toUpperCase());
        switch (op) {
            case POKE: {
                break;
            }
            case SENDBINARY: {
                msg = WSCServerSideServer.sendBinary(basicRemote);
                break;
            }
            case SENDBINARYPART1: {
                msg = WSCServerSideServer.sendBinaryPartial(basicRemote);
                break;
            }
            case SENDBINARYTHROWS: {
                msg = WSCServerSideServer.sendBinaryThrows(basicRemote);
                break;
            }
            case SENDOBJECT: {
                msg = WSCServerSideServer.sendObject(basicRemote);
                break;
            }
            case SENDOBJECTTHROWS: {
                msg = WSCServerSideServer.sendObjectThrows(basicRemote);
                break;
            }
            case SENDOBJECTTHROWSENCODEEEXCEPTION: {
                msg = WSCServerSideServer.sendObjectThrowsEncodeException(basicRemote);
                break;
            }
            case SENDOBJECT_BOOL: {
                msg = WSCServerSideServer.sendObject(basicRemote, Boolean.TYPE);
                break;
            }
            case SENDOBJECT_BYTE: {
                msg = WSCServerSideServer.sendObject(basicRemote, Byte.TYPE);
                break;
            }
            case SENDOBJECT_CHAR: {
                msg = WSCServerSideServer.sendObject(basicRemote, Character.TYPE);
                break;
            }
            case SENDOBJECT_DOUBLE: {
                msg = WSCServerSideServer.sendObject(basicRemote, Double.TYPE);
                break;
            }
            case SENDOBJECT_FLOAT: {
                msg = WSCServerSideServer.sendObject(basicRemote, Float.TYPE);
                break;
            }
            case SENDOBJECT_INT: {
                msg = WSCServerSideServer.sendObject(basicRemote, Integer.TYPE);
                break;
            }
            case SENDOBJECT_LONG: {
                msg = WSCServerSideServer.sendObject(basicRemote, Long.TYPE);
                break;
            }
            case SENDOBJECT_SHORT: {
                msg = WSCServerSideServer.sendObject(basicRemote, Short.TYPE);
                break;
            }
            case SENDTEXT: {
                msg = WSCServerSideServer.sendText(basicRemote);
                break;
            }
            case SENDTEXTPART1: {
                msg = WSCServerSideServer.sendTextPartial(basicRemote);
                break;
            }
            case SENDTEXTTHROWS: {
                msg = WSCServerSideServer.sendTextThrows(basicRemote);
                break;
            }
            case SENDSTREAM: {
                msg = WSCServerSideServer.getSendStream(basicRemote);
                break;
            }
            case SENDWRITER: {
                msg = WSCServerSideServer.getSendWriter(basicRemote);
                break;
            }
            case BATCHING_ALLOWED: {
                msg = WSCServerSideServer.batchingAllowed(basicRemote);
                break;
            }
            case SEND_PING: {
                msg = WSCServerSideServer.sendPing(basicRemote);
                break;
            }
            case SEND_PING_THROWS: {
                msg = WSCServerSideServer.sendPingThrows(basicRemote);
                break;
            }
            case SEND_PONG: {
                msg = WSCServerSideServer.sendPong(basicRemote);
                break;
            }
            case SEND_PONG_THROWS: {
                msg = WSCServerSideServer.sendBinaryThrows(basicRemote);
                break;
            }
            case IDLE: {
                session.setMaxIdleTimeout(1500L);
                break;
            }
            case PING_4_TIMES: {
                msg = WSCServerSideServer.sendPing4times(basicRemote);
                break;
            }
            case PONG_4_TIMES: {
                msg = WSCServerSideServer.sendPong4times(basicRemote);
                break;
            }
            default: {
                throw new IllegalArgumentException("Method " + msg + " not implemented");
            }
        }
        return msg;
    }

    @OnError
    public void onError(Session session, Throwable t) throws IOException {
        logger.log(System.Logger.Level.INFO, "@OnError in " + this.getClass().getName());
        t.printStackTrace();
        String message = "Exception: " + IOUtil.printStackTrace(t);
        session.getBasicRemote().sendText(message);
    }

    protected static String sendBinary(RemoteEndpoint.Basic basicRemote) {
        try {
            basicRemote.sendBinary(ByteBuffer.wrap(OPS.SENDBINARY.name().getBytes()));
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace(e);
        }
    }

    protected static String sendBinaryPartial(RemoteEndpoint.Basic basicRemote) {
        try {
            basicRemote.sendBinary(ByteBuffer.wrap(OPS.SENDBINARYPART1.name().getBytes()), false);
            basicRemote.sendBinary(ByteBuffer.wrap(OPS.SENDBINARYPART2.name().getBytes()), false);
            basicRemote.sendBinary(ByteBuffer.wrap(OPS.SENDBINARYPART3.name().getBytes()), true);
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace(e);
        }
    }

    protected static String sendBinaryThrows(RemoteEndpoint.Basic basicRemote) {
        try {
            basicRemote.sendBinary((ByteBuffer)null);
            return RESPONSE[1];
        }
        catch (IllegalArgumentException e) {
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace(e);
        }
    }

    protected static String sendObject(RemoteEndpoint.Basic basicRemote) {
        try {
            basicRemote.sendObject((Object)new StringBean(OPS.SENDOBJECT.name()));
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace(e);
        }
    }

    protected static String sendObject(RemoteEndpoint.Basic basicRemote, Class<?> type) {
        try {
            if (type == Byte.TYPE) {
                byte b = -100;
                basicRemote.sendObject((Object)b);
            } else if (type == Short.TYPE) {
                short s = -101;
                basicRemote.sendObject((Object)s);
            } else if (type == Integer.TYPE) {
                int i = -102;
                basicRemote.sendObject((Object)i);
            } else if (type == Long.TYPE) {
                long l = -103L;
                basicRemote.sendObject((Object)l);
            } else if (type == Float.TYPE) {
                float f = -104.0f;
                basicRemote.sendObject((Object)Float.valueOf(f));
            } else if (type == Double.TYPE) {
                double d = -105.0;
                basicRemote.sendObject((Object)d);
            } else if (type == Boolean.TYPE) {
                boolean b = false;
                basicRemote.sendObject((Object)b);
            } else if (type == Character.TYPE) {
                char c = 'j';
                basicRemote.sendObject((Object)Character.valueOf(c));
            }
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace(e);
        }
    }

    protected static String sendObjectThrows(RemoteEndpoint.Basic basicRemote) {
        try {
            basicRemote.sendObject((Object)null);
            return RESPONSE[1];
        }
        catch (IllegalArgumentException e) {
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace(e);
        }
    }

    protected static String sendObjectThrowsEncodeException(RemoteEndpoint.Basic basicRemote) {
        try {
            basicRemote.sendObject((Object)new HolderForThrowingEncoder(OPS.SENDOBJECTTHROWSENCODEEEXCEPTION.name()));
            return RESPONSE[1];
        }
        catch (EncodeException e) {
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace(e);
        }
    }

    protected static String sendText(RemoteEndpoint.Basic basicRemote) {
        try {
            basicRemote.sendText(OPS.SENDTEXT.name());
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace(e);
        }
    }

    protected static String sendTextPartial(RemoteEndpoint.Basic basicRemote) {
        try {
            basicRemote.sendText(OPS.SENDTEXTPART1.name(), false);
            basicRemote.sendText(OPS.SENDTEXTPART2.name(), false);
            basicRemote.sendText(OPS.SENDTEXTPART3.name(), true);
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace(e);
        }
    }

    protected static String sendTextThrows(RemoteEndpoint.Basic basicRemote) {
        try {
            basicRemote.sendText((String)null);
            return RESPONSE[1];
        }
        catch (IllegalArgumentException e) {
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace(e);
        }
    }

    protected static String getSendStream(RemoteEndpoint.Basic basicRemote) {
        try {
            OutputStream stream = basicRemote.getSendStream();
            stream.write(OPS.SENDSTREAM.name().getBytes());
            stream.close();
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace(e);
        }
    }

    protected static String getSendWriter(RemoteEndpoint.Basic basicRemote) {
        try {
            Writer writer = basicRemote.getSendWriter();
            writer.append(OPS.SENDWRITER.name());
            writer.close();
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace(e);
        }
    }

    protected static String batchingAllowed(RemoteEndpoint.Basic basicRemote) {
        try {
            boolean allowed = basicRemote.getBatchingAllowed();
            basicRemote.setBatchingAllowed(!allowed);
            basicRemote.sendText(OPS.BATCHING_ALLOWED.name());
            basicRemote.flushBatch();
            basicRemote.setBatchingAllowed(allowed);
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace(e);
        }
    }

    protected static String sendPing(RemoteEndpoint.Basic basicRemote) {
        try {
            basicRemote.sendPing(ByteBuffer.wrap(OPS.SEND_PING.name().getBytes()));
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace(e);
        }
    }

    protected static String sendPingThrows(RemoteEndpoint.Basic basicRemote) {
        try {
            basicRemote.sendPing(ByteBuffer.wrap(WSCServerSideServer.generateMessage(126).getBytes()));
            return RESPONSE[1];
        }
        catch (IllegalArgumentException iae) {
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace(e);
        }
    }

    protected static String generateMessage(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i != length; ++i) {
            sb.append(i % 10);
        }
        return sb.toString();
    }

    protected static String sendPong(RemoteEndpoint.Basic basicRemote) {
        try {
            basicRemote.sendPong(ByteBuffer.wrap(OPS.SEND_PONG.name().getBytes()));
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace(e);
        }
    }

    protected static String sendPongThrows(RemoteEndpoint.Basic basicRemote) {
        try {
            basicRemote.sendPong(ByteBuffer.wrap(WSCServerSideServer.generateMessage(126).getBytes()));
            return RESPONSE[1];
        }
        catch (IllegalArgumentException iae) {
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace(e);
        }
    }

    protected static String sendPing4times(RemoteEndpoint.Basic basicRemote) {
        try {
            byte[] bytes = OPS.POKE.name().getBytes();
            basicRemote.sendPing(ByteBuffer.wrap(bytes));
            Thread.sleep(500L);
            basicRemote.sendPing(ByteBuffer.wrap(bytes));
            Thread.sleep(500L);
            basicRemote.sendPing(ByteBuffer.wrap(bytes));
            Thread.sleep(500L);
            basicRemote.sendPing(ByteBuffer.wrap(bytes));
            Thread.sleep(500L);
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace(e);
        }
    }

    protected static String sendPong4times(RemoteEndpoint.Basic basicRemote) {
        try {
            byte[] bytes = OPS.POKE.name().getBytes();
            basicRemote.sendPong(ByteBuffer.wrap(bytes));
            Thread.sleep(500L);
            basicRemote.sendPong(ByteBuffer.wrap(bytes));
            Thread.sleep(500L);
            basicRemote.sendPong(ByteBuffer.wrap(bytes));
            Thread.sleep(500L);
            basicRemote.sendPong(ByteBuffer.wrap(bytes));
            Thread.sleep(500L);
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace(e);
        }
    }
}

