/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.endpoint.server;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.endpoint.server.WSCMsgServer;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.OnClose;
import jakarta.websocket.Session;
import java.io.IOException;

public class WSCErrorServerEndpoint
extends Endpoint
implements MessageHandler.Whole<String> {
    static final String EXCEPTION = "TCK test throwable";
    private Session session;

    public void onMessage(String msg) {
        this.session.getAsyncRemote().sendText(msg);
        throw new RuntimeException(EXCEPTION);
    }

    public void onOpen(Session session, EndpointConfig config) {
        session.addMessageHandler((MessageHandler)this);
        this.session = session;
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        super.onClose(session, closeReason);
    }

    public void onError(Session session, Throwable t) {
        String msg = WSCErrorServerEndpoint.getCauseMessage(t);
        if (EXCEPTION.equals(msg)) {
            WSCMsgServer.setLastMessage(EXCEPTION);
        } else {
            t.printStackTrace();
            String message = IOUtil.printStackTrace(t);
            try {
                session.getBasicRemote().sendText(message);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String getCauseMessage(Throwable t) {
        String msg = null;
        while (t != null) {
            msg = t.getMessage();
            t = t.getCause();
        }
        return msg;
    }
}

