/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.timer.interceptor.business.mdb;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.timer.common.MessageSenderBean;
import com.sun.ts.tests.ejb30.timer.common.TimerUtil;
import com.sun.ts.tests.ejb30.timer.interceptor.business.common.BusinessTimerBeanBase;
import com.sun.ts.tests.ejb30.timer.interceptor.business.common.Interceptor2;
import com.sun.ts.tests.ejb30.timer.interceptor.business.common.Interceptor3;
import com.sun.ts.tests.ejb30.timer.interceptor.business.mdb.TestBean;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.ejb.EJB;
import jakarta.ejb.MessageDriven;
import jakarta.ejb.Timer;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptors;
import jakarta.interceptor.InvocationContext;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;

@MessageDriven
@Interceptors(value={Interceptor2.class})
public class BusinessTimerBean
extends BusinessTimerBeanBase
implements MessageListener {
    @EJB(beanInterface=TestBean.class, beanName="TestBean")
    private TestBean testBean;

    @AroundInvoke
    private Object aroundInvoke(InvocationContext inv) throws Exception {
        TimerUtil.createMillisecondLaterTimer(this.timerService, "BusinessTimerBean.aroundInvoke");
        return inv.proceed();
    }

    @Interceptors(value={Interceptor3.class})
    public void onMessage(Message msg) {
        Helper.getLogger().info("In onMessage method of " + String.valueOf(this));
        String testName = MessageSenderBean.getTestName(msg);
        if ("messageFromSingletonBeanToMDB".equals(testName)) {
            this.testBean.setReplyFromMDB(testName);
            return;
        }
        super.createMillisecondLaterTimer(testName);
    }

    @Override
    public Timer createMillisecondLaterTimer(String name) {
        return null;
    }

    @PostConstruct
    private void postConstruct() {
        Helper.getLogger().info("In PostConstruct of " + String.valueOf(this));
    }

    @PreDestroy
    private void preDestroy() {
        Helper.getLogger().info("In PreDestroy of " + String.valueOf(this));
    }
}

