/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.tx.cm.stateful.sessionsync;

import com.sun.ts.tests.ejb30.common.lite.EJBLiteJsfClientBase;
import com.sun.ts.tests.ejb30.common.statussingleton.StatusSingletonBean;
import com.sun.ts.tests.ejb30.lite.tx.cm.stateful.sessionsync.RollbackBean;
import com.sun.ts.tests.ejb30.lite.tx.cm.stateful.sessionsync.SessionSyncIF;
import jakarta.ejb.EJB;
import jakarta.ejb.EJBException;
import jakarta.ejb.NoSuchEJBException;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.List;

@EJB(name="ejb/rollbackBean", beanInterface=RollbackBean.class, beanName="RollbackBean")
@Named(value="client")
@RequestScoped
public class JsfClient
extends EJBLiteJsfClientBase {
    @EJB(beanName="AnnotatedBean")
    private SessionSyncIF annotatedBean;
    @EJB(beanName="ImplementingBean")
    private SessionSyncIF implementingBean;
    @EJB(beanName="DescriptorBean")
    private SessionSyncIF descriptorBean;
    @EJB(beanName="StatusSingletonBean")
    private StatusSingletonBean statusSingleton;

    public void sessionSynchronizationCallbackSequence() {
        List<String> expectedAll = Arrays.asList("afterBegin", "aroundInvoke1", "getHistory", "aroundInvoke2", "beforeCompletion", "afterCompletion");
        List<String> historyAll = this.implementingBean.getHistory();
        this.assertEquals(null, expectedAll, historyAll);
        List<String> expectedPartial = Arrays.asList("afterBegin", "aroundInvoke1", "getHistory", "aroundInvoke2", "beforeCompletion");
        for (SessionSyncIF b : new SessionSyncIF[]{this.annotatedBean, this.descriptorBean}) {
            List<String> history = b.getHistory();
            this.assertEquals(null, expectedPartial, history);
        }
    }

    public void afterBeginException() {
        this.rollback(RollbackBean.TestNames.afterBeginException, true, null);
    }

    public void methodException() {
        this.rollback(RollbackBean.TestNames.methodException, true, null);
    }

    public void beforeCompletionException() {
        this.rollback(RollbackBean.TestNames.beforeCompletionException, true, null);
    }

    public void afterCompletionException() {
        this.rollback(RollbackBean.TestNames.afterCompletionException, true, null);
    }

    public void afterBeginSetRollbackOnly() {
        this.rollback(RollbackBean.TestNames.afterBeginSetRollbackOnly, false, false);
    }

    public void methodSetRollbackOnly() {
        this.rollback(RollbackBean.TestNames.methodSetRollbackOnly, false, false);
    }

    public void beforeCompletionSetRollbackOnly() {
        this.rollback(RollbackBean.TestNames.beforeCompletionSetRollbackOnly, false, false);
    }

    private void rollback(RollbackBean.TestNames testName, boolean expectingException, Boolean expectedTxResult) {
        RollbackBean b = (RollbackBean)this.lookup("ejb/rollbackBean", "RollbackBean", null);
        this.statusSingleton.addResult(RollbackBean.TestNames.currentTestKey.toString(), testName.toString());
        this.statusSingleton.getAndResetResult(RollbackBean.TestNames.isTxCommittedKey.toString());
        if (expectingException) {
            try {
                b.rollback();
                throw new RuntimeException("Expecting EJBException, but got none.");
            }
            catch (NoSuchEJBException e) {
                throw new RuntimeException("Expecting other EJBException, but got " + String.valueOf((Object)e));
            }
            catch (EJBException e) {
                this.appendReason("Got expected " + String.valueOf((Object)e));
                try {
                    b.rollback();
                    throw new RuntimeException("Expecting NoSuchEJBException, but got none.");
                }
                catch (NoSuchEJBException ee) {
                    this.appendReason("Got expected " + String.valueOf((Object)ee));
                }
            }
        } else {
            b.rollback();
        }
        if (expectedTxResult == null) {
            return;
        }
        this.assertEquals(null, expectedTxResult, b.getAndResetTransactionStatus());
    }
}

