/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb32.lite.timer.basic.xa;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.lite.tx.cm.common.CoffeeEJBLite;
import com.sun.ts.tests.ejb30.timer.common.TimerBeanBase;
import com.sun.ts.tests.ejb30.timer.common.TimerInfo;
import com.sun.ts.tests.ejb30.timer.common.TimerUtil;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerConfig;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceException;
import java.io.Serializable;
import java.util.Date;
import java.util.logging.Level;

public abstract class XATimerBeanBase
extends TimerBeanBase {
    @PersistenceContext(unitName="ejblite-pu")
    protected EntityManager em;

    public abstract void persistCoffee(int var1, String var2);

    public boolean persistCoffeeCreateTimerRollback(int id, String brandName, Date expiration, TimerInfo info) {
        boolean result = false;
        Timer timer = this.timerService.createSingleActionTimer(expiration, new TimerConfig((Serializable)info, false));
        Helper.getLogger().logp(Level.INFO, "XATimerBeanBase", "persistCoffeeCreateTimerRollback", "Temporarily created timer: " + TimerUtil.toString((Timer)timer));
        CoffeeEJBLite coffeeFound = (CoffeeEJBLite)this.em.find(CoffeeEJBLite.class, (Object)id);
        if (coffeeFound == null) {
            throw new IllegalStateException("Expecting 1 coffee, but found none.");
        }
        Helper.getLogger().logp(Level.INFO, "XATimerBeanBase", "persistCoffeeCreateTimerRollback", "Found the newly-persisted coffee: " + String.valueOf(coffeeFound));
        CoffeeEJBLite c = new CoffeeEJBLite(Integer.valueOf(id), brandName, (float)id);
        try {
            this.em.persist((Object)c);
            this.em.flush();
            Helper.getLogger().logp(Level.INFO, "XATimerBeanBase", "persistCoffeeCreateTimerRollback", "Expecting EntityExistsException or another PersistenceContext, but got none");
            result = false;
        }
        catch (PersistenceException e) {
            Helper.getLogger().logp(Level.INFO, "XATimerBeanBase", "persistCoffeeCreateTimerRollback", "Got the expected " + String.valueOf((Object)e));
            result = true;
        }
        return result;
    }
}

