/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.conversation;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.tests.context.conversation.Cloud;

public abstract class AbstractConversationTest
extends AbstractTest {
    @ArquillianResource
    protected URL contextPath;
    public static final String CID_REQUEST_PARAMETER_NAME = "cid";
    public static final String CID_HEADER_NAME = "org.jboss.cdi.tck.cid";
    public static final String LONG_RUNNING_HEADER_NAME = "org.jboss.cdi.tck.longRunning";

    protected boolean isCloudDestroyed(WebClient client) throws Exception {
        Page page = client.getPage(this.getConversationStatusPath("cloudDestroyed"));
        return page.getWebResponse().getStatusCode() == 200;
    }

    protected boolean isConversationContextDestroyed(WebClient client) throws Exception {
        Page page = client.getPage(this.getConversationStatusPath("conversationContextDestroyed"));
        return page.getWebResponse().getStatusCode() == 200;
    }

    protected void resetCloud(WebClient client) throws Exception {
        client.getPage(this.getConversationStatusPath("resetCloud"));
    }

    protected void resetConversationContextObserver(WebClient client) throws Exception {
        client.getPage(this.getConversationStatusPath("resetConversationContextObserver"));
    }

    protected void invalidateSession(WebClient client) throws Exception {
        client.getPage(this.getConversationStatusPath("invalidateSession"));
    }

    protected String getConversationStatusPath(String method) {
        return this.contextPath + "conversation-status?method=" + method;
    }

    protected String getPath(String viewId) {
        return this.contextPath + viewId;
    }

    protected String getPath(String viewId, String cid) {
        return this.contextPath + viewId + "?" + CID_REQUEST_PARAMETER_NAME + "=" + cid;
    }

    protected <T> Set<T> getElements(HtmlElement rootElement, Class<T> elementClass) {
        HashSet<T> result = new HashSet<T>();
        for (HtmlElement element : rootElement.getHtmlElementDescendants()) {
            result.addAll(this.getElements(element, elementClass));
        }
        if (elementClass.isInstance(rootElement)) {
            result.add(elementClass.cast(rootElement));
        }
        return result;
    }

    protected <T extends HtmlElement> T getFirstMatchingElement(HtmlPage page, Class<T> elementClass, String id) {
        Set<T> inputs = this.getElements(page.getBody(), elementClass);
        for (HtmlElement input : inputs) {
            if (!input.getId().contains(id)) continue;
            return (T)input;
        }
        return null;
    }

    protected String getCid(Page page) {
        return page.getWebResponse().getResponseHeaderValue(CID_HEADER_NAME);
    }

    protected Boolean hasRained(Page page) {
        return Boolean.valueOf(page.getWebResponse().getResponseHeaderValue(Cloud.RAINED_HEADER_NAME));
    }

    protected Boolean isLongRunning(Page page) {
        return Boolean.valueOf(page.getWebResponse().getResponseHeaderValue(LONG_RUNNING_HEADER_NAME));
    }
}

