/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.pathparam;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.ee.rs.JaxrsParamClient;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityPrototype;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityThrowingExceptionGivenByName;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityThrowingWebApplicationException;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityWithConstructor;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityWithFromString;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityWithValueOf;
import ee.jakarta.tck.ws.rs.ee.rs.ParamTest;
import ee.jakarta.tck.ws.rs.ee.rs.RuntimeExceptionMapper;
import ee.jakarta.tck.ws.rs.ee.rs.WebApplicationExceptionMapper;
import ee.jakarta.tck.ws.rs.ee.rs.pathparam.PathParamTest;
import ee.jakarta.tck.ws.rs.ee.rs.pathparam.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsParamClient {
    private static final long serialVersionUID = 1L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_rs_pathparam_web/PathParamTest");
        this.useDefaultValue = false;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/pathparam/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_rs_pathparam_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, PathParamTest.class, ParamEntityPrototype.class, ParamEntityWithConstructor.class, ParamEntityWithValueOf.class, ParamEntityWithFromString.class, ParamTest.class, ParamEntityThrowingWebApplicationException.class, ParamEntityThrowingExceptionGivenByName.class, RuntimeExceptionMapper.class, WebApplicationExceptionMapper.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void test1() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_HTML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "a"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "single=a");
        this.invoke();
    }

    @Test
    public void test2() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "a/b"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "double=ab");
        this.invoke();
    }

    @Test
    public void test3() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "2147483647/b/12.345"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "triple=2147483647b12.345");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "-2147483648/b/123.0"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "triple=-2147483648b123.0");
        this.invoke();
    }

    @Test
    public void test4() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "123.1/true/127/tmp"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "quard=123.1true127tmp");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "345/false/-128/xyz"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "quard=345.0false-128xyz");
        this.invoke();
    }

    @Test
    public void test5() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "-9223372036854775808/b/32767/true/abc"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "penta=-9223372036854775808b32767trueabc");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "9223372036854775807/b/-32768/false/xyz"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "penta=9223372036854775807b-32768falsexyz");
        this.invoke();
    }

    @Test
    public void test6() throws JAXRSCommonClient.Fault {
        String[] headers;
        for (String header : headers = new String[]{"list=abcdef", "list=fedcba"}) {
            this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: text/plain");
            this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "a/b/c/d/e/f"));
            this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, header);
            try {
                this.invoke();
                return;
            }
            catch (Exception ex) {
                TestUtil.logTrace("Header " + header + " didnt work out, try another one");
            }
        }
        throw new JAXRSCommonClient.Fault("If you get to here means test failed.");
    }

    @Test
    public void test7() throws JAXRSCommonClient.Fault {
        String[] headers;
        for (String header : headers = new String[]{"matrix=/a;boolean1=false;boolean2=true", "matrix=/a;boolean2=true;boolean1=false"}) {
            this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept:text/plain");
            this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "matrix/a;boolean1=false;boolean2=true"));
            this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, header);
            try {
                this.invoke();
                return;
            }
            catch (Exception ex) {
                TestUtil.logTrace("Header " + header + " didnt work out, try another one");
            }
        }
        throw new JAXRSCommonClient.Fault("If you get to here means test failed.");
    }

    @Test
    public void pathParamEntityWithConstructorTest() throws JAXRSCommonClient.Fault {
        super.paramEntityWithConstructorTest();
    }

    @Test
    public void pathParamEntityWithValueOfTest() throws JAXRSCommonClient.Fault {
        super.paramEntityWithValueOfTest();
    }

    @Test
    public void pathParamEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        this.searchEqualsEncoded = true;
        super.paramEntityWithFromStringTest();
    }

    @Test
    public void pathParamSetEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.paramCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.SET);
    }

    @Test
    public void pathParamSortedSetEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.paramCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.SORTED_SET);
    }

    @Test
    public void pathParamListEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.paramCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.LIST);
    }

    public void pathFieldParamEntityWithConstructorTest() throws JAXRSCommonClient.Fault {
        super.fieldEntityWithConstructorTest();
    }

    public void pathFieldParamEntityWithValueOfTest() throws JAXRSCommonClient.Fault {
        super.fieldEntityWithValueOfTest();
    }

    public void pathFieldParamEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.fieldEntityWithFromStringTest();
    }

    public void pathFieldParamSetEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.fieldCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.SET);
    }

    public void pathFieldParamSortedSetEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.fieldCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.SORTED_SET);
    }

    public void pathFieldParamListEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.fieldCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.LIST);
    }

    @Test
    public void pathParamEntityWithEncodedTest() throws JAXRSCommonClient.Fault {
        this.searchEqualsEncoded = true;
        super.paramEntityWithEncodedTest();
    }

    @Test
    public void pathParamThrowingWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        super.paramThrowingWebApplicationExceptionTest();
    }

    @Test
    public void pathParamThrowingIllegalArgumentExceptionTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, Response.Status.NOT_FOUND.name());
        super.paramThrowingIllegalArgumentExceptionTest();
    }

    @Override
    protected String buildRequest(String param) {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_PLAIN_TYPE));
        StringBuilder sb = new StringBuilder();
        sb.append(JAXRSCommonClient.Request.GET.name()).append(" ").append(this._contextRoot);
        sb.append("/").append(JAXRSClientIT.segmentFromParam(param)).append("/");
        sb.append(param.replace("=", "%3d")).append("/");
        return sb.append(" HTTP/1.1").toString();
    }

    @Override
    protected String getDefaultValueOfParam(String param) {
        StringBuilder sb = new StringBuilder();
        sb.append(param).append("=");
        sb.append(PathParamTest.class.getSimpleName());
        return sb.toString();
    }
}

