/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.sseeventsource;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.impl.JaxbKeyValueBean;
import ee.jakarta.tck.ws.rs.common.impl.ReplacingOutputStream;
import ee.jakarta.tck.ws.rs.common.impl.SecurityContextImpl;
import ee.jakarta.tck.ws.rs.common.impl.SinglevaluedMap;
import ee.jakarta.tck.ws.rs.common.impl.StringDataSource;
import ee.jakarta.tck.ws.rs.common.impl.StringSource;
import ee.jakarta.tck.ws.rs.common.impl.StringStreamingOutput;
import ee.jakarta.tck.ws.rs.common.impl.TRACE;
import ee.jakarta.tck.ws.rs.common.util.Holder;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.common.util.LinkedHolder;
import ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.OutboundSSEEventImpl;
import ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.SSEEventImpl;
import ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.SSEJAXRSClient;
import ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.SSEMessage;
import ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.sseeventsource.MediaTypeResource;
import ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.sseeventsource.RepeatedCasterResource;
import ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.sseeventsource.ServiceUnavailableResource;
import ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.sseeventsource.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.activation.DataSource;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.sse.InboundSseEvent;
import jakarta.ws.rs.sse.SseEventSource;
import jakarta.xml.bind.JAXBElement;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends SSEJAXRSClient {
    private static final long serialVersionUID = 21L;
    private int mediaTestLevel = 0;

    public JAXRSClientIT() {
        this.setup();
        this.mediaTestLevel = 0;
        this.setContextRoot("/jaxrs_jaxrs21_ee_sse_sseeventsource_web");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/jaxrs21/ee/sse/sseeventsource/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_jaxrs21_ee_sse_sseeventsource_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, MediaTypeResource.class, RepeatedCasterResource.class, ServiceUnavailableResource.class, JaxrsUtil.class, SSEEventImpl.class, SSEMessage.class, OutboundSSEEventImpl.class, TRACE.class, StringSource.class, StringStreamingOutput.class, StringDataSource.class, SinglevaluedMap.class, SecurityContextImpl.class, ReplacingOutputStream.class, JaxbKeyValueBean.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void defaultWaiting1s() throws JAXRSCommonClient.Fault {
        SseEventSource source;
        Holder<Object> holder = new Holder();
        WebTarget target = ClientBuilder.newClient().target(this.getAbsoluteUrl("su/sse"));
        try {
            source = SseEventSource.target((WebTarget)target).build();
            try {
                source.register(holder::set);
                source.open();
                this.sleepUntilHolderGetsFilled(holder);
            }
            finally {
                if (source != null) {
                    source.close();
                }
            }
        }
        catch (Exception e) {
            throw new JAXRSCommonClient.Fault(e);
        }
        JAXRSClientIT.assertNotNull(holder.get(), "Holder was not filled");
        JAXRSClientIT.logTrace("Received message", ((InboundSseEvent)holder.get()).readData());
        holder.set(null);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "su/available"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "OK");
        this.invoke();
        try {
            source = SseEventSource.target((WebTarget)target).build();
            try {
                source.register(holder::set);
                source.open();
            }
            finally {
                if (source != null) {
                    source.close();
                }
            }
        }
        catch (Exception e) {
            throw new JAXRSCommonClient.Fault(e);
        }
        JAXRSClientIT.assertNull(holder.get(), "The event should be sent after default 1s in retry, not sooner");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "su/available"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "OK");
        this.invoke();
        holder = this.querySSEEndpoint("su/sse");
        JAXRSClientIT.logTrace("Received message", ((InboundSseEvent)holder.get()).readData());
        JAXRSClientIT.logTrace("Slept for", (long)this.sleep * this.millis, "ms");
        Assertions.assertTrue((this.sleep < 4 ? 1 : 0) != 0, (String)"The message has been sent unexpectedly late, after 2000ms");
    }

    @Test
    public void wait2Seconds() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "su/available"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "OK");
        this.invoke();
        this.setRequestContentEntity("2");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "su/retry"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "2");
        this.invoke();
        Holder<InboundSseEvent> holder = this.querySSEEndpoint("su/sse");
        JAXRSClientIT.logTrace("Received message", holder.get().readData());
        JAXRSClientIT.logTrace("Slept for", (long)this.sleep * this.millis, "ms");
        Assertions.assertTrue((this.sleep > 3 ? 1 : 0) != 0, (String)"The message has been sent unexpectedly soon, sooner then 2000ms");
        Assertions.assertTrue((this.sleep < 6 ? 1 : 0) != 0, (String)"The message has been sent unexpectedly late, after 3000ms");
        JAXRSClientIT.assertEquals("some_ServiceUnavailableEndpoint_message", holder.get().readData(), "Unexpected message received", holder.get().readData());
    }

    @Test
    @Disabled
    public void connectionLostForDefault500msTest() throws JAXRSCommonClient.Fault {
        this.resetUnavailableServer();
        this.setRequestContentEntity("3");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "su/lost"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "3");
        this.invoke();
        Holder<InboundSseEvent> holder = this.querySSEEndpoint("su/sselost");
        JAXRSClientIT.logTrace("Received message", holder.get().readData());
        JAXRSClientIT.logTrace("Slept for", (long)this.sleep * this.millis, "ms");
        Assertions.assertTrue((this.sleep > 2 ? 1 : 0) != 0, (String)"The message has been sent unexpectedly soon, sooner then 1500ms");
        Assertions.assertTrue((this.sleep < 5 ? 1 : 0) != 0, (String)"The message has been sent unexpectedly late, after 3000ms");
        JAXRSClientIT.assertEquals("some_ServiceUnavailableEndpoint_message", holder.get().readData(), "Unexpected message received", holder.get().readData());
        int cnt = this.getServerCount();
        JAXRSClientIT.logTrace("Received count:", cnt);
        Assertions.assertTrue((cnt > 3 && cnt < 7 ? 1 : 0) != 0, (String)("The client tried to reconnected unexpectedly" + cnt + "times!"));
    }

    @Test
    public void reconnectByEventMethodTest() throws JAXRSCommonClient.Fault {
        Holder<InboundSseEvent> holder = this.querySSEEndpoint("su/reconnectdelay");
        Assertions.assertTrue((boolean)holder.get().isReconnectDelaySet(), (String)"ReconnectDelay was not set");
        long delay = holder.get().getReconnectDelay();
        JAXRSClientIT.assertEquals(delay, 3000L, "Received unexepcted ReconnectDelay", delay);
        JAXRSClientIT.assertEquals("some_ServiceUnavailableEndpoint_message", holder.get().readData(), "Unexpected message received", holder.get().readData());
    }

    @Test
    public void userReconnectByEventMethodTest() throws JAXRSCommonClient.Fault {
        Holder<InboundSseEvent> holder = this.querySSEEndpoint("su/userreconnectdelay");
        Assertions.assertTrue((boolean)holder.get().isReconnectDelaySet(), (String)"ReconnectDelay was not set");
        long delay = holder.get().getReconnectDelay();
        JAXRSClientIT.assertEquals(delay, 20000L, "Received unexepcted ReconnectDelay", delay);
        JAXRSClientIT.assertEquals("some_ServiceUnavailableEndpoint_message", holder.get().readData(), "Unexpected message received", holder.get().readData());
    }

    @Test
    public void stringTest() throws JAXRSCommonClient.Fault {
        this.mediaTest(String.class, "some_ServiceUnavailableEndpoint_message", "text/plain", MediaType.TEXT_PLAIN_TYPE, MediaType.TEXT_HTML_TYPE);
    }

    @Test
    public void byteArrayTest() throws JAXRSCommonClient.Fault {
        BiPredicate<Object, Object> p = (a, b) -> a.equals(new String((byte[])b));
        this.mediaTest(byte[].class, "some_ServiceUnavailableEndpoint_message", p, "text/plain", MediaType.TEXT_PLAIN_TYPE, MediaType.TEXT_HTML_TYPE);
    }

    @Test
    public void inputStreamTest() throws JAXRSCommonClient.Fault {
        BiPredicate<Object, Object> p = (a, b) -> {
            try {
                return JaxrsUtil.readFromStream((InputStream)b).equals(a);
            }
            catch (IOException e) {
                return false;
            }
        };
        this.mediaTest(InputStream.class, "some_ServiceUnavailableEndpoint_message", p, "text/plain", MediaType.TEXT_PLAIN_TYPE, MediaType.TEXT_HTML_TYPE);
    }

    @Test
    public void readerTest() throws JAXRSCommonClient.Fault {
        BiPredicate<Object, Object> p = (a, b) -> {
            try {
                return JaxrsUtil.readFromReader((Reader)b).equals(a);
            }
            catch (IOException e) {
                return false;
            }
        };
        this.mediaTest(Reader.class, "some_ServiceUnavailableEndpoint_message", p, "text/plain", MediaType.TEXT_PLAIN_TYPE, MediaType.TEXT_HTML_TYPE);
    }

    @Test
    public void fileTest() throws JAXRSCommonClient.Fault {
        BiPredicate<Object, Object> p = (a, b) -> {
            try {
                return JaxrsUtil.readFromFile((File)b).equals(a);
            }
            catch (IOException e) {
                return false;
            }
        };
        this.mediaTest(File.class, "some_ServiceUnavailableEndpoint_message", p, "text/plain", MediaType.TEXT_PLAIN_TYPE, MediaType.TEXT_HTML_TYPE);
    }

    @Test
    public void dataSourceTest() throws JAXRSCommonClient.Fault {
        BiPredicate<Object, Object> p = (a, b) -> {
            try {
                return JaxrsUtil.readFromStream(((DataSource)b).getInputStream()).equals(a);
            }
            catch (IOException e) {
                return false;
            }
        };
        this.mediaTest(DataSource.class, "some_ServiceUnavailableEndpoint_message", p, "text/plain", MediaType.TEXT_PLAIN_TYPE, MediaType.TEXT_HTML_TYPE);
    }

    @Test
    public void transformSourceTest() throws JAXRSCommonClient.Fault {
        this.mediaTestLevel = 2;
        BiPredicate<Object, Object> p = (a, b) -> {
            try {
                Source s = (Source)b;
                if (StreamSource.class.isInstance(s)) {
                    return JaxrsUtil.readFromStream(((StreamSource)b).getInputStream()).equals(a);
                }
                return true;
            }
            catch (IOException e) {
                return false;
            }
        };
        this.mediaTest(Source.class, "some_ServiceUnavailableEndpoint_message", p, "text/xml", MediaType.TEXT_XML_TYPE, MediaType.APPLICATION_ATOM_XML_TYPE);
    }

    @Test
    @Tag(value="xml_binding")
    public void jaxbElementTest() throws JAXRSCommonClient.Fault {
        this.mediaTestLevel = 3;
        BiPredicate<Object, Object> p = (a, b) -> ((String)((JAXBElement)b).getValue()).equals(a);
        this.mediaTest(JAXBElement.class, "some_ServiceUnavailableEndpoint_message", p, "text/xml", MediaType.TEXT_XML_TYPE, MediaType.APPLICATION_XML_TYPE, new GenericType<JAXBElement<String>>(){}, "media/jaxb");
    }

    @Test
    @Tag(value="xml_binding")
    public void xmlTest() throws JAXRSCommonClient.Fault {
        this.mediaTestLevel = 2;
        BiPredicate<Object, Object> p = (a, b) -> ((JaxbKeyValueBean)b).getValue().equals(a);
        this.mediaTest(JaxbKeyValueBean.class, "some_ServiceUnavailableEndpoint_message", p, "text/xml", MediaType.TEXT_XML_TYPE, MediaType.APPLICATION_XML_TYPE, this.createGenericType(JaxbKeyValueBean.class), "media/xml");
    }

    @Test
    public void multivaluedMapTest() throws JAXRSCommonClient.Fault {
        this.mediaTestLevel = 3;
        BiPredicate<Object, Object> p = (a, b) -> ((String)((MultivaluedMap)b).getFirst((Object)"key")).equals(a);
        this.mediaTest(MultivaluedMap.class, "some_ServiceUnavailableEndpoint_message", p, "application/x-www-form-urlencoded", MediaType.APPLICATION_FORM_URLENCODED_TYPE, MediaType.APPLICATION_FORM_URLENCODED_TYPE, new GenericType<MultivaluedMap<String, String>>(){}, "media/map");
    }

    @Test
    public void connectionLostFor1500msTest() throws JAXRSCommonClient.Fault {
        this.resetUnavailableServer();
        this.setRequestContentEntity("1");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "su/lost"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "1");
        this.invoke();
        Holder holder = new Holder();
        WebTarget target = ClientBuilder.newClient().target(this.getAbsoluteUrl("su/sselost"));
        try (SseEventSource source = SseEventSource.target((WebTarget)target).reconnectingEvery(2000L, TimeUnit.MILLISECONDS).build();){
            source.register(holder::set);
            source.open();
            this.sleep = this.sleepUntilHolderGetsFilled(holder);
        }
        int cnt = this.getServerCount();
        JAXRSClientIT.logTrace("Slept for", (long)this.sleep * this.millis, "ms");
        JAXRSClientIT.assertNotNull(holder.get(), "Message not received, reconnect was done", cnt - 1, "times.");
        JAXRSClientIT.logTrace("Received message", ((InboundSseEvent)holder.get()).readData());
        Assertions.assertTrue((this.sleep > 3 ? 1 : 0) != 0, (String)"The message has been sent unexpectedly soon, sooner then 2000ms");
        Assertions.assertTrue((this.sleep < 5 ? 1 : 0) != 0, (String)"The message has been sent unexpectedly late, after 3000ms");
        JAXRSClientIT.assertEquals("some_ServiceUnavailableEndpoint_message", ((InboundSseEvent)holder.get()).readData(), "Unexpected message received", ((InboundSseEvent)holder.get()).readData());
        JAXRSClientIT.assertEquals(cnt, 2, "Server was reconnected", cnt, "times, unexpectedly");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void closeTest() throws JAXRSCommonClient.Fault {
        boolean isOpen = true;
        LinkedHolder holder = new LinkedHolder();
        WebTarget target = ClientBuilder.newClient().target(this.getAbsoluteUrl("repeat/cast"));
        this.setRequestContentEntity(Boolean.TRUE);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "repeat/set"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        this.invoke();
        Assertions.assertTrue((boolean)((Boolean)this.getResponse().readEntity(Boolean.class)), (String)"Cast has not been set");
        SseEventSource source = SseEventSource.target((WebTarget)target).build();
        source.register(holder::add);
        source.open();
        this.sleepUntilHolderGetsFilled(holder);
        JAXRSClientIT.assertNotNull(holder.get(), "Message was not received");
        for (Object e : holder) {
            JAXRSClientIT.logMsg("Received message no", e.readData());
        }
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "repeat/isopen"));
        this.invoke();
        isOpen = this.getResponseBody(Boolean.class);
        Assertions.assertTrue((boolean)isOpen, (String)"SseEventSource is closed");
        for (int i = 0; i != 3; ++i) {
            holder.clear();
            this.sleepUntilHolderGetsFilled(holder);
            for (InboundSseEvent e : holder) {
                JAXRSClientIT.logMsg("Received message no", e.readData());
            }
        }
        source.close();
        Assertions.assertFalse((boolean)source.isOpen(), (String)"SseEventSource was not closed");
        int cnt = 0;
        int size = holder.size();
        try {
            while (isOpen && cnt < 20) {
                holder.clear();
                ++cnt;
                this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "repeat/isopen"));
                this.invoke();
                isOpen = this.getResponseBody(Boolean.class);
                Assertions.assertFalse((size == 0 && isOpen ? 1 : 0) != 0, (String)"Message was not received and SseEventSink is open");
                this.sleepUntilHolderGetsFilled(holder);
                for (InboundSseEvent e : holder) {
                    JAXRSClientIT.logMsg("Received message no", e.readData());
                }
                size = holder.size();
            }
            System.out.println("Sending false");
        }
        catch (Throwable throwable) {
            System.out.println("Sending false");
            this.setRequestContentEntity(Boolean.FALSE);
            this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "repeat/set"));
            this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
            this.invoke();
            System.out.println("Sent false");
            throw throwable;
        }
        this.setRequestContentEntity(Boolean.FALSE);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "repeat/set"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        this.invoke();
        System.out.println("Sent false");
    }

    private <T> void mediaTest(Class<T> queryClass, Object compare, String queryMedia, MediaType classMedia, MediaType genericTypeMedia) throws JAXRSCommonClient.Fault {
        this.mediaTest(queryClass, compare, (a, b) -> a.equals(b), queryMedia, classMedia, genericTypeMedia);
    }

    private <T> void mediaTest(Class<T> queryClass, Object compare, BiPredicate<Object, Object> comparator, String queryMedia, MediaType classMedia, MediaType genericTypeMedia) throws JAXRSCommonClient.Fault {
        this.mediaTest(queryClass, compare, comparator, queryMedia, classMedia, genericTypeMedia, this.createGenericType(queryClass), "media/data");
    }

    private <T> void mediaTest(Class<T> queryClass, Object compare, BiPredicate<Object, Object> comparator, String queryMedia, MediaType classMedia, MediaType genericTypeMedia, GenericType<?> type, String path) throws JAXRSCommonClient.Fault {
        this.setRequestContentEntity(queryMedia);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "media/set"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, queryMedia);
        this.invoke();
        Holder<InboundSseEvent> holder = this.querySSEEndpoint(path);
        this.assertHolder(queryClass, compare, comparator, classMedia, genericTypeMedia, type, holder);
        JAXRSClientIT.logTrace("readData(", queryClass, ") returned message as expected when register(Consumer<InboundSseEvent>)");
        Holder exception = new Holder();
        holder = this.querySSEEndpoint(path, (a, b) -> a.register(b::set, exception::set));
        this.assertHolder(queryClass, compare, comparator, classMedia, genericTypeMedia, type, holder);
        JAXRSClientIT.logTrace("readData(", queryClass, ") returned message as expected when register(Consumer<InboundSseEvent>, Consumer<Throwable>)");
        Holder<Boolean> finished = new Holder<Boolean>(false);
        Runnable r = () -> finished.set(true);
        holder = this.querySSEEndpoint(path, (a, b) -> a.register(b::set, exception::set, r));
        this.assertHolder(queryClass, compare, comparator, classMedia, genericTypeMedia, type, holder);
        JAXRSClientIT.logTrace("readData(", queryClass, ") returned message as expected register(Consumer<InboundSseEvent>, Consumer<Throwable>, Runnable)");
    }

    private <T> void assertHolder(Class<T> queryClass, Object compare, BiPredicate<Object, Object> comparator, MediaType classMedia, MediaType genericTypeMedia, GenericType<?> type, Holder<InboundSseEvent> holder) throws JAXRSCommonClient.Fault {
        switch (this.mediaTestLevel) {
            case 0: {
                Assertions.assertTrue((boolean)comparator.test(compare, holder.get().readData(queryClass)), (String)("Unexpected message received" + holder.get().readData()));
            }
            case 1: {
                Assertions.assertTrue((boolean)comparator.test(compare, holder.get().readData(type)), (String)("Unexpected message received" + holder.get().readData()));
            }
            case 2: {
                Assertions.assertTrue((boolean)comparator.test(compare, holder.get().readData(queryClass, classMedia)), (String)("Unexpected message received" + holder.get().readData()));
            }
            case 3: {
                Assertions.assertTrue((boolean)comparator.test(compare, holder.get().readData(type, genericTypeMedia)), (String)("Unexpected message received" + holder.get().readData()));
            }
        }
    }

    private <T> GenericType<T> createGenericType(Class<T> clazz) {
        GenericType type = new GenericType(clazz);
        return type;
    }

    private int getServerCount() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "su/count"));
        this.invoke();
        return Integer.parseInt(this.getResponseBody());
    }

    private void resetUnavailableServer() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "su/reset"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "RESET");
        this.invoke();
    }
}

