/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.core.variant;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Variant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 396770878268682189L;

    public JAXRSClientIT() {
        this.setContextRoot("/jaxrs_rs_core_variantTest_web");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void constructorTest1() throws JAXRSCommonClient.Fault {
        String type = "*";
        String subtype = "*";
        String encoding = "ISO8859-15";
        Locale lang = new Locale("en", "US");
        MediaType mt1 = new MediaType();
        Variant vt = new Variant(mt1, lang, encoding);
        JAXRSClientIT.verifyVariant(vt, type, subtype, lang, encoding);
    }

    @Test
    public void constructorTest2() throws JAXRSCommonClient.Fault {
        String type = "application";
        String subtype = "atom+xml";
        String encoding = "";
        Locale lang = null;
        MediaType mt2 = new MediaType(type, subtype);
        Variant vt = new Variant(mt2, lang, encoding);
        JAXRSClientIT.verifyVariant(vt, type, subtype, lang, encoding);
    }

    @Test
    public void constructorTest3() throws JAXRSCommonClient.Fault {
        String type = "application";
        String subtype = "x-www-form-urlencoded";
        HashMap<String, String> params = new HashMap<String, String>();
        String encoding = null;
        Locale lang = null;
        MediaType mt3 = new MediaType(type, subtype, params);
        Variant vt = new Variant(mt3, lang, encoding);
        JAXRSClientIT.verifyVariant(vt, type, subtype, params, new String[0], lang, encoding);
    }

    @Test
    public void constructorMediaStringStringTest() throws JAXRSCommonClient.Fault {
        Variant vt = null;
        String[] encodings = new String[]{null, "CP1250", "UTF8", "ISO8859-2"};
        Locale[] langs = new Locale[]{null, Locale.CANADA, Locale.FRENCH};
        for (String encoding : encodings) {
            for (Locale lang : langs) {
                vt = new Variant(MediaType.APPLICATION_XHTML_XML_TYPE, lang == null ? null : lang.toString(), encoding);
                JAXRSClientIT.verifyVariant(vt, MediaType.APPLICATION_XHTML_XML_TYPE.getType(), MediaType.APPLICATION_XHTML_XML_TYPE.getSubtype(), lang, encoding);
            }
        }
    }

    @Test
    public void constructorMediaStringStringThrowsIllegalArgumentExceptionTest() throws JAXRSCommonClient.Fault {
        try {
            new Variant((MediaType)null, (String)null, (String)null);
            throw new JAXRSCommonClient.Fault("Did not throw IllegalArgumentException for all nulls");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("Thrown IllegalArgumentException as expected");
            return;
        }
    }

    @Test
    public void constructorMediaStringStringStringTest() throws JAXRSCommonClient.Fault {
        Variant vt = null;
        String[] encodings = new String[]{null, "CP1250", "UTF8", "ISO8859-2"};
        Locale[] langs = new Locale[]{null, Locale.CANADA, Locale.FRENCH};
        for (String encoding : encodings) {
            for (Locale lang : langs) {
                vt = new Variant(MediaType.APPLICATION_XHTML_XML_TYPE, lang == null ? null : lang.getLanguage(), lang == null ? null : lang.getCountry(), encoding);
                JAXRSClientIT.verifyVariant(vt, MediaType.APPLICATION_XHTML_XML_TYPE.getType(), MediaType.APPLICATION_XHTML_XML_TYPE.getSubtype(), lang, encoding);
            }
        }
    }

    @Test
    public void constructorMediaStringStringStringThrowsIllegalArgumentExceptionTest() throws JAXRSCommonClient.Fault {
        try {
            new Variant((MediaType)null, (String)null, (String)null, (String)null);
            throw new JAXRSCommonClient.Fault("Did not throw IllegalArgumentException for all nulls");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("Thrown IllegalArgumentException as expected");
            return;
        }
    }

    @Test
    public void constructorMediaStringStringStringStringTest() throws JAXRSCommonClient.Fault {
        Variant vt = null;
        String[] encodings = new String[]{null, "CP1250", "UTF8", "ISO8859-2"};
        Locale[] langs = new Locale[]{null, Locale.CANADA, Locale.FRENCH};
        for (String encoding : encodings) {
            for (Locale lang : langs) {
                vt = new Variant(MediaType.APPLICATION_XHTML_XML_TYPE, lang == null ? null : lang.getLanguage(), lang == null ? null : lang.getCountry(), lang == null ? null : lang.getVariant(), encoding);
                JAXRSClientIT.verifyVariant(vt, MediaType.APPLICATION_XHTML_XML_TYPE.getType(), MediaType.APPLICATION_XHTML_XML_TYPE.getSubtype(), lang, encoding);
            }
        }
    }

    @Test
    public void constructorMediaStringStringStringStringThrowsIllegalArgumentExceptionTest() throws JAXRSCommonClient.Fault {
        try {
            new Variant((MediaType)null, (String)null, (String)null, (String)null, (String)null);
            throw new JAXRSCommonClient.Fault("Did not throw IllegalArgumentException for all nulls");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("Thrown IllegalArgumentException as expected");
            return;
        }
    }

    @Test
    public void equalTest1() throws JAXRSCommonClient.Fault {
        StringBuffer sb = new StringBuffer();
        String type = "*";
        String subtype = "*";
        MediaType mt1 = new MediaType();
        boolean pass = JAXRSClientIT.checkMediaTypeForEqualTest1(sb, mt1);
        MediaType mt2 = new MediaType(type, subtype);
        Assertions.assertTrue((boolean)(pass &= JAXRSClientIT.checkMediaTypeForEqualTest1(sb, mt2)), (String)("At least one assertion failed: " + sb.toString()));
    }

    private static boolean checkMediaTypeForEqualTest1(StringBuffer sb, MediaType type) {
        String encoding = "ISO8859-15";
        Locale lang1 = new Locale("en", "US");
        Locale lang2 = null;
        Boolean pass = true;
        Variant vt1 = new Variant(type, lang1, encoding);
        Variant vt2 = new Variant(type, lang2, encoding);
        if (vt1.equals((Object)vt2)) {
            pass = false;
            sb.append("Equals Test1 Failed" + newline);
        }
        if (vt1.hashCode() == vt2.hashCode()) {
            sb.append("hasCode Test1 Failed: vt1.hashCode()=" + vt1.hashCode() + newline);
            sb.append("                      vt2.hashCode()=" + vt2.hashCode() + newline);
            pass = false;
        }
        return pass;
    }

    @Test
    public void equalsTest2() throws JAXRSCommonClient.Fault {
        StringBuffer sb = new StringBuffer();
        Boolean pass = true;
        String type = "application";
        String subtype = "atom+xml";
        MediaType mt1 = new MediaType(type, subtype);
        Locale lang = null;
        String encoding = "";
        Variant vt1 = new Variant(mt1, lang, encoding);
        String subtype1 = "xml";
        MediaType mt2 = new MediaType(type, subtype1);
        Variant vt2 = new Variant(mt2, lang, encoding);
        if (vt1.equals((Object)vt2)) {
            pass = false;
            sb.append("Equals Test2 Failed" + newline);
        }
        if (vt1.hashCode() == vt2.hashCode()) {
            sb.append("hasCode Test2 Failed: vt1.hashCode()=" + vt1.hashCode() + newline);
            sb.append("                      vt2.hashCode()=" + vt2.hashCode() + newline);
            pass = false;
        }
        Assertions.assertTrue((boolean)pass, (String)("At least one assertion failed: " + sb.toString()));
    }

    @Test
    public void equalsTest3() throws JAXRSCommonClient.Fault {
        StringBuffer sb = new StringBuffer();
        Boolean pass = true;
        String type = "application";
        String subtype = "x-www-form-urlencoded";
        HashMap params = new HashMap();
        MediaType mt4 = new MediaType(type, subtype, params);
        Locale lang = null;
        String encoding = null;
        Variant vt1 = new Variant(mt4, lang, encoding);
        Variant vt2 = new Variant(mt4, lang, encoding);
        if (!vt1.equals((Object)vt2)) {
            pass = false;
            sb.append("Equals Test3 Failed" + newline);
        }
        if (vt1.hashCode() != vt2.hashCode()) {
            sb.append("hasCode Test3 Failed: vt1.hashCode()=" + vt1.hashCode() + newline);
            sb.append("                      vt2.hashCode()=" + vt2.hashCode() + newline);
            pass = false;
        }
        Assertions.assertTrue((boolean)pass, (String)("At least one assertion failed: " + sb.toString()));
    }

    @Test
    public void languagesTest() throws JAXRSCommonClient.Fault {
        List<String> encodingS = null;
        List<MediaType> mts = null;
        List vts = Variant.languages((Locale[])new Locale[]{new Locale("en", "US"), new Locale("en", "GB"), new Locale("zh", "CN")}).add().build();
        JAXRSClientIT.verifyVariants(vts, mts, this.getLangList(), encodingS);
    }

    @Test
    public void getLanguageStringTest() throws JAXRSCommonClient.Fault {
        Locale[] langs;
        for (Locale lang : langs = new Locale[]{null, Locale.CHINA, Locale.PRC, Locale.CANADA_FRENCH, Locale.GERMAN}) {
            Variant v = new Variant(MediaType.TEXT_PLAIN_TYPE, lang, (String)null);
            if (lang != null) {
                Assertions.assertTrue((boolean)v.getLanguageString().contains(lang.getLanguage()), (String)("Created variant contained " + v.getLanguageString() + "but was expected " + lang.getLanguage()));
                continue;
            }
            Assertions.assertTrue((v.getLanguageString() == null ? 1 : 0) != 0, (String)("#getLanguageString was " + v.getLanguageString() + " expected was null"));
        }
        JAXRSClientIT.logMsg("#getLanguageString returned exected language string");
    }

    @Test
    public void encodingsTest() throws JAXRSCommonClient.Fault {
        String encoding1 = "ISO8859-15";
        String encoding2 = "GB2312";
        String encoding3 = "UTF-8";
        List<String> encodingS = Arrays.asList(encoding1, encoding2, encoding3);
        List<String> langS = null;
        List<MediaType> mts = null;
        List vts = Variant.encodings((String[])new String[]{encoding1, encoding2, encoding3}).add().build();
        JAXRSClientIT.verifyVariants(vts, mts, langS, encodingS);
    }

    @Test
    public void mediaTypesTest() throws JAXRSCommonClient.Fault {
        String type = "application";
        String subtype = "x-www-form-urlencoded";
        MediaType mt = new MediaType(type, subtype);
        type = "application";
        subtype = "atom+xml";
        MediaType mt1 = new MediaType(type, subtype);
        type = "*";
        subtype = "*";
        MediaType mt2 = new MediaType();
        List<String> langS = null;
        List<String> encodingS = null;
        List<MediaType> mts = Arrays.asList(mt, mt1, mt2);
        List vts = Variant.mediaTypes((MediaType[])new MediaType[]{mt, mt1, mt2}).add().build();
        JAXRSClientIT.verifyVariants(vts, mts, langS, encodingS);
    }

    private static void verifyVariants(List<Variant> vts, List<MediaType> mts, List<String> langs, List<String> encodings) throws JAXRSCommonClient.Fault {
        StringBuffer sb = new StringBuffer();
        boolean pass = true;
        for (Variant vt : vts) {
            MediaType mt;
            if (mts != null && (mt = vt.getMediaType()) != null && !mts.contains(mt)) {
                pass = false;
                sb.append("MediaType is not found: " + mt + newline);
            }
            if (langs != null && !langs.contains(vt.getLanguage().toString())) {
                sb.append("Language not found: " + vt.getLanguage() + "." + newline);
            }
            if (encodings == null || encodings.contains(vt.getEncoding())) continue;
            pass = false;
            sb.append("Encoding not found: " + vt.getEncoding() + newline);
        }
        int m = 1;
        int e = 1;
        int l = 1;
        if (mts != null) {
            m = mts.size();
        }
        if (encodings != null) {
            e = encodings.size();
        }
        if (langs != null) {
            l = langs.size();
        }
        if (vts.size() != m * e * l) {
            pass = false;
            sb.append("Number of Variants is incorrect, expecting " + m + "*" + e + "*" + l + ", got " + vts.size() + newline);
        }
        if (!pass) {
            sb.append("Expected language: ");
            if (langs != null) {
                for (String lang : langs) {
                    sb.append(lang + ", ");
                }
                sb.append(newline);
            }
            sb.append("Expected encodings: ");
            if (encodings != null) {
                for (String encoding : encodings) {
                    sb.append(encoding + ", ");
                }
                sb.append(newline);
            }
            sb.append("Expected MediaType: ");
            for (MediaType mt : mts) {
                sb.append(mt.toString() + ", ");
            }
            sb.append(newline);
            throw new JAXRSCommonClient.Fault("at least one assertion failed: " + sb.toString());
        }
    }

    private static void verifyVariant(Variant vt, String type, String subtype, Locale lang, String encoding) throws JAXRSCommonClient.Fault {
        StringBuffer sb = new StringBuffer();
        boolean pass = true;
        MediaType mt = vt.getMediaType();
        if (!JAXRSClientIT.equals(mt.getType(), type)) {
            pass = false;
            JAXRSClientIT.append(sb, "Failed type test.  Expect ", type, mt.getType());
        }
        if (!JAXRSClientIT.equals(mt.getSubtype(), subtype)) {
            pass = false;
            JAXRSClientIT.append(sb, "Failed subtype test.", type, mt.getSubtype());
        }
        if (vt.getLanguage() == null && lang != null) {
            pass = false;
            JAXRSClientIT.append(sb, "Failed langauge test", lang, vt.getLanguage());
        } else if (vt.getLanguage() != null && !vt.getLanguage().toString().equalsIgnoreCase(lang.toString())) {
            pass = false;
            JAXRSClientIT.append(sb, "Failed langauge test.", lang, vt.getLanguage());
        }
        if (encoding == null || encoding.equals("")) {
            if (vt.getEncoding() != null && !vt.getEncoding().equals("")) {
                pass = false;
                JAXRSClientIT.append(sb, "Failed encoding test", encoding, vt.getEncoding());
            }
        } else if (!JAXRSClientIT.equals(vt.getEncoding(), encoding)) {
            pass = false;
            JAXRSClientIT.append(sb, "Failed encoding test.", encoding, vt.getEncoding());
        }
        Assertions.assertTrue((boolean)(pass &= JAXRSClientIT.verifyToString(vt, sb)), (String)("At least one assertion failed: " + sb.toString()));
    }

    private static void verifyVariant(Variant vt, String type, String subtype, Map<String, String> params, String[] pname, Locale lang, String encoding) throws JAXRSCommonClient.Fault {
        StringBuffer sb = new StringBuffer();
        boolean pass = true;
        MediaType mt = vt.getMediaType();
        if (!JAXRSClientIT.equals(mt.getType(), type)) {
            pass = false;
            JAXRSClientIT.append(sb, "Failed type test.", type, mt.getType());
        }
        if (!JAXRSClientIT.equals(mt.getSubtype(), subtype)) {
            pass = false;
            JAXRSClientIT.append(sb, "Failed subtype test.", subtype, mt.getSubtype());
        }
        Map param_actual = mt.getParameters();
        if (params.size() != param_actual.size()) {
            pass = false;
            JAXRSClientIT.append(sb, "Parameters size are different.", params.size(), param_actual.size());
        }
        int i = pname.length;
        int j = 0;
        while (j < i) {
            sb.append("Processing Parameter " + j);
            if (!param_actual.containsKey(pname[j])) {
                pass = false;
                sb.append("Parameter Key " + pname[j] + " not found." + newline);
            } else {
                String tmp = (String)param_actual.get(pname[j]);
                if (JAXRSClientIT.equals(tmp, params.get(pname[j])) || tmp.startsWith("\"") || tmp.equals("\"" + params.get(pname[j]) + "\"")) break;
                pass = false;
                sb.append("Parameter Key ").append(pname[j]).append(" returned different value than expected.").append(newline);
                JAXRSClientIT.append(sb, "", params.get(pname[j]), param_actual.get(pname[j]));
                ++j;
            }
            Assertions.assertTrue((boolean)pass, (String)("At least one assertion failed: " + sb.toString()));
        }
        if (vt.getLanguage() == null) {
            if (lang != null) {
                pass = false;
                JAXRSClientIT.append(sb, "Failed language test.", lang, vt.getLanguage());
            }
        } else if (!JAXRSClientIT.equals(vt.getLanguage(), lang)) {
            pass = false;
            JAXRSClientIT.append(sb, "Failed language test.", lang, vt.getLanguage());
        }
        if (encoding == null || encoding == "") {
            if (vt.getEncoding() != null && !vt.getEncoding().equals("")) {
                pass = false;
                JAXRSClientIT.append(sb, "Failed encoding test.", encoding, vt.getEncoding());
            }
        } else if (!JAXRSClientIT.equals(vt.getEncoding(), encoding)) {
            pass = false;
            JAXRSClientIT.append(sb, "Failed encoding test.", encoding, vt.getEncoding());
        }
        pass &= JAXRSClientIT.verifyToString(vt, sb);
    }

    private static boolean verifyToString(Variant variant, StringBuffer sb) {
        String badPrefix = Variant.class.getName() + "@";
        boolean startsWith = variant.toString().startsWith(badPrefix);
        if (startsWith &= variant.toString().length() <= badPrefix.length() + 8) {
            sb.append("Variant.toString() is not overridden");
        }
        return !startsWith;
    }

    private static void append(StringBuffer sb, Object ... args) {
        sb.append(args[0]);
        sb.append(" Expect ");
        sb.append(args[1]);
        sb.append(" got ");
        sb.append(args[2]);
        sb.append(newline);
    }

    private static <T> boolean equals(T first, T second) {
        return first == null ? null == second : first.equals(second);
    }

    protected List<String> getLangList() {
        return Arrays.asList("en-US", "en-GB", "zh-CN");
    }
}

