/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.ordercolumn;

import com.sun.ts.tests.jpa.core.annotations.ordercolumn.Department;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name="EMPLOYEE")
public class Employee
implements Serializable {
    private int id;
    private String firstName;
    private String lastName;
    private float salary;
    private Department department;

    public Employee() {
    }

    public Employee(int id, String firstName, String lastName, float salary) {
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
        this.salary = salary;
    }

    public Employee(int id, String firstName, String lastName, float salary, Department department) {
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
        this.salary = salary;
        this.department = department;
    }

    @Id
    @Column(name="ID")
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Column(name="FIRSTNAME")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Column(name="LASTNAME")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Column(name="SALARY")
    public float getSalary() {
        return this.salary;
    }

    public void setSalary(float salary) {
        this.salary = salary;
    }

    @ManyToOne(cascade={CascadeType.PERSIST})
    @JoinColumn(name="FK_DEPT")
    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + this.getId());
        result.append(", first: " + this.getFirstName());
        result.append(", last: " + this.getLastName());
        result.append(", salary: " + this.getSalary());
        result.append("]");
        return result.toString();
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (!(o instanceof Employee)) {
            return result;
        }
        Employee other = (Employee)o;
        if (this.getId() == other.getId() && this.getFirstName().equals(other.getFirstName()) && this.getLastName().equals(other.getLastName()) && this.getSalary() == other.getSalary() && this.getDepartment().equals(other.getDepartment())) {
            result = true;
        }
        return result;
    }

    public int hashCode() {
        int myHash = this.getId() + this.getFirstName().hashCode() + this.getLastName().hashCode() + (int)this.getSalary();
        return myHash;
    }
}

