/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.defaultmapping.basictypes;

import ee.jakarta.tck.json.bind.MappingTester;
import ee.jakarta.tck.json.bind.SimpleMappingTester;
import ee.jakarta.tck.json.bind.TypeContainer;
import ee.jakarta.tck.json.bind.defaultmapping.basictypes.model.BooleanContainer;
import ee.jakarta.tck.json.bind.defaultmapping.basictypes.model.ByteContainer;
import ee.jakarta.tck.json.bind.defaultmapping.basictypes.model.CharacterContainer;
import ee.jakarta.tck.json.bind.defaultmapping.basictypes.model.DoubleContainer;
import ee.jakarta.tck.json.bind.defaultmapping.basictypes.model.FloatContainer;
import ee.jakarta.tck.json.bind.defaultmapping.basictypes.model.IntegerContainer;
import ee.jakarta.tck.json.bind.defaultmapping.basictypes.model.LongContainer;
import ee.jakarta.tck.json.bind.defaultmapping.basictypes.model.NumberContainer;
import ee.jakarta.tck.json.bind.defaultmapping.basictypes.model.ShortContainer;
import ee.jakarta.tck.json.bind.defaultmapping.basictypes.model.StringContainer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class BasicJavaTypesMappingTest {
    @Test
    public void testStringMapping() throws Exception {
        MappingTester<String> stringMappingTester = new MappingTester<String>(StringContainer.class);
        stringMappingTester.test("Test String", "\"Test String\"");
        stringMappingTester.test(new String(new byte[]{-17, -69, -65}, StandardCharsets.UTF_8), "\"" + new String(new byte[]{-17, -69, -65}, StandardCharsets.UTF_8) + "\"");
        stringMappingTester.test(new String("Test String".getBytes(), StandardCharsets.UTF_8), "\"" + new String("Test String".getBytes(), StandardCharsets.UTF_8) + "\"");
    }

    @Test
    public void testCharacterMapping() {
        MappingTester<Character> characterMappingTester = new MappingTester<Character>(CharacterContainer.class);
        characterMappingTester.test(Character.valueOf('c'), "\"c\"");
        characterMappingTester.test(Character.valueOf('\u0000'), "\"\\u0000\"");
        characterMappingTester.test(Character.valueOf('\uffff'), "\"\uffff\"");
    }

    @Test
    public void testByteMapping() {
        MappingTester<Byte> byteMappingTester = new MappingTester<Byte>(ByteContainer.class);
        byteMappingTester.test((byte)0, "0");
        byteMappingTester.test((byte)-128, String.valueOf(-128));
        byteMappingTester.test((byte)127, String.valueOf(127));
    }

    @Test
    public void testShortMapping() {
        MappingTester<Short> shortMappingTester = new MappingTester<Short>(ShortContainer.class);
        shortMappingTester.test((short)0, "0");
        shortMappingTester.test((short)Short.MIN_VALUE, String.valueOf(Short.MIN_VALUE));
        shortMappingTester.test((short)Short.MAX_VALUE, String.valueOf(Short.MAX_VALUE));
    }

    @Test
    public void testIntegerMapping() {
        MappingTester<Integer> integerMappingTester = new MappingTester<Integer>(IntegerContainer.class);
        integerMappingTester.test(0, "0");
        integerMappingTester.test(Integer.MIN_VALUE, String.valueOf(Integer.MIN_VALUE));
        integerMappingTester.test(Integer.MAX_VALUE, String.valueOf(Integer.MAX_VALUE));
    }

    @Test
    @Disabled(value="See https://github.com/eclipse-ee4j/jsonb-api/issues/180")
    public void testLongMapping() {
        MappingTester<Long> longMappingTester = new MappingTester<Long>(LongContainer.class);
        longMappingTester.test(0L, "0");
        longMappingTester.test(Long.MIN_VALUE, String.valueOf(Long.MIN_VALUE));
        longMappingTester.test(Long.MAX_VALUE, String.valueOf(Long.MAX_VALUE));
    }

    @Test
    public void testFloatMapping() {
        MappingTester<Float> floatMappingTester = new MappingTester<Float>(FloatContainer.class);
        floatMappingTester.test(Float.valueOf(0.0f), "0.0");
        floatMappingTester.test(Float.valueOf(0.5f), "0.5");
        floatMappingTester.test(Float.valueOf(Float.MIN_VALUE), String.valueOf(Float.MIN_VALUE));
        floatMappingTester.test(Float.valueOf(Float.MAX_VALUE), String.valueOf(Float.MAX_VALUE));
    }

    @Test
    public void testDoubleMapping() {
        MappingTester<Double> doubleMappingTester = new MappingTester<Double>(DoubleContainer.class);
        doubleMappingTester.test(0.0, "0.0");
        doubleMappingTester.test((Double)Double.MIN_VALUE, String.valueOf(Double.MIN_VALUE));
        doubleMappingTester.test((Double)Double.MAX_VALUE, String.valueOf(Double.MAX_VALUE));
    }

    @Test
    public void testBooleanMapping() {
        MappingTester<Boolean> booleanMappingTester = new MappingTester<Boolean>(BooleanContainer.class);
        booleanMappingTester.test(true, "true");
        booleanMappingTester.test(false, "false");
        booleanMappingTester.test(Boolean.TRUE, Boolean.TRUE.toString());
        booleanMappingTester.test(Boolean.FALSE, Boolean.FALSE.toString());
    }

    @Test
    public void testNumberMapping() {
        new SimpleMappingTester<TypeContainer>(NumberContainer.class, TypeContainer.class).test(new NumberContainer(), "\\{\\s*\"instance\"\\s*:\\s*0[\\.0]?+\\s*}", "{ \"instance\" : 0 }", new NumberContainer(){
            {
                this.setInstance(new BigDecimal("0"));
            }
        });
    }
}

