/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox;

import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSConnectionRequestInfo;
import com.sun.ts.tests.common.connector.whitebox.TSDataSource;
import jakarta.resource.Referenceable;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnectionFactory;
import java.io.Serializable;
import java.util.Vector;
import javax.naming.Reference;

public class TSEISDataSource
implements TSDataSource,
Serializable,
Referenceable {
    private String desc;
    private ManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private Reference reference;

    public TSEISDataSource(ManagedConnectionFactory mcf, ConnectionManager cm) {
        this.mcf = mcf;
        if (cm != null) {
            this.cm = cm;
        }
    }

    @Override
    public TSConnection getConnection() throws Exception {
        try {
            return (TSConnection)this.cm.allocateConnection(this.mcf, null);
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
    }

    @Override
    public TSConnection getConnection(String username, String password) throws Exception {
        try {
            TSConnectionRequestInfo info = new TSConnectionRequestInfo(username, password);
            return (TSConnection)this.cm.allocateConnection(this.mcf, (ConnectionRequestInfo)info);
        }
        catch (ResourceException ex) {
            throw new Exception(ex.getMessage());
        }
    }

    @Override
    public Vector getLog() {
        return ConnectorStatus.getConnectorStatus().getLogVector();
    }

    @Override
    public Vector getStateLog() {
        return ConnectorStatus.getConnectorStatus().getStateLogVector();
    }

    @Override
    public boolean checkConnectionManager() {
        return this.cm instanceof Serializable;
    }

    @Override
    public void clearLog() {
    }

    @Override
    public void setLogFlag(boolean b) {
        ConnectorStatus.getConnectorStatus().setLogFlag(b);
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Reference getReference() {
        return this.reference;
    }
}

