/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.tool.FileChooser;
import com.sun.javatest.tool.TestSuiteChooser;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.tool.jthelp.HelpBroker;
import com.sun.javatest.tool.jthelp.JTHelpBroker;
import com.sun.javatest.util.FileInfoCache;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;

public class SelectedWorkDirApprover {
    static final String JTM = ".jtm";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(SelectedWorkDirApprover.class);
    private FileInfoCache cache = new FileInfoCache();
    private int mode;
    private TestSuiteChooser testSuiteChooser;
    private WorkDirectory workDir;
    private Component parent;
    private boolean approveOpenSelection_dirExists = false;
    private UIFactory uif = new UIFactory(SelectedWorkDirApprover.class, (HelpBroker)new JTHelpBroker());
    private boolean allowNoTemplate = false;
    private boolean openInsteadOfCreate = false;

    public SelectedWorkDirApprover(int mode, Component parent) {
        this.mode = mode;
        this.parent = parent;
    }

    public static boolean isIgnoreable(File f) {
        return f.getName().isEmpty();
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public boolean approveNewSelection(File dir, TestSuite testSuite) {
        if (testSuite == null) {
            throw new IllegalStateException();
        }
        if (dir.exists()) {
            if (this.isWorkDirectory(dir)) {
                return this.approveNewSelection_workDirExists(dir, testSuite);
            }
            if (dir.isDirectory()) {
                return this.approveNewSelection_dirExists(dir, testSuite);
            }
        } else {
            return this.approveNewSelection_dirNotFound(dir, testSuite);
        }
        this.uif.showLiteralError(null, i18n.getString("wdc.notADir.err", (Object)dir));
        return false;
    }

    private boolean approveNewSelection_workDirExists(File dir, TestSuite testSuite) {
        int option = this.uif.showLiteralYesNoDialog(i18n.getString("wdc.exists_openIt.title"), i18n.getString("wdc.exists_openIt.txt"));
        if (option != 0) {
            return false;
        }
        try {
            this.workDir = WorkDirectory.open(dir, testSuite);
            if (testSuite != null && this.workDir.getTestSuite() != testSuite) {
                this.uif.showLiteralError(null, i18n.getString("wdc.wrongTS.err"));
                return false;
            }
            this.openInsteadOfCreate = true;
            return true;
        }
        catch (FileNotFoundException e) {
            this.uif.showLiteralError(null, i18n.getString("wdc.cantFindDir.err", (Object)dir.getPath()));
            return false;
        }
        catch (WorkDirectory.MismatchFault e) {
            this.uif.showLiteralError(null, i18n.getString("wdc.wrongTS.err"));
            return false;
        }
        catch (WorkDirectory.Fault e) {
            this.uif.showLiteralError(null, i18n.getString("wdc.cantOpen.err", (Object)e.getMessage()));
            return false;
        }
    }

    private boolean approveNewSelection_dirExists(File dir, TestSuite testSuite) {
        int option = this.uif.showYesNoDialog("wdc.existsNotWorkDir_convert");
        if (option != 0) {
            return false;
        }
        try {
            this.workDir = WorkDirectory.convert(dir, testSuite);
            return true;
        }
        catch (FileNotFoundException e) {
            this.uif.showError("wdc.cantFindDir", (Object)dir.getPath());
            return false;
        }
        catch (WorkDirectory.Fault e) {
            this.uif.showError("wdc.cantConvert", (Object)e.getMessage());
            return false;
        }
    }

    private boolean approveNewSelection_dirNotFound(File dir, TestSuite testSuite) {
        try {
            this.workDir = WorkDirectory.create(dir, testSuite);
            return true;
        }
        catch (WorkDirectory.Fault e) {
            this.uif.showError("wdc.cantCreate", (Object)e.getMessage());
            return false;
        }
    }

    public boolean approveOpenSelection(File dir, TestSuite testSuite) {
        if (dir.exists()) {
            if (this.isWorkDirectory(dir)) {
                return this.approveOpenSelection_workDirExists(dir, testSuite);
            }
            if (dir.isDirectory()) {
                this.approveOpenSelection_dirExists = false;
                return this.approveOpenSelection_dirExists;
            }
        } else {
            return this.approveOpenSelection_dirNotFound(dir, testSuite);
        }
        this.uif.showLiteralError(null, i18n.getString("wdc.notADir.err", (Object)dir));
        return false;
    }

    private boolean approveOpenSelection_workDirExists(File dir, TestSuite testSuite) {
        try {
            switch (this.mode) {
                case 2: {
                    if (testSuite == null) {
                        throw new IllegalStateException();
                    }
                    this.workDir = WorkDirectory.open(dir, testSuite);
                    if (this.workDir.getTestSuite() == testSuite) break;
                    this.uif.showLiteralError(null, i18n.getString("wdc.wrongTS.err"));
                    return false;
                }
                case 1: {
                    try {
                        this.workDir = WorkDirectory.open(dir);
                        break;
                    }
                    catch (WorkDirectory.TestSuiteFault e) {
                        int option = this.uif.showYesNoDialog("wdc.tsError_specifyNew", (Object)e.getMessage());
                        if (option != 0) {
                            return false;
                        }
                        if (this.testSuiteChooser == null) {
                            this.testSuiteChooser = new TestSuiteChooser();
                        }
                        if (testSuite != null) {
                            this.testSuiteChooser.setSelectedTestSuite(testSuite);
                        }
                        this.testSuiteChooser.showDialog(this.parent);
                        TestSuite newTestSuite = this.testSuiteChooser.getSelectedTestSuite();
                        if (newTestSuite == null) {
                            return false;
                        }
                        this.workDir = WorkDirectory.open(dir, newTestSuite);
                        break;
                    }
                    catch (WorkDirectory.TemplateMissingFault e) {
                        int option = this.uif.showYesNoDialog("wdc.tsError_specifyTemplate", (Object)e.getMessage());
                        if (option != 0) {
                            return false;
                        }
                        FileChooser chooser = new FileChooser();
                        chooser.addChoosableExtension(JTM, this.uif.getI18NString("ce.jtmFiles"));
                        chooser.showOpenDialog(this.parent);
                        File newTemplate = chooser.getSelectedFile();
                        if (newTemplate == null) {
                            return false;
                        }
                        WorkDirectory.changeTemplate(dir, newTemplate);
                        this.workDir = WorkDirectory.open(dir);
                    }
                }
            }
            return true;
        }
        catch (FileNotFoundException e) {
            this.uif.showLiteralError(null, i18n.getString("wdc.cantFindDir.err", (Object)dir.getPath()));
        }
        catch (WorkDirectory.MismatchFault e) {
            this.uif.showLiteralError(null, i18n.getString("wdc.wrongTS.err"));
        }
        catch (WorkDirectory.Fault e) {
            this.uif.showLiteralError(null, i18n.getString("wdc.cantOpen.err", (Object)e.getMessage()));
        }
        return false;
    }

    private boolean approveOpenSelection_dirNotFound(File dir, TestSuite testSuite) {
        if (testSuite == null) {
            this.uif.showError("wdc.notFound_noTestSuite");
            return false;
        }
        if (!this.allowNoTemplate) {
            this.uif.showLiteralError(null, i18n.getString("wdc.cantFindDir.err", (Object)dir.getPath()));
            return false;
        }
        int option = this.uif.showYesNoDialog("wdc.notFound_createIt", (Object)testSuite.getPath());
        if (option != 0) {
            return false;
        }
        try {
            this.workDir = WorkDirectory.create(dir, testSuite);
        }
        catch (WorkDirectory.Fault e) {
            this.uif.showError("wdc.cantCreate", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public boolean isWorkDirectory(File f) {
        if (SelectedWorkDirApprover.isIgnoreable(f)) {
            return false;
        }
        Boolean b = this.cache.get(f);
        if (b == null) {
            boolean v = WorkDirectory.isWorkDirectory(f);
            this.cache.put(f, v);
            return v;
        }
        return b;
    }

    public boolean isApprovedOpenSelection_dirExists() {
        return this.approveOpenSelection_dirExists;
    }

    public WorkDirectory getWorkDirectory() {
        return this.workDir;
    }

    void setAllowNoTemplate(boolean allowNoTemplate) {
        this.allowNoTemplate = allowNoTemplate;
    }

    public boolean isOpenedInsteadOfCreated() {
        return this.openInsteadOfCreate;
    }
}

