/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.report.HTMLReport;
import com.sun.javatest.report.HTMLSection;
import com.sun.javatest.report.ReportSettings;
import com.sun.javatest.report.ReportWriter;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

class StatisticsSection
extends HTMLSection {
    private final I18NResourceBundle i18n;
    private final String[] headings;
    private TestResultTable resultTable;
    private File[] initFiles;
    private Map<String, int[]> keywordTable = new HashMap<String, int[]>();
    private int[] statusTotals = new int[4];

    StatisticsSection(HTMLReport parent, ReportSettings set, File dir, I18NResourceBundle i18n) {
        super(i18n.getString("stats.title"), set, dir, parent);
        this.i18n = i18n;
        this.headings = new String[]{i18n.getString("stats.heading.passed"), i18n.getString("stats.heading.failed"), i18n.getString("stats.heading.error"), i18n.getString("stats.heading.notRun")};
        this.initFiles = this.settings.getInitialFiles();
        this.resultTable = this.settings.getInterview().getWorkDirectory().getTestResultTable();
        TestResultTable.TreeIterator iter = null;
        try {
            iter = this.initFiles == null ? this.resultTable.getIterator(this.settings.filter) : this.resultTable.getIterator(this.initFiles, this.settings.filter);
        }
        catch (TestResultTable.Fault f) {
            throw new JavaTestError(i18n.getString("stats.testResult.err"));
        }
        while (iter.hasNext()) {
            TestResult tr = (TestResult)iter.next();
            try {
                Status s = tr.getStatus();
                TestDescription td = tr.getDescription();
                this.processKeywords(s.getType(), td);
            }
            catch (TestResult.Fault fault) {}
        }
        this.settings.getFilterStatsIfReportIsNotForAllTests().entrySet().forEach(e -> ((ArrayList)e.getValue()).forEach(td -> this.processKeywords(3, (TestDescription)td)));
    }

    private void processKeywords(int statusType, TestDescription td) {
        Object[] keys = td.getKeywords();
        Arrays.sort(keys);
        String sortedKeys = StringArray.join((String[])keys);
        int[] v = this.keywordTable.get(sortedKeys);
        if (v == null) {
            v = new int[4];
            this.keywordTable.put(sortedKeys, v);
        }
        int n = statusType;
        v[n] = v[n] + 1;
        int n2 = statusType;
        this.statusTotals[n2] = this.statusTotals[n2] + 1;
    }

    @Override
    void writeContents(ReportWriter repWriter) throws IOException {
        super.writeContents(repWriter);
        repWriter.startTag("ul");
        repWriter.startTag("li");
        repWriter.writeLink("#" + HTMLReport.anchors[4], this.i18n.getString("stats.keywordValue"));
        repWriter.endTag("ul");
        repWriter.newLine();
    }

    @Override
    void writeSummary(ReportWriter repWriter) throws IOException {
        super.writeSummary(repWriter);
        this.writeKeywordSummary(repWriter);
    }

    private void writeKeywordSummary(ReportWriter out) throws IOException {
        int c;
        int ncols = 2;
        for (int statusTotal1 : this.statusTotals) {
            if (statusTotal1 <= 0) continue;
            ++ncols;
        }
        String[] head = new String[ncols];
        int c2 = 0;
        head[c2++] = this.i18n.getString("stats.keyword");
        for (int i = 0; i < this.statusTotals.length; ++i) {
            if (this.statusTotals[i] <= 0) continue;
            head[c2++] = this.headings[i];
        }
        head[c2] = this.i18n.getString("stats.total");
        Vector<String[]> v = new Vector<String[]>();
        block2: for (Map.Entry<String, int[]> e : this.keywordTable.entrySet()) {
            int i;
            String k = e.getKey();
            int[] kv = e.getValue();
            String[] newEntry = new String[ncols];
            c = 0;
            int total = 0;
            newEntry[c++] = k;
            for (i = 0; i < kv.length; ++i) {
                if (this.statusTotals[i] != 0) {
                    newEntry[c++] = kv[i] == 0 ? "" : Integer.toString(kv[i]);
                }
                total += kv[i];
            }
            newEntry[c] = Integer.toString(total);
            for (i = 0; i < v.size(); ++i) {
                String[] entry = (String[])v.get(i);
                if (k.compareTo(entry[0]) >= 0) continue;
                v.add(i, newEntry);
                continue block2;
            }
            v.add(newEntry);
        }
        String[] totalsEntry = new String[ncols];
        int c3 = 0;
        int total = 0;
        totalsEntry[c3++] = this.i18n.getString("stats.total");
        int[] nArray = this.statusTotals;
        int newEntry = nArray.length;
        for (c = 0; c < newEntry; ++c) {
            int statusTotal = nArray[c];
            if (statusTotal != 0) {
                totalsEntry[c3++] = Integer.toString(statusTotal);
            }
            total += statusTotal;
        }
        totalsEntry[c3] = Integer.toString(total);
        v.add(totalsEntry);
        String[][] table = (String[][])v.toArray((T[])new String[v.size()][]);
        out.startTag("h3");
        out.writeLinkDestination(HTMLReport.anchors[4], this.i18n.getString("stats.keywordValue"));
        out.endTag("h3");
        out.newLine();
        out.startTag("table");
        out.writeAttr("border", 1);
        out.startTag("tr");
        for (c3 = 0; c3 < head.length; ++c3) {
            out.startTag("th");
            out.writeAttr("style", c3 == 0 ? "text-align:left;" : "text-align:right;");
            out.write(head[c3]);
            out.endTag("th");
        }
        out.endTag("tr");
        for (String[] aTable : table) {
            out.startTag("tr");
            for (c = 0; c < aTable.length; ++c) {
                out.startTag("td");
                out.writeAttr("style", c == 0 ? "text-align:left;" : "text-align:right;");
                if (aTable[c] == null || aTable[c].isEmpty()) {
                    out.writeEntity("&nbsp;");
                } else {
                    out.write(aTable[c]);
                }
                out.endTag("td");
            }
            out.endTag("tr");
        }
        out.endTag("table");
    }
}

