/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.util.StringArray;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;

public class ConfigValuesMap {
    private boolean tracing;
    private PrintStream traceOut;
    private String[] fromValues;
    private String[] toValues;

    public ConfigValuesMap(Reader r) throws IOException {
        String line;
        BufferedReader in = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        Vector<String> from = new Vector<String>();
        Vector<String> to = new Vector<String>();
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            String[] row = StringArray.split(line);
            if (row.length < 2) {
                throw new IOException("format error in map file, line is: " + line);
            }
            from.add(row[0].replaceAll("\\Q\\u0020\\E", " "));
            to.add(row[1].replaceAll("\\Q\\u0020\\E", " "));
        }
        in.close();
        this.fromValues = from.toArray(new String[from.size()]);
        this.toValues = to.toArray(new String[to.size()]);
    }

    public ConfigValuesMap(Map<String, String> map) {
        this.fromValues = new String[map.size()];
        this.toValues = new String[map.size()];
        int index = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.fromValues[index] = entry.getKey();
            this.toValues[index] = entry.getValue();
            ++index;
        }
    }

    public static ConfigValuesMap readFile(String name) throws IOException {
        try {
            Class<Reader> clazz = Class.forName("java.io.FileReader").asSubclass(Reader.class);
            Reader r = clazz.getConstructor(String.class).newInstance(name);
            return new ConfigValuesMap(r);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("file system not accessible (" + e + ")");
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw ConfigValuesMap.fileSystemProblem(t);
        }
        catch (Error | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw ConfigValuesMap.fileSystemProblem(e);
        }
    }

    public static ConfigValuesMap readURL(URL u) throws IOException {
        return new ConfigValuesMap(new InputStreamReader(u.openStream(), StandardCharsets.UTF_8.name()));
    }

    public static ConfigValuesMap readFileOrURL(String name) throws IOException {
        if (name.length() > 5 && name.substring(0, 5).equalsIgnoreCase("http:")) {
            return ConfigValuesMap.readURL(new URL(name));
        }
        return ConfigValuesMap.readFile(name);
    }

    private static IOException fileSystemProblem(Throwable t) {
        return new IOException("problem accessing file system: " + t);
    }

    public void map(String ... args) {
        if (this.fromValues == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            for (int j = 0; j < this.fromValues.length; ++j) {
                String f = this.fromValues[j];
                String t = this.toValues[j];
                int index = arg.indexOf(f);
                while (index != -1) {
                    arg = arg.substring(0, index) + t + arg.substring(index + f.length());
                    index = arg.indexOf(f, index + t.length());
                }
            }
            if (this.tracing && !Objects.equals(arg, args[i])) {
                this.traceOut.println("MAPARG-from: " + args[i]);
                this.traceOut.println("MAPARG-to:   " + arg);
            }
            args[i] = arg;
        }
    }

    public Enumeration<String[]> enumerate() {
        Vector<String[]> v = new Vector<String[]>(this.fromValues.length);
        for (int i = 0; i < this.fromValues.length; ++i) {
            v.add(new String[]{this.fromValues[i], this.toValues[i]});
        }
        return v.elements();
    }

    public void setTracing(boolean state, PrintStream out) {
        this.tracing = state;
        this.traceOut = state ? out : null;
    }
}

