/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.provider.overridestandard;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.impl.StringStreamingOutput;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.provider.overridestandard.AbstractProvider;
import ee.jakarta.tck.ws.rs.spec.provider.overridestandard.Resource;
import ee.jakarta.tck.ws.rs.spec.provider.overridestandard.TSAppConfig;
import ee.jakarta.tck.ws.rs.spec.provider.overridestandard.TckBooleanProvider;
import ee.jakarta.tck.ws.rs.spec.provider.overridestandard.TckByteArrayProvider;
import ee.jakarta.tck.ws.rs.spec.provider.overridestandard.TckCharacterProvider;
import ee.jakarta.tck.ws.rs.spec.provider.overridestandard.TckDataSourceProvider;
import ee.jakarta.tck.ws.rs.spec.provider.overridestandard.TckFileProvider;
import ee.jakarta.tck.ws.rs.spec.provider.overridestandard.TckInputStreamProvider;
import ee.jakarta.tck.ws.rs.spec.provider.overridestandard.TckJaxbProvider;
import ee.jakarta.tck.ws.rs.spec.provider.overridestandard.TckMapProvider;
import ee.jakarta.tck.ws.rs.spec.provider.overridestandard.TckNumberProvider;
import ee.jakarta.tck.ws.rs.spec.provider.overridestandard.TckReaderProvider;
import ee.jakarta.tck.ws.rs.spec.provider.overridestandard.TckSourceProvider;
import ee.jakarta.tck.ws.rs.spec.provider.overridestandard.TckStreamingOutputProvider;
import ee.jakarta.tck.ws.rs.spec.provider.overridestandard.TckStringProvider;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Deflater;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    String[] methodsAll = new String[]{"bytearray", "string", "inputstream", "reader", "file", "datasource", "source", "jaxb", "streamingoutput"};

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_provider_overridestandard_web/resource");
    }

    private void setPropertyAndInvoke(String resourceMethod, MediaType md) throws JAXRSCommonClient.Fault {
        String ct = JAXRSClientIT.buildContentType(md);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, resourceMethod));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, ct);
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(md));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, resourceMethod);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING_IGNORE_CASE, "Tck" + resourceMethod + "Reader");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING_IGNORE_CASE, "Tck" + resourceMethod + "Writer");
        this.invoke();
    }

    void setPropertyAndInvokeEncoded(String resourceMethod) throws JAXRSCommonClient.Fault {
        byte[] buffer = new byte[20];
        Deflater deflater = new Deflater();
        deflater.setInput(resourceMethod.getBytes());
        deflater.finish();
        deflater.deflate(buffer);
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Transfer-Encoding: deflate");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Transfer-Encoding: chunked");
        this.setProperty(JAXRSCommonClient.Property.CONTENT, new String(buffer));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, resourceMethod));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, "501");
        this.invoke();
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/provider/overridestandard/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_provider_overridestandard_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, AbstractProvider.class, TckBooleanProvider.class, TckByteArrayProvider.class, TckCharacterProvider.class, TckDataSourceProvider.class, TckDataSourceProvider.class, TckFileProvider.class, TckInputStreamProvider.class, TckJaxbProvider.class, TckMapProvider.class, TckNumberProvider.class, TckReaderProvider.class, TckSourceProvider.class, TckStreamingOutputProvider.class, TckStringProvider.class, StringStreamingOutput.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    @Tag(value="xml_binding")
    public void readWriteByteArrayProviderTest() throws JAXRSCommonClient.Fault {
        this.setPropertyAndInvoke("bytearray", MediaType.APPLICATION_XML_TYPE);
    }

    @Test
    @Tag(value="xml_binding")
    public void readWriteStringProviderTest() throws JAXRSCommonClient.Fault {
        this.setPropertyAndInvoke("string", MediaType.APPLICATION_XML_TYPE);
    }

    @Test
    @Tag(value="xml_binding")
    public void readWriteInputStreamProviderTest() throws JAXRSCommonClient.Fault {
        this.setPropertyAndInvoke("inputstream", MediaType.APPLICATION_XML_TYPE);
    }

    @Test
    @Tag(value="xml_binding")
    public void readWriteReaderProviderTest() throws JAXRSCommonClient.Fault {
        this.setPropertyAndInvoke("reader", MediaType.APPLICATION_XML_TYPE);
    }

    @Test
    @Tag(value="xml_binding")
    public void readWriteFileProviderTest() throws JAXRSCommonClient.Fault {
        this.setPropertyAndInvoke("file", MediaType.APPLICATION_XML_TYPE);
    }

    @Test
    @Tag(value="xml_binding")
    public void readWriteDataSourceProviderTest() throws JAXRSCommonClient.Fault {
        this.setPropertyAndInvoke("datasource", MediaType.APPLICATION_XML_TYPE);
    }

    @Test
    @Tag(value="xml_binding")
    public void readWriteSourceProviderTest() throws JAXRSCommonClient.Fault {
        this.setPropertyAndInvoke("source", MediaType.APPLICATION_XML_TYPE);
    }

    @Test
    @Tag(value="xml_binding")
    public void readWriteJaxbProviderTest() throws JAXRSCommonClient.Fault {
        this.setPropertyAndInvoke("jaxb", MediaType.APPLICATION_XML_TYPE);
    }

    @Test
    @Tag(value="xml_binding")
    public void readWriteStreamingOutputProviderTest() throws JAXRSCommonClient.Fault {
        this.setPropertyAndInvoke("streamingoutput", MediaType.APPLICATION_XML_TYPE);
    }

    @Test
    @Tag(value="xml_binding")
    public void readWriteMapProviderTest() throws JAXRSCommonClient.Fault {
        this.setPropertyAndInvoke("map", MediaType.APPLICATION_FORM_URLENCODED_TYPE);
    }

    @Test
    @Tag(value="xml_binding")
    public void readWriteBooleanProviderTest() throws JAXRSCommonClient.Fault {
        MediaType mt = MediaType.TEXT_PLAIN_TYPE;
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "boolean"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(mt));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(mt));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "false");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING_IGNORE_CASE, "true");
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void readWriteCharacterProviderTest() throws JAXRSCommonClient.Fault {
        MediaType mt = MediaType.TEXT_PLAIN_TYPE;
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "character"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(mt));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(mt));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "a");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING_IGNORE_CASE, "c");
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void readWriteIntegerProviderTest() throws JAXRSCommonClient.Fault {
        MediaType mt = MediaType.TEXT_PLAIN_TYPE;
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "number"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(mt));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(mt));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "0");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING_IGNORE_CASE, "2");
        this.invoke();
    }
}

