/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.client.clientresponsecontext;

import ee.jakarta.tck.ws.rs.api.client.clientresponsecontext.ContextProvider;
import ee.jakarta.tck.ws.rs.api.client.clientresponsecontext.NullStringBeanRuntimeDelegate;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.provider.StringBean;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanRuntimeDelegate;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = -9134505693194656037L;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void getAllowedMethodsTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                Set map = responseContext.getAllowedMethods();
                JAXRSCommonClient.logMsg("found methods:", JaxrsUtil.iterableToString(" ", map));
                Assertions.assertTrue((map.size() == 2 ? 1 : 0) != 0, (String)"Allowed mthods were not set");
                Assertions.assertTrue((boolean)map.contains("OPTIONS"), (String)"OPTIONS allowed method were not found");
                Assertions.assertTrue((boolean)map.contains("GET"), (String)"GET allowed method was not found");
            }
        };
        Response response = Response.ok().header("Allow", (Object)"get").header("Allow", (Object)"options").build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.OK, provider);
    }

    @Test
    public void getCookiesTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                Map map = responseContext.getCookies();
                Assertions.assertTrue((map.size() == 2 ? 1 : 0) != 0, (String)"Cookies were not set");
            }
        };
        NewCookie cookie1 = new NewCookie("cookie1", "cookie1");
        NewCookie cookie2 = new NewCookie("cookie2", "cookie2");
        Response response = Response.ok().cookie(new NewCookie[]{cookie1}).cookie(new NewCookie[]{cookie2}).build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.OK, provider);
    }

    @Test
    public void getDateTest() throws JAXRSCommonClient.Fault {
        final Date date = JAXRSClientIT.getNewDate();
        ContextProvider in = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                Assertions.assertTrue((boolean)date.equals(responseContext.getDate()), (String)("The #getDate " + responseContext.getDate() + " is not equal to what is inserted to the response " + date));
                JAXRSCommonClient.logMsg("Found #getDate()=", responseContext.getDate());
            }
        };
        Response response = Response.ok().header("Date", (Object)date).build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.OK, in);
    }

    @Test
    public void getEntityStreamTest() throws JAXRSCommonClient.Fault {
        String entity = "ENTITY";
        ContextProvider in = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                InputStream stream = responseContext.getEntityStream();
                Assertions.assertTrue((stream != null ? 1 : 0) != 0, (String)"the #getEntityStream is null");
                InputStreamReader isr = new InputStreamReader(stream);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                try {
                    line = br.readLine();
                }
                catch (IOException e) {
                    throw new JAXRSCommonClient.Fault(e);
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
                Assertions.assertTrue((boolean)"ENTITY".equals(line), (String)("The #getEntityStream " + line + " is not equal to what is inserted to the response: ENTITY"));
                JAXRSCommonClient.logMsg("Found #getEntityStream()=", line);
                responseContext.setEntityStream((InputStream)new ByteArrayInputStream("ENTITY".getBytes()));
            }
        };
        Response response = Response.ok((Object)"ENTITY").build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.OK, in);
    }

    @Test
    public void getEntityTagTest() throws JAXRSCommonClient.Fault {
        String value = "EntityTagValue";
        EntityTag tag = new EntityTag("EntityTagValue");
        ContextProvider in = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                EntityTag etag = responseContext.getEntityTag();
                Assertions.assertTrue((etag != null ? 1 : 0) != 0, (String)"the #getEntityTag is null");
                Assertions.assertTrue((boolean)"EntityTagValue".equals(etag.getValue()), (String)("The #getEntityTag " + etag.getValue() + " is not equal to what is inserted to the response: EntityTagValue"));
                JAXRSCommonClient.logMsg("Found #getEntityTag()=", "EntityTagValue");
            }
        };
        Response response = Response.ok().tag(tag).build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.OK, in);
    }

    @Test
    public void getHeadersTest() throws JAXRSCommonClient.Fault {
        String header1 = "header1";
        String value1 = "value1";
        String header2 = "header2";
        String value2 = "value2";
        ContextProvider in = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                MultivaluedMap headers = responseContext.getHeaders();
                Assertions.assertTrue((headers != null ? 1 : 0) != 0, (String)"the #getHeaders is null");
                Assertions.assertTrue((headers.size() == 2 ? 1 : 0) != 0, (String)("the #getHeaders size is " + headers.size() + " expected 2"));
                Assertions.assertTrue((boolean)"value1".equals(headers.getFirst((Object)"header1")), (String)("#getHeaders was supposed to containheader1:value1 header, but header1 is " + (String)headers.getFirst((Object)"header1")));
                JAXRSCommonClient.logMsg("Found #getHeaders()={", "header1", ":", "value1", "}");
            }
        };
        Response response = Response.ok().header("header1", (Object)"value1").header("header2", (Object)"value2").build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.OK, in);
    }

    @Test
    public void getHeadersIsMutableTest() throws JAXRSCommonClient.Fault {
        String header1 = "header1";
        String value1 = "value1";
        ContextProvider in = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                MultivaluedMap headers = responseContext.getHeaders();
                headers.add((Object)"header1", (Object)"value1");
                headers = responseContext.getHeaders();
                Assertions.assertTrue((headers != null ? 1 : 0) != 0, (String)"the #getHeaders is null");
                Assertions.assertTrue((headers.size() == 1 ? 1 : 0) != 0, (String)("the #getHeaders size is " + headers.size() + " expected 1"));
                Assertions.assertTrue((boolean)"value1".equals(headers.getFirst((Object)"header1")), (String)("#getHeaders was supposed to contain header1:value1 header, but header1 is " + (String)headers.getFirst((Object)"header1")));
                JAXRSCommonClient.logMsg("#getHeaders is mutable as expected");
            }
        };
        Response response = Response.ok().build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.OK, in);
    }

    @Test
    public void getHeaderStringIsNullTest() throws JAXRSCommonClient.Fault {
        String header1 = "header1";
        ContextProvider in = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                String header = responseContext.getHeaderString("header1");
                Assertions.assertTrue((header == null ? 1 : 0) != 0, (String)"the #getHeaderString is NOT null");
                JAXRSCommonClient.logMsg("#getHeaderString is null as expected");
            }
        };
        Response response = Response.ok().build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.OK, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public <T> void getHeaderStringIsEmptyTest() throws JAXRSCommonClient.Fault {
        String header1 = "header1";
        RuntimeDelegate original = RuntimeDelegate.getInstance();
        RuntimeDelegate.setInstance((RuntimeDelegate)new NullStringBeanRuntimeDelegate(original));
        ContextProvider in = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                String header = responseContext.getHeaderString("header1");
                Assertions.assertTrue((header != null ? 1 : 0) != 0, (String)"the #getHeaderString is null");
                Assertions.assertTrue((boolean)header.equals(""), (String)("the #getHeaderString is NOT empty, but " + header));
                JAXRSCommonClient.logMsg("#getHeaderString is empty string as expected");
            }
        };
        Response response = Response.ok().header("header1", (Object)new StringBean("aa")).build();
        try {
            JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.OK, in);
        }
        finally {
            RuntimeDelegate.setInstance((RuntimeDelegate)original);
            StringBeanRuntimeDelegate.assertNotStringBeanRuntimeDelegate();
        }
    }

    @Test
    public void getHeaderStringTest() throws JAXRSCommonClient.Fault {
        String header1 = "header1";
        String value1 = "value1";
        ContextProvider in = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                String header = responseContext.getHeaderString("header1");
                Assertions.assertTrue((header != null ? 1 : 0) != 0, (String)"the #getHeaderString is null");
                Assertions.assertTrue((boolean)header.equals("value1"), (String)("the #getHeaderString=" + header + " differs from expected value1"));
                JAXRSCommonClient.logMsg("#getHeaderString is", "value1", "as expected");
            }
        };
        Response response = Response.ok().header("header1", (Object)"value1").build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.OK, in);
    }

    @Test
    public void getHeaderStringIsCommaSeparatedTest() throws JAXRSCommonClient.Fault {
        String header1 = "header1";
        String value1 = "value1";
        String value2 = "value2";
        ContextProvider in = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                String header = responseContext.getHeaderString("header1");
                String value3 = "value1,value2";
                String value4 = "value2,value1";
                Assertions.assertTrue((header != null ? 1 : 0) != 0, (String)"the #getHeaderString is null");
                Assertions.assertTrue((header.equals(value3) || header.equals(value4) ? 1 : 0) != 0, (String)("the #getHeaderString=" + header + " differs from expected comma separated combination of value1 and value2"));
                JAXRSCommonClient.logMsg("#getHeaderString is comma separated combination of", "value1", "and", "value2", "as expected");
            }
        };
        Response response = Response.ok().header("header1", (Object)"value1").header("header1", (Object)"value2").build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.OK, in);
    }

    @Test
    public void getLanguageTest() throws JAXRSCommonClient.Fault {
        final Locale language = Locale.CANADA_FRENCH;
        ContextProvider in = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                Locale responseLanguage = responseContext.getLanguage();
                Assertions.assertTrue((responseLanguage != null ? 1 : 0) != 0, (String)"the #getLanguage is null");
                Assertions.assertTrue((boolean)language.equals(responseLanguage), (String)("#getLanguage was supposed to be " + language + " but was " + responseLanguage));
                JAXRSCommonClient.logMsg("Found #getLanguage()=", responseLanguage);
            }
        };
        Response response = Response.ok((Object)"entity").language(language).build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.OK, in);
    }

    @Test
    public void getLastModifiedTest() throws JAXRSCommonClient.Fault {
        final Date lastModified = JAXRSClientIT.getNewDate();
        ContextProvider in = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                Date date = responseContext.getLastModified();
                Assertions.assertTrue((date != null ? 1 : 0) != 0, (String)"the #getLastModified is null");
                Assertions.assertTrue((boolean)lastModified.equals(date), (String)("#getLastModified was supposed to be " + lastModified + " but was " + date));
                JAXRSCommonClient.logMsg("Found #getLastModified()=", date);
            }
        };
        Response response = Response.ok().lastModified(lastModified).build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.OK, in);
    }

    @Test
    public void getLengthTest() throws JAXRSCommonClient.Fault {
        String entity = "ENTITY";
        ContextProvider in = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                int len = responseContext.getLength();
                Assertions.assertTrue((len == "ENTITY".length() ? 1 : 0) != 0, (String)("#getLength was supposed to be " + "ENTITY".length() + " but was " + len));
                JAXRSCommonClient.logMsg("Found #getLength()=", len);
            }
        };
        Response response = Response.ok().header("Content-Length", (Object)"ENTITY".length()).build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.OK, in);
    }

    @Test
    public void getLinkTest() throws JAXRSCommonClient.Fault {
        String rel = "RELATION";
        ContextProvider in = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                Link link = responseContext.getLink("RELATION");
                Assertions.assertTrue((link != null ? 1 : 0) != 0, (String)"the #getLink is null");
                Assertions.assertTrue((link.getUri() != null ? 1 : 0) != 0, (String)"the #getLink.getUri is null");
                Assertions.assertTrue((boolean)link.getUri().toASCIIString().contains(JAXRSClientIT.getUrl()), (String)("#getLink was supposed to contain " + JAXRSClientIT.getUrl() + " but was " + link.getUri().toASCIIString()));
                JAXRSCommonClient.logMsg("Found #getLink()=", link.getUri().toASCIIString());
            }
        };
        Response response = Response.ok().link(JAXRSClientIT.getUrl(), "RELATION").build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.OK, in);
    }

    @Test
    public void getLinkBuilderTest() throws JAXRSCommonClient.Fault {
        String rel = "RELATION";
        ContextProvider in = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                Link.Builder builder = responseContext.getLinkBuilder("RELATION");
                Assertions.assertTrue((builder != null ? 1 : 0) != 0, (String)"the #getLinkBuilder is null");
                Assertions.assertTrue((boolean)builder.build(new Object[0]).getUri().toASCIIString().contains(JAXRSClientIT.getUrl()), (String)("#getLinkBuilder.build was supposed to contain " + JAXRSClientIT.getUrl() + " but was " + builder.build(new Object[0]).getUri().toASCIIString()));
                JAXRSCommonClient.logMsg("Found #getLinkBuilder()=", builder.build(new Object[0]).getUri().toASCIIString());
            }
        };
        Response response = Response.ok().link(JAXRSClientIT.getUrl(), "RELATION").build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.OK, in);
    }

    @Test
    public void getLinksTest() throws JAXRSCommonClient.Fault {
        final Link link = Link.fromUri((String)JAXRSClientIT.getUrl()).build(new Object[0]);
        ContextProvider in = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                Set links = responseContext.getLinks();
                Assertions.assertTrue((links != null ? 1 : 0) != 0, (String)"the #getLinks is null");
                Assertions.assertTrue((links.size() == 1 ? 1 : 0) != 0, (String)("the links was supposed to be of size 1, was " + links.size()));
                Assertions.assertTrue((boolean)links.contains(link), (String)("#getLinks was supposed to contain " + link.getUri().toASCIIString()));
                JAXRSCommonClient.logMsg("Found #getLinks()={", link.getUri().toASCIIString(), "}");
            }
        };
        Response response = Response.ok().links(new Link[]{link}).build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.OK, in);
    }

    @Test
    public void getLocationTest() throws JAXRSCommonClient.Fault {
        URI uri = null;
        try {
            uri = new URI(JAXRSClientIT.getUrl());
        }
        catch (URISyntaxException e) {
            throw new JAXRSCommonClient.Fault(e);
        }
        final URI location = uri;
        ContextProvider in = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                URI responseLocation = responseContext.getLocation();
                Assertions.assertTrue((responseLocation != null ? 1 : 0) != 0, (String)"the #getLinks is null");
                Assertions.assertTrue((boolean)location.equals(responseLocation), (String)("#getLocation was supposed to be " + location + " but was " + responseLocation));
                JAXRSCommonClient.logMsg("Found #getLocation=", location.toASCIIString());
            }
        };
        Response response = Response.ok().location(location).build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.OK, in);
    }

    @Test
    public void getMediaTypeTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                MediaType type = responseContext.getMediaType();
                Assertions.assertTrue((boolean)MediaType.APPLICATION_SVG_XML_TYPE.equals((Object)type), (String)("Unexpected mediatype found " + type));
                TestUtil.logMsg("Found expected MediaType.APPLICATION_SVG_XML_TYPE");
            }
        };
        Response response = Response.ok((Object)"TEST", (String)"application/svg+xml").build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.OK, provider);
    }

    @Test
    public void getStatusTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                Assertions.assertTrue((responseContext.getStatus() == 222 ? 1 : 0) != 0, (String)("unexpected status " + responseContext.getStatus()));
                TestUtil.logMsg("Found expected response status 222");
            }
        };
        Response response = Response.status((int)222).build();
        ClientRequestFilter filter = JAXRSClientIT.createRequestFilter(response);
        Invocation i = JAXRSClientIT.buildInvocation(filter, provider);
        Response r = JAXRSClientIT.invoke(i);
        Assertions.assertTrue((r.getStatus() == 222 ? 1 : 0) != 0, (String)("unexpected status " + r.getStatus()));
    }

    @Test
    public void getStatusInfoTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                Assertions.assertTrue((responseContext.getStatusInfo().getStatusCode() == 222 ? 1 : 0) != 0, (String)("unexpected status " + responseContext.getStatusInfo().getStatusCode()));
                TestUtil.logMsg("Found expected response status 222");
            }
        };
        Response response = Response.status((int)222).build();
        ClientRequestFilter filter = JAXRSClientIT.createRequestFilter(response);
        Invocation i = JAXRSClientIT.buildInvocation(filter, provider);
        Response r = JAXRSClientIT.invoke(i);
        Assertions.assertTrue((r.getStatus() == 222 ? 1 : 0) != 0, (String)("unexpected status " + r.getStatus()));
    }

    @Test
    public void hasEntityWhenEntityTest() throws JAXRSCommonClient.Fault {
        String entity = "eNtitY";
        ContextProvider in = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                boolean has = responseContext.hasEntity();
                Assertions.assertTrue((boolean)has, (String)"the #hasEntity did not found the given entity");
                JAXRSCommonClient.logMsg("Found #hasEntity()=true");
            }
        };
        Response response = Response.ok((Object)"eNtitY").build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.OK, in);
    }

    @Test
    public void hasEntityWhenNoEntityTest() throws JAXRSCommonClient.Fault {
        ContextProvider in = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                boolean has = responseContext.hasEntity();
                Assertions.assertTrue((!has ? 1 : 0) != 0, (String)"the #hasEntity found some entity");
                JAXRSCommonClient.logMsg("Found #hasEntity()=false");
            }
        };
        Response response = Response.ok().build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.OK, in);
    }

    @Test
    public void hasLinkWhenLinkTest() throws JAXRSCommonClient.Fault {
        String rel = "RelatiOn";
        ContextProvider in = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                boolean has = responseContext.hasLink("RelatiOn");
                Assertions.assertTrue((boolean)has, (String)"the #hasLink did not found the given link");
                JAXRSCommonClient.logMsg("#hasLink has found the given link");
            }
        };
        Response response = Response.ok().link(JAXRSClientIT.getUrl(), "RelatiOn").build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.OK, in);
    }

    @Test
    public void hasLinkWhenNoLinkTest() throws JAXRSCommonClient.Fault {
        ContextProvider in = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                boolean has = responseContext.hasLink("rel");
                Assertions.assertTrue((!has ? 1 : 0) != 0, (String)"the #hasLink did found some link");
                JAXRSCommonClient.logMsg("#hasLink has not found any link as expected");
            }
        };
        Response response = Response.ok().link(JAXRSClientIT.getUrl(), "ANY").build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.OK, in);
    }

    @Test
    public void setEntityStreamTest() throws JAXRSCommonClient.Fault {
        String entity = "ENTITY";
        ContextProvider in = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                responseContext.setEntityStream((InputStream)new ByteArrayInputStream("ENTITY".getBytes()));
                InputStream stream = responseContext.getEntityStream();
                Assertions.assertTrue((stream != null ? 1 : 0) != 0, (String)"the #getEntityStream is null");
                InputStreamReader isr = new InputStreamReader(stream);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                try {
                    line = br.readLine();
                }
                catch (IOException e) {
                    throw new JAXRSCommonClient.Fault(e);
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
                Assertions.assertTrue((boolean)"ENTITY".equals(line), (String)("The #getEntityStream " + line + " is not equal to what is inserted to the response: ENTITY"));
                JAXRSCommonClient.logMsg("#setEntityStream(", "ENTITY", ") set entity", line);
            }
        };
        Response response = Response.ok().build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.OK, in);
    }

    @Test
    public void setStatusTest() throws JAXRSCommonClient.Fault {
        ContextProvider in = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                responseContext.setStatus(Response.Status.FORBIDDEN.getStatusCode());
            }
        };
        Response response = Response.ok().build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.FORBIDDEN, in);
    }

    @Test
    public void setStatusInfoTest() throws JAXRSCommonClient.Fault {
        ContextProvider in = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext requestContext, ClientResponseContext responseContext) throws JAXRSCommonClient.Fault {
                Response.StatusType info = new Response.StatusType(){

                    public int getStatusCode() {
                        return Response.Status.FOUND.getStatusCode();
                    }

                    public String getReasonPhrase() {
                        return null;
                    }

                    public Response.Status.Family getFamily() {
                        return null;
                    }
                };
                responseContext.setStatusInfo(info);
            }
        };
        Response response = Response.ok().build();
        JAXRSClientIT.invokeWithResponseAndAssertStatus(response, Response.Status.FOUND, in);
    }

    protected static ClientRequestFilter createRequestFilter(final Response response) {
        ClientRequestFilter outFilter = new ClientRequestFilter(){

            public void filter(ClientRequestContext context) throws IOException {
                Response r = response == null ? Response.ok().build() : response;
                context.abortWith(r);
            }
        };
        return outFilter;
    }

    protected static Response invoke(Invocation i) throws JAXRSCommonClient.Fault {
        Response r = null;
        try {
            r = i.invoke();
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof JAXRSCommonClient.Fault) {
                throw (JAXRSCommonClient.Fault)cause;
            }
            throw new JAXRSCommonClient.Fault(e);
        }
        return r;
    }

    protected static Invocation buildInvocation(ClientRequestFilter requestFilter, ContextProvider ... provider) {
        WebTarget target = JAXRSClientIT.buildTarget(requestFilter, provider);
        Invocation i = target.request().buildGet();
        return i;
    }

    protected static WebTarget buildTarget(ClientRequestFilter requestFilter, ContextProvider ... providers) {
        Client client = ClientBuilder.newClient();
        client.register((Object)requestFilter);
        for (ContextProvider provider : providers) {
            client.register((Object)provider);
        }
        WebTarget target = client.target(JAXRSClientIT.getUrl());
        return target;
    }

    protected static void assertStatus(Response r, Response.Status status) throws JAXRSCommonClient.Fault {
        Assertions.assertTrue((r.getStatus() == status.getStatusCode() ? 1 : 0) != 0, (String)("Expected " + status.getStatusCode() + " got " + r.getStatus()));
        TestUtil.logMsg("Found expected status: " + status.getStatusCode());
    }

    protected static void invokeWithResponseAndAssertStatus(Response response, Response.Status status, ContextProvider provider) throws JAXRSCommonClient.Fault {
        ClientRequestFilter filter = JAXRSClientIT.createRequestFilter(response);
        Invocation i = JAXRSClientIT.buildInvocation(filter, provider);
        Response r = JAXRSClientIT.invoke(i);
        JAXRSClientIT.assertStatus(r, status);
    }

    protected static String getUrl() {
        return "http://localhost:8080/404URL/";
    }

    protected static Date getNewDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(14, 0);
        Date date = calendar.getTime();
        return date;
    }
}

