/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.resource.responsemediatype;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.resource.responsemediatype.ErrorResource;
import ee.jakarta.tck.ws.rs.spec.resource.responsemediatype.MediaResource;
import ee.jakarta.tck.ws.rs.spec.resource.responsemediatype.MediaWriter;
import ee.jakarta.tck.ws.rs.spec.resource.responsemediatype.NoMediaResource;
import ee.jakarta.tck.ws.rs.spec.resource.responsemediatype.StringWriter;
import ee.jakarta.tck.ws.rs.spec.resource.responsemediatype.TSAppConfig;
import ee.jakarta.tck.ws.rs.spec.resource.responsemediatype.WeightResource;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_resource_responsemediatype_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/resource/responsemediatype/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_resource_responsemediatype_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, MediaResource.class, ErrorResource.class, MediaWriter.class, NoMediaResource.class, StringWriter.class, WeightResource.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void responseOverrideTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "resource/responseoverride"));
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_XML_TYPE));
        this.invoke();
    }

    @Test
    public void responseNotAllowedToOverrideTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "resource/responseoverride"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.APPLICATION_JSON_TYPE));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.NOT_ACCEPTABLE));
        this.invoke();
    }

    @Test
    public void responseOverrideNoProducesTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "nomedia/responseoverride"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.APPLICATION_JSON_TYPE));
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_XML_TYPE));
        this.invoke();
    }

    @Test
    public void methodProducesTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "resource/method"));
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_ATOM_XML_TYPE));
        this.invoke();
    }

    @Test
    public void classProducesTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.HEAD, "resource/class"));
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_HTML_TYPE));
        this.invoke();
    }

    @Test
    public void mesageBodyWriterProducesTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "nomedia/list"));
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_SVG_XML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, List.class.getSimpleName());
        this.invoke();
    }

    public void noProducesTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "nomedia/nothing"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "nothing");
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_OCTET_STREAM_TYPE));
        this.invoke();
    }

    public void noProducesResponseReturnTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "nomedia/response"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "nothing");
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_OCTET_STREAM_TYPE));
        this.invoke();
    }

    @Test
    public void noPreferenceTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "weight"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/plain");
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        this.invoke();
    }

    @Test
    public void textPreferenceTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "weight"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: text/*");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/plain");
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        this.invoke();
    }

    @Test
    public void appPreferenceTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "weight"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: application/*;q=0.9, application/xml;q=0.1");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "application/xml");
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_XML_TYPE));
        this.invoke();
    }

    @Test
    public void imagePreferenceTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "weight"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: image/*");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "image/png");
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, "Content-Type: image/png");
        this.invoke();
    }

    @Test
    public void clientImagePreferenceTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "weight"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: image/something;q=0.1, image/*;q=0.9");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "image/png");
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, "Content-Type: image/png");
        this.invoke();
    }

    @Test
    public void clientXmlHtmlPreferenceTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "weight"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: text/html;q=0.2,text/xml;q=0.9");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/xml");
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_XML_TYPE));
        this.invoke();
    }

    @Test
    public void clientXmlHtmlPreferenceNoWeightOnServerTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "resource"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: text/html;q=0.2,text/xml;q=0.9");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/xml");
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_XML_TYPE));
        this.invoke();
    }

    @Test
    public void clientHtmlXmlPreferenceTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "weight"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: text/xml;q=0.3, text/html;q=0.9");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/html");
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_HTML_TYPE));
        this.invoke();
    }

    @Test
    public void clientAnyPreferenceTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "weight"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: */*;q=0.8, text/xml;q=0.3");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/plain");
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        this.invoke();
    }

    @Test
    public void defaultErrorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "error"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: text/*");
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.NOT_ACCEPTABLE));
        this.invoke();
    }

    @Test
    public void defaultResponseErrorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "error"));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "anything");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: text/*");
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.NOT_ACCEPTABLE));
        this.invoke();
    }
}

