/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.core.configuration;

import ee.jakarta.tck.ws.rs.api.rs.core.configurable.Assertable;
import ee.jakarta.tck.ws.rs.api.rs.core.configurable.CallableProvider;
import ee.jakarta.tck.ws.rs.api.rs.core.configurable.Registrar;
import ee.jakarta.tck.ws.rs.api.rs.core.configurable.SingleCheckAssertable;
import ee.jakarta.tck.ws.rs.api.rs.core.configuration.CallableProvider1;
import ee.jakarta.tck.ws.rs.api.rs.core.configuration.CallableProvider2;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configurable;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.ext.MessageBodyReader;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = -6325966971451285868L;
    private int registeredPropertiesCnt = -1;
    private int registeredClassesCnt = -1;
    private int registeredInstancesCnt = -1;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void getPropertiesTest() throws JAXRSCommonClient.Fault {
        Assertable assertable = new Assertable(){

            @Override
            public void check1OnClient(Client client) throws JAXRSCommonClient.Fault {
                this.assertSizeAndLog(client.getConfiguration(), 1);
            }

            @Override
            public void check2OnTarget(WebTarget target) throws JAXRSCommonClient.Fault {
                this.assertSizeAndLog(target.getConfiguration(), 2);
            }

            void assertSizeAndLog(Configuration config, int size) throws JAXRSCommonClient.Fault {
                int pSize = config.getProperties().size();
                JAXRSCommonClient.assertEqualsInt(pSize, size + JAXRSClientIT.this.registeredPropertiesCnt, "getConfiguration().getProperties() is not unexpected", this.getLocation(), "got", pSize, "properties");
                JAXRSCommonClient.logMsg("Found", pSize, "properties");
            }
        };
        this.checkConfigWithProperties(assertable);
    }

    @Test
    public void getPropertiesIsImmutableTest() throws JAXRSCommonClient.Fault {
        Assertable assertable = new Assertable(){

            @Override
            public void check1OnClient(Client client) throws JAXRSCommonClient.Fault {
                this.setNewProperty(client.getConfiguration());
                this.assertSizeAndLog(client.getConfiguration(), 1);
            }

            @Override
            public void check2OnTarget(WebTarget target) throws JAXRSCommonClient.Fault {
                this.setNewProperty(target.getConfiguration());
                this.assertSizeAndLog(target.getConfiguration(), 2);
            }

            void setNewProperty(Configuration config) {
                try {
                    config.getProperties().put("property88", "property88");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            void assertSizeAndLog(Configuration config, int size) throws JAXRSCommonClient.Fault {
                Assertions.assertTrue((config.getProperties().size() == size + JAXRSClientIT.this.registeredPropertiesCnt ? 1 : 0) != 0, (String)("getConfiguration().getProperties() is NOT immutable " + this.getLocation() + " got " + config.getProperties().size()));
                JAXRSCommonClient.logMsg("Found", config.getProperties().size(), " properties");
            }
        };
        this.checkConfigWithProperties(assertable);
    }

    @Test
    public void getPropertyTest() throws JAXRSCommonClient.Fault {
        Assertable assertable = new Assertable(){

            @Override
            public void check1OnClient(Client client) throws JAXRSCommonClient.Fault {
                this.assertPropertyIsSet(client.getConfiguration(), "property0");
                JAXRSCommonClient.logMsg("Found", client.getConfiguration().getProperty("property0"));
            }

            @Override
            public void check2OnTarget(WebTarget target) throws JAXRSCommonClient.Fault {
                this.assertPropertyIsSet(target.getConfiguration(), "property0");
                this.assertPropertyIsSet(target.getConfiguration(), "property1");
                JAXRSCommonClient.logMsg("Found", target.getConfiguration().getProperty("property1"));
            }

            void assertPropertyIsSet(Configuration config, String property) throws JAXRSCommonClient.Fault {
                Assertions.assertTrue((boolean)config.getProperty(property).equals(property), (String)("config.setProperty() did not set anything: " + this.getLocation()));
            }
        };
        this.checkConfigWithProperties(assertable);
    }

    @Test
    public void getPropertyIsNullTest() throws JAXRSCommonClient.Fault {
        SingleCheckAssertable assertable = new SingleCheckAssertable(){

            void assertPropertyIsNull(Configurable<?> config) throws JAXRSCommonClient.Fault {
                Assertions.assertTrue((config.getConfiguration().getProperty("property88") == null ? 1 : 0) != 0, (String)("#getProperty('nonexisting') != null " + this.getLocation()));
                JAXRSCommonClient.logMsg("#getProperty('nonexisting') is null as expected");
            }

            @Override
            protected void check(Configurable<?> configurable) throws JAXRSCommonClient.Fault {
                this.assertPropertyIsNull(configurable);
            }
        };
        this.checkConfigWithProperties(assertable);
    }

    @Test
    public void getClassesTest() throws JAXRSCommonClient.Fault {
        Assertable assertable = new Assertable(){

            @Override
            public void check1OnClient(Client client) throws JAXRSCommonClient.Fault {
                this.assertSizeAndLog(client.getConfiguration(), 1);
            }

            @Override
            public void check2OnTarget(WebTarget target) throws JAXRSCommonClient.Fault {
                this.assertSizeAndLog(target.getConfiguration(), 2);
            }

            void assertSizeAndLog(Configuration config, int count) throws JAXRSCommonClient.Fault {
                Assertions.assertTrue((config.getClasses().size() == count + JAXRSClientIT.this.registeredClassesCnt ? 1 : 0) != 0, (String)("config.getClasses() return unexcepted size " + this.getLocation() + " : " + config.getClasses().size()));
                JAXRSCommonClient.logMsg("Found", config.getClasses().size(), "providers");
            }
        };
        Object[] providerClasses = new Class[]{CallableProvider1.class, CallableProvider2.class};
        this.checkConfig(assertable, providerClasses);
    }

    @Test
    public void getClassesIsImmutableTest() throws JAXRSCommonClient.Fault {
        Assertable assertable = new Assertable(){

            @Override
            public void check1OnClient(Client client) throws JAXRSCommonClient.Fault {
                this.assertSizeAndLog(client.getConfiguration(), 0);
                this.registerNewProviderInstance(client.getConfiguration());
                this.assertSizeAndLog(client.getConfiguration(), 0);
            }

            @Override
            public void check2OnTarget(WebTarget target) throws JAXRSCommonClient.Fault {
                this.registerNewProviderInstance(target.getConfiguration());
                this.assertSizeAndLog(target.getConfiguration(), 0);
            }

            void assertSizeAndLog(Configuration config, int count) throws JAXRSCommonClient.Fault {
                if (config.getClasses().size() == 1) {
                    JAXRSCommonClient.logMsg("Found", config.getClasses().iterator().next());
                }
                Assertions.assertTrue((config.getClasses().size() == count + JAXRSClientIT.this.registeredClassesCnt ? 1 : 0) != 0, (String)("config.getClasses() return unexcepted size " + this.getLocation() + " : " + config.getClasses().size()));
                JAXRSCommonClient.logMsg("Found", config.getClasses().size(), "providers");
            }

            void registerNewProviderInstance(Configuration config) {
                Class<CallableProvider> clz = CallableProvider.class;
                try {
                    config.getClasses().add(clz);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.checkConfigWithProperties(assertable);
    }

    @Test
    public void getClassesIsNeverNullTest() throws JAXRSCommonClient.Fault {
        SingleCheckAssertable assertable = new SingleCheckAssertable(){

            @Override
            protected void check(Configurable<?> configurable) throws JAXRSCommonClient.Fault {
                this.assertNotNullAndLog(configurable);
            }

            void assertNotNullAndLog(Configurable<?> config) throws JAXRSCommonClient.Fault {
                JAXRSCommonClient.assertNotNull(config.getConfiguration().getClasses(), "#getClasses shall never be null", this.getLocation());
                JAXRSCommonClient.logMsg("#getClasses() is not null as expected", this.getLocation());
            }
        };
        this.checkConfigWithProperties(assertable);
    }

    @Test
    public void getInstancesTest() throws JAXRSCommonClient.Fault {
        Assertable assertable = new Assertable(){

            @Override
            public void check1OnClient(Client client) throws JAXRSCommonClient.Fault {
                this.assertSizeAndLog(client.getConfiguration(), 1);
            }

            @Override
            public void check2OnTarget(WebTarget target) throws JAXRSCommonClient.Fault {
                this.assertSizeAndLog(target.getConfiguration(), 2);
            }

            void assertSizeAndLog(Configuration config, int count) throws JAXRSCommonClient.Fault {
                Assertions.assertTrue((config.getInstances().size() == count + JAXRSClientIT.this.registeredInstancesCnt ? 1 : 0) != 0, (String)("config.getClasses() return unexcepted size " + this.getLocation() + " : " + config.getInstances().size()));
                JAXRSCommonClient.logMsg("Found", config.getInstances().size(), "providers");
            }
        };
        Object[] providerObjects = JAXRSClientIT.createProviderInstances();
        this.checkConfig(assertable, providerObjects);
    }

    @Test
    public void getInstancesIsImmutableTest() throws JAXRSCommonClient.Fault {
        SingleCheckAssertable assertable = new SingleCheckAssertable(){

            @Override
            protected void check(Configurable<?> configurable) throws JAXRSCommonClient.Fault {
                this.registerNewProviderInstance(configurable.getConfiguration());
                this.assertSizeAndLog(configurable.getConfiguration(), 0);
            }

            void assertSizeAndLog(Configuration config, int count) throws JAXRSCommonClient.Fault {
                Assertions.assertTrue((config.getClasses().size() == count + JAXRSClientIT.this.registeredClassesCnt ? 1 : 0) != 0, (String)("config.getClasses() return unexcepted size " + this.getLocation() + " : " + config.getClasses().size()));
                JAXRSCommonClient.logMsg("Found", config.getClasses().size(), "providers");
            }

            void registerNewProviderInstance(Configuration config) {
                try {
                    config.getInstances().add(new CallableProvider());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.checkConfigWithProperties(assertable);
    }

    @Test
    public void getContractsTest() throws JAXRSCommonClient.Fault {
        int priority = 124;
        SingleCheckAssertable assertable = new SingleCheckAssertable(){

            void assertNotNullAndLog(Configurable<?> config) throws JAXRSCommonClient.Fault {
                Map map = config.getConfiguration().getContracts(CallableProvider.class);
                JAXRSCommonClient.assertEqualsInt(1, map.size(), "Unexpected contract size", map.size());
                Class contract = (Class)map.entrySet().iterator().next().getKey();
                JAXRSCommonClient.assertEquals(MessageBodyReader.class, contract, "Unexpected contract", contract, this.getLocation());
                JAXRSCommonClient.logMsg("#getContracts() is", contract, "as expected", this.getLocation());
                int p = (Integer)map.get(contract);
                JAXRSCommonClient.assertEqualsInt(124, p, "Unexpected priority", p);
                JAXRSCommonClient.logMsg("Found expected priority", p);
            }

            @Override
            protected void check(Configurable<?> configurable) throws JAXRSCommonClient.Fault {
                this.assertNotNullAndLog(configurable);
            }
        };
        Registrar registrar = new Registrar(){

            @Override
            public void register(Configurable<?> config, Object registerable) {
                HashMap<Class<MessageBodyReader>, Integer> map = new HashMap<Class<MessageBodyReader>, Integer>();
                map.put(MessageBodyReader.class, 124);
                config.register(CallableProvider.class, map);
            }
        };
        this.checkConfigWithProperties(registrar, assertable);
    }

    @Test
    public void getContractsIsNeverNullTest() throws JAXRSCommonClient.Fault {
        SingleCheckAssertable assertable = new SingleCheckAssertable(){

            void assertNotNullAndLog(Configurable<?> config) throws JAXRSCommonClient.Fault {
                Map map = config.getConfiguration().getContracts(MessageBodyReader.class);
                JAXRSCommonClient.assertNotNull(map, "getContracts is null", this.getLocation());
                JAXRSCommonClient.logMsg("#getContracts() is not null as expected", this.getLocation());
            }

            @Override
            protected void check(Configurable<?> configurable) throws JAXRSCommonClient.Fault {
                this.assertNotNullAndLog(configurable);
            }
        };
        this.checkConfigWithProperties(assertable);
    }

    @Test
    public void getInstancesIsNeverNullTest() throws JAXRSCommonClient.Fault {
        SingleCheckAssertable assertable = new SingleCheckAssertable(){

            void assertNotNullAndLog(Configurable<?> config) throws JAXRSCommonClient.Fault {
                JAXRSCommonClient.assertNotNull(config.getConfiguration().getInstances(), "config.getInstances() shall never be null", this.getLocation());
                JAXRSCommonClient.logMsg("#getInstances() is not null as expected", this.getLocation());
            }

            @Override
            protected void check(Configurable<?> configurable) throws JAXRSCommonClient.Fault {
                this.assertNotNullAndLog(configurable);
            }
        };
        this.checkConfigWithProperties(assertable);
    }

    @Test
    public void getPropertyNamesTest() throws JAXRSCommonClient.Fault {
        Assertable assertable = new Assertable(){

            @Override
            public void check1OnClient(Client client) throws JAXRSCommonClient.Fault {
                this.assertSizeAndLog(client.getConfiguration(), 1);
            }

            @Override
            public void check2OnTarget(WebTarget target) throws JAXRSCommonClient.Fault {
                this.assertSizeAndLog(target.getConfiguration(), 2);
            }

            void assertSizeAndLog(Configuration config, int size) throws JAXRSCommonClient.Fault {
                int names = config.getPropertyNames().size();
                JAXRSCommonClient.assertEqualsInt(names, size + JAXRSClientIT.this.registeredPropertiesCnt, "getPropertyNames() is unexpected", this.getLocation(), "got", names, "properties");
                JAXRSCommonClient.logMsg("Found", names, "properties");
            }
        };
        this.checkConfigWithProperties(assertable);
    }

    @Test
    public void getPropertyNamesIsImmutableTest() throws JAXRSCommonClient.Fault {
        Assertable assertable = new Assertable(){

            @Override
            public void check1OnClient(Client client) throws JAXRSCommonClient.Fault {
                this.setNewProperty(client.getConfiguration());
                this.assertSizeAndLog(client.getConfiguration(), 1);
            }

            @Override
            public void check2OnTarget(WebTarget target) throws JAXRSCommonClient.Fault {
                this.setNewProperty(target.getConfiguration());
                this.assertSizeAndLog(target.getConfiguration(), 2);
            }

            void setNewProperty(Configuration config) {
                try {
                    config.getPropertyNames().add("property88");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            void assertSizeAndLog(Configuration config, int size) throws JAXRSCommonClient.Fault {
                int pSize = config.getPropertyNames().size();
                JAXRSCommonClient.assertEqualsInt(pSize, size + JAXRSClientIT.this.registeredPropertiesCnt, "getPropertyNames() is NOT immutable", this.getLocation(), "got", pSize, "properties");
                JAXRSCommonClient.logMsg("Found", pSize, " properties");
            }
        };
        this.checkConfigWithProperties(assertable);
    }

    @Test
    public void getRuntimeTypeTest() throws JAXRSCommonClient.Fault {
        SingleCheckAssertable assertable = new SingleCheckAssertable(){

            void assertNotNullAndLog(Configurable<?> config) throws JAXRSCommonClient.Fault {
                JAXRSCommonClient.assertEquals(RuntimeType.CLIENT, config.getConfiguration().getRuntimeType(), "getRuntimeType() is unexpected", config.getConfiguration().getRuntimeType(), this.getLocation());
                JAXRSCommonClient.logMsg("#getRuntimeType() is", RuntimeType.CLIENT, "as expected", this.getLocation());
            }

            @Override
            protected void check(Configurable<?> configurable) throws JAXRSCommonClient.Fault {
                this.assertNotNullAndLog(configurable);
            }
        };
        this.checkConfigWithProperties(assertable);
    }

    @Test
    public void isRegisteredProviderRegisteredInstanceTest() throws JAXRSCommonClient.Fault {
        Assertable assertable = new Assertable(){
            CallableProvider1 p1 = new CallableProvider1();
            CallableProvider2 p2 = new CallableProvider2();

            @Override
            public void check1OnClient(Client client) throws JAXRSCommonClient.Fault {
                client.register((Object)this.p1);
                this.assertSizeAndLog(client.getConfiguration(), 1);
            }

            @Override
            public void check2OnTarget(WebTarget target) throws JAXRSCommonClient.Fault {
                target.register((Object)this.p2);
                this.assertSizeAndLog(target.getConfiguration(), 2);
            }

            void assertSizeAndLog(Configuration config, int size) throws JAXRSCommonClient.Fault {
                Assertions.assertFalse((boolean)config.isRegistered(CallableProvider.class), (String)"CallableProvider is unexpectedly registered");
                switch (size) {
                    case 2: {
                        Assertions.assertFalse((boolean)config.isRegistered((Object)new CallableProvider2()), (String)("CallableProvider2 is registered " + this.getLocation()));
                        Assertions.assertTrue((boolean)config.isRegistered((Object)this.p2), (String)("CallableProvider2.class is NOT registered " + this.getLocation()));
                        Assertions.assertTrue((boolean)config.isRegistered(CallableProvider2.class), (String)("CallableProvider2.class is NOT registered " + this.getLocation()));
                        JAXRSCommonClient.logMsg("Found registered CallableProvider2 as expected", this.getLocation());
                    }
                    case 1: {
                        Assertions.assertFalse((boolean)config.isRegistered((Object)new CallableProvider1()), (String)("CallableProvider1 is registered " + this.getLocation()));
                        Assertions.assertTrue((boolean)config.isRegistered((Object)this.p1), (String)("CallableProvider1.class is NOT registered " + this.getLocation()));
                        Assertions.assertTrue((boolean)config.isRegistered(CallableProvider1.class), (String)("CallableProvider1.class is NOT registered " + this.getLocation()));
                        JAXRSCommonClient.logMsg("Found registered CallableProvider1 as expected", this.getLocation());
                    }
                }
            }
        };
        this.checkConfigWithProperties(assertable);
    }

    @Test
    public void isRegisteredProviderRegisteredClassTest() throws JAXRSCommonClient.Fault {
        Assertable assertable = new Assertable(){

            @Override
            public void check1OnClient(Client client) throws JAXRSCommonClient.Fault {
                client.register(CallableProvider1.class);
                this.assertSizeAndLog(client.getConfiguration(), 1);
            }

            @Override
            public void check2OnTarget(WebTarget target) throws JAXRSCommonClient.Fault {
                target.register(CallableProvider2.class);
                this.assertSizeAndLog(target.getConfiguration(), 2);
            }

            void assertSizeAndLog(Configuration config, int size) throws JAXRSCommonClient.Fault {
                Assertions.assertFalse((boolean)config.isRegistered((Object)new CallableProvider()), (String)"CallableProvider is unexpectedly registered");
                Assertions.assertFalse((boolean)config.isRegistered(CallableProvider.class), (String)"CallableProvider is unexpectedly registered");
                switch (size) {
                    case 2: {
                        Assertions.assertFalse((boolean)config.isRegistered((Object)new CallableProvider2()), (String)("CallableProvider2 is registered " + this.getLocation()));
                        Assertions.assertTrue((boolean)config.isRegistered(CallableProvider2.class), (String)("CallableProvider2.class is NOT registered " + this.getLocation()));
                        JAXRSCommonClient.logMsg("Found registered CallableProvider2 as expected", this.getLocation());
                    }
                    case 1: {
                        Assertions.assertFalse((boolean)config.isRegistered((Object)new CallableProvider1()), (String)("CallableProvider1 is registered " + this.getLocation()));
                        Assertions.assertTrue((boolean)config.isRegistered(CallableProvider1.class), (String)("CallableProvider1.class is NOT registered " + this.getLocation()));
                        JAXRSCommonClient.logMsg("Found registered CallableProvider1 as expected", this.getLocation());
                    }
                }
            }
        };
        this.checkConfigWithProperties(assertable);
    }

    private static String[] createPropertyInstances() {
        String[] properties = new String[]{"property0", "property1"};
        return properties;
    }

    private static Object[] createProviderInstances() {
        Object[] instances = new CallableProvider[]{new CallableProvider(){}, new CallableProvider(){}};
        return instances;
    }

    private void checkConfigWithProperties(Assertable assertable) throws JAXRSCommonClient.Fault {
        Object[] properties = JAXRSClientIT.createPropertyInstances();
        this.checkConfig(assertable, properties);
    }

    private void checkConfigWithProperties(Registrar registrar, Assertable assertable) throws JAXRSCommonClient.Fault {
        Object[] properties = JAXRSClientIT.createPropertyInstances();
        this.checkConfig(registrar, assertable, properties);
    }

    private void checkConfig(Assertable assertable, Object[] registerables) throws JAXRSCommonClient.Fault {
        this.checkConfig(new Registrar(), assertable, registerables);
    }

    protected void checkConfig(Registrar registrar, Assertable assertable, Object[] registerables) throws JAXRSCommonClient.Fault {
        Client client = ClientBuilder.newClient();
        Configuration config = client.getConfiguration();
        this.registeredPropertiesCnt = config.getProperties().size();
        this.registeredClassesCnt = config.getClasses().size();
        this.registeredInstancesCnt = config.getInstances().size();
        JAXRSClientIT.logMsg("Already registered", this.registeredClassesCnt, "classes");
        JAXRSClientIT.logMsg("Already registered", this.registeredInstancesCnt, "instances");
        JAXRSClientIT.logMsg("Already registered", this.registeredPropertiesCnt, "properties");
        this.register(registrar, (Configurable<?>)client, registerables[0]);
        assertable.check1OnClient(client);
        assertable.incrementLocation();
        WebTarget target = client.target("http://tck.cts:888");
        this.register(registrar, (Configurable<?>)target, registerables[1]);
        assertable.check2OnTarget(target);
        assertable.incrementLocation();
    }

    protected void register(Registrar registrar, Configurable<?> config, Object registerable) {
        registrar.register(config, registerable);
    }
}

