/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec.template;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TemplateUtilities;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.BasicSession;
import com.sun.javatest.exec.InterviewEditor;
import com.sun.javatest.exec.Session;
import com.sun.javatest.tool.FileHistory;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.util.Map;
import java.util.Objects;

public class TemplateSession
extends BasicSession {
    static final String TEMPLATE_PROP_NAME = "Template";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TemplateSession.class);
    protected final InterviewParameters templ;

    public TemplateSession(TestSuite ts) throws Session.Fault {
        super(ts);
        try {
            this.templ = ts.createInterview();
            this.templ.setTemplate(true);
        }
        catch (TestSuite.Fault f) {
            throw new Session.Fault(f);
        }
    }

    @Override
    protected void initPropertyList() {
        super.initPropertyList();
        this.props.add(TEMPLATE_PROP_NAME);
    }

    @Override
    public String getValue(String name) {
        if (TEMPLATE_PROP_NAME.equals(name)) {
            if (this.templ == null) {
                return null;
            }
            File f = this.templ.getFile();
            return f == null ? null : f.getPath();
        }
        return super.getValue(name);
    }

    @Override
    public void dispose() {
        this.templ.dispose();
        super.dispose();
    }

    @Override
    public void save(Map<String, String> map) {
        if (this.templ.getFile() != null) {
            map.put("template", this.templ.getFile().getPath());
        }
        super.save(map);
    }

    @Override
    public void restore(Map<String, String> map) throws Session.Fault {
        super.restore(map);
        this.restoreTemplate(map);
    }

    protected void restoreTemplate(Map<String, String> map) {
        String templPath = map.get("template");
        if (templPath != null) {
            try {
                String oldWDpath;
                String[] begins;
                if (!new File(templPath).exists() && this.getWorkDirectory() != null && (begins = WorkDirectory.getDiffInPaths(templPath, oldWDpath = this.getWorkDirectory().getPrevWDPath())) != null && templPath.startsWith(begins[1])) {
                    templPath = begins[0] + templPath.substring(begins[1].length());
                }
                this.templ.load(new File(templPath));
                if (this.getWorkDirectory() != null) {
                    FileHistory.getFileHistory(this.getWorkDirectory(), "templateHistory.jtl").add(this.templ.getFile());
                }
                this.templ.setTemplate(true);
                this.notifyObservers(new E_NewTemplate(this.templ));
            }
            catch (Exception ex) {
                System.err.println(i18n.getString("tcc.cantRestoreTemplate.err", (Object)templPath));
            }
        }
    }

    @Override
    public void update(Session.Update u) throws Session.Fault {
        if (u instanceof U_NewTemplate) {
            this.updateTemplate(((U_NewTemplate)u).templ);
        } else {
            super.update(u);
        }
    }

    @Override
    protected void updateNewConfig(InterviewParameters ip) throws Session.Fault {
        String newPath;
        String oldPath = this.templ.getTemplatePath();
        if (!Objects.equals(oldPath, newPath = ip.getTemplatePath()) && oldPath != null && !oldPath.equals(newPath)) {
            try {
                File templateFile = new File(newPath);
                this.templ.load(templateFile);
                this.templ.setFile(templateFile);
                TemplateUtilities.setTemplateFile(this.getWorkDirectory(), templateFile, true);
                this.notifyObservers(new E_NewTemplate(this.templ));
                super.updateNewConfig(ip);
            }
            catch (Exception ex) {
                throw new Session.Fault(ex);
            }
        } else {
            super.updateNewConfig(ip);
        }
    }

    @Override
    protected void applyWorkDir(WorkDirectory wd) {
        super.applyWorkDir(wd);
        if (this.templ != null) {
            this.templ.setWorkDirectory(wd);
        }
    }

    protected void loadTemplateFromWD(WorkDirectory wd) throws Session.Fault {
        File templateFile = TemplateUtilities.getTemplateFile(wd);
        if (templateFile != null) {
            try {
                InterviewParameters newValue = InterviewParameters.open(templateFile, wd);
                InterviewEditor.copy(newValue, this.templ);
                this.templ.setFile(templateFile);
                TemplateUtilities.setTemplateFile(wd, templateFile, true);
                this.notifyObservers(new E_NewTemplate(this.templ));
            }
            catch (Exception ex) {
                throw new Session.Fault(ex);
            }
        }
    }

    @Deprecated
    public InterviewParameters getConfig() {
        return this.getInterviewParameters();
    }

    public InterviewParameters getTemplate() {
        return this.templ;
    }

    protected void updateTemplate(InterviewParameters t) throws Session.Fault {
        if (InterviewEditor.equal(t, this.templ) && t.getFile() != null && t.getFile().equals(this.templ.getFile())) {
            return;
        }
        try {
            InterviewEditor.copy(t, this.templ);
            TemplateUtilities.setTemplateFile(this.getWorkDirectory(), this.templ.getFile(), true);
        }
        catch (Exception e) {
            throw new Session.Fault(e);
        }
        if (!this.templ.getTemplatePath().equals(this.getInterviewParameters().getTemplatePath())) {
            this.getInterviewParameters().clear();
            this.notifyObservers(new BasicSession.E_NewConfig(this.getInterviewParameters()));
        }
        this.notifyObservers(new E_NewTemplate(this.templ));
    }

    public static class U_NewTemplate
    implements Session.Update {
        public final InterviewParameters templ;

        public U_NewTemplate(InterviewParameters templ) {
            this.templ = templ;
        }
    }

    public static class E_NewTemplate
    implements Session.Event {
        public final InterviewParameters templ;

        public E_NewTemplate(InterviewParameters templ) {
            this.templ = templ;
        }
    }
}

