/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.pointertests;

import ee.jakarta.tck.jsonp.api.common.JsonAssert;
import ee.jakarta.tck.jsonp.api.common.PointerRFCObject;
import ee.jakarta.tck.jsonp.api.common.SimpleValues;
import ee.jakarta.tck.jsonp.api.common.TestResult;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonPointer;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.util.logging.Logger;

public class PointerResolve {
    private static final Logger LOGGER = Logger.getLogger(PointerResolve.class.getName());

    PointerResolve() {
    }

    TestResult test() {
        TestResult result = new TestResult("RFC 6901 pointer resolving");
        LOGGER.info("Testing RFC 6901 pointer resolving");
        this.testResolveWholeDocument(result);
        this.testResolveEmptyName(result);
        this.testResolveSimpleArray(result);
        this.testResolveSimpleArrayItems(result);
        this.testResolvePathWithSlash(result);
        this.testResolvePathWithEncodedSlash(result);
        this.testResolvePathWithPercent(result);
        this.testResolvePathWithCaret(result);
        this.testResolvePathWithVerticalBar(result);
        this.testResolvePathWithBackSlash(result);
        this.testResolvePathWithDoubleQuotes(result);
        this.testResolvePathWithSpace(result);
        this.testResolvePathWithTilde(result);
        this.testResolvePathWithEncodedTilde(result);
        this.testResolvePathWithEncodedTildeOne(result);
        this.testResolveValidNumericIndexInArray(result);
        this.testResolveMemberAfterLastInArray(result);
        this.testResolveNumericIndexWithLeadingZeroInArray(result);
        this.testResolvenonNumericIndexInArray(result);
        return result;
    }

    private void testResolveWholeDocument(TestResult result) {
        JsonObject in;
        LOGGER.info(" - resolving of \"\" pointer");
        JsonObject check = in = PointerRFCObject.createRFC6901Object();
        JsonPointer ptr = Json.createPointer((String)"");
        try {
            JsonValue out = ptr.getValue((JsonStructure)in);
            if (!JsonAssert.assertEquals(out, (JsonValue)check)) {
                result.fail("GET \"\"", "GET operation failed for \"\" path");
            }
        }
        catch (JsonException e) {
            result.fail("GET \"\"", "GET operation exception: " + e.getMessage());
        }
    }

    private void testResolveEmptyName(TestResult result) {
        LOGGER.info(" - resolving of \"/\" pointer");
        JsonObject in = PointerRFCObject.createRFC6901Object();
        JsonNumber check = Json.createValue((int)0);
        JsonPointer ptr = Json.createPointer((String)"/");
        try {
            JsonValue out = ptr.getValue((JsonStructure)in);
            if (!JsonAssert.assertEquals(out, (JsonValue)check)) {
                result.fail("GET \"/\"", "GET operation failed for \"/\" path");
            }
        }
        catch (JsonException e) {
            result.fail("GET \"/\"", "GET operation exception: " + e.getMessage());
        }
    }

    private void testResolveSimpleArray(TestResult result) {
        LOGGER.info(" - resolving of \"/foo\" pointer");
        JsonObject in = PointerRFCObject.createRFC6901Object();
        JsonArray check = PointerRFCObject.RFC_VAL1;
        JsonPointer ptr = Json.createPointer((String)"/foo");
        try {
            JsonValue out = ptr.getValue((JsonStructure)in);
            if (!JsonAssert.assertEquals(out, (JsonValue)check)) {
                result.fail("GET \"/foo\"", "GET operation failed for \"/foo\" path");
            }
        }
        catch (JsonException e) {
            result.fail("GET \"/foo\"", "GET operation exception: " + e.getMessage());
        }
    }

    private void testResolveSimpleArrayItems(TestResult result) {
        String[] itemPtrs = new String[]{"/foo/0", "/foo/1"};
        String[] itemVals = new String[]{"bar", "baz"};
        JsonObject in = PointerRFCObject.createRFC6901Object();
        for (int i = 0; i < itemPtrs.length; ++i) {
            LOGGER.info(" - resolving of \"" + itemPtrs[i] + "\" pointer");
            JsonString check = Json.createValue((String)itemVals[i]);
            JsonPointer ptr = Json.createPointer((String)itemPtrs[i]);
            try {
                JsonValue out = ptr.getValue((JsonStructure)in);
                if (JsonAssert.assertEquals(out, (JsonValue)check)) continue;
                result.fail("GET \"" + itemPtrs[i] + "\"", "GET operation failed for \"" + itemPtrs[i] + "\" path");
                continue;
            }
            catch (JsonException e) {
                result.fail("GET \"" + itemPtrs[i] + "\"", "GET operation exception: " + e.getMessage());
            }
        }
    }

    private void testResolvePathWithEncodedSlash(TestResult result) {
        LOGGER.info(" - resolving of \"/a~1b\" pointer");
        JsonObject in = PointerRFCObject.createRFC6901Object();
        JsonNumber check = Json.createValue((int)1);
        JsonPointer ptr = Json.createPointer((String)"/a~1b");
        try {
            JsonValue out = ptr.getValue((JsonStructure)in);
            if (!JsonAssert.assertEquals(out, (JsonValue)check)) {
                result.fail("GET \"/a~1b\"", "GET operation failed for \"/a~1b\" path");
            }
        }
        catch (JsonException e) {
            LOGGER.info("    ! Exception: " + e.getMessage());
            result.fail("GET \"/a~1b\"", "GET operation exception: " + e.getMessage());
        }
    }

    private void testResolvePathWithSlash(TestResult result) {
        LOGGER.info(" - resolving of \"/a/b\" pointer");
        JsonObject in = PointerRFCObject.createRFC6901Object();
        JsonPointer ptr = Json.createPointer((String)"/a/b");
        try {
            JsonValue out = ptr.getValue((JsonStructure)in);
            result.fail("GET \"/a/b\"", "GET operation succeeded for \"/a/b\" path");
        }
        catch (JsonException e) {
            LOGGER.info("    - Expected exception: " + e.getMessage());
        }
    }

    private void testResolvePathWithPercent(TestResult result) {
        LOGGER.info(" - resolving of \"/c%d\" pointer");
        JsonObject in = PointerRFCObject.createRFC6901Object();
        JsonNumber check = Json.createValue((int)2);
        JsonPointer ptr = Json.createPointer((String)"/c%d");
        try {
            JsonValue out = ptr.getValue((JsonStructure)in);
            if (!JsonAssert.assertEquals(out, (JsonValue)check)) {
                result.fail("GET \"/c%d\"", "GET operation failed for \"/c%d\" path");
            }
        }
        catch (JsonException e) {
            result.fail("GET \"/c%d\"", "GET operation exception: " + e.getMessage());
        }
    }

    private void testResolvePathWithCaret(TestResult result) {
        LOGGER.info(" - resolving of \"/e^f\" pointer");
        JsonObject in = PointerRFCObject.createRFC6901Object();
        JsonNumber check = Json.createValue((int)3);
        JsonPointer ptr = Json.createPointer((String)"/e^f");
        try {
            JsonValue out = ptr.getValue((JsonStructure)in);
            if (!JsonAssert.assertEquals(out, (JsonValue)check)) {
                result.fail("GET \"/e^f\"", "GET operation failed for \"/e^f\" path");
            }
        }
        catch (JsonException e) {
            result.fail("GET \"/e^f\"", "GET operation exception: " + e.getMessage());
        }
    }

    private void testResolvePathWithVerticalBar(TestResult result) {
        LOGGER.info(" - resolving of \"/g|h\" pointer");
        JsonObject in = PointerRFCObject.createRFC6901Object();
        JsonNumber check = Json.createValue((int)4);
        JsonPointer ptr = Json.createPointer((String)"/g|h");
        try {
            JsonValue out = ptr.getValue((JsonStructure)in);
            if (!JsonAssert.assertEquals(out, (JsonValue)check)) {
                result.fail("GET \"/g|h\"", "GET operation failed for \"/g|h\" path");
            }
        }
        catch (JsonException e) {
            result.fail("GET \"/g|h\"", "GET operation exception: " + e.getMessage());
        }
    }

    private void testResolvePathWithBackSlash(TestResult result) {
        LOGGER.info(" - resolving of \"/i\\j\" pointer");
        JsonObject in = PointerRFCObject.createRFC6901Object();
        JsonNumber check = Json.createValue((int)5);
        JsonPointer ptr = Json.createPointer((String)"/i\\j");
        try {
            JsonValue out = ptr.getValue((JsonStructure)in);
            if (!JsonAssert.assertEquals(out, (JsonValue)check)) {
                result.fail("GET \"/i\\j\"", "GET operation failed for \"/i\\j\" path");
            }
        }
        catch (JsonException e) {
            result.fail("GET \"/i\\j\"", "GET operation exception: " + e.getMessage());
        }
    }

    private void testResolvePathWithDoubleQuotes(TestResult result) {
        LOGGER.info(" - resolving of \"/k\"l\" pointer");
        JsonObject in = PointerRFCObject.createRFC6901Object();
        JsonNumber check = Json.createValue((int)6);
        JsonPointer ptr = Json.createPointer((String)"/k\"l");
        try {
            JsonValue out = ptr.getValue((JsonStructure)in);
            if (!JsonAssert.assertEquals(out, (JsonValue)check)) {
                result.fail("GET \"/k\"l\"", "GET operation failed for \"/k\"l\" path");
            }
        }
        catch (JsonException e) {
            result.fail("GET \"/k\"l\"", "GET operation exception: " + e.getMessage());
        }
    }

    private void testResolvePathWithSpace(TestResult result) {
        LOGGER.info(" - resolving of \"/ \" pointer");
        JsonObject in = PointerRFCObject.createRFC6901Object();
        JsonNumber check = Json.createValue((int)7);
        JsonPointer ptr = Json.createPointer((String)"/ ");
        try {
            JsonValue out = ptr.getValue((JsonStructure)in);
            if (!JsonAssert.assertEquals(out, (JsonValue)check)) {
                result.fail("GET \"/ \"", "GET operation failed for \"/ \" path");
            }
        }
        catch (JsonException e) {
            result.fail("GET \"/ \"", "GET operation exception: " + e.getMessage());
        }
    }

    private void testResolvePathWithTilde(TestResult result) {
        LOGGER.info(" - resolving of \"/m~n\" pointer (optional)");
        JsonObject in = PointerRFCObject.createRFC6901Object();
        JsonNumber check = Json.createValue((int)8);
        JsonPointer ptr = Json.createPointer((String)"/m~n");
        boolean noError = true;
        try {
            JsonValue out = ptr.getValue((JsonStructure)in);
            if (!JsonAssert.assertEquals(out, (JsonValue)check)) {
                noError = false;
                LOGGER.info("    - Pointer \"m~n\" did not return expected value");
            }
        }
        catch (JsonException e) {
            noError = false;
            LOGGER.info("    - Expected exception: " + e.getMessage());
        }
        if (noError) {
            LOGGER.info("    - Pointer resolving accepts '~' outside escape sequence");
        }
    }

    private void testResolvePathWithEncodedTilde(TestResult result) {
        LOGGER.info(" - resolving of \"/m~0n\" pointer");
        JsonObject in = PointerRFCObject.createRFC6901Object();
        JsonNumber check = Json.createValue((int)8);
        JsonPointer ptr = Json.createPointer((String)"/m~0n");
        try {
            JsonValue out = ptr.getValue((JsonStructure)in);
            if (!JsonAssert.assertEquals(out, (JsonValue)check)) {
                result.fail("GET \"/m~0n\"", "GET operation failed for \"/m~0n\" path");
            }
        }
        catch (JsonException e) {
            result.fail("GET \"/m~0n\"", "GET operation exception: " + e.getMessage());
        }
    }

    private void testResolvePathWithEncodedTildeOne(TestResult result) {
        LOGGER.info(" - resolving of \"/o~01p\" pointer");
        JsonObject in = PointerRFCObject.createRFC6901Object();
        JsonNumber check = Json.createValue((int)9);
        JsonPointer ptr = Json.createPointer((String)"/o~01p");
        try {
            JsonValue out = ptr.getValue((JsonStructure)in);
            if (!JsonAssert.assertEquals(out, (JsonValue)check)) {
                result.fail("GET \"/o~01p\"", "GET operation failed for \"/o~01p\" path");
            }
        }
        catch (JsonException e) {
            result.fail("GET \"/o~01p\"", "GET operation exception: " + e.getMessage());
        }
    }

    private void testResolveValidNumericIndexInArray(TestResult result) {
        LOGGER.info(" - resolving of pointer containing existing numeric array index");
        JsonArray[] arraysIn = new JsonArray[]{SimpleValues.createSimpleStringArray5(), SimpleValues.createSimpleIntArray5(), SimpleValues.createSimpleBoolArray5(), SimpleValues.createSimpleObjectArray5()};
        JsonValue[] strings = new JsonValue[]{SimpleValues.toJsonValue("First value"), SimpleValues.toJsonValue("Second value"), SimpleValues.toJsonValue("Third value"), SimpleValues.toJsonValue("Fourth value"), SimpleValues.toJsonValue("Fifth value")};
        JsonValue[] ints = new JsonValue[]{SimpleValues.toJsonValue(1), SimpleValues.toJsonValue(2), SimpleValues.toJsonValue(3), SimpleValues.toJsonValue(4), SimpleValues.toJsonValue(5)};
        JsonValue[] bools = new JsonValue[]{SimpleValues.toJsonValue(false), SimpleValues.toJsonValue(true), SimpleValues.toJsonValue(true), SimpleValues.toJsonValue(false), SimpleValues.toJsonValue(true)};
        JsonValue[] objs = new JsonValue[]{SimpleValues.OBJ_VALUE_1, SimpleValues.OBJ_VALUE_2, SimpleValues.OBJ_VALUE_3, SimpleValues.OBJ_VALUE_4, SimpleValues.OBJ_VALUE_5};
        JsonValue[][] checks = new JsonValue[][]{strings, ints, bools, objs};
        for (int i = 0; i < arraysIn.length; ++i) {
            for (int j = 0; j < 5; ++j) {
                String path = "/" + Integer.toString(j);
                JsonPointer ptr = Json.createPointer((String)path);
                JsonValue out = ptr.getValue((JsonStructure)arraysIn[i]);
                if (JsonAssert.assertEquals(out, checks[i][j])) continue;
                JsonValue.ValueType type = checks[i][j].getValueType();
                String typeName = type == JsonValue.ValueType.TRUE || type == JsonValue.ValueType.FALSE ? "boolean" : type.toString().toLowerCase();
                result.fail("GET \"" + path + "\"", "GET operation failed for \"" + path + "\" path on " + typeName + " array");
            }
        }
    }

    private void testResolveMemberAfterLastInArray(TestResult result) {
        LOGGER.info(" - resolving of array \"/-\" pointer");
        JsonArray[] arraysIn = new JsonArray[]{SimpleValues.createEmptyArray(), SimpleValues.createStringArray(new String[0]), SimpleValues.createSimpleIntArray5(), SimpleValues.createBoolArray2(), SimpleValues.createSimpleObjectArray5()};
        String[] typeNames = new String[]{"empty", "String", "int", "boolean", "JsonObject"};
        for (int i = 0; i < arraysIn.length; ++i) {
            JsonPointer ptr = Json.createPointer((String)"/-");
            try {
                JsonValue out = ptr.getValue((JsonStructure)arraysIn[i]);
                result.fail("GET \"/-\"", "GET operation succeeded for \"/-\" key");
                continue;
            }
            catch (JsonException e) {
                LOGGER.info("    - Expected exception for \"/-\" path in " + typeNames[i] + " array: " + e.getMessage());
            }
        }
    }

    private void testResolveNumericIndexWithLeadingZeroInArray(TestResult result) {
        LOGGER.info(" - resolving of pointer containing numeric array index with leading '0' (optional)");
        JsonArray[] arraysIn = new JsonArray[]{SimpleValues.createSimpleStringArray5(), SimpleValues.createSimpleIntArray5(), SimpleValues.createSimpleBoolArray5(), SimpleValues.createSimpleObjectArray5()};
        String[] typeNames = new String[]{"String", "int", "boolean", "JsonObject"};
        for (int i = 0; i < arraysIn.length; ++i) {
            for (int j = 0; j < 5; ++j) {
                String path = "/0" + Integer.toString(j);
                JsonPointer ptr = Json.createPointer((String)path);
                try {
                    JsonValue out = ptr.getValue((JsonStructure)arraysIn[i]);
                    LOGGER.info("    ! GET operation succeeded for \"" + path + "\" path on " + typeNames[i] + " array");
                    continue;
                }
                catch (JsonException jsonException) {
                    // empty catch block
                }
            }
        }
    }

    private void testResolvenonNumericIndexInArray(TestResult result) {
        LOGGER.info(" - resolving of pointer containing non numeric array index");
        JsonArray[] arraysIn = new JsonArray[]{SimpleValues.createEmptyArray(), SimpleValues.createStringArray(new String[0]), SimpleValues.createSimpleIntArray5(), SimpleValues.createBoolArray2(), SimpleValues.createSimpleObjectArray5()};
        String[] typeNames = new String[]{"empty", "String", "int", "boolean", "JsonObject"};
        String wholeDocument = "";
        String[] paths = new String[]{"/", "/1a", "/b4", "/name"};
        for (int i = 0; i < arraysIn.length; ++i) {
            JsonPointer wholeDocPtr = Json.createPointer((String)"");
            try {
                JsonValue wholeOut = wholeDocPtr.getValue((JsonStructure)arraysIn[i]);
                if (!JsonAssert.assertEquals(wholeOut, (JsonValue)arraysIn[i])) {
                    result.fail("GET \"\"", "GET operation failed for \"\" path on " + typeNames[i] + " array");
                }
            }
            catch (JsonException e) {
                result.fail("GET \"\"", "GET operation failed for \"\" path on " + typeNames[i] + " array: " + e.getMessage());
            }
            for (int j = 0; j < paths.length; ++j) {
                JsonPointer ptr = Json.createPointer((String)paths[j]);
                try {
                    JsonValue out = ptr.getValue((JsonStructure)arraysIn[i]);
                    result.fail("GET \"" + paths[j] + "\"", "GET operation succeeded for \"" + paths[j] + "\" path on " + typeNames[i] + " array");
                    continue;
                }
                catch (JsonException jsonException) {
                    // empty catch block
                }
            }
        }
    }
}

