/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.api.config;

import ee.jakarta.tck.json.bind.api.model.SimpleContainerDeserializer;
import ee.jakarta.tck.json.bind.api.model.SimpleContainerSerializer;
import ee.jakarta.tck.json.bind.api.model.SimpleIntegerAdapter;
import ee.jakarta.tck.json.bind.api.model.SimpleIntegerDeserializer;
import ee.jakarta.tck.json.bind.api.model.SimpleIntegerSerializer;
import ee.jakarta.tck.json.bind.api.model.SimplePropertyNamingStrategy;
import ee.jakarta.tck.json.bind.api.model.SimplePropertyVisibilityStrategy;
import ee.jakarta.tck.json.bind.api.model.SimpleStringAdapter;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.adapter.JsonbAdapter;
import jakarta.json.bind.config.PropertyNamingStrategy;
import jakarta.json.bind.config.PropertyVisibilityStrategy;
import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.bind.serializer.JsonbSerializer;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JsonbConfigTest {
    @Test
    public void testGetAsMap() {
        JsonbConfig jsonbConfig = new JsonbConfig().withFormatting(Boolean.valueOf(true)).withNullValues(Boolean.valueOf(true));
        Map configMap = jsonbConfig.getAsMap();
        String validationMessage = "Failed to get configuration properties as a map using JsonbConfig.getAsMap method.";
        MatcherAssert.assertThat((String)validationMessage, (Object)configMap.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((String)validationMessage, (Object)configMap, (Matcher)Matchers.hasKey((Object)"jsonb.formatting"));
        MatcherAssert.assertThat((String)validationMessage, (Object)configMap, (Matcher)Matchers.hasKey((Object)"jsonb.null-values"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> configMap.put("jsonb.binary-data-strategy", "BASE_64"), (String)"Failed to get configuration properties as an unmodifiable map using JsonbConfig.getAsMap method.");
    }

    @Test
    public void testGetProperty() {
        JsonbConfig jsonbConfig = new JsonbConfig().withFormatting(Boolean.valueOf(true)).withNullValues(Boolean.valueOf(true));
        Optional property = jsonbConfig.getProperty("jsonb.formatting");
        String validationMessage = "Failed to get a configuration property using JsonbConfig.getProperty method.";
        Assertions.assertTrue((boolean)property.isPresent(), (String)validationMessage);
        Assertions.assertTrue((boolean)((Boolean)property.get()), (String)validationMessage);
    }

    @Test
    public void testGetUnsetProperty() {
        JsonbConfig jsonbConfig = new JsonbConfig().withFormatting(Boolean.valueOf(true)).withNullValues(Boolean.valueOf(true));
        Optional property = jsonbConfig.getProperty("jsonb.adapters");
        Assertions.assertFalse((boolean)property.isPresent(), (String)"Failed to get Optional.empty for an unset configuration property using JsonbConfig.getProperty method.");
    }

    @Test
    public void testSetProperty() {
        JsonbConfig jsonbConfig = new JsonbConfig().setProperty("jsonb.property-naming-strategy", (Object)"UPPER_CAMEL_CASE_WITH_SPACES");
        MatcherAssert.assertThat((String)"Failed to set a property value using JsonbConfig.setProperty method.", jsonbConfig.getProperty("jsonb.property-naming-strategy").get(), (Matcher)CoreMatchers.is((Object)"UPPER_CAMEL_CASE_WITH_SPACES"));
    }

    @Test
    public void testWithAdapters() {
        SimpleStringAdapter simpleStringAdapter = new SimpleStringAdapter();
        JsonbConfig jsonbConfig = new JsonbConfig().withAdapters(new JsonbAdapter[]{simpleStringAdapter});
        String validationMessage = "Failed to configure a custom adapter using JsonbConfig.withAdapters method.";
        Object adapters = jsonbConfig.getProperty("jsonb.adapters").get();
        MatcherAssert.assertThat((String)validationMessage, adapters, (Matcher)Matchers.instanceOf(JsonbAdapter[].class));
        MatcherAssert.assertThat((String)validationMessage, (Object)((JsonbAdapter[])adapters)[0], (Matcher)CoreMatchers.is((Object)simpleStringAdapter));
    }

    @Test
    public void testWithAdaptersMultipleCalls() {
        JsonbConfig jsonbConfig = new JsonbConfig().withAdapters(new JsonbAdapter[]{new SimpleIntegerAdapter()}).withAdapters(new JsonbAdapter[]{new SimpleStringAdapter()});
        Object adapters = jsonbConfig.getProperty("jsonb.adapters").get();
        MatcherAssert.assertThat((String)("Not expected JsonbAdapter array but " + adapters.getClass()), adapters, (Matcher)Matchers.instanceOf(JsonbAdapter[].class));
        MatcherAssert.assertThat((String)"Failed to configure multiple custom adapters using multiple JsonbConfig.withAdapters method calls.", (Object)((JsonbAdapter[])adapters).length, (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testWithMultipleAdapters() {
        JsonbConfig jsonbConfig = new JsonbConfig().withAdapters(new JsonbAdapter[]{new SimpleIntegerAdapter(), new SimpleStringAdapter()});
        Object adapters = jsonbConfig.getProperty("jsonb.adapters").get();
        MatcherAssert.assertThat((String)("Not expected JsonbAdapter array but " + adapters.getClass()), adapters, (Matcher)Matchers.instanceOf(JsonbAdapter[].class));
        MatcherAssert.assertThat((String)"Failed to configure multiple custom adapters using multiple JsonbConfig.withAdapters method calls.", (Object)((JsonbAdapter[])adapters).length, (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testWithBinaryDataStrategy() {
        JsonbConfig jsonbConfig = new JsonbConfig().withBinaryDataStrategy("BASE_64_URL");
        Optional property = jsonbConfig.getProperty("jsonb.binary-data-strategy");
        String validationMessage = "Failed to configure a custom binary data strategy using JsonbConfig.withBinaryDataStrategy method.";
        Assertions.assertTrue((boolean)property.isPresent(), (String)validationMessage);
        MatcherAssert.assertThat((String)validationMessage, property.get(), (Matcher)CoreMatchers.is((Object)"BASE_64_URL"));
    }

    @Test
    public void testWithDateFormat() {
        JsonbConfig jsonbConfig = new JsonbConfig().withDateFormat("YYYYMMDD", Locale.GERMAN);
        Optional property = jsonbConfig.getProperty("jsonb.date-format");
        String validationMessage = "Failed to configure a custom date format using JsonbConfig.withDateFormat method.";
        Assertions.assertTrue((boolean)property.isPresent(), (String)validationMessage);
        MatcherAssert.assertThat((String)validationMessage, property.get(), (Matcher)CoreMatchers.is((Object)"YYYYMMDD"));
    }

    @Test
    public void testWithDeserializers() {
        SimpleContainerDeserializer deserializer = new SimpleContainerDeserializer();
        JsonbConfig jsonbConfig = new JsonbConfig().withDeserializers(new JsonbDeserializer[]{deserializer});
        Object deserializers = jsonbConfig.getProperty("jsonb.derializers").get();
        String validationMessage = "Failed to configure a custom deserializer using JsonbConfig.withDeserializers method.";
        MatcherAssert.assertThat((String)validationMessage, deserializers, (Matcher)Matchers.instanceOf(JsonbDeserializer[].class));
        MatcherAssert.assertThat((String)validationMessage, (Object)((JsonbDeserializer[])deserializers)[0], (Matcher)CoreMatchers.is((Object)deserializer));
    }

    @Test
    public void testWithDeserializersMultipleCalls() {
        JsonbConfig jsonbConfig = new JsonbConfig().withDeserializers(new JsonbDeserializer[]{new SimpleIntegerDeserializer()}).withDeserializers(new JsonbDeserializer[]{new SimpleContainerDeserializer()});
        Object deserializers = jsonbConfig.getProperty("jsonb.derializers").get();
        MatcherAssert.assertThat((String)("Not expected JsonbDeserializer array but " + deserializers.getClass()), deserializers, (Matcher)Matchers.instanceOf(JsonbDeserializer[].class));
        MatcherAssert.assertThat((String)"Failed to configure multiple custom deserializers using multiple JsonbConfig.withDeserializers method calls.", (Object)((JsonbDeserializer[])deserializers).length, (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testWithEncoding() {
        JsonbConfig jsonbConfig = new JsonbConfig().withEncoding("UCS2");
        Optional property = jsonbConfig.getProperty("jsonb.encoding");
        String validationMessage = "Failed to configure a custom character encoding using JsonbConfig.withEncoding method.";
        Assertions.assertTrue((boolean)property.isPresent(), (String)validationMessage);
        MatcherAssert.assertThat((String)validationMessage, property.get(), (Matcher)CoreMatchers.is((Object)"UCS2"));
    }

    @Test
    public void testWithFormatting() {
        JsonbConfig jsonbConfig = new JsonbConfig().withFormatting(Boolean.valueOf(true));
        Optional property = jsonbConfig.getProperty("jsonb.formatting");
        String validationMessage = "Failed to configure JSON string formatting using JsonbConfig.withFormatting method.";
        Assertions.assertTrue((boolean)property.isPresent(), (String)validationMessage);
        Assertions.assertTrue((boolean)((Boolean)property.get()), (String)validationMessage);
    }

    @Test
    public void testWithLocale() {
        JsonbConfig jsonbConfig = new JsonbConfig().withLocale(Locale.GERMAN);
        Optional property = jsonbConfig.getProperty("jsonb.locale");
        String validationMessage = "Failed to configure a custom locale using JsonbConfig.withLocale method.";
        Assertions.assertTrue((boolean)property.isPresent(), (String)validationMessage);
        MatcherAssert.assertThat((String)validationMessage, property.get(), (Matcher)CoreMatchers.is((Object)Locale.GERMAN));
    }

    @Test
    public void testWithNullValues() {
        JsonbConfig jsonbConfig = new JsonbConfig().withNullValues(Boolean.valueOf(true));
        Optional property = jsonbConfig.getProperty("jsonb.null-values");
        String validationMessage = "Failed to configure serialization of null values using JsonbConfig.withNullValues method.";
        Assertions.assertTrue((boolean)property.isPresent(), (String)validationMessage);
        Assertions.assertTrue((boolean)((Boolean)property.get()), (String)validationMessage);
    }

    @Test
    public void testWithPropertyNamingStrategy() {
        SimplePropertyNamingStrategy propertyNamingStrategy = new SimplePropertyNamingStrategy();
        JsonbConfig jsonbConfig = new JsonbConfig().withPropertyNamingStrategy((PropertyNamingStrategy)propertyNamingStrategy);
        Optional property = jsonbConfig.getProperty("jsonb.property-naming-strategy");
        String validationMessage = "Failed to configure a custom property naming strategy using JsonbConfig.withPropertyNamingStrategy method.";
        Assertions.assertTrue((boolean)property.isPresent(), (String)validationMessage);
        MatcherAssert.assertThat((String)validationMessage, property.get(), (Matcher)CoreMatchers.is((Object)propertyNamingStrategy));
    }

    @Test
    public void testWithPropertyNamingStrategyString() {
        JsonbConfig jsonbConfig = new JsonbConfig().withPropertyNamingStrategy("UPPER_CAMEL_CASE");
        Optional property = jsonbConfig.getProperty("jsonb.property-naming-strategy");
        String validationMessage = "Failed to configure a custom property naming strategy using JsonbConfig.withPropertyNamingStrategy method with String argument.";
        Assertions.assertTrue((boolean)property.isPresent(), (String)validationMessage);
        MatcherAssert.assertThat((String)validationMessage, property.get(), (Matcher)CoreMatchers.is((Object)"UPPER_CAMEL_CASE"));
    }

    @Test
    public void testWithPropertyOrderStrategy() {
        JsonbConfig jsonbConfig = new JsonbConfig().withPropertyOrderStrategy("LEXICOGRAPHICAL");
        Optional property = jsonbConfig.getProperty("jsonb.property-order-strategy");
        String validationMessage = "Failed to configure a custom property order strategy using JsonbConfig.withPropertyOrderStrategy method.";
        Assertions.assertTrue((boolean)property.isPresent(), (String)validationMessage);
        MatcherAssert.assertThat((String)validationMessage, property.get(), (Matcher)CoreMatchers.is((Object)"LEXICOGRAPHICAL"));
    }

    @Test
    public void testWithPropertyVisibilityStrategy() {
        SimplePropertyVisibilityStrategy propertyVisibilityStrategy = new SimplePropertyVisibilityStrategy();
        JsonbConfig jsonbConfig = new JsonbConfig().withPropertyVisibilityStrategy((PropertyVisibilityStrategy)propertyVisibilityStrategy);
        Optional property = jsonbConfig.getProperty("jsonb.property-visibility-strategy");
        String validationMessage = "Failed to configure a custom property visibility strategy using JsonbConfig.withPropertyVisibilityStrategy method.";
        Assertions.assertTrue((boolean)property.isPresent(), (String)validationMessage);
        MatcherAssert.assertThat((String)validationMessage, property.get(), (Matcher)CoreMatchers.is((Object)propertyVisibilityStrategy));
    }

    @Test
    public void testWithSerializers() {
        SimpleContainerSerializer serializer = new SimpleContainerSerializer();
        JsonbConfig jsonbConfig = new JsonbConfig().withSerializers(new JsonbSerializer[]{serializer});
        Object serializers = jsonbConfig.getProperty("jsonb.serializers").get();
        String validationMessage = "Failed to configure a custom serializer using JsonbConfig.withSerializers method.";
        MatcherAssert.assertThat((String)validationMessage, serializers, (Matcher)Matchers.instanceOf(JsonbSerializer[].class));
        MatcherAssert.assertThat((String)validationMessage, (Object)((JsonbSerializer[])serializers)[0], (Matcher)CoreMatchers.is((Object)serializer));
    }

    @Test
    public void testWithSerializersMultipleCalls() {
        JsonbConfig jsonbConfig = new JsonbConfig().withSerializers(new JsonbSerializer[]{new SimpleIntegerSerializer()}).withSerializers(new JsonbSerializer[]{new SimpleContainerSerializer()});
        Object serializers = jsonbConfig.getProperty("jsonb.serializers").get();
        MatcherAssert.assertThat((String)("Not expected JsonbSerializer array but " + serializers.getClass()), serializers, (Matcher)Matchers.instanceOf(JsonbSerializer[].class));
        MatcherAssert.assertThat((String)"Failed to configure multiple custom serializers using multiple JsonbConfig.withSerializers method calls.", (Object)((JsonbSerializer[])serializers).length, (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testWithStrictIJson() {
        JsonbConfig jsonbConfig = new JsonbConfig().withStrictIJSON(Boolean.valueOf(true));
        Optional property = jsonbConfig.getProperty("jsonb.strict-ijson");
        String validationMessage = "Failed to configure strict I-JSON support using JsonbConfig.withStrictIJSON method.";
        Assertions.assertTrue((boolean)property.isPresent(), (String)validationMessage);
        Assertions.assertTrue((boolean)((Boolean)property.get()), (String)validationMessage);
    }
}

