/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.vehicle.ejbembed;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public final class EmbeddableEJBProcess {
    private static final Logger logger = Logger.getLogger("com.sun.ts.tests.common.vehicle.ejbembed");
    private String javaHome = System.getProperty("java.home");
    private String javaCmd = this.javaHome + File.separator + "bin" + File.separator + "java";
    private List<String> cmdList = new ArrayList<String>();
    private Process ps;
    private String tsHome;
    private String tsRunClasspath;
    private String classpathSuffix;
    private String testClassName;
    private String[] args;
    private Properties props;

    public EmbeddableEJBProcess(String[] args, Properties props) {
        this.args = args;
        this.props = props;
        this.tsHome = props.getProperty("ts.home");
        this.tsRunClasspath = props.getProperty("ts.run.classpath");
        this.classpathSuffix = this.getOpts("-classpathSuffix");
        this.testClassName = props.getProperty("test_classname");
        this.cmdList.add(this.javaCmd);
        this.constructClassPathOption();
        this.constructSystemProps();
        this.cmdList.add(this.testClassName);
        ProcessBuilder pb = new ProcessBuilder(this.cmdList).redirectErrorStream(true);
        logger.info(String.format("Starting process: %s%n", pb.command()));
        logger.fine(String.format("%s%nEnvironment:", pb.environment()));
        try {
            this.ps = pb.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void constructSystemProps() {
        this.cmdList.add("-Dts.ejb.embed=true");
        this.cmdList.add("-DtestName=" + this.props.getProperty("testName"));
    }

    private String getOpts(String tag) {
        String val = null;
        for (int i = 0; i < this.args.length; ++i) {
            if (!this.args[i].equals(tag)) continue;
            val = this.args[i + 1];
            break;
        }
        logger.fine(String.format("Got arg: %s %s", tag, val));
        return val;
    }

    private String getPkgDirFromTestClass() {
        String pkgDir = this.testClassName.substring(0, this.testClassName.lastIndexOf(46));
        pkgDir = this.testClassName.replace('.', File.separatorChar);
        return pkgDir;
    }

    private void constructClassPathOption() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.tsRunClasspath);
        sb.append(File.pathSeparator);
        sb.append(this.tsHome).append(File.separator).append("dist").append(File.separator);
        sb.append(this.getPkgDirFromTestClass()).append(File.separator);
        sb.append("*.jar");
        if (this.classpathSuffix != null) {
            sb.append(File.pathSeparator);
            sb.append(this.classpathSuffix);
        }
        this.cmdList.add("-classpath");
        this.cmdList.add(sb.toString());
    }

    public String getTestResult() {
        StringBuilder sb = new StringBuilder();
        InputStream is = null;
        try {
            String line;
            is = this.ps.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                sb.append(line).append(System.getProperty("line.separator"));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }
}

